/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_ISO5426CONVERTER_H
#define TELLICO_ISO5426CONVERTER_H

class TQCString;
class TQString;
class TQChar;

#include <tqglobal.h>

namespace Tellico {

/**
 * @author Robby Stephenson
 */
class Iso5426Converter {
public:
  static TQString toUtf8(const TQCString& text);

private:
  static bool hasNext(uint pos, uint len);
  static bool isAscii(uchar c);
  static bool isCombining(uchar c);

  static TQChar getChar(uchar c);
  static TQChar getCombiningChar(uint i);
};

} // end namespace

#endif
