/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_XML_H
#define TELLICO_XML_H

#include <tqstring.h>

namespace Tellico {
  namespace XML {
    extern const TQString nsXSL;
    extern const TQString nsBibtexml;
    extern const TQString dtdBibtexml;

    extern const uint syntaxVersion;
    extern const TQString nsTellico;

    TQString pubTellico(int version = syntaxVersion);
    TQString dtdTellico(int version = syntaxVersion);

    bool versionConversion(uint from, uint to);

    extern const TQString nsBookcase;
    extern const TQString nsDublinCore;
    extern const TQString nsZing;
    extern const TQString nsZingDiag;

    bool validXMLElementName(const TQString& name);
    TQString elementName(const TQString& name);
  }
}

#endif
