/*
 * $Id: MachBuntButton.cpp,v 1.34 2004/03/23 15:34:45 llunak Exp $
 *
 */

#include "MachBunt.h"  
#include <kpixmapeffect.h>
#include <kimageeffect.h>
#include <kiconeffect.h>
#include <kdrawutil.h>
#include <tdelocale.h>

#include <tqlayout.h>
#include <tqdrawutil.h>
#include <tqtooltip.h>
#include <tqdatetime.h>
#include <tqbitmap.h>
#include <tqimage.h>
#include <tqcursor.h>

namespace SuSEMachBunt {

// the titlebar buttons
extern bool    pixmaps_created;

TQPixmap *defaultPixmap;
TQColor  *btnForeground;

MachBuntButton::MachBuntButton(MachBunt * c, const char *name,
                               int _button, TQPixmap bgI, TQPixmap bgA,
			       bool isMini,
                               const TQString &tip)
    : TQButton (c->widget(), name), position( ButtonMiddle ), client( c )
{
	setTipText(tip);
        setMouseTracking( true );
        setCursor( arrowCursor );

	// Eliminate background flicker
	setBackgroundMode( TQWidget::NoBackground ); 
	
	menuBtn    = _button == BtnMenu;
	miniBtn    = isMini;
	button     = _button;
	state      = 0;
	pressed    = 0;
	bg[0]      = bgI;
	bg[1]      = bgA;

	// Use larger button for the menu, or mini-buttons for toolwindows.
	if ( isMini ) {
	    setFixedSize(12, 12);
	    resize(12, 12);
	} else{
	    setFixedSize(PIX_HEIGHT, PIX_HEIGHT);
	    resize(PIX_HEIGHT, PIX_HEIGHT);
	}
}

MachBuntButton::~MachBuntButton()
{
};

TQSize MachBuntButton::sizeHint() const
{
   if ( miniBtn )
      return(TQSize(12, 12));
   else
      return(TQSize(PIX_HEIGHT, PIX_HEIGHT));
}


void MachBuntButton::reset(unsigned long changes)
{
	repaint(false);
	if (!menuBtn){
		emit ( shapeMe(0) );
		state=0;
		pressed = 0;
	}
}


void MachBuntButton::setBitmap(const unsigned char *bitmap)
{
    repaint( false );   
}


void MachBuntButton::setPixmap( const TQPixmap &_p )
{
	TQPixmap p;

	if ( _p.isNull() )
		p = *defaultPixmap;
	else
		p = _p;

	if ( miniBtn ){
		menuPixmap.convertFromImage( p.convertToImage().smoothScale(8,8) );
	}else
	    menuPixmap = p;


	for ( int m=0; m<2; m++ )
     for ( int M=0; M<3; M++ )
      for ( int a=0; a<2; a++ )
		if (menuBtn)
          menuButtonPixmap[button][m][M][a].resize(0,0);
		else
          buttonPixmap[button][m][M][a].resize(0,0);

    repaint( false );   
}

void MachBuntButton::enterEvent( TQEvent *e )
{
	if (pressed){
		state = 2;
		emit ( shapeMe(this->x()) );
	}else
		state = 1;
	repaint();
	TQButton::enterEvent(e);
}

void MachBuntButton::leaveEvent( TQEvent *e )
{
	if (pressed)
		emit ( shapeMe(0) );
	state = 0;
	repaint();
	TQButton::leaveEvent(e);
}

void MachBuntButton::setPosition( ButtonPos pos )
{
    position = pos;
}

bool MachBuntButton::resizePosition( TQPoint pos )
{
    if( pos.y() < BUTTON_RESIZE_SIZE )
        return true;
    if( position == ButtonLeft && pos.x() < BUTTON_RESIZE_SIZE )
        return true;
    if( position == ButtonRight && pos.x() > width() - 1 - BUTTON_RESIZE_SIZE )
        return true;
    return false;
}

void MachBuntButton::mouseMoveEvent( TQMouseEvent* e )
{
        if( resizePosition( e->pos()))
            {
            e->ignore();
            unsetCursor(); // use cursor set according to mousePosition()
            return;
            }
       if ( pressed == 1 )
	  emit( mousePressedMove(e) );
        e->ignore(); // so that dragging works, even when moving more inside the button
        setCursor( arrowCursor );
}

void MachBuntButton::mousePressEvent( TQMouseEvent* e )
{
        if( resizePosition( e->pos()))
            {
            e->ignore();
            return;
            }
	if (!menuBtn){
		state = 2;
		pressed = 1;
		emit ( shapeMe(this->x()) );
	}

	last_button = e->button();
	TQMouseEvent me ( e->type(), e->pos(), e->globalPos(),
					 LeftButton, e->state() );
	TQButton::mousePressEvent( &me );
}

void MachBuntButton::mouseReleaseEvent( TQMouseEvent* e )
{
	if (!menuBtn){
		emit ( shapeMe(0) );
		if (state==2)
			state=1;
		pressed = 0;
	}
        if( resizePosition( e->pos()))
            {
            e->ignore();
            return;
            }
	last_button = e->button();
	TQMouseEvent me ( e->type(), e->pos(), e->globalPos(),
			 LeftButton, e->state() );
	TQButton::mouseReleaseEvent( &me );
}

void MachBuntButton::drawButton(TQPainter *p)
{
	bool a = client->isActive();
	TQPixmap *P;
	if (menuBtn)
		P = &menuButtonPixmap[button][a][state][miniBtn];
	else
		P = &buttonPixmap[button][a][state][miniBtn];

	if ( P->isNull() )
        *P = create_buttonPixmap( miniBtn ? 12 : PIX_HEIGHT, miniBtn ? 12 : PIX_HEIGHT, menuPixmap, bg[a], a, state );

	p->drawPixmap( 0, 0, *P );
}

void MachBuntButton::setTipText(const TQString &tip) {
  if(KDecoration::options()->showTooltips()) {
    TQToolTip::remove(this );
    TQToolTip::add(this, tip );
  }
}

}
