/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

/* Common definitions and includes for portal interfaces */
#ifndef __INTERFACE_H_
#define __INTERFACE_H_

// TQt
#include <tqdbusconnection.h>
#include <tqdbusmessage.h>
#include <tqdbusvariant.h>
#include <tqdbusdatalist.h>
#include <tqdbusdata.h>
#include <tqdbuserror.h>
#include <tqobject.h>

// Portal
#include "util.h"


#define OPTION_VALID(opt, sig) \
    options.keys().contains(opt) && check_variant(options[opt], sig)

#endif // __INTERFACE_H_