/***************************************************************************
    begin                : Sat Jan 11 2003
    copyright            : (C) 2003 by kiriuja
    email                : kplayer-dev@en-directo.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* Taken from kplayer CVS 2003-09-21 (kplayer > 0.3.1) by Jonathan Riddell
 * Changes from kplayer original marked by CHANGED
 */

#include <tdeapplication.h>
#include <tdetoolbar.h>
#include <tdetoolbarbutton.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <kdebug.h>

//CHANGED #include "kplayersettings.h"
#include "kplayerslideraction.h"
#include "kplayerslideraction.moc"

void KPlayerPopupFrame::keyPressEvent (TQKeyEvent* ev)
{
    switch ( ev -> key() )
    {
    case TQt::Key_Alt:
    case TQt::Key_Tab:
    case TQt::Key_Escape:
    case TQt::Key_Return:
    case TQt::Key_Enter:
        close();
    }
}

/*void KPlayerPopupFrame::closeEvent (TQCloseEvent* ev)
{
  TQFrame::closeEvent (ev);
}

void KPlayerPopupFrame::mousePressEvent (TQMouseEvent* ev)
{
  TQFrame::mousePressEvent (ev);
//if ( ! rect().contains (ev -> pos()) )
//  m_outside_mouse_press = true;
}

void KPlayerPopupFrame::mouseReleaseEvent (TQMouseEvent* ev)
{
  TQFrame::mouseReleaseEvent (ev);
  if ( m_outside_mouse_press )
  {
    m_outside_mouse_press = false;
    if ( ! rect().contains (ev -> pos()) )
      close();
  }
}*/

KPlayerPopupSliderAction::KPlayerPopupSliderAction (const TQString& text,
        const TQString& pix, const TDEShortcut& shortcut, const TQObject* receiver,
        const char* slot, TQObject* parent, const char* name)
        : TDEAction (text, pix, shortcut, parent, name)
{
    m_frame = new KPlayerPopupFrame;
    m_frame -> setFrameStyle (TQFrame::PopupPanel | TQFrame::Raised);
    m_frame -> setLineWidth (2);
    m_slider = new KPlayerSlider (TQt::Vertical, m_frame);
    m_frame -> resize (36, m_slider -> sizeHint().height() + 4);
    m_slider -> setGeometry (m_frame -> contentsRect());
    //CHANGED  kdDebug() << "Popup slider size " << m_slider -> width() << "x" << m_slider -> height() << "\n";
    connect (m_slider, TQ_SIGNAL (changed (int)), receiver, slot);
}

KPlayerPopupSliderAction::~KPlayerPopupSliderAction()
{
    delete m_frame;
    m_frame = 0;
}

/*int KPlayerPopupSliderAction::plug (TQWidget* widget, int index)
{
  Q_ASSERT (m_slider);
  Q_ASSERT (widget);
  Q_ASSERT (! isPlugged());
  if ( ! m_slider || ! widget || isPlugged() )
    return -1;
  Q_ASSERT (widget -> inherits ("TDEToolBar"));
  if ( ! widget -> inherits ("TDEToolBar") )
    return -1;
  int retval = TDEAction::plug (widget, index);
//  if ( retval >= 0 )
//    m_slider -> reparent (widget, TQPoint());
  return retval;
}

void KPlayerPopupSliderAction::unplug (TQWidget* widget)
{
  Q_ASSERT (m_slider);
  Q_ASSERT (widget);
  Q_ASSERT (isPlugged());
  Q_ASSERT (widget -> inherits ("TDEToolBar"));
  if ( ! m_slider || ! widget || ! isPlugged() || ! widget -> inherits ("TDEToolBar") )
    return;
//m_slider -> reparent (0, TQPoint());
  TDEAction::unplug (widget);
}*/

void KPlayerPopupSliderAction::slotActivated (void)
{
    TDEAction::slotActivated();
    TQWidget* button = 0;
    if ( sender() )
    {
        //CHANGED    kdDebug() << "Sender class name: " << sender() -> className() << "\n";
        if ( sender() -> inherits ("TDEToolBarButton") )
            button = (TQWidget*) sender();
        else if ( sender() -> inherits ("TDEToolBar") )
        {
            TDEToolBar* toolbar = (TDEToolBar*) sender();
            int index = findContainer (toolbar);
            if ( index >= 0 )
                button = toolbar -> getButton (itemId (index));
        }
    }
    TQPoint point;
    if ( button )
        point = button -> mapToGlobal (TQPoint (0, button -> height()));
    else
    {
        point = TQCursor::pos() - TQPoint (m_frame -> width() / 2, m_frame -> height() / 2);
        if ( point.x() + m_frame -> width() > TQApplication::desktop() -> width() )
            point.setX (TQApplication::desktop() -> width() - m_frame -> width());
        if ( point.y() + m_frame -> height() > TQApplication::desktop() -> height() )
            point.setY (TQApplication::desktop() -> height() - m_frame -> height());
        if ( point.x() < 0 )
            point.setX (0);
        if ( point.y() < 0 )
            point.setY (0);
    }
    //CHANGED  kdDebug() << "Point: " << point.x() << "x" << point.y() << "\n";
    m_frame -> move (point);
    /*if ( kapp && kapp -> activeWindow() )
      {
        TQMouseEvent me (TQEvent::MouseButtonRelease, TQPoint(0,0), TQPoint(0,0), TQMouseEvent::LeftButton, TQMouseEvent::NoButton);
        TQApplication::sendEvent (kapp -> activeWindow(), &me);
      }*/
    m_frame -> show();
    m_slider -> setFocus();
}

KPlayerSliderAction::KPlayerSliderAction (const TQString& text, const TDEShortcut& cut,
        const TQObject* receiver, const char* slot, TDEActionCollection* parent, const char* name)
        : KWidgetAction (new KPlayerSlider (TQt::Horizontal, 0, name), text, cut, receiver, slot, parent, name)
        //: TDEAction (text, 0, parent, name)
{
    setAutoSized (true);
    connect (slider(), TQ_SIGNAL (changed (int)), receiver, slot);
}

KPlayerSliderAction::~KPlayerSliderAction()
{
}

int KPlayerSliderAction::plug (TQWidget* widget, int index)
{
    //Q_ASSERT (widget);
    //Q_ASSERT (! isPlugged());
    //Q_ASSERT (slider());
    //if ( ! slider() || ! widget || isPlugged() )
    //  return -1;
    //Q_ASSERT (widget -> inherits ("TDEToolBar"));
    //if ( ! widget -> inherits ("TDEToolBar") )
    //  return -1;
    //if ( kapp && ! kapp -> authorizeTDEAction (name()) )
    //  return -1;
    int result = KWidgetAction::plug (widget, index);
    if ( result < 0 )
        return result;
    TDEToolBar* toolbar = (TDEToolBar*) widget;
    //int id = getToolButtonID();
    //kdDebug() << "TQt::Orientation: " << toolbar -> orientation() << "\n";
    //m_slider -> reparent (toolbar, TQPoint());
    //toolbar -> insertWidget (id, 0, m_slider, index);
    //toolbar -> setItemAutoSized (id, true);
    //TQWhatsThis::remove (m_slider);
    //if ( ! whatsThis().isEmpty() )
    //  TQWhatsThis::add (m_slider, whatsThis());
    //if ( ! text().isEmpty() )
    //  TQToolTip::add (m_slider, text());
    //addContainer (toolbar, id);
    //setupToolbar (toolbar -> orientation(), toolbar);
    orientationChanged (toolbar -> orientation());
    connect (toolbar, TQ_SIGNAL (orientationChanged (TQt::Orientation)), this, TQ_SLOT (orientationChanged (TQt::Orientation)));
    //connect (toolbar, TQ_SIGNAL (destroyed()), this, TQ_SLOT (toolbarDestroyed()));
    //if ( parentCollection() )
    //  parentCollection() -> connectHighlight (toolbar, this);
    //return containerCount() - 1;
    return result;
}

void KPlayerSliderAction::unplug (TQWidget* widget)
{
    //Q_ASSERT (m_slider);
    //Q_ASSERT (isPlugged());
    //Q_ASSERT (widget -> inherits ("TDEToolBar"));
    KWidgetAction::unplug (widget);
    if ( ! slider() || ! isPlugged() || widget != slider() -> parent() )
        return;
    //TDEToolBar* toolbar = (TDEToolBar*) widget;
    disconnect (widget, TQ_SIGNAL (orientationChanged (TQt::Orientation)), this, TQ_SLOT (orientationChanged (TQt::Orientation)));
    //disconnect (toolbar, TQ_SIGNAL (destroyed()), this, TQ_SLOT (toolbarDestroyed()));
    //m_slider -> reparent (0, TQPoint());
    /*int index = findContainer (toolbar);
      if ( index == -1 )
        return;
      bar -> removeItem (menuId (index));
      removeContainer (index);*/
}

/*void KPlayerSliderAction::setupToolbar (TQt::Orientation orientation, TDEToolBar* toolbar)
{
    if ( orientation == TQt::Horizontal )
    {
//      toolbar -> setMinimumWidth (300);
//      toolbar -> setMinimumHeight (0);
      toolbar -> setFixedExtentWidth (300);
      toolbar -> setFixedExtentHeight (-1);
//      toolbar -> setHorizontallyStretchable (true);
//      toolbar -> setVerticallyStretchable (false);
    }
    else
    {
//      toolbar -> setMinimumWidth (0);
//      toolbar -> setMinimumHeight (300);
      toolbar -> setFixedExtentWidth (-1);
      toolbar -> setFixedExtentHeight (300);
//      toolbar -> setHorizontallyStretchable (false);
//      toolbar -> setVerticallyStretchable (true);
    }
}*/

void KPlayerSliderAction::orientationChanged (TQt::Orientation orientation)
{
    //if ( sender() && sender() -> inherits ("TDEToolBar") )
    //  setupToolbar (orientation, (TDEToolBar*) sender());
    //Q_ASSERT (m_slider);
    //Q_ASSERT (isPlugged());
    if ( slider() )
        slider() -> setOrientation (orientation);
}

/*void KPlayerSliderAction::toolbarDestroyed (void)
{
  if ( m_slider )
    m_slider -> reparent (0, TQPoint());
}*/

KPlayerSlider::KPlayerSlider (TQt::Orientation orientation, TQWidget* parent, const char* name)
//CHANGED  : TQSlider (orientation, parent, name)
        : TQSlider (300, 2200, 400, 1000, orientation, parent, name)
{
    m_changing_orientation = false;
    setTickmarks (TQSlider::Both);
    connect (this, TQ_SIGNAL (valueChanged (int)), this, TQ_SLOT (sliderValueChanged (int)));
}

KPlayerSlider::~KPlayerSlider()
{
    //CHANGED  kdDebug() << "KPlayerSlider destroyed\n";
}

TQSize KPlayerSlider::sizeHint() const
{
    TQSize hint = TQSlider::sizeHint();
    //CHANGED int length = kPlayerSettings() -> preferredSliderLength();
    int length = 200;
    if ( orientation() == TQt::Horizontal )
    {
        if ( hint.width() < length )
            hint.setWidth (length);
    }
    else
    {
        if ( hint.height() < length )
            hint.setHeight (length);
    }
    return hint;
}

TQSize KPlayerSlider::minimumSizeHint() const
{
    //kdDebug() << "KPlayerSlider minimum size hint\n";
    TQSize hint = TQSlider::minimumSizeHint();
    //CHANGED  int length = kPlayerSettings() -> minimumSliderLength();
    int length = 200;
    if ( orientation() == TQt::Horizontal )
    {
        if ( hint.width() < length )
            hint.setWidth (length);
    }
    else
    {
        if ( hint.height() < length )
            hint.setHeight (length);
    }
    return hint;
}

void KPlayerSlider::setOrientation (TQt::Orientation o)
{
    if ( o == orientation() )
        return;
    m_changing_orientation = true;
    int minValue = TQSlider::minValue();
    int maxValue = TQSlider::maxValue();
    int value = TQSlider::value();
    TQSlider::setOrientation (o);
    TQSlider::setMinValue (- maxValue);
    TQSlider::setMaxValue (- minValue);
    TQSlider::setValue (- value);
    m_changing_orientation = false;
}

int KPlayerSlider::minValue (void) const
{
    if ( orientation() == TQt::Horizontal )
        return TQSlider::minValue();
    return - TQSlider::maxValue();
}

void KPlayerSlider::setMinValue (int minValue)
{
    if ( orientation() == TQt::Horizontal )
        TQSlider::setMinValue (minValue);
    else
        TQSlider::setMaxValue (- minValue);
}

int KPlayerSlider::maxValue (void) const
{
    if ( orientation() == TQt::Horizontal )
        return TQSlider::maxValue();
    return - TQSlider::minValue();
}

void KPlayerSlider::setMaxValue (int maxValue)
{
    if ( orientation() == TQt::Horizontal )
        TQSlider::setMaxValue (maxValue);
    else
        TQSlider::setMinValue (- maxValue);
}

int KPlayerSlider::lineStep (void) const
{
    return TQSlider::lineStep();
}

void KPlayerSlider::setLineStep (int lineStep)
{
    TQSlider::setLineStep (lineStep);
}

int KPlayerSlider::pageStep (void) const
{
    return TQSlider::pageStep();
}

void KPlayerSlider::setPageStep (int pageStep)
{
    TQSlider::setPageStep (pageStep);
    setTickInterval (pageStep);
}

int KPlayerSlider::value (void) const
{
    if ( orientation() == TQt::Horizontal )
        return TQSlider::value();
    return - TQSlider::value();
}

void KPlayerSlider::setValue (int value, int)
{
    if ( orientation() == TQt::Horizontal )
        TQSlider::setValue (value);
    else
        TQSlider::setValue (- value);
}

void KPlayerSlider::setup (int minValue, int maxValue, int value, int pageStep, int lineStep)
{
    setMinValue (minValue);
    setMaxValue (maxValue);
    setLineStep (lineStep);
    setPageStep (pageStep);
    setValue (value);
}

void KPlayerSlider::sliderValueChanged (int)
{
    if ( ! m_changing_orientation )
        emit changed (value());
}
