/***************************************************************************
                          kroutinginfo.h  -  description
                             -------------------
    begin                : Mon Mar 3 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : juancho@linuxmail.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KROUTINGINFO_H
#define KROUTINGINFO_H

#include <tqstring.h>


/**Has all the routing info of the machine, like default gateway, default gateway device,
  routes to other hosts and networks, etc.

  *@author Juan Luis Baptiste
  */

class KRoutingInfo {
public: 
	KRoutingInfo();
	~KRoutingInfo();
private: // Private attributes
  TQString networking;
  TQString forwardIPv4;
  TQString hostName;
  TQString domainName;
  TQString gateway;
  TQString gatewayDevice;

public: // Public attributes
  TQString isNetworkingEnabled();
  TQString isForwardIPv4Enabled();
  TQString getHostName();
  TQString getGatewayDevice();
  TQString getGateway();
  TQString getDomainName();
  void setNetworkingEnabled(const TQString &networking);
  void setForwardIPv4Enabled(const TQString &forwardIPv4);
  void setHostName(const TQString &hostName);
  void setDomainName(const TQString &domainName);
  void setGateway(const TQString &gateway);
  void setGatewayDevice(const TQString &gatewayDevice);
  
};

#endif
