/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef SMSCONTACT_H
#define SMSCONTACT_H

#include "kopetecontact.h"
#include "kopetemessage.h"

#include <tqstring.h>

class SMSAccount;
namespace Kopete { class ChatSession; }
namespace Kopete { class MetaContact; }

class TDEActionCollection;
class TDEAction;

class SMSContact : public Kopete::Contact
{
	TQ_OBJECT
  
public:
	SMSContact( Kopete::Account* _account, const TQString &phoneNumber,
		const TQString &displayName, Kopete::MetaContact *parent );

	TQPtrList<TDEAction>* customContextMenuActions();

	const TQString &phoneNumber();
	void setPhoneNumber( const TQString phoneNumber );
	const TQString qualifiedNumber();

	/**
	 * Serialize contact
	 */
	virtual void serialize( TQMap<TQString, TQString> &serializedData,
		TQMap<TQString, TQString> &addressBookData );

	Kopete::ChatSession* manager( Kopete::Contact::CanCreateFlags canCreate = Kopete::Contact::CanCreate );

public slots:
	virtual void slotUserInfo();
	virtual void deleteContact();
	void slotSendingSuccess(const Kopete::Message &msg);
	void slotSendingFailure(const Kopete::Message &msg, const TQString &error);

private slots:
	void userPrefs();
	void slotChatSessionDestroyed();

private:
	TDEAction* m_actionPrefs;

	TQString m_phoneNumber;

	Kopete::ChatSession* m_msgManager;
};

#endif
