#ifndef JUKIFACE_H
#define JUKIFACE_H

#include <dcopobject.h>
#include <tqstringlist.h>
#include <tqpixmap.h>

class CollectionIface : public DCOPObject
{
    K_DCOP
k_dcop:
    void openFile(const TQString &file) { open(file); }
    void openFile(const TQStringList &files) { open(files); }
    void openFile(const TQString &playlist, const TQString &file) { open(playlist, file); }
    void openFile(const TQString &playlist, const TQStringList &files) { open(playlist, files); }

    virtual TQStringList playlists() const = 0;
    virtual void createPlaylist(const TQString &) = 0;
    virtual void remove() = 0;

    virtual void removeTrack(const TQString &playlist, const TQString &file) { removeTrack(playlist, TQStringList(file)); }
    virtual void removeTrack(const TQString &playlist, const TQStringList &files) = 0;

    virtual TQString playlist() const = 0;
    virtual TQString playingPlaylist() const = 0;
    virtual void setPlaylist(const TQString &playlist) = 0;

    virtual TQStringList playlistTracks(const TQString &playlist) const = 0;
    virtual TQString trackProperty(const TQString &file, const TQString &property) const = 0;

    virtual TQPixmap trackCover(const TQString &file, const TQString &size = "Small") const = 0;

protected:
    CollectionIface() : DCOPObject("Collection") {}
    virtual void open(const TQStringList &files) = 0;
    virtual void open(const TQString &playlist, const TQStringList &files) = 0;
};

class PlayerIface : public DCOPObject
{
    K_DCOP
k_dcop:
    virtual bool playing() const = 0;
    virtual bool paused() const = 0;
    virtual float volume() const = 0;
    virtual int status() const = 0;
    
    virtual TQStringList trackProperties() = 0;
    virtual TQString trackProperty(const TQString &property) const = 0;
    virtual TQPixmap trackCover(const TQString &size = "Small") const = 0;

    virtual TQString currentFile() const
    {
        return trackProperty("Path");
    }

    virtual void play() = 0;
    virtual void play(const TQString &file) = 0;
    virtual void pause() = 0;
    virtual void stop() = 0;
    virtual void playPause() = 0;

    virtual void back() = 0;
    virtual void forward() = 0;
    virtual void seekBack() = 0;
    virtual void seekForward() = 0;
    virtual void forwardAlbum() = 0;

    virtual void volumeUp() = 0;
    virtual void volumeDown() = 0;
    virtual void mute() = 0;
    virtual void setVolume(float volume) = 0;
    virtual void seek(int time) = 0;

    virtual TQString playingString() const = 0;
    virtual int currentTime() const = 0;
    virtual int totalTime() const = 0;

    /**
     * @return The current player mode.
     * @see setRandomPlayMode()
     */
    virtual TQString randomPlayMode() const = 0;

    /**
     * Sets the player mode to one of normal, random play, or album
     * random play, depending on @p randomMode.
     * "NoRandom" -> Normal
     * "Random" -> Random
     * "AlbumRandom" -> Album Random
     */
    virtual void setRandomPlayMode(const TQString &randomMode) = 0;

protected:
    PlayerIface() : DCOPObject("Player") {}
};

class SearchIface : public DCOPObject
{
    K_DCOP
k_dcop:
    virtual TQString searchText() const = 0;
    virtual void setSearchText(const TQString &text) = 0;

protected:
    SearchIface() : DCOPObject("Search") {}
};

#endif
