/***************************************************************************
 *   Copyright (C) 2005 by Mark Six                                        *
 *   marksix@xs4all.nl                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "kportview.h"
#include <tqlayout.h>
#include <tqlabel.h>

KPortView::KPortView( CPicoBlaze *cpu, TQWidget *parent, const char *name)
 : TDEToolBar(parent, name)
{
	m_cpu = cpu ;
	
	TQWidget *widget = new TQWidget( this ) ;
	widget->setMinimumSize( 200, 65 ) ;
	
	TQLabel *label = new TQLabel( "ID", widget ) ;
	label->move( 3, 0 ) ;
	
	label = new TQLabel( "b7", widget ) ;
	label->move( 32, 0 ) ;

	label = new TQLabel( "b0", widget ) ;
	label->move( 137, 0 ) ;
	
	label = new TQLabel( "I", widget ) ;
	label->move( 160, 0 ) ;
	
	label = new TQLabel( "O", widget ) ;
	label->move( 175, 0 ) ;
	
	m_editID = new KLineEdit( widget ) ;
	m_editID->setText( "0" ) ;
	m_editID->setFixedSize( 30, 20 ) ;
	m_editID->move( 2, 22 );
	connect( m_editID, TQ_SIGNAL( textChanged( const TQString &) ), this, TQ_SLOT( setID( const TQString &) ) ) ;
	
	int i ;
	for ( i = 0 ; i < 8 ; i++ ) {
		m_bits[ i ] = new TQCheckBox( widget ) ;
		m_bits[ i ]->move( 35 + i * 15, 22 ) ;
	}
	
	m_readable = new TQCheckBox( widget ) ;
	m_readable->move( 160, 22 ) ;
	
	m_writeable = new TQCheckBox( widget ) ;
	m_writeable->move( 175, 22 ) ;

	m_port = new KPort( 0 ) ;
	m_cpu->addPort( m_port ) ;
	
	connect( m_port, TQ_SIGNAL( read() ), this, TQ_SLOT( read() ) ) ;
	connect( m_port, TQ_SIGNAL( write(unsigned char) ), this, TQ_SLOT( write(unsigned char) ) ) ;
	connect( m_readable, TQ_SIGNAL( toggled(bool) ), this, TQ_SLOT( readableToggled(bool) ) ) ;
	connect( m_writeable, TQ_SIGNAL( toggled(bool) ), this, TQ_SLOT( writeableToggled(bool) ) ) ;
	
	setWidget( widget ) ;
	setCloseMode( Always ) ;

	m_writeable->setChecked( true ) ;
	writeableToggled( true ) ;
	m_readable->setChecked( true ) ;
	readableToggled( true ) ;

	setResizeEnabled( true ) ;

	m_backgroundColor = m_editID->backgroundColor() ;
}

KPortView::~KPortView()
{
	m_cpu->deletePort( m_port ) ;
}
/*
void KPortView::closeEvent ( TQCloseEvent * e ) 
{
	emit closing( this ) ;
}
*/
void KPortView::setID( const TQString &newID )
{
	TQString str ;
	bool ok ;
	int id ;
	
	id = newID.toInt( &ok ) ;
	
	if ( ok && id >= 0 && id <= 255 ) {
		m_port->setID( id ) ;				// change it back to the old id
		m_editID->setText( newID ) ;
		m_editID->setBackgroundColor( m_backgroundColor ) ;
	} else {
		m_editID->setBackgroundColor( TQColor( 255, 128, 128 ) ) ;
	}


	/*else {
		str.sprintf( "%d", m_port->getID() ) ;
		m_editID->setText( str ) ;	
	}*/
}

TQString KPortView::id()
{
	return m_editID->text() ;
}

void KPortView::read()
{
	unsigned char value = 0 ;
	int i ;
	
	for ( i = 0 ; i < 8 ; i++ ) 
		if ( m_bits[ i ]->isChecked() )
			value |= ( 0x80 >> i ) ;
	
	m_port->setReadValue( value ) ;
}

void KPortView::write( unsigned char value )
{
	int i;
	for ( i = 0 ; i < 8 ; i++ ) 
		if  ( value & ( 0x80 >> i ) )
			m_bits[ i ]->setChecked( true ) ;
		else	
			m_bits[ i ]->setChecked( false ) ;
}

void KPortView::readableToggled( bool on )
{
	int mode = m_port->getMode() ;
	if ( on ) mode |= PortReadable ;
	else      mode &= ~PortReadable ;
	m_port->setMode( mode ) ;
}

void KPortView::writeableToggled( bool on )
{
	int mode = m_port->getMode() ;
	if ( on ) mode |= PortWriteable ;
	else      mode &= ~PortWriteable ;
	m_port->setMode( mode ) ;
}

void KPortView::readConfig( KSimpleConfig &config, TQString group ) 
{
	config.setGroup( group ) ;

	int mode = config.readPropertyEntry( "Mode", TQVariant::Int ).toInt() ;
	m_port->setMode( mode ) ;
	m_readable->setChecked( (mode & PortReadable) != 0 ) ;
	m_writeable->setChecked( (mode & PortWriteable ) != 0 ) ;

	TQString id = config.readEntry( "Id" ) ;
	setID( id ) ;
}

void KPortView::writeConfig( KSimpleConfig &config, TQString group ) 
{
	config.setGroup( group ) ;
	
	config.writeEntry( "Mode", m_port->getMode() ) ;
	config.writeEntry( "Id", m_port->getID() ) ;
}



#include "kportview.moc"
