# UniversalIndentGUI-TQt
A GUI frontend for several code formatters, beautifiers and indenters

Ever concerned about how your code looks like?
Ever heard of different indenting styles, for example K&R?
Ever received code from someone else who didn't care about code formatting?
Ever tried to configure a code indenter to convert such code to your coding style?
Ever got bored by that tedious "changing a parameter"-"call the indeter"-"try and error" procedure?

Help is close to you. UniversalIndentGUI-TQt offers a live preview for setting the parameters of nearly any indenter. You change the value of a parameter and directly see how your reformatted code will look like. Save your beauty looking code or create an anywhere usable batch/shell script to reformat whole directories or just one file even out of the editor of your choice that supports external tool calls.

Many free available code beautifier, formatter and indenter are currently supported, like GNU Indent, Uncrustify, Artistic Styler, PHP Stylist, Ruby Beautify, HTML Tidy and many other (look at features for complete list). Currently not supported indenters can be easyly added by creating a configuration file for them.

Thus UniversalIndentGUI-TQt is open for nearly any new indenter and programming languages. Give it a try.
Perhaps you'll also find an indenter for your programming language that you even didn't know that it exists.

## Features

* Live Preview: change an indenter parameter and directly see how your formatted code will look like.
* Support for many existing indenter possible.
* Easy adding of new indenters: just create a parameter definition file for the new indenter.
* Load and save different indenter configurations.
* Reset to indenters default parameters.
* Support for many programming languages through the various indenters
* Really easy to handle user interface.
* Tooltips for each indenter parameter.
* Creation of batch/shell scripts.
* Drag'n Drop of source code files.
* Support for many different file encodings, like Korean KOI8-R or Chinese BIG5.

## Contributing

If you wish to contribute to UniversalIndentGUI-TQt (TDE), you might do so:

- TDE Gitea Workspace (TGW) collaboration tool.
  https://mirror.git.trinitydesktop.org/gitea
