#ifndef _LIBKVIAVATAR_H_
#define _LIBKVIAVATAR_H_
//=============================================================================
//
//   File : libkviavatar.cpp
//   Creation date : Thu Nov 12 02:32:59 2004 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include <tqdialog.h>

class TQLineEdit;
class KviIrcConnection;

class KviAsyncAvatarSelectionDialog : public TQDialog
{
	TQ_OBJECT
  
public:
	KviAsyncAvatarSelectionDialog(TQWidget * par,const TQString &szInitialPath,KviIrcConnection * c);
	~KviAsyncAvatarSelectionDialog();
protected:
	TQLineEdit        * m_pLineEdit;
	TQString            m_szAvatarName;
	KviIrcConnection * m_pConnection;
protected:
	virtual void closeEvent(TQCloseEvent * e);
	const TQString &avatarName(){ return m_szAvatarName; };
protected slots:
	void okClicked();
	void cancelClicked();
	void chooseFileClicked();
};


#endif //!_LIBKVIAVATAR_H_
