//=============================================================================
//
//   File : packthemedialog.cpp
//   Created on Wed 03 Jan 2007 01:11:44 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2007 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "packthemedialog.h"
#include "themefunctions.h"

#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqregexp.h>
#include <tqmessagebox.h>
#include <tqdir.h>
#include <tqcombobox.h>
#include <tqpainter.h>
#include <tqtooltip.h>
#include <tqimage.h>
#include <kvi_tal_textedit.h>
#include <tqmultilineedit.h>
#include <tqbuffer.h>
#include <tqlabel.h>
#include <tqregexp.h>


#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_config.h"
#include "kvi_fileutils.h"
#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_iconmanager.h"
#include "kvi_styled_controls.h"
#include "kvi_packagefile.h"
#include "kvi_fileextensions.h"
#include "kvi_filedialog.h"
#include "kvi_msgbox.h"
#include "kvi_selectors.h"
#include "kvi_miscutils.h"
#include "kvi_sourcesdate.h"



KviPackThemeDialog::KviPackThemeDialog(TQWidget * pParent,KviPointerList<KviThemeInfo> * pThemeInfoList)
: KviTalWizard(pParent)
{
	m_pThemeInfoList = pThemeInfoList;

	KviThemeInfo * pThemeInfo;
	TQString szPackageName;
	TQString szPackageAuthor;
	TQString szPackageDescription;
	TQString szPackageVersion;

	m_szPackagePath = TQDir::homeDirPath();
	KviTQString::ensureLastCharIs(m_szPackagePath,TQChar(KVI_PATH_SEPARATOR_CHAR));

	bool bPackagePathSet = false;

	if(m_pThemeInfoList->count() > 1)
	{
		szPackageName = "MyThemes";
		szPackageAuthor = __tr2qs_ctx("Your name here","theme");
		szPackageVersion = "1.0.0";
		szPackageDescription = __tr2qs_ctx("Put a package description here...","theme");
	} else {
		if(m_pThemeInfoList->count() > 0)
		{
			pThemeInfo = m_pThemeInfoList->first();
			szPackageName = pThemeInfo->subdirectory();
			szPackageAuthor = pThemeInfo->author();
			szPackageDescription = pThemeInfo->description();
			szPackageVersion = pThemeInfo->version();

			m_szPackagePath += pThemeInfo->subdirectory();
			if(m_szPackagePath.find(TQRegExp("[0-9]\\.[0-9]")) == -1)
			{
				m_szPackagePath += "-";
				m_szPackagePath += szPackageVersion;
			}
			m_szPackagePath += ".";
			m_szPackagePath += KVI_FILEEXTENSION_THEMEPACKAGE;
			
			bPackagePathSet = true;
		}
	}

	if(!bPackagePathSet)
	{
		m_szPackagePath += szPackageName;
		m_szPackagePath += "-";
		m_szPackagePath += szPackageVersion;
		m_szPackagePath += ".";
		m_szPackagePath += KVI_FILEEXTENSION_THEMEPACKAGE;
	}

	setCaption(__tr2qs_ctx("Export Theme - KVIrc","theme"));
	setMinimumSize(400,350);

	// welcome page ==================================================================================
	TQWidget * pPage = new TQWidget(this);
	TQGridLayout * pLayout = new TQGridLayout(pPage,2,1,4,4);
	
	TQLabel * pLabel = new TQLabel(pPage);
	TQString szText = "<p>";
	szText += __tr2qs_ctx("This procedure allows you to export the selected themes to a single package. It is useful when you want to distribute your themes to the public.","theme");
	szText += "</p><p>";
	szText += __tr2qs_ctx("You will be asked to provide a package name, a description and, if you want, an icon/screenshot.","theme");
	szText += "</p><p>";
	szText += __tr2qs_ctx("Hit the \"Next\" button to begin.","theme");
	szText += "<p>";
	
	pLabel->setText(szText);
	pLayout->addWidget(pLabel,0,0);
	pLayout->setRowStretch(1,1);
	
	addPage(pPage,__tr2qs_ctx("Welcome","theme"));
	setBackEnabled(pPage,false);
	setNextEnabled(pPage,true);
	setHelpEnabled(pPage,false);
	setFinishEnabled(pPage,false);

	// theme data name ================================================================================

	pPage = new TQWidget(this);
	pLayout = new TQGridLayout(pPage,2,1,4,4);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("This is the information list for the themes you're packaging. If it looks OK press \"Next\" to continue, otherwise press \"Cancel\" and rewiew your themes first.","theme"));
	pLabel->setTextFormat(TQt::RichText);
	pLayout->addWidget(pLabel,0,0);

	TQString szThemesDescription = "<html><body bgcolor=\"#ffffff\">";

	int iIdx = 0;
	TQPixmap pixScreenshot;
	TQString szScreenshotPath;

	for(pThemeInfo = m_pThemeInfoList->first();pThemeInfo;pThemeInfo = m_pThemeInfoList->next())
	{
		TQString szThemeDescription;
		
		if(pixScreenshot.isNull())
		{
			pixScreenshot = pThemeInfo->smallScreenshot();
			if(!pixScreenshot.isNull())
				szScreenshotPath = pThemeInfo->smallScreenshotPath();
		}
		
		KviThemeFunctions::getThemeHtmlDescription(
			szThemeDescription,
			pThemeInfo->name(),
			pThemeInfo->version(),
			pThemeInfo->description(),
			pThemeInfo->subdirectory(),
			pThemeInfo->application(),
			pThemeInfo->author(),
			pThemeInfo->date(),
			pThemeInfo->themeEngineVersion(),
			pThemeInfo->smallScreenshot(),
			iIdx
		);

		if(iIdx > 0)
			szThemesDescription += "<hr>";
		szThemesDescription += szThemeDescription;
		iIdx++;
	}
	
	szThemesDescription += "</body></html>";

	KviTalTextEdit * pTextEdit = new KviTalTextEdit(pPage);
	pTextEdit->setPaper(TQBrush(TQColor(255,255,255)));
	pTextEdit->setReadOnly(true);
	pTextEdit->setText(szThemesDescription);
	pLayout->addWidget(pTextEdit,1,0);
	pLayout->setRowStretch(1,1);

	addPage(pPage,__tr2qs_ctx("Theme Data","theme"));
	setBackEnabled(pPage,true);
	setHelpEnabled(pPage,false);
	setNextEnabled(pPage,true);
	setFinishEnabled(pPage,false);

	// packager informations ================================================================================

	pPage = new TQWidget(this);
	pLayout = new TQGridLayout(pPage,5,2,4,4);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Here you need to provide informations about you (the packager) and a short description of the package you're creating.","theme"));
	pLabel->setTextFormat(TQt::RichText);
	pLayout->addMultiCellWidget(pLabel,0,0,0,1);
	
	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Package Name:","theme"));
	pLayout->addWidget(pLabel,1,0);
	
	m_pPackageNameEdit = new TQLineEdit(pPage);
	m_pPackageNameEdit->setText(szPackageName);
	pLayout->addWidget(m_pPackageNameEdit,1,1);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Version:","theme"));
	pLayout->addWidget(pLabel,2,0);
	
	m_pPackageVersionEdit = new TQLineEdit(pPage);
	m_pPackageVersionEdit->setText(szPackageVersion);
	pLayout->addWidget(m_pPackageVersionEdit,2,1);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Description:","theme"));
	pLayout->addWidget(pLabel,3,0);
	
	m_pPackageDescriptionEdit = new KviTalTextEdit(pPage);
	m_pPackageDescriptionEdit->setText(szPackageDescription);
	pLayout->addWidget(m_pPackageDescriptionEdit,3,1);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Package Author:","theme"));
	pLayout->addWidget(pLabel,4,0);
	
	m_pPackagerNameEdit = new TQLineEdit(pPage);
	m_pPackagerNameEdit->setText(szPackageAuthor);
	pLayout->addWidget(m_pPackagerNameEdit,4,1);


	pLayout->setRowStretch(3,1);
	pLayout->setColStretch(1,1);

	addPage(pPage,__tr2qs_ctx("Package Informations","theme"));
	setBackEnabled(pPage,true);
	setHelpEnabled(pPage,false);
	setNextEnabled(pPage,true);
	setFinishEnabled(pPage,false);

	// screenshot/logo/icon ================================================================================

	pPage = new TQWidget(this);
	pLayout = new TQGridLayout(pPage,3,1,4,4);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Here you can choose the image that will appear in the installation dialog for your theme package. It can be an icon, a logo or a screenshot and it should be not larger than 300x225. If you don't provide an image a simple default icon will be used at installation stage.","theme"));
	pLabel->setTextFormat(TQt::RichText);
	pLayout->addWidget(pLabel,0,0);
	
	m_pImageLabel = new TQLabel(pPage);
	m_pImageLabel->setFrameStyle(TQFrame::Sunken | TQFrame::Panel);
	m_pImageLabel->setMinimumSize(300,225);
	m_pImageLabel->setAlignment(TQt::AlignCenter | TQt::AlignVCenter);
	pLayout->addWidget(m_pImageLabel,1,0);

	TQString szFilter = "*.png *.jpg *.xpm";
	m_pImageSelector = new KviFileSelector(pPage,"",&m_szImagePath,true,0,szFilter);
	connect(m_pImageSelector,TQ_SIGNAL(selectionChanged(const TQString &)),this,TQ_SLOT(imageSelectionChanged(const TQString &)));
	pLayout->addWidget(m_pImageSelector,2,0);
	pLayout->setRowStretch(1,1);

	m_pImageSelectionPage = pPage;
	addPage(pPage,__tr2qs_ctx("Icon/Screenshot","theme"));
	setBackEnabled(pPage,true);
	setHelpEnabled(pPage,false);
	setNextEnabled(pPage,true);
	setFinishEnabled(pPage,false);

	// save file name ================================================================================

	pPage = new TQWidget(this);
	pLayout = new TQGridLayout(pPage,4,1,4,4);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Here you must choose the file name for the theme package. It should have a *.%1 extension.","theme").arg(KVI_FILEEXTENSION_THEMEPACKAGE));
	pLabel->setTextFormat(TQt::RichText);
	pLayout->addWidget(pLabel,0,0);

	szFilter = "*.";
	szFilter += KVI_FILEEXTENSION_THEMEPACKAGE;
	m_pPathSelector = new KviFileSelector(pPage,"",&m_szPackagePath,true,KviFileSelector::ChooseSaveFileName,szFilter);
	pLayout->addWidget(m_pPathSelector,1,0);

	pLabel = new TQLabel(pPage);
	pLabel->setText(__tr2qs_ctx("Finally hit the \"Finish\" button to complete the packaging operation.","theme"));
	pLabel->setTextFormat(TQt::RichText);
	pLayout->addWidget(pLabel,3,0);

	pLayout->setRowStretch(2,1);

	addPage(pPage,__tr2qs_ctx("Package Path","theme"));
	setBackEnabled(pPage,true);
	setHelpEnabled(pPage,false);
	setNextEnabled(pPage,false);
	setFinishEnabled(pPage,true);

	if(!szScreenshotPath.isEmpty())
	{
		m_pImageSelector->setSelection(szScreenshotPath);
		imageSelectionChanged(szScreenshotPath);
	}
}

KviPackThemeDialog::~KviPackThemeDialog()
{
}

void KviPackThemeDialog::imageSelectionChanged(const TQString &szImagePath)
{
	TQImage pix(szImagePath);
	if(!pix.isNull())
	{
		TQPixmap out;
		if(pix.width() > 300 || pix.height() > 225)
			out.convertFromImage(pix.smoothScale(300,225,TQImage::ScaleMin));
		else
			out.convertFromImage(pix);
		m_pImageLabel->setPixmap(out);
		return;
	}

	TQMessageBox::critical(this,__tr2qs_ctx("Export Theme - KVIrc","theme"),__tr2qs_ctx("Failed to load the selected image","theme"),
		TQMessageBox::Ok,TQMessageBox::NoButton,TQMessageBox::NoButton);

	m_pImageSelector->setSelection("");
	m_pImageLabel->setPixmap(TQPixmap());
}


void KviPackThemeDialog::accept()
{
	if(!packTheme())return;
	KviTalWizard::accept();
}


bool KviPackThemeDialog::packTheme()
{
	m_pImageSelector->commit();
	m_pPathSelector->commit();

	TQString szPackageAuthor = m_pPackagerNameEdit->text();
	TQString szPackageName = m_pPackageNameEdit->text();
	TQString szPackageDescription = m_pPackageDescriptionEdit->text();
	TQString szPackageVersion = m_pPackageVersionEdit->text();

	TQImage pix(m_szImagePath);
	TQPixmap out;
	if(!pix.isNull())
	{
		if(pix.width() > 300 || pix.height() > 225)
			out.convertFromImage(pix.smoothScale(300,225,TQImage::ScaleMin));
		else
			out.convertFromImage(pix);
	} else {
		if(!m_szImagePath.isEmpty())
		{
			TQMessageBox::critical(this,__tr2qs_ctx("Export Theme - KVIrc","theme"),__tr2qs_ctx("Failed to load the selected image: please fix it","theme"),
				TQMessageBox::Ok,TQMessageBox::NoButton,TQMessageBox::NoButton);
			setCurrentPage(m_pImageSelectionPage);
			return false;
		}
	}

	KviPackageWriter f;

	TQString szTmp = TQDateTime::currentDateTime().toString();

	f.addInfoField("PackageType","ThemePack");
	f.addInfoField("ThemePackVersion","1");
	f.addInfoField("Name",szPackageName);
	f.addInfoField("Version",szPackageVersion);
	f.addInfoField("Author",szPackageAuthor);
	f.addInfoField("Description",szPackageDescription);
	f.addInfoField("Date",szTmp);
	f.addInfoField("Application","KVIrc " KVI_VERSION "." KVI_SOURCES_DATE);

	if(!out.isNull())
	{
		TQByteArray * pba = new TQByteArray();
		TQBuffer buffer(*pba);
		buffer.open(IO_WriteOnly);
		out.save(&buffer,"PNG");
		buffer.close();
		f.addInfoField("Image",pba); // cool :) [no disk access needed]
	}

	szTmp.setNum(m_pThemeInfoList->count());
	f.addInfoField("ThemeCount",szTmp);

	int iIdx = 0;
	for(KviThemeInfo * pInfo = m_pThemeInfoList->first();pInfo;pInfo = m_pThemeInfoList->next())
	{
		KviTQString::sprintf(szTmp,"Theme%dName",iIdx);
		f.addInfoField(szTmp,pInfo->name());
		KviTQString::sprintf(szTmp,"Theme%dVersion",iIdx);
		f.addInfoField(szTmp,pInfo->version());
		KviTQString::sprintf(szTmp,"Theme%dDescription",iIdx);
		f.addInfoField(szTmp,pInfo->description());
		KviTQString::sprintf(szTmp,"Theme%dDate",iIdx);
		f.addInfoField(szTmp,pInfo->date());
		KviTQString::sprintf(szTmp,"Theme%dSubdirectory",iIdx);
		f.addInfoField(szTmp,pInfo->subdirectory());
		KviTQString::sprintf(szTmp,"Theme%dAuthor",iIdx);
		f.addInfoField(szTmp,pInfo->author());
		KviTQString::sprintf(szTmp,"Theme%dApplication",iIdx);
		f.addInfoField(szTmp,pInfo->application());
		KviTQString::sprintf(szTmp,"Theme%dThemeEngineVersion",iIdx);
		f.addInfoField(szTmp,pInfo->themeEngineVersion());
		TQPixmap pixScreenshot = pInfo->smallScreenshot();
		if(!pixScreenshot.isNull())
		{
			KviTQString::sprintf(szTmp,"Theme%dScreenshot",iIdx);
			TQByteArray * pba = new TQByteArray();
			TQBuffer bufferz(*pba);
			bufferz.open(IO_WriteOnly);
			pixScreenshot.save(&bufferz,"PNG");
			bufferz.close();
			f.addInfoField(szTmp,pba);
		}

		if(!f.addDirectory(pInfo->absoluteDirectory(),pInfo->subdirectory()))
		{
			szTmp = __tr2qs_ctx("Packaging failed","theme");
			szTmp += ": ";
			szTmp += f.lastError();
			TQMessageBox::critical(this,__tr2qs_ctx("Export Theme - KVIrc","theme"),szTmp,
					TQMessageBox::Ok,TQMessageBox::NoButton,TQMessageBox::NoButton);
		}

		iIdx++;
	}

	if(!f.pack(m_szPackagePath))
	{
		szTmp = __tr2qs_ctx("Packaging failed","theme");
		szTmp += ": ";
		szTmp += f.lastError();
		TQMessageBox::critical(this,__tr2qs_ctx("Export Theme - KVIrc","theme"),szTmp,
				TQMessageBox::Ok,TQMessageBox::NoButton,TQMessageBox::NoButton);
		return false;
	}
	
	//KviPackageReader r;
	//r.unpack("/root/test.kvt","/root/unpacked_test_kvt");

	TQMessageBox::information(this,__tr2qs_ctx("Export Theme - KVIrc","theme"),__tr2qs("Package saved succesfully"),
				TQMessageBox::Ok,TQMessageBox::NoButton,TQMessageBox::NoButton);

	return true;
}

