#include <tqtextstream.h>

#include "kword13utils.h"
#include "kword13layout.h"

KWord13Layout::KWord13Layout( void ) : m_outline( false )
{
}

KWord13Layout::~KWord13Layout( void )
{
}

void KWord13Layout::xmldump( TQTextStream& iostream )
{
    iostream << "    <layout name=\"" << EscapeXmlDump( m_name )
        << "\" outline=\"" << ( m_outline ? TQString("true") : TQString("false") ) << "\">\n";
    
    for ( TQMap<TQString,TQString>::ConstIterator it = m_layoutProperties.begin();
        it != m_layoutProperties.end();
        ++it)
    {
        iostream << "     <param key=\"" << it.key() << "\" data=\"" << EscapeXmlDump( it.data() ) << "\"/>\n";
    }
    
    m_format.xmldump( iostream );
    
    iostream << "    </layout>\n";
}

TQString KWord13Layout::key( void ) const
{
    TQString strKey;
    
    strKey += m_name;
    strKey += '@';
    
    // Use the number of properties as it is an easy sorting value
    strKey += TQString::number( m_layoutProperties.count(), 16 );
    strKey += ':';
    
    if ( m_outline )
        strKey += "O1,";
    else
        strKey += "O0,";
    
    // use the worst key: the whole TQMap (### FIXME)
    for ( TQMap<TQString,TQString>::const_iterator it = m_layoutProperties.constBegin() ;
        it != m_layoutProperties.constEnd(); ++it )
    {
        strKey += it.key();
        strKey += '=';
        strKey += it.data();
        strKey += ';';
    }
    
    strKey += '@';
    // At the end, the key from the <FORMAT id="1">
    strKey += m_format.key();
    
    return strKey;
}

TQString KWord13Layout::getProperty( const TQString& name ) const
{
    TQMap<TQString,TQString>::ConstIterator it ( m_layoutProperties.find( name ) );
    if ( it == m_layoutProperties.end() )
    {
        // Property does not exist
        return TQString();
    }
    else
    {
        return it.data();
    }
}

