/* This file is part of the KDE project
   Copyright (C) 2004 Matt Rogers <matt.rogers@kdemail.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDB_DRIVER_ODBC_H
#define KEXIDB_DRIVER_ODBC_H

//Kexi Includes
#include <kexidb/driver.h>

class TQCString;
class TQString;

namespace KexiDB
{

class Connection;
class DriverManager;
class ODBCDriverPrivate;

//! ODBC database driver.
/*!
 * This is the ODBC Driver for Kexi.
 * @author Matt Rogers <matt.rogers@kdemail.net>
 */
class ODBCDriver : public Driver
{
	TQ_OBJECT
  
	KEXIDB_DRIVER

	public:
		ODBCDriver( TQObject *parent, const char *name, const TQStringList &args = TQStringList() );
		~ODBCDriver();

		virtual bool isSystemDatabaseName( const TQString& name ) const;
		/** \return true if n is a system object name; 
		 * \todo Find out what is a system object name and what isn't  
		 */
		virtual bool isSystemObjectName( const TQString& name );

		/** 
		 * \return true if \a n is a system field name; 
		 * There aren't any system fields per tables, unless the table
		 * is a system table
		 */
		virtual bool isSystemFieldName( const TQString& name ) const;
		
		virtual TQString escapeString( const TQString& str ) const;
		virtual TQCString escapeString( const TQCString& str ) const;

	protected:
		virtual Connection *drv_createConnection( ConnectionData &conn_data );
};

}

#endif

