/* This file is part of the KDE project
   Copyright (C) 2004 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXINAMEWIDGET_H
#define KEXINAMEWIDGET_H

#include <tqlabel.h>
#include <tqlayout.h>
#include <klineedit.h>

namespace KexiUtils {
class Validator;
class MultiValidator;
}

class KEXIMAIN_EXPORT KexiNameWidget : public TQWidget
{
	TQ_OBJECT
  

	public:
		KexiNameWidget(const TQString& message, 
			TQWidget * parent = 0, const char * name = 0, WFlags fl = 0);

		KexiNameWidget(const TQString& message, 
			const TQString& nameLabel, const TQString& nameText, 
			const TQString& captionLabel, const TQString& captionText, 
			TQWidget * parent = 0, const char * name = 0, WFlags fl = 0);

		virtual ~KexiNameWidget(); 

		TQLabel* captionLabel() const { return lbl_caption; }
		TQLabel* nameLabel() const { return lbl_name; }
		KLineEdit* captionLineEdit() const { return le_caption; }
		KLineEdit* nameLineEdit() const { return le_name; }

		TQString messageText() const { return lbl_message->text(); }
		
		void setMessageText(const TQString& msg);

		//! \return entered caption text
		TQString captionText() const;

		void setCaptionText(const TQString& capt);
		//! \return entered name text, always in lower case

		TQString nameText() const;

		void setNameText(const TQString& name);

		/*! Sets i18n'ed warning message displayed when user leaves 'name' field
		 without filling it (if acceptsEmptyValue() is false). 
		 By default the message is equal "Please enter the name.". */
		void setWarningForName( const TQString& txt ) { m_nameWarning = txt; }

		/*! Sets i18n'ed warning message displayed when user leaves 'name' field
		 without filling it (if acceptsEmptyValue() is false). 
		 By default the message is equal "Please enter the caption." */
		void setWarningForCaption( const TQString& txt ) { m_captionWarning = txt; }

		/*! \return true if name or caption is empty. */
		bool empty() const;

		KexiUtils::Validator *nameValidator() const;

		/*! Adds subvalidator for name field. In fact it's is added to internal 
		 multivalidator. If \a owned is true, \a validator will be owned by the object.
		 \sa MultiValidator::addSubvalidator(). */
		void addNameSubvalidator( KexiUtils::Validator* validator, bool owned = true );

		/*! \return true if name text cannot be empty (true by default). */
		bool isNameRequired() const;

		void setNameRequired( bool set );

		/*! \return true if caption text cannot be empty (false by default). */
		bool isCaptionRequired() const { return m_caption_required; }

		void setCaptionRequired(bool set) { m_caption_required = set; }

	public slots:
		/*! Clears both name and caption. */
		virtual void clear();

		/*! Checks if both fields have valid values 
		 (i.e. not empty if acceptsEmptyValue() is false).
		 If not, warning message is shown and false is returned. */
		bool checkValidity();

	signals:
		/*! Emitted whenever return key is pressed on name or caption label. */
		void returnPressed();

		/*! Emitted whenever the caption or the name text changes */
		void textChanged();

		/*! Emitted whenever the message changes */
		void messageChanged();

	protected slots:
		void slotNameTxtChanged(const TQString&);
		void slotCaptionTxtChanged(const TQString&);
//		bool eventFilter( TQObject *obj, TQEvent *ev );
	
	protected:
		void init(
			const TQString& message, 
			const TQString& nameLabel, const TQString& nameText, 
			const TQString& captionLabel, const TQString& captionText);

		TQLabel* lbl_message;
		TQLabel* lbl_caption;
		TQLabel* lbl_name;
		KLineEdit* le_caption;
		KLineEdit* le_name;
		TQGridLayout* lyr;
		KexiUtils::MultiValidator *m_validator;
		TQString m_nameWarning, m_captionWarning;

		bool m_le_name_txtchanged_disable : 1;
		bool m_le_name_autofill : 1;
		bool m_caption_required : 1;

		friend class KexiNameDialog;
};

#endif
