/* This file is part of the KOffice project
 * Copyright (C) 2005 Thomas Zander <zander@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; version 2.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef kwstatistics_h
#define kwstatistics_h

class KWFrameSet;
class KWDocument;
class TQVBoxLayout;
class TQTabWidget;
class TQLabel;

#include <defs.h>
#include <kdialogbase.h>

/**
 * A class that calculates and show the statistics for a certain KWDocument
 */
class KWStatisticsDialog : public KDialogBase
{
    TQ_OBJECT
  

public:
    KWStatisticsDialog( TQWidget *parent, KWDocument *doc );
    bool wasCanceled()const { return m_canceled; }

private:
    KWDocument *m_doc;
    TQWidget *m_parent;
    bool m_canceled;
    TQLabel *m_resultLabelAll[7];
    TQLabel *m_resultLabelSelected[7];
    TQLabel *m_resultGeneralLabel[6];

    void addBox( TQFrame *page, TQLabel **resultLabel, bool calcWithFootNoteCheckbox );
    void addBoxGeneral( TQFrame *page, TQLabel **resultLabel );

    bool calcStats( TQLabel **resultLabel, bool selection, bool useFootEndNote );
    void calcGeneral( TQLabel **resultLabel );
    bool docHasSelection()const;
    double calcFlesch(ulong sentences, ulong words, ulong syllables);
private slots:
    void slotRefreshValue(bool);
};

#endif
