/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _KO_PALETTE_
#define _KO_PALETTE_

#include <tqdockwindow.h>
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqtoolbutton.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <tqfont.h>
#include <tqlayout.h>
#include <koffice_export.h>

#include "kopalettemanager.h"
/**
 * A floating palette that allows the adding and removing of widgets
 * to its organzing principle.
 *
 * There is currently no titlebar with a shade button; I hope to be
 * able to use TQDockWidget's toggle view action for that.
 */
class KOPALETTE_EXPORT KoPalette : public TQDockWindow {

TQ_OBJECT
  

public:

    KoPalette(TQWidget * parent, const char * name);
    virtual ~KoPalette();

public:

    virtual void resetFont();
    
    void setStyle(enumKoPaletteStyle style) { m_style = style; };
    enumKoPaletteStyle style() { return m_style; };

    virtual void plug(TQWidget * widget, const TQString & name, int position) = 0;
    virtual void unplug(const TQWidget * widget) = 0;
    virtual void showPage(TQWidget *w) = 0;
    virtual void togglePageHidden(TQWidget *w) = 0;
    virtual void hidePage(TQWidget * w) = 0;
    virtual void makeVisible(bool v) = 0;
    virtual bool isHidden(TQWidget * w) = 0;
    virtual int indexOf(TQWidget *w) = 0;

protected:

    virtual void setMainWidget(TQWidget * widget);
    TQFont m_font;
    enumKoPaletteStyle m_style;
    
private:
    TQWidget * m_page;
    
};

#endif //_KO_PALETTE_
