/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __PERMISSION_DIALOG_H
#define __PERMISSION_DIALOG_H

// TDE
#include <kdialogbase.h>

typedef TQMap<TQString, TQString> Dictionary;

class TQVBox;
class TQHBox;
class TQLabel;

class TDEPermissionDialog : public KDialogBase
{
    TQ_OBJECT

    public:
        TDEPermissionDialog(TQString application, TQString feature,
                            TQString icon = "messagebox_question",
                            Dictionary details = {});
        virtual ~TDEPermissionDialog();

        void appendWidget(TQWidget *widget);

    private:
        TQVBox  *m_vbox;
        TQHBox  *m_hbox;
        TQLabel *m_icon;
        TQLabel *m_text;
        TQLabel *m_detail;
};

#endif // __PERMISSION_DIALOG_H