# Copyright 1999-2023 Gentoo Authors
# Copyright 2020-2023 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_LANGS="af ar az be bg bn br bs ca cs csb cy da de el en_GB eo es et
	eu fa fi fr fy ga gl he hi hr hu is it ja kk km ko lt lv mk mn ms
	nb nds nl nn pa pl pt pt_BR ro ru rw se sk sl sr sr@Latn ss sv ta te
	tg th tr uk uz uz@cyrillic vi wa zh_CN zh_TW"

TRINITY_MODULE_NAME="tde-i18n"
TRINITY_MODULE_TYPE="core"
inherit trinity-base-2

DESCRIPTION="Trinity internationalization package"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
SLOT="14"

for X in ${TRINITY_LANGS} ; do
	IUSE="${IUSE} l10n_${X}"
done

LINGUAS="en"

find_lang() {
	local lang
	lang=${1}
	LINGUAS+=" ${lang}"
}

src_prepare() {
	trinity_l10n_for_each_locale_do find_lang
	trinity-base-2_src_prepare
}

src_configure() {
	local mycmakeargs=( -DBUILD_ALL=ON )
	trinity-base-2_src_configure
}

src_install() {
	[[ "${LINGUAS}" == "en" ]] && return 0
	trinity-base-2_src_install
}
