 /*
    channellist.h - IRC Channel Search Widget

    Copyright (c) 2004      by Jason Keirstead <jason@keirstead.org>

    Kopete    (c) 2004      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef CHANNELLIST_H
#define CHANNELLIST_H

#include <tqwidget.h>
#include <tqmap.h>
#include <tqpair.h>

#include "kircengine.h"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQLabel;
class TQLineEdit;
class TQPushButton;
class TDEListView;
class TQSpinBox;
class TQListViewItem;

class ChannelList
	: public TQWidget
{
	TQ_OBJECT
  

	public:
		ChannelList( TQWidget *parent, KIRC::Engine *engine );

	public slots:
		void search();
		void reset();
		void clear();

	signals:
		void channelDoubleClicked( const TQString &channel );
		void channelSelected( const TQString &channel );

	private slots:
		void slotItemDoubleClicked( TQListViewItem * i );
		void slotItemSelected( TQListViewItem * i );
		void slotChannelListed( const TQString & channel, uint users, const TQString & topic );
		void slotListEnd();
		void slotSearchCache();
		void slotStatusChanged( KIRC::Engine::Status );

	private:
		void checkSearchResult( const TQString & channel, uint users, const TQString & topic );

		TQLabel* textLabel1_2;
		TQLineEdit* channelSearch;
		TQSpinBox* numUsers;
		TQPushButton* mSearchButton;
		TDEListView* mChannelList;
		TQVBoxLayout* ChannelListLayout;
		TQHBoxLayout* layout72_2;
		KIRC::Engine *m_engine;
		bool mSearching;
		TQString mSearch;
		uint mUsers;
		TQMap< TQString, TQPair< uint, TQString > > channelCache;
		TQMap< TQString, TQPair< uint, TQString > >::const_iterator cacheIterator;
};

#endif
