/****************************************************************************
** $Id$
**
** Created : 2001
**
** Copyright (C) 2001 Carsten Pfeiffer <pfeiffer@kde.org>
**
****************************************************************************/

#ifndef KDEACCOUNTSPARSER_H
#define KDEACCOUNTSPARSER_H

#include <tdeabc/formatplugin.h>

namespace TDEABC {
    class AddressBook;
}

class KDEAccountsFormat : public TDEABC::FormatPlugin
{
public:
    KDEAccountsFormat() {}
    ~KDEAccountsFormat() {}

    virtual bool loadAll( TDEABC::AddressBook *, 
                          TDEABC::Resource *resource, TQFile *file );

    virtual bool load( TDEABC::Addressee&, TQFile *)
    {
        tqDebug("*** KDE Accounts format: load single entry not supported.");
        return false;
    }
    virtual void save( const TDEABC::Addressee&, TQFile *)
    {
        tqDebug("*** KDE Accounts format: save not supported.");
    }
    virtual void saveAll( TDEABC::AddressBook *, TDEABC::Resource *, TQFile *)
    {
        tqDebug("*** KDE Accounts format: save not supported.");
    }
    virtual bool checkFormat( TQFile *file ) const
    {
        if ( file->name().endsWith( "/accounts" ) )
            return true; // lame, but works for me :)

        return false;
    }

};

#endif // KDEACCOUNTSPARSER_H
