/***************************************************************************
                     specialchardialog.cpp
                             -------------------

    copyright            : (C) 2004 - Michal Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqfile.h>
#include <tqpushbutton.h>
#include <tqtextstream.h>
#include <tqregexp.h> 

#include <tdelocale.h>
#include <kstandarddirs.h>
#include <tdelistbox.h>
#include <klineedit.h>

#include "specialchardialog.h"
#include "resource.h"

SpecialCharDialog::SpecialCharDialog( TQWidget* parent, const char* name, bool modal, WFlags fl)
    :SpecialCharDialogS( parent, name, modal, fl )
{
  connect ( FilterLineEdit, TQ_SIGNAL(textChanged(const TQString&)), 
      TQ_SLOT(filterChars(const TQString&)) );
  connect ( CharsListBox, TQ_SIGNAL(doubleClicked(TQListBoxItem*)), 
      TQ_SLOT(insertCode()) );
  connect (buttonOk, TQ_SIGNAL(clicked()), TQ_SLOT(insertCode()));
  connect (buttonChar, TQ_SIGNAL(clicked()), TQ_SLOT(insertChar()));
  connect (buttonCancel, TQ_SIGNAL(clicked()), TQ_SLOT(cancel()));
  filterChars("");
}

SpecialCharDialog::~SpecialCharDialog()
{
}

void SpecialCharDialog::filterChars(const TQString& filter)
{
  CharsListBox->clear();
  if (filter.isEmpty())
    CharsListBox->insertStringList(charList);
  else {
    for (TQStringList::ConstIterator it = charList.begin(); it != charList.end(); ++it)
      if ( (*it).contains(filter, false) )
        CharsListBox->insertItem(*it);
  }
  if (CharsListBox->currentItem() == -1 && CharsListBox->count())
    CharsListBox->setCurrentItem(0);
}

TQString SpecialCharDialog::selection()
{
  return m_selection;
}

void SpecialCharDialog::insertCode()
{
  TQString selected = CharsListBox->text(CharsListBox->currentItem());
  int begin = selected.find("(&")+1;
  int length = selected.find(";)") - begin + 1;
  m_selection = selected.mid(begin, length);
  done(TQDialog::Accepted);
}

void SpecialCharDialog::insertChar()
{
  m_selection = CharsListBox->text(CharsListBox->currentItem()).left(1);
  done(TQDialog::Accepted);
}

void SpecialCharDialog::cancel()
{
  m_selection = "";
  done(TQDialog::Rejected);
}

#include "specialchardialog.moc"
