/***************************************************************************
                          numberdialog.cpp  -  description
                             -------------------
    begin                : Don Apr 24 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "numberdialog.h"
#include "batchrenamer.h"

// TQt includes
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqtooltip.h>

// TDE includes
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <tqcheckbox.h>

void KMyIntSpinBox::keyPressEvent( TQKeyEvent* e )
{
    if( e->key() == Key_Return )
        emit returnPressed();
}

NumberDialog::NumberDialog(TQValueList<int> & n,TQWidget *parent )
    : KDialogBase( KDialogBase::Plain, "KRename",
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent, 0, true, true )
{
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    TQVBoxLayout* layout = new TQVBoxLayout( plainPage(), 6, 6 );

    TQGroupBox* group1 = new TQGroupBox( plainPage() );
    group1->setTitle( i18n("&Numbering") );
    group1->setColumnLayout(0, TQt::Vertical );
    group1->layout()->setSpacing( 6 );
    group1->layout()->setMargin( 11 );
    TQVBoxLayout* group1Layout = new TQVBoxLayout( group1->layout() );
    group1Layout->setAlignment( TQt::AlignTop );
    
    spinIndex = new KIntNumInput( group1 );
    spinIndex->setMaxValue( SPINMAX );
    spinIndex->setLabel( i18n( "Start &index:" ), AlignLeft | AlignVCenter );

    spinStep = new KIntNumInput( spinIndex, 1, group1 );
    spinStep->setRange( -SPINMAX, SPINMAX, 1, false );
    spinStep->setValue( 1 );
    spinStep->setLabel( i18n( "Step &by:" ), AlignLeft | AlignVCenter );

    checkResetCounter = new TQCheckBox( i18n("&Reset counter for every directory"), group1 );
    
    TQGroupBox* group2 = new TQGroupBox( plainPage() );
    group2->setTitle( i18n("S&kip Numbers") );
    group2->setColumnLayout(0, TQt::Horizontal );
    group2->layout()->setSpacing( 6 );
    group2->layout()->setMargin( 11 );
    TQHBoxLayout* group2Layout = new TQHBoxLayout( group2->layout() );
    group2Layout->setAlignment( TQt::AlignTop );

    listNumbers = new TDEListBox( group2 );

    buttonAdd = new KPushButton( group2 );
    buttonAdd->setText( i18n( "&Add Number" ) );

    buttonRemove = new KPushButton( group2 );
    buttonRemove->setText( i18n( "&Remove Number" ) );

    spinNumber = new KMyIntSpinBox( group2 );
    spinNumber->setMaxValue( SPINMAX );
    spinNumber->setMinValue( -SPINMAX );
    spinNumber->setValue( 0 );
    spinNumber->setFocus();

    TQVBoxLayout* layout2 = new TQVBoxLayout( 0, 6, 6 );
    layout2->addWidget( buttonAdd );
    layout2->addWidget( buttonRemove );
    layout2->addWidget( spinNumber );
    layout2->addItem( spacer );
                                                                
    group1Layout->addWidget( spinIndex );
    group1Layout->addWidget( spinStep );
    group1Layout->addWidget( checkResetCounter );
    
    group2Layout->addWidget( listNumbers );
    group2Layout->addLayout( layout2 );
    
    layout->addWidget( group1 );
    layout->addWidget( group2 );

    TQToolTip::add( spinIndex, i18n( "Number of the first file." ) );
    TQToolTip::add( spinStep, i18n( "The counter is increased/decreased by this value." ) );
    TQToolTip::add( listNumbers, i18n("Add all numbers that should be skipped by krename during the rename process.<br>"
    "E.g.: If 2 is skipped files will be numbered: file0, file1, file3, ...") );
    TQToolTip::add( checkResetCounter, i18n("<qt>The counter is set to the start index in every directory. "
                                           "This setting applies to all used counters.</qt>" ) );

    connect( buttonAdd, TQ_SIGNAL( clicked() ), this, TQ_SLOT( addNumber() ) );
    connect( buttonRemove,TQ_SIGNAL( clicked() ), this, TQ_SLOT( removeNumber() ) );
    connect( spinNumber, TQ_SIGNAL( returnPressed()), this, TQ_SLOT( addNumber() ) );
    
    for( unsigned int i = 0; i < n.count(); i++ )
            listNumbers->insertItem( TQString("%1").arg(n[i]), -1 );

    update();
}

NumberDialog::~NumberDialog()
{
}

void NumberDialog::addNumber()
{
    TQString tmp = TQString("%1").arg(spinNumber->value());
    for( unsigned int i = 0; i < listNumbers->count(); i++ )
        if( listNumbers->text(i) == tmp )
            return;
    listNumbers->insertItem( tmp, -1 );
    sort();
}

void NumberDialog::removeNumber()
{
    unsigned int i = 0;
    do {
        if(listNumbers->isSelected( i )) {
            listNumbers->removeItem( i );
            listNumbers->setSelected( i-1, true );
            return;
        } else
            i++;
    } while( i < listNumbers->count() );
}

TQValueList<int> NumberDialog::getList()
{
    TQValueList<int> skip;
    for( unsigned int i = 0; i < listNumbers->count(); i++ )
        skip.append( listNumbers->text(i).toInt() );

    return skip;
}

void NumberDialog::sort()
{
    // Not very fast, but I hope it won't be used on ot big lists ;)
    if( listNumbers->count() < 1 )
        return;

    for( unsigned int i = 0; i < listNumbers->count()-1; i++) {
        if( listNumbers->text(i).toInt() > listNumbers->text(i+1).toInt() ) {
            TQString tmp = listNumbers->text(i);
            listNumbers->removeItem(i);
            listNumbers->insertItem( tmp, i+1 );
            i = 0;
        }
    }
}

#include "numberdialog.moc"
