
#ifndef DIRDIALOG_H
#define DIRDIALOG_H

#include <kdialog.h>

class Config;

class TQCheckBox;

class KLineEdit;
class KPushButton;
// class KURLRequester;
class TDEListBox;

/**
 * @short The Replay Gain Tool
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class DirDialog : public KDialog
{
    TQ_OBJECT
  
public:
    enum Mode {
        Convert    = 0x0001,
        ReplayGain = 0x0002
    };

    /**
     * Constructor
     */
    DirDialog( Config*, Mode, TQWidget* parent=0, const char* name=0, bool modal=true, WFlags f=0 );

    /**
     * Destructor
     */
    virtual ~DirDialog();

    TQString directory;
    TQStringList selectedFileTypes;
    bool recursive;

private slots:
    void selectDirectoryClicked();
    void okClicked();
    void selectAllClicked();
    void selectNoneClicked();
    void recursiveToggled( bool );

private:
//     KURLRequester* uDirectory;
    KLineEdit* lDirectory;
    KPushButton* pDirectory;
    TDEListBox* fileTypes;
    KPushButton* pSelectAll;
    KPushButton* pSelectNone;
    TQCheckBox* cRecursive;
    KPushButton* pCancel;
    KPushButton* pOk;

};


#endif
