/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

// much of this code is adapted from libtdepim
// which is GPL licensed, Copyright (c) 2004 David Faure

#ifndef TELLICO_GUI_OVERLAYWIDGET_H
#define TELLICO_GUI_OVERLAYWIDGET_H

#include <tqframe.h>

namespace Tellico {
  namespace GUI {

/**
 * @author Robby Stephenson
 */
class OverlayWidget : public TQFrame {
TQ_OBJECT
  

public:
  OverlayWidget(TQWidget* parent, TQWidget* anchor);

  void setCorner(Corner corner);
  Corner corner() const { return m_corner; }

  void addWidget(TQWidget* widget);

protected:
  void resizeEvent(TQResizeEvent* event);
  bool eventFilter(TQObject* object, TQEvent* event);
  bool event(TQEvent* event);

private:
  void reposition();

  TQWidget* m_anchor;
  Corner m_corner;
};

  } // end namespace
} // end namespace

#endif
