/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  lets the user choose a nick from the list
  begin:     Sam Dez 7 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#ifndef DCCRECIPIENTDIALOG_H
#define DCCRECIPIENTDIALOG_H

#include <kdialogbase.h>


class KLineEdit;

class DccRecipientDialog : public KDialogBase
{
    TQ_OBJECT
  

        public:
        DccRecipientDialog(TQWidget* parent, const TQStringList &list, const TQSize &size);
        ~DccRecipientDialog();

        static TQString getNickname(TQWidget* parent, const TQStringList& list);

    protected slots:
        void newNicknameSelected(TQListBoxItem* item);
                                                  // KDE double click
        void newNicknameSelectedQuit(TQListBoxItem* item);

        void slotOk();
        void slotCancel();

    protected:
        TQString getSelectedNickname();
        static TQString selectedNickname;

        KLineEdit* nicknameInput;
};
#endif
