/***************************************************************************
                          setpageengines.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETPAGEENGINES_H
#define SETPAGEENGINES_H

#include <kbuttonbox.h>
#include <tdelistview.h>
#include <kcombobox.h>
#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqwidget.h>
#include <tqgroupbox.h>
#include <tqptrlist.h>
#include <tqhbox.h>
#include <tqlayout.h>
#include "resource.h"
#include "dlg_engine.h"

/**
  *@author Troy Corbin Jr.
  */

class setPageEngines : public TQVBoxLayout
{
   TQ_OBJECT
  
	public:
						setPageEngines(TQWidget *parent=0, resource *Rsrc=0);
						~setPageEngines();
		
	public slots:
					
		void									slotEngine_Add( void );
		void									slotEngine_Modify( void );
		void									slotEngine_Delete( void );

		void									slotCurrent_White( int );
		void									slotCurrent_White_Book( int );
		void									slotCurrent_Black( int );
		void									slotCurrent_Black_Book( int );

		void									slotToggle_White_Book( bool );
		void									slotToggle_Black_Book( bool );

	signals:
	
		void									enableApply( void );

	protected slots:
		void									BuildEngineData( void );
		void									selectionChanged( void );

	private:
		TQWidget 							*Parent;
		resource							*Resource;

		TQHBox									*BOX_Current;
  		TQGroupBox							*GROUP_White_Current;
  			KComboBox							*Engines_White;
  			TQCheckBox							*White_Use_Book;
  			KComboBox							*Engines_White_Book;
  		TQGroupBox							*GROUP_Black_Current;
  			KComboBox							*Engines_Black;
  			TQCheckBox							*Black_Use_Book;
  			KComboBox							*Engines_Black_Book;

		TQGroupBox							*GROUP_Engines;
			TDEListView							*Engines_ListView;
			KButtonBox						*Engines_ButtonBox;
				TQPushButton					*Engines_Button_Add;
				TQPushButton					*Engines_Button_Change;
				TQPushButton					*Engines_Button_Delete;
		dlg_engine						*Engine_Dialog;
};

#endif
