/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include <tqtooltip.h>
#include <tqimage.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeaction.h>
#include <tdemessagebox.h>
#include "kvpnckicker.h"
#include "kvpnc.h"

KVpncKicker::KVpncKicker( KVpncConfig *GlobalConfig,TQWidget* parent, const char *name  )
		: KSystemTray( parent, name ) {
	this->parent = parent;
	this->initDockWindow();
	this->GlobalConfig = GlobalConfig;
	     TDEAction *quit = actionCollection()->action( "file_quit" );
        quit->disconnect();
        KVpnc *myParent = static_cast<KVpnc *>( parent );
    connect( quit, TQ_SIGNAL( activated() ), myParent, TQ_SLOT( quitCalledKicker() ) );

	show();
}

KVpncKicker::~KVpncKicker() {}

void KVpncKicker::closeEvent( TQCloseEvent *e  )
{
	if ( GlobalConfig->KvpncDebugLevel > 1 )
		GlobalConfig->appendLogEntry ( i18n ( "CloseEvent recieved (reciever: %1)." ).arg("kvpnckicker"), GlobalConfig->debug );

	emit closeEventKicker(e);
}

void KVpncKicker::enterEvent( TQEvent* e )
{
	if (e->type() == TQEvent::Enter)
		emit tooltipRequested();
	
	KSystemTray::enterEvent(e);
	
}

void KVpncKicker::setStatus( int status ) {
	if ( status == connecting ) {
		setPixmap( connectingIcon );
	}
	else if (status ==  connected){
		setPixmap( connectedIcon );
	}
	else
		setPixmap( disconnectedIcon );
}

void KVpncKicker::initDockWindow() {
	disconnectedIcon = loadIcon( "disconnected");
	connectedIcon = loadIcon( "connected"  );
	connectingIcon = loadIcon( "connecting" );
	//setFixedSize( DOCK_WIDTH, DOCK_HEIGHT );
	setPixmap( disconnectedIcon );
	TQToolTip::add(this, i18n("Disconnected"));
}

TDEPopupMenu* KVpncKicker::menu() {
	return contextMenu();
}

#include "kvpnckicker.moc"
