/***************************************************************************
    smb4knetworkbrowsertooltip  -  Tool tip for the network browser.
                             -------------------
    begin                : Sa Jan 20 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqtooltip.h>
#include <tqdesktopwidget.h>
#include <tqapplication.h>
#include <tqtimer.h>

// KDE includes
#include <tdelocale.h>

// application specific includes
#include "smb4knetworkbrowsertooltip.h"
#include "smb4knetworkbrowseritem.h"

Smb4KNetworkBrowserToolTip::Smb4KNetworkBrowserToolTip( Smb4KNetworkBrowserItem *item )
: TQLabel( 0, "NetworkBrowserToolTip", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM | WDestructiveClose ), m_item( item )
{
  setPalette( TQToolTip::palette() );
  setLineWidth( 1 );
  setMidLineWidth( 1 );
  setFrameShape( Box );
  setFrameShadow( Plain );
  setMouseTracking( true );

  m_layout = new TQGridLayout( this );
  m_layout->setMargin( 10 );
  m_layout->setSpacing( 3 );

  // We will set up the tip in the showTip() function.
}


Smb4KNetworkBrowserToolTip::~Smb4KNetworkBrowserToolTip()
{
  // Never touch the Smb4KNetworkBrowserItem object here
}


void Smb4KNetworkBrowserToolTip::showTip( const TQPoint &pos )
{
  if ( !m_item || isShown() )
  {
    return;
  }

  setupTip();

  adjustSize();

  TQPoint p( pos );

  TQDesktopWidget *d = TQApplication::desktop();

  if ( p.x() + width() > d->width() )
  {
    p.setX( p.x() - width() - 5 );
  }
  else
  {
    p.setX( p.x() + 5 );
  }

  if ( p.y() + height() > d->height() )
  {
    p.setY( p.y() - height() - 5 );
  }
  else
  {
    p.setY( p.y() + 5 );
  }

  setGeometry( p.x(), p.y(), width(), height() );
  polish();
  show();
  TQTimer::singleShot( 10000, this, TQ_SLOT( slotHideToolTip() ) );
}


void Smb4KNetworkBrowserToolTip::setupTip()
{
  switch ( m_item->type() )
  {
    case Smb4KNetworkBrowserItem::Workgroup:
    {
      TQLabel *workgroup_label =    new TQLabel( i18n( "Workgroup:" ), this );
      TQLabel *workgroup =          new TQLabel( m_item->workgroupItem()->name() , this );

      TQString master_label_entry = m_item->workgroupItem()->hasPseudoMaster() ? i18n( "Pseudo master browser:" ) : i18n( "Master browser:" );
      TQLabel *master_label =       new TQLabel( master_label_entry, this );

      TQString master_entry =       m_item->workgroupItem()->masterIP().isEmpty() ?
                                   (m_item->workgroupItem()->master().isEmpty() ? i18n( "Unknown" ) : m_item->workgroupItem()->master()) :
                                   m_item->workgroupItem()->master() + " ("+m_item->workgroupItem()->masterIP()+")";
      TQLabel *master =             new TQLabel( master_entry, this, "MasterBrowser" );

      m_layout->addWidget( workgroup_label, 0, 1, 0 );
      m_layout->addWidget( workgroup, 0, 2, 0 );
      m_layout->addWidget( master_label, 1, 1, 0 );
      m_layout->addWidget( master, 1, 2, 0 );

      break;
    }
    case Smb4KNetworkBrowserItem::Host:
    {
      TQLabel *host_label =       new TQLabel( i18n( "Host:" ), this );
      TQLabel *host =             new TQLabel( m_item->hostItem()->name(), this );

      TQLabel *comment_label =    new TQLabel( i18n( "Comment:" ), this );
      TQLabel *comment =          new TQLabel( m_item->hostItem()->comment(), this );

      TQLabel *ip_label =         new TQLabel( i18n( "IP address:" ), this );
      TQString ip_entry =         m_item->hostItem()->ip().isEmpty() ? i18n( "Unknown" ) : m_item->hostItem()->ip();
      TQLabel *ip_address =       new TQLabel( ip_entry, this, "IPAddress" );

      TQLabel *os_label =         new TQLabel( i18n( "Operating system:" ), this );
      TQLabel *operating_system = new TQLabel( m_item->hostItem()->osString().isEmpty() ? i18n( "Unknown" ) :
                                             m_item->hostItem()->osString(), this, "OSString" );

      TQLabel *server_label =     new TQLabel( i18n( "Server string:" ), this );
      TQLabel *server_string =    new TQLabel( m_item->hostItem()->serverString().isEmpty() ? i18n( "Unknown" ) :
                                             m_item->hostItem()->serverString(), this, "ServerString" );

      TQFrame *line = new TQFrame( this );
      line->setLineWidth( 1 );
      line->setMidLineWidth( 0 );
      line->setFixedWidth( 100 );
      line->setFrameShape( TQFrame::HLine );
      line->setFrameShadow( TQFrame::Plain );

      TQLabel *workgroup_label =  new TQLabel( i18n( "Workgroup:" ), this );
      TQLabel *workgroup =        new TQLabel( m_item->hostItem()->workgroup(), this );

      Smb4KWorkgroupItem *workgroup_item = static_cast<Smb4KNetworkBrowserItem *>( m_item->parent() )->workgroupItem();
      TQLabel *master_label =     new TQLabel( i18n( "Master browser:" ), this );
      TQLabel *master_yes_no =    new TQLabel( (workgroup_item && !workgroup_item->master().isEmpty()) ?
                                             workgroup_item->master() : i18n( "Unknown" ), this );

      m_layout->addWidget( host_label, 0, 1, 0 );
      m_layout->addWidget( host, 0, 2, 0 );
      m_layout->addWidget( comment_label, 1, 1, 0 );
      m_layout->addWidget( comment, 1, 2, 0 );
      m_layout->addWidget( ip_label, 2, 1, 0 );
      m_layout->addWidget( ip_address, 2, 2, 0 );
      m_layout->addWidget( os_label, 3, 1, 0 );
      m_layout->addWidget( operating_system, 3, 2, 0 );
      m_layout->addWidget( server_label, 4, 1, 0 );
      m_layout->addWidget( server_string, 4, 2, 0 );
      m_layout->addMultiCellWidget( line, 5, 5, 1, 2, TQt::AlignCenter );
      m_layout->addWidget( workgroup_label, 6, 1, 0 );
      m_layout->addWidget( workgroup, 6, 2, 0 );
      m_layout->addWidget( master_label, 7, 1, 0 );
      m_layout->addWidget( master_yes_no, 7, 2, 0 );

      break;
    }
    case Smb4KNetworkBrowserItem::Share:
    {
      TQLabel *share_label =   new TQLabel( i18n( "Share:" ), this );
      TQLabel *share =         new TQLabel( m_item->shareItem()->name(), this );

      TQLabel *comment_label = new TQLabel( i18n( "Comment:" ), this );
      TQLabel *comment =       new TQLabel( m_item->shareItem()->comment(), this );

      TQLabel *type_label =    new TQLabel( i18n( "Type:" ), this );
      TQLabel *type =          new TQLabel( m_item->shareItem()->translatedType(), this );

      TQLabel *mounted_label = NULL;
      TQLabel *mounted = NULL;

      if ( !m_item->isPrinter() )
      {
        mounted_label = new TQLabel( i18n( "Mounted:" ), this );
        mounted =       new TQLabel( m_item->isMounted() ? i18n( "Yes" ) : i18n( "No" ), this );
      }

      TQFrame *line = new TQFrame( this );
      line->setLineWidth( 1 );
      line->setMidLineWidth( 0 );
      line->setFixedWidth( 100 );
      line->setFrameShape( TQFrame::HLine );
      line->setFrameShadow( TQFrame::Plain );

      TQLabel *host_label =    new TQLabel( i18n( "Host:" ), this );
      TQLabel *host =          new TQLabel( m_item->shareItem()->host(), this );

      Smb4KHostItem *host_item = static_cast<Smb4KNetworkBrowserItem *>( m_item->parent() )->hostItem();
      TQLabel *ip_label =      new TQLabel( i18n( "IP address:" ), this );
      TQLabel *ip_address =    new TQLabel( (host_item && !host_item->ip().isEmpty()) ?
                                          host_item->ip() : i18n( "Unknown" ), this, "IPAddress" );

      m_layout->addWidget( share_label, 0, 1, 0 );
      m_layout->addWidget( share, 0, 2, 0 );
      m_layout->addWidget( comment_label, 1, 1, 0 );
      m_layout->addWidget( comment, 1, 2, 0 );
      m_layout->addWidget( type_label, 2, 1, 0 );
      m_layout->addWidget( type, 2, 2, 0 );

      if ( !m_item->isPrinter() )
      {
        m_layout->addWidget( mounted_label, 3, 1, 0 );
        m_layout->addWidget( mounted, 3, 2, 0 );
        m_layout->addMultiCellWidget( line, 4, 4, 1, 2, TQt::AlignCenter );
        m_layout->addWidget( host_label, 5, 1, 0 );
        m_layout->addWidget( host, 5, 2, 0 );
        m_layout->addWidget( ip_label, 6, 1, 0 );
        m_layout->addWidget( ip_address, 6, 2, 0 );
      }
      else
      {
        m_layout->addMultiCellWidget( line, 3, 3, 1, 2, TQt::AlignCenter );
        m_layout->addWidget( host_label, 4, 1, 0 );
        m_layout->addWidget( host, 4, 2, 0 );
        m_layout->addWidget( ip_label, 5, 1, 0 );
        m_layout->addWidget( ip_address, 5, 2, 0 );
      }

      break;
    }
    default:
    {
      break;
    }
  }

  TQLabel *pix_label = new TQLabel( this );
  pix_label->setPixmap( m_item->desktopIcon() );

  m_layout->addMultiCellWidget( pix_label, 0, m_layout->numRows(), 0, 0, TQt::AlignCenter );
}


void Smb4KNetworkBrowserToolTip::update()
{
  // This function updates a tool tip that
  // is shown. So, if the tool tip exists, but
  // is not shown, stop here.
  if ( !isShown() )
  {
    return;
  }

  switch ( m_item->type() )
  {
    case Smb4KNetworkBrowserItem::Workgroup:
    {
      TQLabel *master_label = static_cast<TQLabel *>( child( "MasterBrowser", "TQLabel", true ) );

      if ( master_label )
      {
        TQString master_string = m_item->workgroupItem()->masterIP().isEmpty() ?
                                m_item->workgroupItem()->master() :
                                m_item->workgroupItem()->master() + " ("+m_item->workgroupItem()->masterIP()+")";

        master_label->setText( master_string );
      }

      break;
    }
    case Smb4KNetworkBrowserItem::Host:
    {
      TQLabel *os_label =     static_cast<TQLabel *>( child( "OSString", "TQLabel", true ) );
      TQLabel *server_label = static_cast<TQLabel *>( child( "ServerString", "TQLabel", true ) );
      TQLabel *ip_label =     static_cast<TQLabel *>( child( "IPAddress", "TQLabel", true ) );

      if ( os_label )
      {
        TQString os_string = m_item->hostItem()->osString().isEmpty() ?
                            i18n( "Unknown" ) :
                            m_item->hostItem()->osString();

        os_label->setText( os_string );
      }

      if ( server_label )
      {
        TQString server_string = m_item->hostItem()->serverString().isEmpty() ?
                                i18n( "Unknown" ) :
                                m_item->hostItem()->serverString();

        server_label->setText( server_string );
      }

      if ( ip_label )
      {
        TQString ip_string = m_item->hostItem()->ip().isEmpty() ?
                            i18n( "Unknown" ) :
                            m_item->hostItem()->ip();

        ip_label->setText( ip_string );
      }

      break;
    }
    case Smb4KNetworkBrowserItem::Share:
    {
      TQLabel *ip_label = static_cast<TQLabel *>( child( "IPAddress", "TQLabel", true ) );

      if ( ip_label )
      {
        Smb4KHostItem *host = static_cast<Smb4KNetworkBrowserItem *>( m_item->parent() )->hostItem();
        TQString ip_string;

        if ( host )
        {
          ip_string = (host && !host->ip().isEmpty()) ?
                      host->ip() :
                      i18n( "Unknown" );
        }
        else
        {
          ip_string = i18n( "Unknown" );
        }

        ip_label->setText( ip_string );
      }

      break;
    }
    default:
    {
      break;
    }
  }
}


void Smb4KNetworkBrowserToolTip::mousePressEvent( TQMouseEvent *e )
{
  hide();
  TQLabel::mousePressEvent( e );
}


void Smb4KNetworkBrowserToolTip::leaveEvent( TQEvent *e )
{
  hide();
  TQLabel::leaveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KNetworkBrowserToolTip::slotHideToolTip()
{
  if ( isShown() )
  {
    hide();
  }
}


#include "smb4knetworkbrowsertooltip.moc"
