// SPDX-FileCopyrightText: 2025 mio <stigma@disroot.org>
//
// SPDX-License-Identifier: GPL-2.0-or-later.

#include "audioView.h"

#include <tqlayout.h>

#include "analyzer.h"

namespace Codeine
{

AudioView::AudioView(TQWidget *parent, const char *name)
    : TQFrame(parent, name)
{
    auto *layout = new TQHBoxLayout(this);
    m_analyzer = new Analyzer::Block(this);

    // We subtract one from the below to remove excess padding.
    // 36 blocks for the max/min height is arbitrary, but looks okay.
    m_analyzer->setMaximumSize((Analyzer::Block::MAX_COLUMNS / 2) * (Analyzer::Block::WIDTH + 1) - 1,
        36 * (Analyzer::Block::HEIGHT + 1) - 1);

    m_analyzer->setMinimumSize(Analyzer::Block::WIDTH * Analyzer::Block::MIN_COLUMNS,
        36 * (Analyzer::Block::HEIGHT + 1) - 1);

    layout->addWidget(m_analyzer);
}

}
