
#ifndef K9Mplayer_H
#define K9Mplayer_H

#include "k9common.h"
#include "../k9Mplayer/mplayer.h"


class k9DVD;
class k9DVDTitle;
class TDEProcess;
class TQTimer;
class TQResizeEvent;

class K9Mplayer : public MPlayer
{
  TQ_OBJECT
  
private:
  TDEProcess    *m_process;
  bool m_seeking,m_initVol;
  int m_title;
  k9DVDTitle *m_dvdTitle;
  TQString m_device;
  TQTimer *m_timer;
  void sendCmd(TQString _cmd);
  int m_position;
  bool m_canwrite;
  TQWidget *m_container;
  float m_ratio;
public:
  //K9Mplayer(TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  K9Mplayer(TQObject  *parent=0,const char *name=0,const TQStringList args=0);
  ~K9Mplayer();
  /*$PUBLIC_FUNCTIONS$*/
  void setDevice(const TQString & _device);
  void setTitle(const TQString & _numTitle,const TQString &_numChapter);
private slots:
  void slotLengthChanged();
  void slotNewPosition(int _pos,const TQTime & _time);
  void receivedStdout (TDEProcess *proc, char *buffer, int buflen);
  void wroteStdin(TDEProcess *_process);
  void timeout();
public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          sliderReleased();
  virtual void          bPlayClick();
  virtual void          bStopClick();
  virtual void 		sliderPressed();
  virtual void		sliderChanged(int _value);
  virtual void 		open(k9DVD *_dvd,k9DVDTitle *_title,int chapter);
  virtual void		titleChanged();
  virtual void		cbAudioActivated (int _value);
  virtual void 		cbSubActivated (int _value);
  virtual void		bUpClick();
  virtual void 		bDownClick();
  virtual void          bSwitchAudioClick();
protected:
  /*$PROTECTED_FUNCTIONS$*/
  void resizeEvent ( TQResizeEvent * _resiseEvent);
protected slots:
  /*$PROTECTED_SLOTS$*/

};

#endif

