import org.trinitydesktop.qt.*;

public class LCDRange extends TQVBox {
	private TQSlider slider;
	
	public LCDRange(TQWidget parent, String name) {
		super(parent, name);
		TQLCDNumber lcd = new TQLCDNumber(2, this, "lcd");
		slider = new TQSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);
		
		connect(slider, TQ_SIGNAL("valueChanged(int)"),
						lcd, TQ_SLOT("display(int)"));
		connect(slider, TQ_SIGNAL("valueChanged(int)"),
						TQ_SIGNAL("valueChanged(int)"));

		setFocusProxy(slider);
	}

	public int value() {
		return slider.value();
	}

	public void setValue(int value) {
		slider.setValue(value);
	}

	public void setRange(int minVal, int maxVal) {
		if (minVal < 0 || maxVal > 99 || minVal > maxVal) {
			tqWarning("LCDRange::setRange("+minVal+","+maxVal+")\n"+
							 "\tRange must be 0..99\n"+
							 "\tand minVal must not be greater than maxVal");
			return;
		}
		slider.setRange(minVal, maxVal);
	}
}
