#ifndef TESTLIBRSS_H
#define TESTLIBRSS_H

#include <tqobject.h>

#include "loader.h"
#include "document.h"
#include "article.h"
#include "global.h"

using RSS::Loader;
using RSS::Document;
using RSS::Status;

class Tester : public TQObject
{
	TQ_OBJECT

	public:
		void test( const TQString &url );

	private slots:
		void slotLoadingComplete( Loader *loader, Document doc, Status status );
};

class TestRetriever : public RSS::DataRetriever
{
	TQ_OBJECT

public:
	TestRetriever();
	~TestRetriever() override;

	void retrieveData(const KURL &url) override;

	int errorCode() const override { return m_errorCode; }

	void abort() override { /* no-op */ }

private:
	int m_errorCode;
};

#endif
