"""
This is a minimal PyKDE app template - it constructs an application
and a main window, but does nothing else.
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from tdecore import TDEApplication
from tdeui import TDEMainWindow


"""
Most PyKDE applications will need a main window - the is the top
level widget (the parent for all other widgets). TDEMainWindow has
more functionality than shown here (see more complex templates).
It has the ability to create the other major parts of the user
interface - the main view, menus, toolbars, etc.

Usually you provide a subclass of TDEMainWindow, construct menus
and toolbars in the subclass' __init__ method, and provide
slots for menu/toolbar actions in separate methods.
"""
class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)


#-------------------- main ------------------------------------------------

# instantiate TDEApplication - no other TQObject
# or TQWidget based classes can be instantiated
# until there is a TDEApplication instance
appName = "template"
app = TDEApplication (sys.argv, appName)

# instantiate the subclass of TDEMainWindow
mainWindow = MainWin (None, "main window")

# create the display
mainWindow.show()

# run TDEApplication's event loop until the
# program exits
app.exec_loop()


