# Copyright 2022-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_NAME="tdeaccessibility"
TRINITY_MODULE_TYPE="core"
TRINITY_NEED_ARTS="optional"
TSM_EXTRACT_ALSO="kspeechsink"
inherit trinity-meta-2

DESCRIPTION="TDE text-to-speech subsystem"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi

IUSE="akode +alsa epos festival flite freetts hadifix kate"
REQUIRED_USE="|| ( akode alsa arts )"

DEPEND=" akode? ( ~media-libs/akode-${PV} )
	alsa? ( media-libs/alsa-lib )
	~trinity-base/kcontrol-${PV}"
RDEPEND=" ${DEPEND}
	flite? ( app-accessibility/flite )
	freetts? ( app-accessibility/freetts )
	hadifix? ( app-accessibility/mbrola )
	kate? ( trinity-base/kate )"

# Missing dependencies:
# festival? ( app-accessibility/festival )
# epos? ( app-accessibility/epos )
# hadifix? ( app-accessibility/txt2pho )
# Note: tha flags should me masked

pkg_setup() {
	if use festival; then
		ewarn
		ewarn "app-accessibility/festival was removed from portage. In order to use it"
		ewarn "as your TTS engine you will have to source the festival binary yourself."
	fi

	if use epos; then
		ewarn
		ewarn "app-accessibility/epos was removed from portage. In order to use it"
		ewarn "as your TTS engine you will have to source the binary for it yourself."
	fi

	if use hadifix; then
		ewarn
		ewarn "Hadifix TTS engine requires txt2pho utility which is not currently in portage."
		ewarn "In order to use Hadifix as your TTS engine you will have to source the binary yourself."
	fi

	elog "Besides built-in support for several engines kttsd includes generic 'Command'"
	elog "module which may utilize other 3rd-party TTS engines like:"
	elog " - app-accessibility/espeak-ng"
	elog " - app-accessibility/rhvoice"
	elog " - app-accessibility/speech-dispatcher"
	elog "and others. You are welcome to install one of them."

	trinity-meta-2_pkg_setup
}

src_configure() {
	local mycmakeargs=(
		-DWITH_ALSA="$(usex alsa)"
		-DWITH_AKODE="$(usex akode)"
		-DBUILD_KTTSD_FESTIVAL="$(usex festival)"
		-DBUILD_KTTSD_EPOS="$(usex epos)"
		-DBUILD_KTTSD_FLITE="$(usex flite)"
		-DBUILD_KTTSD_FREETTS="$(usex freetts)"
		-DBUILD_KTTSD_HADIFIX=$(usex hadifix)
		-DBUILD_KTTSD_KATE="$(usex kate)"
		-DBUILD_KTTSD_COMMAND=ON
		-DWITH_GSTREAMER=OFF # gstreamer support is not really finished
	)

	trinity-meta-2_src_configure
}
