// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +zve64x \
// RUN:   -target-feature +xandesvpackfph -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <andes_vector.h>

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.nxv1f16.f32.i64(<vscale x 1 x half> poison, <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4(vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.nxv2f16.f32.i64(<vscale x 2 x half> poison, <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2(vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.nxv4f16.f32.i64(<vscale x 4 x half> poison, <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1(vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.nxv8f16.f32.i64(<vscale x 8 x half> poison, <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2(vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.nxv16f16.f32.i64(<vscale x 16 x half> poison, <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4(vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.nxv32f16.f32.i64(<vscale x 32 x half> poison, <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8(vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> poison, <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_m(vbool64_t mask, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> poison, <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_m(vbool32_t mask, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> poison, <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_m(vbool16_t mask, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> poison, <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_m(vbool8_t mask, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> poison, <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_m(vbool4_t mask, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> poison, <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 7, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_m(vbool2_t mask, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_rm(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.nxv1f16.f32.i64(<vscale x 1 x half> poison, <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_rm(vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_rm(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.nxv2f16.f32.i64(<vscale x 2 x half> poison, <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_rm(vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_rm(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.nxv4f16.f32.i64(<vscale x 4 x half> poison, <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_rm(vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_rm(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.nxv8f16.f32.i64(<vscale x 8 x half> poison, <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_rm(vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_rm(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.nxv16f16.f32.i64(<vscale x 16 x half> poison, <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_rm(vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_rm(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.nxv32f16.f32.i64(<vscale x 32 x half> poison, <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], i64 0, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_rm(vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf4_rm_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.nds.vfpmadt.mask.nxv1f16.f32.i64(<vscale x 1 x half> poison, <vscale x 1 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_nds_vfpmadt_vf_f16mf4_rm_m(vbool64_t mask, vfloat16mf4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16mf2_rm_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.nds.vfpmadt.mask.nxv2f16.f32.i64(<vscale x 2 x half> poison, <vscale x 2 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_nds_vfpmadt_vf_f16mf2_rm_m(vbool32_t mask, vfloat16mf2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m1_rm_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.nds.vfpmadt.mask.nxv4f16.f32.i64(<vscale x 4 x half> poison, <vscale x 4 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_nds_vfpmadt_vf_f16m1_rm_m(vbool16_t mask, vfloat16m1_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m2_rm_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.nds.vfpmadt.mask.nxv8f16.f32.i64(<vscale x 8 x half> poison, <vscale x 8 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_nds_vfpmadt_vf_f16m2_rm_m(vbool8_t mask, vfloat16m2_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m4_rm_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.nds.vfpmadt.mask.nxv16f16.f32.i64(<vscale x 16 x half> poison, <vscale x 16 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_nds_vfpmadt_vf_f16m4_rm_m(vbool4_t mask, vfloat16m4_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, __RISCV_FRM_RNE, vl);
}

// CHECK-RV64-LABEL: @test_nds_vfpmadt_vf_f16m8_rm_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.nds.vfpmadt.mask.nxv32f16.f32.i64(<vscale x 32 x half> poison, <vscale x 32 x half> [[OP1:%.*]], float [[OP2:%.*]], <vscale x 32 x i1> [[MASK:%.*]], i64 0, i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_nds_vfpmadt_vf_f16m8_rm_m(vbool2_t mask, vfloat16m8_t op1, float op2, size_t vl) {
  return __riscv_nds_vfpmadt(mask, op1, op2, __RISCV_FRM_RNE, vl);
}
