/* The contents of this file was automatically generated by dump_modes.c
   with arguments: 48000 960 96000 1920
   It contains static definitions for some pre-defined modes. */
#include "modes.h"
#include "rate.h"

#ifdef HAVE_ARM_NE10
#define OVERRIDE_FFT 1
#include "static_modes_fixed_arm_ne10.h"
#endif

#ifndef DEF_WINDOW120
#define DEF_WINDOW120
static const celt_coef window120[120] = {
#ifdef ENABLE_QEXT
144497, 1300330, 3611201, 7075520, 11690888,
17454086, 24361057, 32406886, 41585775, 51891010,
63314937, 75848919, 89483305, 104207389, 120009370,
136876310, 154794092, 173747379, 193719571, 214692768,
236647730, 259563841, 283419077, 308189974, 333851611,
360377579, 387739975, 415909390, 444854905, 474544098,
504943052, 536016380, 567727246, 600037405, 632907246,
666295842, 700161014, 734459402, 769146541, 804176950,
839504226, 875081152, 910859802, 946791664, 982827767,
1018918807, 1055015290, 1091067670, 1127026498, 1162842573,
1198467087, 1233851789, 1268949131, 1303712428, 1338096006,
1372055358, 1405547288, 1438530058, 1470963524, 1502809271,
1534030739, 1564593342, 1594464577, 1623614128, 1652013956,
1679638382, 1706464158, 1732470524, 1757639263, 1781954729,
1805403879, 1827976282, 1849664120, 1870462177, 1890367816,
1909380946, 1927503971, 1944741741, 1961101475, 1976592692,
1991227121, 2005018607, 2017983004, 2030138067, 2041503335,
2052100006, 2061950806, 2071079861, 2079512553, 2087275384,
2094395835, 2100902218, 2106823532, 2112189321, 2117029527,
2121374347, 2125254092, 2128699049, 2131739343, 2134404804,
2136724838, 2138728301, 2140443380, 2141897478, 2143117097,
2144127740, 2144953807, 2145618502, 2146143741, 2146550077,
2146856618, 2147080958, 2147239113, 2147345467, 2147412716,
2147451825, 2147471991, 2147480611, 2147483254, 2147483643,
#else
2, 20, 55, 108, 178,
266, 372, 494, 635, 792,
966, 1157, 1365, 1590, 1831,
2089, 2362, 2651, 2956, 3276,
3611, 3961, 4325, 4703, 5094,
5499, 5916, 6346, 6788, 7241,
7705, 8179, 8663, 9156, 9657,
10167, 10684, 11207, 11736, 12271,
12810, 13353, 13899, 14447, 14997,
15547, 16098, 16648, 17197, 17744,
18287, 18827, 19363, 19893, 20418,
20936, 21447, 21950, 22445, 22931,
23407, 23874, 24330, 24774, 25208,
25629, 26039, 26435, 26819, 27190,
27548, 27893, 28224, 28541, 28845,
29135, 29411, 29674, 29924, 30160,
30384, 30594, 30792, 30977, 31151,
31313, 31463, 31602, 31731, 31849,
31958, 32057, 32148, 32229, 32303,
32370, 32429, 32481, 32528, 32568,
32604, 32634, 32661, 32683, 32701,
32717, 32729, 32740, 32748, 32754,
32758, 32762, 32764, 32766, 32767,
32767, 32767, 32767, 32767, 32767,
#endif
};
#endif

#ifndef DEF_LOGN400
#define DEF_LOGN400
static const opus_int16 logN400[21] = {
0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 16, 16, 16, 21, 21, 24, 29, 34, 36, };
#endif

#ifndef DEF_PULSE_CACHE50
#define DEF_PULSE_CACHE50
static const opus_int16 cache_index50[105] = {
-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 41, 41, 41,
82, 82, 123, 164, 200, 222, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 123, 123, 123, 164, 164, 240, 266, 283, 295, 41, 41, 41,
41, 41, 41, 41, 41, 123, 123, 123, 123, 240, 240, 240, 266, 266, 305,
318, 328, 336, 123, 123, 123, 123, 123, 123, 123, 123, 240, 240, 240, 240,
305, 305, 305, 318, 318, 343, 351, 358, 364, 240, 240, 240, 240, 240, 240,
240, 240, 305, 305, 305, 305, 343, 343, 343, 351, 351, 370, 376, 382, 387,
};
static const unsigned char cache_bits50[392] = {
40, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 40, 15, 23, 28,
31, 34, 36, 38, 39, 41, 42, 43, 44, 45, 46, 47, 47, 49, 50,
51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 63, 65,
66, 67, 68, 69, 70, 71, 71, 40, 20, 33, 41, 48, 53, 57, 61,
64, 66, 69, 71, 73, 75, 76, 78, 80, 82, 85, 87, 89, 91, 92,
94, 96, 98, 101, 103, 105, 107, 108, 110, 112, 114, 117, 119, 121, 123,
124, 126, 128, 40, 23, 39, 51, 60, 67, 73, 79, 83, 87, 91, 94,
97, 100, 102, 105, 107, 111, 115, 118, 121, 124, 126, 129, 131, 135, 139,
142, 145, 148, 150, 153, 155, 159, 163, 166, 169, 172, 174, 177, 179, 35,
28, 49, 65, 78, 89, 99, 107, 114, 120, 126, 132, 136, 141, 145, 149,
153, 159, 165, 171, 176, 180, 185, 189, 192, 199, 205, 211, 216, 220, 225,
229, 232, 239, 245, 251, 21, 33, 58, 79, 97, 112, 125, 137, 148, 157,
166, 174, 182, 189, 195, 201, 207, 217, 227, 235, 243, 251, 17, 35, 63,
86, 106, 123, 139, 152, 165, 177, 187, 197, 206, 214, 222, 230, 237, 250,
25, 31, 55, 75, 91, 105, 117, 128, 138, 146, 154, 161, 168, 174, 180,
185, 190, 200, 208, 215, 222, 229, 235, 240, 245, 255, 16, 36, 65, 89,
110, 128, 144, 159, 173, 185, 196, 207, 217, 226, 234, 242, 250, 11, 41,
74, 103, 128, 151, 172, 191, 209, 225, 241, 255, 9, 43, 79, 110, 138,
163, 186, 207, 227, 246, 12, 39, 71, 99, 123, 144, 164, 182, 198, 214,
228, 241, 253, 9, 44, 81, 113, 142, 168, 192, 214, 235, 255, 7, 49,
90, 127, 160, 191, 220, 247, 6, 51, 95, 134, 170, 203, 234, 7, 47,
87, 123, 155, 184, 212, 237, 6, 52, 97, 137, 174, 208, 240, 5, 57,
106, 151, 192, 231, 5, 59, 111, 158, 202, 243, 5, 55, 103, 147, 187,
224, 5, 60, 113, 161, 206, 248, 4, 65, 122, 175, 224, 4, 67, 127,
182, 234, };
static const unsigned char cache_caps50[168] = {
224, 224, 224, 224, 224, 224, 224, 224, 160, 160, 160, 160, 185, 185, 185,
178, 178, 168, 134, 61, 37, 224, 224, 224, 224, 224, 224, 224, 224, 240,
240, 240, 240, 207, 207, 207, 198, 198, 183, 144, 66, 40, 160, 160, 160,
160, 160, 160, 160, 160, 185, 185, 185, 185, 193, 193, 193, 183, 183, 172,
138, 64, 38, 240, 240, 240, 240, 240, 240, 240, 240, 207, 207, 207, 207,
204, 204, 204, 193, 193, 180, 143, 66, 40, 185, 185, 185, 185, 185, 185,
185, 185, 193, 193, 193, 193, 193, 193, 193, 183, 183, 172, 138, 65, 39,
207, 207, 207, 207, 207, 207, 207, 207, 204, 204, 204, 204, 201, 201, 201,
188, 188, 176, 141, 66, 40, 193, 193, 193, 193, 193, 193, 193, 193, 193,
193, 193, 193, 194, 194, 194, 184, 184, 173, 139, 65, 39, 204, 204, 204,
204, 204, 204, 204, 204, 201, 201, 201, 201, 198, 198, 198, 187, 187, 175,
140, 66, 40, };
#endif

#ifdef ENABLE_QEXT
# ifndef DEF_QEXT_PULSE_CACHE50
# define DEF_QEXT_PULSE_CACHE50
static const opus_int16 qext_cache_index50[70] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 61, 61,
61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 72, 72, 72,
72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 80, 80, 80, 80,
80, 80, 80, 80, 80, 80, 80, 80, 80, 80, };
static const unsigned char qext_cache_bits50[86] = {
40, 26, 45, 59, 70, 79, 87, 94, 100, 105, 110, 114, 118, 122, 125,
128, 131, 136, 141, 146, 150, 153, 157, 160, 163, 168, 173, 178, 182, 185,
189, 192, 195, 200, 205, 210, 214, 217, 221, 224, 227, 19, 34, 61, 83,
101, 118, 132, 145, 157, 167, 177, 186, 194, 202, 209, 216, 222, 234, 245,
254, 10, 42, 77, 107, 133, 157, 179, 200, 219, 236, 253, 7, 50, 93,
131, 165, 197, 227, 255, 5, 58, 109, 155, 197, 237, };
static const unsigned char qext_cache_caps50[112] = {
159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 171,
171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 167, 167, 167,
167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 166, 166, 166, 166, 166,
166, 166, 166, 166, 166, 166, 166, 166, 166, 163, 163, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 165, 165, 165, 165, 165, 165, 165,
165, 165, 165, 165, 165, 165, 165, };
# endif
#endif

#ifndef FFT_TWIDDLES48000_960
#define FFT_TWIDDLES48000_960
static const kiss_twiddle_cpx fft_twiddles48000_960[480] = {
#ifdef ENABLE_QEXT
{2147483647, 0}, {2147299668, -28109692},
{2146747759, -56214568}, {2145828016, -84309812},
{2144540596, -112390610}, {2142885721, -140452151},
{2140863673, -168489625}, {2138474799, -196498230},
{2135719508, -224473166}, {2132598273, -252409639},
{2129111628, -280302863}, {2125260170, -308148059},
{2121044561, -335940456}, {2116465521, -363675290},
{2111523836, -391347811}, {2106220352, -418953276},
{2100555978, -446486956}, {2094531684, -473944133},
{2088148504, -501320102}, {2081407530, -528610172},
{2074309917, -555809667}, {2066856882, -582913927},
{2059049702, -609918309}, {2050889714, -636818183},
{2042378317, -663608942}, {2033516969, -690285996},
{2024307188, -716844772}, {2014750553, -743280720},
{2004848700, -769589312}, {1994603327, -795766038},
{1984016189, -821806413}, {1973089100, -847705977},
{1961823932, -873460290}, {1950222616, -899064940},
{1938287139, -924515541}, {1926019547, -949807730},
{1913421941, -974937175}, {1900496480, -999899569},
{1887245379, -1024690635}, {1873670908, -1049306126},
{1859775393, -1073741824}, {1845561216, -1097993542},
{1831030811, -1122057124}, {1816186668, -1145928447},
{1801031331, -1169603422}, {1785567396, -1193077991},
{1769797514, -1216348132}, {1753724386, -1239409858},
{1737350766, -1262259218}, {1720679461, -1284892296},
{1703713325, -1307305214}, {1686455268, -1329494133},
{1668908244, -1351455249}, {1651075262, -1373184801},
{1632959377, -1394679064}, {1614563692, -1415934356},
{1595891361, -1436947036}, {1576945581, -1457713501},
{1557729600, -1478230195}, {1538246711, -1498493602},
{1518500250, -1518500250}, {1498493602, -1538246711},
{1478230195, -1557729600}, {1457713501, -1576945581},
{1436947036, -1595891361}, {1415934356, -1614563692},
{1394679064, -1632959377}, {1373184801, -1651075262},
{1351455249, -1668908244}, {1329494133, -1686455268},
{1307305214, -1703713325}, {1284892296, -1720679461},
{1262259218, -1737350766}, {1239409858, -1753724386},
{1216348132, -1769797514}, {1193077991, -1785567396},
{1169603422, -1801031331}, {1145928447, -1816186668},
{1122057124, -1831030811}, {1097993542, -1845561216},
{1073741824, -1859775393}, {1049306126, -1873670908},
{1024690635, -1887245379}, {999899569, -1900496480},
{974937175, -1913421941}, {949807730, -1926019547},
{924515541, -1938287139}, {899064940, -1950222616},
{873460290, -1961823932}, {847705977, -1973089100},
{821806413, -1984016189}, {795766038, -1994603327},
{769589312, -2004848700}, {743280720, -2014750553},
{716844772, -2024307188}, {690285996, -2033516969},
{663608942, -2042378317}, {636818183, -2050889714},
{609918309, -2059049702}, {582913927, -2066856882},
{555809667, -2074309917}, {528610172, -2081407530},
{501320102, -2088148504}, {473944133, -2094531684},
{446486956, -2100555978}, {418953276, -2106220352},
{391347811, -2111523836}, {363675290, -2116465521},
{335940456, -2121044561}, {308148059, -2125260170},
{280302863, -2129111628}, {252409639, -2132598273},
{224473166, -2135719508}, {196498230, -2138474799},
{168489625, -2140863673}, {140452151, -2142885721},
{112390610, -2144540596}, {84309812, -2145828016},
{56214568, -2146747759}, {28109692, -2147299668},
{0, -2147483648}, {-28109692, -2147299668},
{-56214568, -2146747759}, {-84309812, -2145828016},
{-112390610, -2144540596}, {-140452151, -2142885721},
{-168489625, -2140863673}, {-196498230, -2138474799},
{-224473166, -2135719508}, {-252409639, -2132598273},
{-280302863, -2129111628}, {-308148059, -2125260170},
{-335940456, -2121044561}, {-363675290, -2116465521},
{-391347811, -2111523836}, {-418953276, -2106220352},
{-446486956, -2100555978}, {-473944133, -2094531684},
{-501320102, -2088148504}, {-528610172, -2081407530},
{-555809667, -2074309917}, {-582913927, -2066856882},
{-609918309, -2059049702}, {-636818183, -2050889714},
{-663608942, -2042378317}, {-690285996, -2033516969},
{-716844772, -2024307188}, {-743280720, -2014750553},
{-769589312, -2004848700}, {-795766038, -1994603327},
{-821806413, -1984016189}, {-847705977, -1973089100},
{-873460290, -1961823932}, {-899064940, -1950222616},
{-924515541, -1938287139}, {-949807730, -1926019547},
{-974937175, -1913421941}, {-999899569, -1900496480},
{-1024690635, -1887245379}, {-1049306126, -1873670908},
{-1073741824, -1859775393}, {-1097993542, -1845561216},
{-1122057124, -1831030811}, {-1145928447, -1816186668},
{-1169603422, -1801031331}, {-1193077991, -1785567396},
{-1216348132, -1769797514}, {-1239409858, -1753724386},
{-1262259218, -1737350766}, {-1284892296, -1720679461},
{-1307305214, -1703713325}, {-1329494133, -1686455268},
{-1351455249, -1668908244}, {-1373184801, -1651075262},
{-1394679064, -1632959377}, {-1415934356, -1614563692},
{-1436947036, -1595891361}, {-1457713501, -1576945581},
{-1478230195, -1557729600}, {-1498493602, -1538246711},
{-1518500250, -1518500250}, {-1538246711, -1498493602},
{-1557729600, -1478230195}, {-1576945581, -1457713501},
{-1595891361, -1436947036}, {-1614563692, -1415934356},
{-1632959377, -1394679064}, {-1651075262, -1373184801},
{-1668908244, -1351455249}, {-1686455268, -1329494133},
{-1703713325, -1307305214}, {-1720679461, -1284892296},
{-1737350766, -1262259218}, {-1753724386, -1239409858},
{-1769797514, -1216348132}, {-1785567396, -1193077991},
{-1801031331, -1169603422}, {-1816186668, -1145928447},
{-1831030811, -1122057124}, {-1845561216, -1097993542},
{-1859775393, -1073741824}, {-1873670908, -1049306126},
{-1887245379, -1024690635}, {-1900496480, -999899569},
{-1913421941, -974937175}, {-1926019547, -949807730},
{-1938287139, -924515541}, {-1950222616, -899064940},
{-1961823932, -873460290}, {-1973089100, -847705977},
{-1984016189, -821806413}, {-1994603327, -795766038},
{-2004848700, -769589312}, {-2014750553, -743280720},
{-2024307188, -716844772}, {-2033516969, -690285996},
{-2042378317, -663608942}, {-2050889714, -636818183},
{-2059049702, -609918309}, {-2066856882, -582913927},
{-2074309917, -555809667}, {-2081407530, -528610172},
{-2088148504, -501320102}, {-2094531684, -473944133},
{-2100555978, -446486956}, {-2106220352, -418953276},
{-2111523836, -391347811}, {-2116465521, -363675290},
{-2121044561, -335940456}, {-2125260170, -308148059},
{-2129111628, -280302863}, {-2132598273, -252409639},
{-2135719508, -224473166}, {-2138474799, -196498230},
{-2140863673, -168489625}, {-2142885721, -140452151},
{-2144540596, -112390610}, {-2145828016, -84309812},
{-2146747759, -56214568}, {-2147299668, -28109692},
{-2147483648, 0}, {-2147299668, 28109692},
{-2146747759, 56214568}, {-2145828016, 84309812},
{-2144540596, 112390610}, {-2142885721, 140452151},
{-2140863673, 168489625}, {-2138474799, 196498230},
{-2135719508, 224473166}, {-2132598273, 252409639},
{-2129111628, 280302863}, {-2125260170, 308148059},
{-2121044561, 335940456}, {-2116465521, 363675290},
{-2111523836, 391347811}, {-2106220352, 418953276},
{-2100555978, 446486956}, {-2094531684, 473944133},
{-2088148504, 501320102}, {-2081407530, 528610172},
{-2074309917, 555809667}, {-2066856882, 582913927},
{-2059049702, 609918309}, {-2050889714, 636818183},
{-2042378317, 663608942}, {-2033516969, 690285996},
{-2024307188, 716844772}, {-2014750553, 743280720},
{-2004848700, 769589312}, {-1994603327, 795766038},
{-1984016189, 821806413}, {-1973089100, 847705977},
{-1961823932, 873460290}, {-1950222616, 899064940},
{-1938287139, 924515541}, {-1926019547, 949807730},
{-1913421941, 974937175}, {-1900496480, 999899569},
{-1887245379, 1024690635}, {-1873670908, 1049306126},
{-1859775393, 1073741824}, {-1845561216, 1097993542},
{-1831030811, 1122057124}, {-1816186668, 1145928447},
{-1801031331, 1169603422}, {-1785567396, 1193077991},
{-1769797514, 1216348132}, {-1753724386, 1239409858},
{-1737350766, 1262259218}, {-1720679461, 1284892296},
{-1703713325, 1307305214}, {-1686455268, 1329494133},
{-1668908244, 1351455249}, {-1651075262, 1373184801},
{-1632959377, 1394679064}, {-1614563692, 1415934356},
{-1595891361, 1436947036}, {-1576945581, 1457713501},
{-1557729600, 1478230195}, {-1538246711, 1498493602},
{-1518500250, 1518500250}, {-1498493602, 1538246711},
{-1478230195, 1557729600}, {-1457713501, 1576945581},
{-1436947036, 1595891361}, {-1415934356, 1614563692},
{-1394679064, 1632959377}, {-1373184801, 1651075262},
{-1351455249, 1668908244}, {-1329494133, 1686455268},
{-1307305214, 1703713325}, {-1284892296, 1720679461},
{-1262259218, 1737350766}, {-1239409858, 1753724386},
{-1216348132, 1769797514}, {-1193077991, 1785567396},
{-1169603422, 1801031331}, {-1145928447, 1816186668},
{-1122057124, 1831030811}, {-1097993542, 1845561216},
{-1073741824, 1859775393}, {-1049306126, 1873670908},
{-1024690635, 1887245379}, {-999899569, 1900496480},
{-974937175, 1913421941}, {-949807730, 1926019547},
{-924515541, 1938287139}, {-899064940, 1950222616},
{-873460290, 1961823932}, {-847705977, 1973089100},
{-821806413, 1984016189}, {-795766038, 1994603327},
{-769589312, 2004848700}, {-743280720, 2014750553},
{-716844772, 2024307188}, {-690285996, 2033516969},
{-663608942, 2042378317}, {-636818183, 2050889714},
{-609918309, 2059049702}, {-582913927, 2066856882},
{-555809667, 2074309917}, {-528610172, 2081407530},
{-501320102, 2088148504}, {-473944133, 2094531684},
{-446486956, 2100555978}, {-418953276, 2106220352},
{-391347811, 2111523836}, {-363675290, 2116465521},
{-335940456, 2121044561}, {-308148059, 2125260170},
{-280302863, 2129111628}, {-252409639, 2132598273},
{-224473166, 2135719508}, {-196498230, 2138474799},
{-168489625, 2140863673}, {-140452151, 2142885721},
{-112390610, 2144540596}, {-84309812, 2145828016},
{-56214568, 2146747759}, {-28109692, 2147299668},
{0, 2147483647}, {28109692, 2147299668},
{56214568, 2146747759}, {84309812, 2145828016},
{112390610, 2144540596}, {140452151, 2142885721},
{168489625, 2140863673}, {196498230, 2138474799},
{224473166, 2135719508}, {252409639, 2132598273},
{280302863, 2129111628}, {308148059, 2125260170},
{335940456, 2121044561}, {363675290, 2116465521},
{391347811, 2111523836}, {418953276, 2106220352},
{446486956, 2100555978}, {473944133, 2094531684},
{501320102, 2088148504}, {528610172, 2081407530},
{555809667, 2074309917}, {582913927, 2066856882},
{609918309, 2059049702}, {636818183, 2050889714},
{663608942, 2042378317}, {690285996, 2033516969},
{716844772, 2024307188}, {743280720, 2014750553},
{769589312, 2004848700}, {795766038, 1994603327},
{821806413, 1984016189}, {847705977, 1973089100},
{873460290, 1961823932}, {899064940, 1950222616},
{924515541, 1938287139}, {949807730, 1926019547},
{974937175, 1913421941}, {999899569, 1900496480},
{1024690635, 1887245379}, {1049306126, 1873670908},
{1073741824, 1859775393}, {1097993542, 1845561216},
{1122057124, 1831030811}, {1145928447, 1816186668},
{1169603422, 1801031331}, {1193077991, 1785567396},
{1216348132, 1769797514}, {1239409858, 1753724386},
{1262259218, 1737350766}, {1284892296, 1720679461},
{1307305214, 1703713325}, {1329494133, 1686455268},
{1351455249, 1668908244}, {1373184801, 1651075262},
{1394679064, 1632959377}, {1415934356, 1614563692},
{1436947036, 1595891361}, {1457713501, 1576945581},
{1478230195, 1557729600}, {1498493602, 1538246711},
{1518500250, 1518500250}, {1538246711, 1498493602},
{1557729600, 1478230195}, {1576945581, 1457713501},
{1595891361, 1436947036}, {1614563692, 1415934356},
{1632959377, 1394679064}, {1651075262, 1373184801},
{1668908244, 1351455249}, {1686455268, 1329494133},
{1703713325, 1307305214}, {1720679461, 1284892296},
{1737350766, 1262259218}, {1753724386, 1239409858},
{1769797514, 1216348132}, {1785567396, 1193077991},
{1801031331, 1169603422}, {1816186668, 1145928447},
{1831030811, 1122057124}, {1845561216, 1097993542},
{1859775393, 1073741824}, {1873670908, 1049306126},
{1887245379, 1024690635}, {1900496480, 999899569},
{1913421941, 974937175}, {1926019547, 949807730},
{1938287139, 924515541}, {1950222616, 899064940},
{1961823932, 873460290}, {1973089100, 847705977},
{1984016189, 821806413}, {1994603327, 795766038},
{2004848700, 769589312}, {2014750553, 743280720},
{2024307188, 716844772}, {2033516969, 690285996},
{2042378317, 663608942}, {2050889714, 636818183},
{2059049702, 609918309}, {2066856882, 582913927},
{2074309917, 555809667}, {2081407530, 528610172},
{2088148504, 501320102}, {2094531684, 473944133},
{2100555978, 446486956}, {2106220352, 418953276},
{2111523836, 391347811}, {2116465521, 363675290},
{2121044561, 335940456}, {2125260170, 308148059},
{2129111628, 280302863}, {2132598273, 252409639},
{2135719508, 224473166}, {2138474799, 196498230},
{2140863673, 168489625}, {2142885721, 140452151},
{2144540596, 112390610}, {2145828016, 84309812},
{2146747759, 56214568}, {2147299668, 28109692},
#else
{32767, 0}, {32765, -429},
{32757, -858}, {32743, -1286},
{32723, -1715}, {32698, -2143},
{32667, -2571}, {32631, -2998},
{32588, -3425}, {32541, -3851},
{32488, -4277}, {32429, -4702},
{32365, -5126}, {32295, -5549},
{32219, -5971}, {32138, -6393},
{32052, -6813}, {31960, -7232},
{31863, -7650}, {31760, -8066},
{31651, -8481}, {31538, -8895},
{31419, -9307}, {31294, -9717},
{31164, -10126}, {31029, -10533},
{30888, -10938}, {30743, -11342},
{30592, -11743}, {30435, -12142},
{30274, -12540}, {30107, -12935},
{29935, -13328}, {29758, -13719},
{29576, -14107}, {29389, -14493},
{29197, -14876}, {28999, -15257},
{28797, -15636}, {28590, -16011},
{28378, -16384}, {28161, -16754},
{27939, -17121}, {27713, -17485},
{27482, -17847}, {27246, -18205},
{27005, -18560}, {26760, -18912},
{26510, -19261}, {26255, -19606},
{25997, -19948}, {25733, -20286},
{25466, -20622}, {25193, -20953},
{24917, -21281}, {24636, -21605},
{24351, -21926}, {24062, -22243},
{23769, -22556}, {23472, -22865},
{23170, -23170}, {22865, -23472},
{22556, -23769}, {22243, -24062},
{21926, -24351}, {21605, -24636},
{21281, -24917}, {20953, -25193},
{20622, -25466}, {20286, -25733},
{19948, -25997}, {19606, -26255},
{19261, -26510}, {18912, -26760},
{18560, -27005}, {18205, -27246},
{17847, -27482}, {17485, -27713},
{17121, -27939}, {16754, -28161},
{16384, -28378}, {16011, -28590},
{15636, -28797}, {15257, -28999},
{14876, -29197}, {14493, -29389},
{14107, -29576}, {13719, -29758},
{13328, -29935}, {12935, -30107},
{12540, -30274}, {12142, -30435},
{11743, -30592}, {11342, -30743},
{10938, -30888}, {10533, -31029},
{10126, -31164}, {9717, -31294},
{9307, -31419}, {8895, -31538},
{8481, -31651}, {8066, -31760},
{7650, -31863}, {7232, -31960},
{6813, -32052}, {6393, -32138},
{5971, -32219}, {5549, -32295},
{5126, -32365}, {4702, -32429},
{4277, -32488}, {3851, -32541},
{3425, -32588}, {2998, -32631},
{2571, -32667}, {2143, -32698},
{1715, -32723}, {1286, -32743},
{858, -32757}, {429, -32765},
{0, -32767}, {-429, -32765},
{-858, -32757}, {-1286, -32743},
{-1715, -32723}, {-2143, -32698},
{-2571, -32667}, {-2998, -32631},
{-3425, -32588}, {-3851, -32541},
{-4277, -32488}, {-4702, -32429},
{-5126, -32365}, {-5549, -32295},
{-5971, -32219}, {-6393, -32138},
{-6813, -32052}, {-7232, -31960},
{-7650, -31863}, {-8066, -31760},
{-8481, -31651}, {-8895, -31538},
{-9307, -31419}, {-9717, -31294},
{-10126, -31164}, {-10533, -31029},
{-10938, -30888}, {-11342, -30743},
{-11743, -30592}, {-12142, -30435},
{-12540, -30274}, {-12935, -30107},
{-13328, -29935}, {-13719, -29758},
{-14107, -29576}, {-14493, -29389},
{-14876, -29197}, {-15257, -28999},
{-15636, -28797}, {-16011, -28590},
{-16384, -28378}, {-16754, -28161},
{-17121, -27939}, {-17485, -27713},
{-17847, -27482}, {-18205, -27246},
{-18560, -27005}, {-18912, -26760},
{-19261, -26510}, {-19606, -26255},
{-19948, -25997}, {-20286, -25733},
{-20622, -25466}, {-20953, -25193},
{-21281, -24917}, {-21605, -24636},
{-21926, -24351}, {-22243, -24062},
{-22556, -23769}, {-22865, -23472},
{-23170, -23170}, {-23472, -22865},
{-23769, -22556}, {-24062, -22243},
{-24351, -21926}, {-24636, -21605},
{-24917, -21281}, {-25193, -20953},
{-25466, -20622}, {-25733, -20286},
{-25997, -19948}, {-26255, -19606},
{-26510, -19261}, {-26760, -18912},
{-27005, -18560}, {-27246, -18205},
{-27482, -17847}, {-27713, -17485},
{-27939, -17121}, {-28161, -16754},
{-28378, -16384}, {-28590, -16011},
{-28797, -15636}, {-28999, -15257},
{-29197, -14876}, {-29389, -14493},
{-29576, -14107}, {-29758, -13719},
{-29935, -13328}, {-30107, -12935},
{-30274, -12540}, {-30435, -12142},
{-30592, -11743}, {-30743, -11342},
{-30888, -10938}, {-31029, -10533},
{-31164, -10126}, {-31294, -9717},
{-31419, -9307}, {-31538, -8895},
{-31651, -8481}, {-31760, -8066},
{-31863, -7650}, {-31960, -7232},
{-32052, -6813}, {-32138, -6393},
{-32219, -5971}, {-32295, -5549},
{-32365, -5126}, {-32429, -4702},
{-32488, -4277}, {-32541, -3851},
{-32588, -3425}, {-32631, -2998},
{-32667, -2571}, {-32698, -2143},
{-32723, -1715}, {-32743, -1286},
{-32757, -858}, {-32765, -429},
{-32767, 0}, {-32765, 429},
{-32757, 858}, {-32743, 1286},
{-32723, 1715}, {-32698, 2143},
{-32667, 2571}, {-32631, 2998},
{-32588, 3425}, {-32541, 3851},
{-32488, 4277}, {-32429, 4702},
{-32365, 5126}, {-32295, 5549},
{-32219, 5971}, {-32138, 6393},
{-32052, 6813}, {-31960, 7232},
{-31863, 7650}, {-31760, 8066},
{-31651, 8481}, {-31538, 8895},
{-31419, 9307}, {-31294, 9717},
{-31164, 10126}, {-31029, 10533},
{-30888, 10938}, {-30743, 11342},
{-30592, 11743}, {-30435, 12142},
{-30274, 12540}, {-30107, 12935},
{-29935, 13328}, {-29758, 13719},
{-29576, 14107}, {-29389, 14493},
{-29197, 14876}, {-28999, 15257},
{-28797, 15636}, {-28590, 16011},
{-28378, 16384}, {-28161, 16754},
{-27939, 17121}, {-27713, 17485},
{-27482, 17847}, {-27246, 18205},
{-27005, 18560}, {-26760, 18912},
{-26510, 19261}, {-26255, 19606},
{-25997, 19948}, {-25733, 20286},
{-25466, 20622}, {-25193, 20953},
{-24917, 21281}, {-24636, 21605},
{-24351, 21926}, {-24062, 22243},
{-23769, 22556}, {-23472, 22865},
{-23170, 23170}, {-22865, 23472},
{-22556, 23769}, {-22243, 24062},
{-21926, 24351}, {-21605, 24636},
{-21281, 24917}, {-20953, 25193},
{-20622, 25466}, {-20286, 25733},
{-19948, 25997}, {-19606, 26255},
{-19261, 26510}, {-18912, 26760},
{-18560, 27005}, {-18205, 27246},
{-17847, 27482}, {-17485, 27713},
{-17121, 27939}, {-16754, 28161},
{-16384, 28378}, {-16011, 28590},
{-15636, 28797}, {-15257, 28999},
{-14876, 29197}, {-14493, 29389},
{-14107, 29576}, {-13719, 29758},
{-13328, 29935}, {-12935, 30107},
{-12540, 30274}, {-12142, 30435},
{-11743, 30592}, {-11342, 30743},
{-10938, 30888}, {-10533, 31029},
{-10126, 31164}, {-9717, 31294},
{-9307, 31419}, {-8895, 31538},
{-8481, 31651}, {-8066, 31760},
{-7650, 31863}, {-7232, 31960},
{-6813, 32052}, {-6393, 32138},
{-5971, 32219}, {-5549, 32295},
{-5126, 32365}, {-4702, 32429},
{-4277, 32488}, {-3851, 32541},
{-3425, 32588}, {-2998, 32631},
{-2571, 32667}, {-2143, 32698},
{-1715, 32723}, {-1286, 32743},
{-858, 32757}, {-429, 32765},
{0, 32767}, {429, 32765},
{858, 32757}, {1286, 32743},
{1715, 32723}, {2143, 32698},
{2571, 32667}, {2998, 32631},
{3425, 32588}, {3851, 32541},
{4277, 32488}, {4702, 32429},
{5126, 32365}, {5549, 32295},
{5971, 32219}, {6393, 32138},
{6813, 32052}, {7232, 31960},
{7650, 31863}, {8066, 31760},
{8481, 31651}, {8895, 31538},
{9307, 31419}, {9717, 31294},
{10126, 31164}, {10533, 31029},
{10938, 30888}, {11342, 30743},
{11743, 30592}, {12142, 30435},
{12540, 30274}, {12935, 30107},
{13328, 29935}, {13719, 29758},
{14107, 29576}, {14493, 29389},
{14876, 29197}, {15257, 28999},
{15636, 28797}, {16011, 28590},
{16384, 28378}, {16754, 28161},
{17121, 27939}, {17485, 27713},
{17847, 27482}, {18205, 27246},
{18560, 27005}, {18912, 26760},
{19261, 26510}, {19606, 26255},
{19948, 25997}, {20286, 25733},
{20622, 25466}, {20953, 25193},
{21281, 24917}, {21605, 24636},
{21926, 24351}, {22243, 24062},
{22556, 23769}, {22865, 23472},
{23170, 23170}, {23472, 22865},
{23769, 22556}, {24062, 22243},
{24351, 21926}, {24636, 21605},
{24917, 21281}, {25193, 20953},
{25466, 20622}, {25733, 20286},
{25997, 19948}, {26255, 19606},
{26510, 19261}, {26760, 18912},
{27005, 18560}, {27246, 18205},
{27482, 17847}, {27713, 17485},
{27939, 17121}, {28161, 16754},
{28378, 16384}, {28590, 16011},
{28797, 15636}, {28999, 15257},
{29197, 14876}, {29389, 14493},
{29576, 14107}, {29758, 13719},
{29935, 13328}, {30107, 12935},
{30274, 12540}, {30435, 12142},
{30592, 11743}, {30743, 11342},
{30888, 10938}, {31029, 10533},
{31164, 10126}, {31294, 9717},
{31419, 9307}, {31538, 8895},
{31651, 8481}, {31760, 8066},
{31863, 7650}, {31960, 7232},
{32052, 6813}, {32138, 6393},
{32219, 5971}, {32295, 5549},
{32365, 5126}, {32429, 4702},
{32488, 4277}, {32541, 3851},
{32588, 3425}, {32631, 2998},
{32667, 2571}, {32698, 2143},
{32723, 1715}, {32743, 1286},
{32757, 858}, {32765, 429},
#endif
};
#ifndef FFT_BITREV480
#define FFT_BITREV480
static const opus_int16 fft_bitrev480[480] = {
0, 96, 192, 288, 384, 32, 128, 224, 320, 416, 64, 160, 256, 352, 448,
8, 104, 200, 296, 392, 40, 136, 232, 328, 424, 72, 168, 264, 360, 456,
16, 112, 208, 304, 400, 48, 144, 240, 336, 432, 80, 176, 272, 368, 464,
24, 120, 216, 312, 408, 56, 152, 248, 344, 440, 88, 184, 280, 376, 472,
4, 100, 196, 292, 388, 36, 132, 228, 324, 420, 68, 164, 260, 356, 452,
12, 108, 204, 300, 396, 44, 140, 236, 332, 428, 76, 172, 268, 364, 460,
20, 116, 212, 308, 404, 52, 148, 244, 340, 436, 84, 180, 276, 372, 468,
28, 124, 220, 316, 412, 60, 156, 252, 348, 444, 92, 188, 284, 380, 476,
1, 97, 193, 289, 385, 33, 129, 225, 321, 417, 65, 161, 257, 353, 449,
9, 105, 201, 297, 393, 41, 137, 233, 329, 425, 73, 169, 265, 361, 457,
17, 113, 209, 305, 401, 49, 145, 241, 337, 433, 81, 177, 273, 369, 465,
25, 121, 217, 313, 409, 57, 153, 249, 345, 441, 89, 185, 281, 377, 473,
5, 101, 197, 293, 389, 37, 133, 229, 325, 421, 69, 165, 261, 357, 453,
13, 109, 205, 301, 397, 45, 141, 237, 333, 429, 77, 173, 269, 365, 461,
21, 117, 213, 309, 405, 53, 149, 245, 341, 437, 85, 181, 277, 373, 469,
29, 125, 221, 317, 413, 61, 157, 253, 349, 445, 93, 189, 285, 381, 477,
2, 98, 194, 290, 386, 34, 130, 226, 322, 418, 66, 162, 258, 354, 450,
10, 106, 202, 298, 394, 42, 138, 234, 330, 426, 74, 170, 266, 362, 458,
18, 114, 210, 306, 402, 50, 146, 242, 338, 434, 82, 178, 274, 370, 466,
26, 122, 218, 314, 410, 58, 154, 250, 346, 442, 90, 186, 282, 378, 474,
6, 102, 198, 294, 390, 38, 134, 230, 326, 422, 70, 166, 262, 358, 454,
14, 110, 206, 302, 398, 46, 142, 238, 334, 430, 78, 174, 270, 366, 462,
22, 118, 214, 310, 406, 54, 150, 246, 342, 438, 86, 182, 278, 374, 470,
30, 126, 222, 318, 414, 62, 158, 254, 350, 446, 94, 190, 286, 382, 478,
3, 99, 195, 291, 387, 35, 131, 227, 323, 419, 67, 163, 259, 355, 451,
11, 107, 203, 299, 395, 43, 139, 235, 331, 427, 75, 171, 267, 363, 459,
19, 115, 211, 307, 403, 51, 147, 243, 339, 435, 83, 179, 275, 371, 467,
27, 123, 219, 315, 411, 59, 155, 251, 347, 443, 91, 187, 283, 379, 475,
7, 103, 199, 295, 391, 39, 135, 231, 327, 423, 71, 167, 263, 359, 455,
15, 111, 207, 303, 399, 47, 143, 239, 335, 431, 79, 175, 271, 367, 463,
23, 119, 215, 311, 407, 55, 151, 247, 343, 439, 87, 183, 279, 375, 471,
31, 127, 223, 319, 415, 63, 159, 255, 351, 447, 95, 191, 287, 383, 479,
};
#endif

#ifndef FFT_BITREV240
#define FFT_BITREV240
static const opus_int16 fft_bitrev240[240] = {
0, 48, 96, 144, 192, 16, 64, 112, 160, 208, 32, 80, 128, 176, 224,
4, 52, 100, 148, 196, 20, 68, 116, 164, 212, 36, 84, 132, 180, 228,
8, 56, 104, 152, 200, 24, 72, 120, 168, 216, 40, 88, 136, 184, 232,
12, 60, 108, 156, 204, 28, 76, 124, 172, 220, 44, 92, 140, 188, 236,
1, 49, 97, 145, 193, 17, 65, 113, 161, 209, 33, 81, 129, 177, 225,
5, 53, 101, 149, 197, 21, 69, 117, 165, 213, 37, 85, 133, 181, 229,
9, 57, 105, 153, 201, 25, 73, 121, 169, 217, 41, 89, 137, 185, 233,
13, 61, 109, 157, 205, 29, 77, 125, 173, 221, 45, 93, 141, 189, 237,
2, 50, 98, 146, 194, 18, 66, 114, 162, 210, 34, 82, 130, 178, 226,
6, 54, 102, 150, 198, 22, 70, 118, 166, 214, 38, 86, 134, 182, 230,
10, 58, 106, 154, 202, 26, 74, 122, 170, 218, 42, 90, 138, 186, 234,
14, 62, 110, 158, 206, 30, 78, 126, 174, 222, 46, 94, 142, 190, 238,
3, 51, 99, 147, 195, 19, 67, 115, 163, 211, 35, 83, 131, 179, 227,
7, 55, 103, 151, 199, 23, 71, 119, 167, 215, 39, 87, 135, 183, 231,
11, 59, 107, 155, 203, 27, 75, 123, 171, 219, 43, 91, 139, 187, 235,
15, 63, 111, 159, 207, 31, 79, 127, 175, 223, 47, 95, 143, 191, 239,
};
#endif

#ifndef FFT_BITREV120
#define FFT_BITREV120
static const opus_int16 fft_bitrev120[120] = {
0, 24, 48, 72, 96, 8, 32, 56, 80, 104, 16, 40, 64, 88, 112,
4, 28, 52, 76, 100, 12, 36, 60, 84, 108, 20, 44, 68, 92, 116,
1, 25, 49, 73, 97, 9, 33, 57, 81, 105, 17, 41, 65, 89, 113,
5, 29, 53, 77, 101, 13, 37, 61, 85, 109, 21, 45, 69, 93, 117,
2, 26, 50, 74, 98, 10, 34, 58, 82, 106, 18, 42, 66, 90, 114,
6, 30, 54, 78, 102, 14, 38, 62, 86, 110, 22, 46, 70, 94, 118,
3, 27, 51, 75, 99, 11, 35, 59, 83, 107, 19, 43, 67, 91, 115,
7, 31, 55, 79, 103, 15, 39, 63, 87, 111, 23, 47, 71, 95, 119,
};
#endif

#ifndef FFT_BITREV60
#define FFT_BITREV60
static const opus_int16 fft_bitrev60[60] = {
0, 12, 24, 36, 48, 4, 16, 28, 40, 52, 8, 20, 32, 44, 56,
1, 13, 25, 37, 49, 5, 17, 29, 41, 53, 9, 21, 33, 45, 57,
2, 14, 26, 38, 50, 6, 18, 30, 42, 54, 10, 22, 34, 46, 58,
3, 15, 27, 39, 51, 7, 19, 31, 43, 55, 11, 23, 35, 47, 59,
};
#endif

#ifndef FFT_STATE48000_960_0
#define FFT_STATE48000_960_0
static const kiss_fft_state fft_state48000_960_0 = {
480,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
8,    /* scale_shift */
-1,    /* shift */
{5, 96, 3, 32, 4, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev480,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_480,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_1
#define FFT_STATE48000_960_1
static const kiss_fft_state fft_state48000_960_1 = {
240,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
7,    /* scale_shift */
1,    /* shift */
{5, 48, 3, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev240,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_240,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_2
#define FFT_STATE48000_960_2
static const kiss_fft_state fft_state48000_960_2 = {
120,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
6,    /* scale_shift */
2,    /* shift */
{5, 24, 3, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev120,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_120,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_3
#define FFT_STATE48000_960_3
static const kiss_fft_state fft_state48000_960_3 = {
60,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
5,    /* scale_shift */
3,    /* shift */
{5, 12, 3, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev60,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_60,
#else
NULL,
#endif
};
#endif

#endif

#ifndef MDCT_TWIDDLES960
#define MDCT_TWIDDLES960
static const celt_coef mdct_twiddles960[1800] = {
#ifdef ENABLE_QEXT
2147483468, 2147469095, 2147431723, 2147371355, 2147287990,
2147181629, 2147052273, 2146899924, 2146724584, 2146526254,
2146304937, 2146060634, 2145793349, 2145503083, 2145189842,
2144853627, 2144494442, 2144112292, 2143707180, 2143279110,
2142828088, 2142354118, 2141857204, 2141337354, 2140794571,
2140228862, 2139640233, 2139028690, 2138394240, 2137736889,
2137056645, 2136353515, 2135627506, 2134878626, 2134106884,
2133312286, 2132494843, 2131654563, 2130791454, 2129905526,
2128996788, 2128065251, 2127110924, 2126133817, 2125133941,
2124111307, 2123065925, 2121997806, 2120906963, 2119793407,
2118657149, 2117498202, 2116316578, 2115112291, 2113885352,
2112635775, 2111363574, 2110068761, 2108751352, 2107411359,
2106048798, 2104663683, 2103256028, 2101825849, 2100373162,
2098897981, 2097400322, 2095880202, 2094337637, 2092772643,
2091185237, 2089575437, 2087943258, 2086288720, 2084611839,
2082912633, 2081191122, 2079447322, 2077681253, 2075892934,
2074082383, 2072249621, 2070394667, 2068517540, 2066618262,
2064696851, 2062753329, 2060787717, 2058800036, 2056790306,
2054758550, 2052704789, 2050629045, 2048531340, 2046411698,
2044270140, 2042106689, 2039921369, 2037714204, 2035485216,
2033234429, 2030961869, 2028667558, 2026351522, 2024013785,
2021654373, 2019273310, 2016870623, 2014446336, 2012000477,
2009533071, 2007044144, 2004533723, 2002001835, 1999448508,
1996873768, 1994277643, 1991660161, 1989021350, 1986361238,
1983679853, 1980977226, 1978253383, 1975508355, 1972742171,
1969954860, 1967146453, 1964316979, 1961466469, 1958594953,
1955702462, 1952789027, 1949854680, 1946899451, 1943923372,
1940926475, 1937908793, 1934870357, 1931811201, 1928731356,
1925630856, 1922509734, 1919368023, 1916205758, 1913022972,
1909819698, 1906595972, 1903351828, 1900087301, 1896802425,
1893497236, 1890171769, 1886826060, 1883460144, 1880074058,
1876667838, 1873241521, 1869795142, 1866328740, 1862842350,
1859336011, 1855809760, 1852263635, 1848697674, 1845111914,
1841506395, 1837881155, 1834236233, 1830571667, 1826887497,
1823183763, 1819460504, 1815717761, 1811955572, 1808173978,
1804373021, 1800552740, 1796713177, 1792854372, 1788976368,
1785079205, 1781162925, 1777227570, 1773273182, 1769299805,
1765307479, 1761296249, 1757266156, 1753217244, 1749149557,
1745063138, 1740958031, 1736834279, 1732691928, 1728531020,
1724351602, 1720153717, 1715937410, 1711702727, 1707449714,
1703178415, 1698888876, 1694581143, 1690255263, 1685911282,
1681549245, 1677169201, 1672771196, 1668355276, 1663921490,
1659469885, 1655000508, 1650513407, 1646008631, 1641486227,
1636946244, 1632388731, 1627813736, 1623221309, 1618611498,
1613984353, 1609339924, 1604678260, 1599999411, 1595303428,
1590590360, 1585860258, 1581113173, 1576349155, 1571568256,
1566770527, 1561956018, 1557124783, 1552276872, 1547412337,
1542531231, 1537633606, 1532719513, 1527789007, 1522842139,
1517878963, 1512899531, 1507903898, 1502892116, 1497864239,
1492820322, 1487760417, 1482684580, 1477592864, 1472485325,
1467362016, 1462222994, 1457068312, 1451898025, 1446712191,
1441510863, 1436294098, 1431061951, 1425814478, 1420551737,
1415273782, 1409980671, 1404672460, 1399349206, 1394010966,
1388657798, 1383289758, 1377906904, 1372509294, 1367096986,
1361670037, 1356228505, 1350772450, 1345301929, 1339817000,
1334317724, 1328804158, 1323276361, 1317734393, 1312178313,
1306608181, 1301024057, 1295425999, 1289814068, 1284188325,
1278548828, 1272895640, 1267228820, 1261548429, 1255854528,
1250147177, 1244426439, 1238692373, 1232945043, 1227184508,
1221410831, 1215624074, 1209824299, 1204011567, 1198185941,
1192347484, 1186496258, 1180632325, 1174755748, 1168866591,
1162964917, 1157050787, 1151124267, 1145185419, 1139234307,
1133270995, 1127295547, 1121308026, 1115308496, 1109297023,
1103273670, 1097238502, 1091191583, 1085132978, 1079062753,
1072980972, 1066887699, 1060783002, 1054666944, 1048539592,
1042401010, 1036251266, 1030090423, 1023918550, 1017735711,
1011541973, 1005337402, 999122065, 992896028, 986659358,
980412122, 974154386, 967886217, 961607684, 955318852,
949019790, 942710564, 936391243, 930061894, 923722585,
917373383, 911014357, 904645574, 898267104, 891879014,
885481373, 879074249, 872657710, 866231826, 859796666,
853352298, 846898791, 840436214, 833964638, 827484130,
820994760, 814496598, 807989714, 801474176, 794950056,
788417422, 781876345, 775326894, 768769141, 762203154,
755629005, 749046764, 742456501, 735858287, 729252193,
722638289, 716016646, 709387335, 702750427, 696105993,
689454104, 682794832, 676128248, 669454423, 662773428,
656085336, 649390218, 642688145, 635979190, 629263424,
622540918, 615811746, 609075979, 602333690, 595584950,
588829831, 582068407, 575300749, 568526931, 561747023,
554961100, 548169234, 541371497, 534567963, 527758704,
520943793, 514123303, 507297307, 500465878, 493629090,
486787016, 479939728, 473087301, 466229807, 459367320,
452499914, 445627662, 438750638, 431868915, 424982567,
418091668, 411196291, 404296511, 397392401, 390484035,
383571488, 376654833, 369734144, 362809495, 355880961,
348948616, 342012534, 335072790, 328129457, 321182610,
314232323, 307278671, 300321729, 293361570, 286398270,
279431902, 272462542, 265490265, 258515144, 251537254,
244556671, 237573469, 230587722, 223599506, 216608896,
209615966, 202620791, 195623446, 188624006, 181622546,
174619141, 167613866, 160606796, 153598006, 146587571,
139575567, 132562067, 125547148, 118530885, 111513352,
104494625, 97474778, 90453888, 83432030, 76409277,
69385707, 62361393, 55336412, 48310838, 41284746,
34258213, 27231312, 20204120, 13176712, 6149162,
-878453, -7906059, -14933580, -21960942, -28988068,
-36014884, -43041314, -50067283, -57092716, -64117537,
-71141672, -78165045, -85187581, -92209205, -99229841,
-106249414, -113267850, -120285073, -127301007, -134315578,
-141328711, -148340330, -155350361, -162358728, -169365356,
-176370170, -183373096, -190374058, -197372981, -204369791,
-211364411, -218356769, -225346788, -232334393, -239319511,
-246302065, -253281982, -260259186, -267233603, -274205159,
-281173778, -288139385, -295101907, -302061269, -309017396,
-315970213, -322919647, -329865622, -336808065, -343746901,
-350682056, -357613455, -364541025, -371464690, -378384377,
-385300013, -392211522, -399118830, -406021865, -412920551,
-419814815, -426704583, -433589782, -440470337, -447346176,
-454217223, -461083406, -467944652, -474800886, -481652035,
-488498026, -495338786, -502174241, -509004318, -515828944,
-522648046, -529461551, -536269386, -543071478, -549867754,
-556658141, -563442567, -570220959, -576993244, -583759350,
-590519205, -597272736, -604019870, -610760536, -617494660,
-624222173, -630943000, -637657070, -644364312, -651064652,
-657758021, -664444345, -671123554, -677795576, -684460338,
-691117771, -697767803, -704410362, -711045377, -717672778,
-724292493, -730904451, -737508582, -744104815, -750693079,
-757273304, -763845419, -770409354, -776965038, -783512402,
-790051375, -796581887, -803103868, -809617249, -816121959,
-822617929, -829105090, -835583372, -842052705, -848513021,
-854964249, -861406322, -867839170, -874262724, -880676915,
-887081675, -893476935, -899862626, -906238681, -912605031,
-918961607, -925308342, -931645168, -937972016, -944288820,
-950595511, -956892022, -963178285, -969454234, -975719800,
-981974918, -988219519, -994453537, -1000676905, -1006889557,
-1013091426, -1019282445, -1025462549, -1031631671, -1037789745,
-1043936705, -1050072485, -1056197020, -1062310244, -1068412091,
-1074502497, -1080581395, -1086648722, -1092704411, -1098748398,
-1104780618, -1110801008, -1116809501, -1122806034, -1128790543,
-1134762964, -1140723232, -1146671283, -1152607055, -1158530484,
-1164441505, -1170340057, -1176226074, -1182099496, -1187960258,
-1193808298, -1199643553, -1205465961, -1211275460, -1217071986,
-1222855479, -1228625876, -1234383115, -1240127136, -1245857875,
-1251575272, -1257279266, -1262969796, -1268646800, -1274310217,
-1279959989, -1285596052, -1291218348, -1296826816, -1302421396,
-1308002029, -1313568653, -1319121210, -1324659641, -1330183885,
-1335693885, -1341189580, -1346670912, -1352137822, -1357590252,
-1363028143, -1368451438, -1373860077, -1379254004, -1384633159,
-1389997487, -1395346928, -1400681427, -1406000925, -1411305366,
-1416594694, -1421868850, -1427127780, -1432371426, -1437599733,
-1442812644, -1448010104, -1453192057, -1458358447, -1463509220,
-1468644319, -1473763690, -1478867279, -1483955030, -1489026889,
-1494082802, -1499122714, -1504146572, -1509154322, -1514145910,
-1519121283, -1524080387, -1529023170, -1533949577, -1538859558,
-1543753058, -1548630027, -1553490410, -1558334157, -1563161216,
-1567971534, -1572765060, -1577541744, -1582301533, -1587044377,
-1591770225, -1596479027, -1601170732, -1605845289, -1610502649,
-1615142762, -1619765578, -1624371047, -1628959121, -1633529750,
-1638082885, -1642618478, -1647136479, -1651636841, -1656119516,
-1660584454, -1665031609, -1669460933, -1673872378, -1678265898,
-1682641444, -1686998971, -1691338432, -1695659779, -1699962968,
-1704247951, -1708514683, -1712763118, -1716993211, -1721204917,
-1725398189, -1729572984, -1733729257, -1737866963, -1741986057,
-1746086497, -1750168237, -1754231234, -1758275445, -1762300826,
-1766307335, -1770294927, -1774263561, -1778213194, -1782143784,
-1786055289, -1789947667, -1793820875, -1797674873, -1801509620,
-1805325074, -1809121194, -1812897940, -1816655271, -1820393147,
-1824111529, -1827810376, -1831489648, -1835149306, -1838789312,
-1842409625, -1846010208, -1849591022, -1853152028, -1856693188,
-1860214464, -1863715819, -1867197215, -1870658615, -1874099982,
-1877521279, -1880922469, -1884303515, -1887664383, -1891005035,
-1894325435, -1897625550, -1900905342, -1904164776, -1907403819,
-1910622435, -1913820590, -1916998250, -1920155379, -1923291946,
-1926407915, -1929503255, -1932577931, -1935631910, -1938665161,
-1941677650, -1944669345, -1947640214, -1950590226, -1953519348,
-1956427550, -1959314800, -1962181067, -1965026321, -1967850531,
-1970653667, -1973435699, -1976196596, -1978936331, -1981654873,
-1984352192, -1987028261, -1989683050, -1992316532, -1994928677,
-1997519459, -2000088848, -2002636818, -2005163342, -2007668391,
-2010151941, -2012613963, -2015054432, -2017473321, -2019870604,
-2022246257, -2024600252, -2026932566, -2029243173, -2031532049,
-2033799168, -2036044507, -2038268042, -2040469748, -2042649603,
-2044807583, -2046943664, -2049057824, -2051150040, -2053220291,
-2055268553, -2057294804, -2059299024, -2061281190, -2063241282,
-2065179277, -2067095157, -2068988899, -2070860485, -2072709893,
-2074537104, -2076342098, -2078124857, -2079885360, -2081623590,
-2083339527, -2085033153, -2086704450, -2088353400, -2089979985,
-2091584189, -2093165993, -2094725382, -2096262337, -2097776843,
-2099268884, -2100738443, -2102185505, -2103610054, -2105012075,
-2106391553, -2107748474, -2109082822, -2110394584, -2111683744,
-2112950291, -2114194210, -2115415487, -2116614110, -2117790065,
-2118943341, -2120073924, -2121181804, -2122266967, -2123329402,
-2124369098, -2125386044, -2126380229, -2127351642, -2128300272,
-2129226111, -2130129147, -2131009371, -2131866773, -2132701345,
-2133513078, -2134301962, -2135067990, -2135811153, -2136531442,
-2137228852, -2137903373, -2138555000, -2139183723, -2139789539,
-2140372438, -2140932416, -2141469466, -2141983583, -2142474761,
-2142942995, -2143388280, -2143810610, -2144209982, -2144586392,
-2144939834, -2145270306, -2145577804, -2145862324, -2146123864,
-2146362421, -2146577992, -2146770575, -2146940167, -2147086768,
-2147210375, -2147310987, -2147388603, -2147443222, -2147474844,
2147482929, 2147425435, 2147275952, 2147034487, 2146701050,
2146275656, 2145758322, 2145149071, 2144447929, 2143654926,
2142770096, 2141793477, 2140725111, 2139565043, 2138313323,
2136970005, 2135535146, 2134008809, 2132391057, 2130681961,
2128881593, 2126990031, 2125007356, 2122933653, 2120769010,
2118513521, 2116167282, 2113730393, 2111202959, 2108585087,
2105876892, 2103078487, 2100189994, 2097211535, 2094143239,
2090985237, 2087737664, 2084400659, 2080974365, 2077458929,
2073854502, 2070161238, 2066379295, 2062508835, 2058550025,
2054503033, 2050368032, 2046145201, 2041834720, 2037436773,
2032951550, 2028379241, 2023720043, 2018974156, 2014141783,
2009223131, 2004218410, 1999127836, 1993951625, 1988690000,
1983343186, 1977911412, 1972394912, 1966793920, 1961108677,
1955339428, 1949486417, 1943549898, 1937530123, 1931427351,
1925241843, 1918973864, 1912623682, 1906191570, 1899677803,
1893082661, 1886406424, 1879649381, 1872811820, 1865894033,
1858896318, 1851818974, 1844662304, 1837426615, 1830112217,
1822719423, 1815248550, 1807699917, 1800073849, 1792370671,
1784590714, 1776734311, 1768801799, 1760793518, 1752709809,
1744551021, 1736317502, 1728009604, 1719627685, 1711172102,
1702643219, 1694041400, 1685367013, 1676620432, 1667802029,
1658912184, 1649951276, 1640919689, 1631817811, 1622646032,
1613404744, 1604094343, 1594715227, 1585267800, 1575752465,
1566169630, 1556519705, 1546803104, 1537020244, 1527171542,
1517257422, 1507278307, 1497234626, 1487126808, 1476955286,
1466720497, 1456422878, 1446062871, 1435640919, 1425157469,
1414612971, 1404007875, 1393342636, 1382617710, 1371833558,
1360990642, 1350089425, 1339130374, 1328113960, 1317040654,
1305910930, 1294725265, 1283484138, 1272188032, 1260837429,
1249432816, 1237974681, 1226463516, 1214899813, 1203284068,
1191616778, 1179898443, 1168129565, 1156310649, 1144442200,
1132524727, 1120558740, 1108544752, 1096483278, 1084374834,
1072219940, 1060019115, 1047772882, 1035481766, 1023146293,
1010766993, 998344394, 985879030, 973371434, 960822142,
948231691, 935600622, 922929474, 910218791, 897469118,
884680999, 871854984, 858991622, 846091463, 833155061,
820182969, 807175743, 794133941, 781058120, 767948841,
754806666, 741632158, 728425880, 715188400, 701920283,
688622098, 675294414, 661937804, 648552838, 635140090,
621700135, 608233549, 594740907, 581222789, 567679774,
554112440, 540521371, 526907147, 513270353, 499611571,
485931388, 472230390, 458509162, 444768294, 431008373,
417229989, 403433732, 389620194, 375789965, 361943639,
348081809, 334205068, 320314011, 306409232, 292491328,
278560894, 264618528, 250664827, 236700388, 222725809,
208741690, 194748629, 180747225, 166738079, 152721790,
138698959, 124670187, 110636075, 96597223, 82554233,
68507707, 54458246, 40406452, 26352928, 12298274,
-1756906, -15812011, -29866438, -43919586, -57970853,
-72019637, -86065335, -100107347, -114145071, -128177904,
-142205248, -156226499, -170241059, -184248325, -198247699,
-212238581, -226220372, -240192472, -254154282, -268105206,
-282044645, -295972002, -309886680, -323788084, -337675619,
-351548688, -365406698, -379249055, -393075166, -406884440,
-420676284, -434450107, -448205320, -461941333, -475657559,
-489353409, -503028296, -516681636, -530312842, -543921332,
-557506522, -571067830, -584604676, -598116479, -611602660,
-625062643, -638495850, -651901706, -665279637, -678629069,
-691949432, -705240153, -718500664, -731730397, -744928785,
-758095263, -771229267, -784330234, -797397602, -810430813,
-823429308, -836392529, -849319923, -862210934, -875065011,
-887881603, -900660162, -913400139, -926100989, -938762167,
-951383133, -963963344, -976502263, -988999351, -1001454074,
-1013865898, -1026234291, -1038558724, -1050838668, -1063073598,
-1075262990, -1087406320, -1099503070, -1111552721, -1123554757,
-1135508663, -1147413928, -1159270041, -1171076495, -1182832785,
-1194538405, -1206192856, -1217795637, -1229346252, -1240844206,
-1252289006, -1263680162, -1275017186, -1286299593, -1297526899,
-1308698624, -1319814288, -1330873416, -1341875533, -1352820169,
-1363706855, -1374535124, -1385304512, -1396014559, -1406664805,
-1417254794, -1427784073, -1438252190, -1448658697, -1459003149,
-1469285102, -1479504115, -1489659751, -1499751576, -1509779156,
-1519742062, -1529639867, -1539472148, -1549238483, -1558938453,
-1568571644, -1578137643, -1587636039, -1597066426, -1606428400,
-1615721561, -1624945509, -1634099849, -1643184191, -1652198144,
-1661141322, -1670013342, -1678813825, -1687542393, -1696198672,
-1704782292, -1713292884, -1721730085, -1730093532, -1738382868,
-1746597738, -1754737789, -1762802673, -1770792044, -1778705561,
-1786542883, -1794303676, -1801987607, -1809594347, -1817123570,
-1824574954, -1831948179, -1839242929, -1846458892, -1853595759,
-1860653224, -1867630985, -1874528743, -1881346202, -1888083070,
-1894739060, -1901313885, -1907807264, -1914218919, -1920548575,
-1926795962, -1932960811, -1939042858, -1945041843, -1950957509,
-1956789602, -1962537873, -1968202076, -1973781967, -1979277308,
-1984687864, -1990013401, -1995253694, -2000408516, -2005477648,
-2010460871, -2015357973, -2020168744, -2024892978, -2029530472,
-2034081027, -2038544449, -2042920547, -2047209133, -2051410023,
-2055523038, -2059548001, -2063484740, -2067333086, -2071092874,
-2074763944, -2078346137, -2081839301, -2085243286, -2088557947,
-2091783140, -2094918728, -2097964577, -2100920556, -2103786539,
-2106562402, -2109248028, -2111843300, -2114348108, -2116762344,
-2119085905, -2121318692, -2123460608, -2125511562, -2127471467,
-2129340237, -2131117794, -2132804061, -2134398966, -2135902440,
-2137314419, -2138634843, -2139863654, -2141000801, -2142046235,
-2142999911, -2143861787, -2144631828, -2145310000, -2145896274,
-2146390624, -2146793031, -2147103476, -2147321946, -2147448433,
2147480773, 2147250799, 2146652904, 2145687192, 2144353827,
2142653038, 2140585116, 2138150417, 2135349356, 2132182414,
2128650133, 2124753120, 2120492040, 2115867626, 2110880668,
2105532022, 2099822604, 2093753392, 2087325426, 2080539807,
2073397699, 2065900325, 2058048970, 2049844978, 2041289756,
2032384769, 2023131544, 2013531666, 2003586779, 1993298588,
1982668856, 1971699403, 1960392110, 1948748914, 1936771810,
1924462850, 1911824143, 1898857855, 1885566207, 1871951478,
1858015999, 1843762158, 1829192399, 1814309216, 1799115162,
1783612838, 1767804901, 1751694060, 1735283075, 1718574758,
1701571972, 1684277631, 1666694698, 1648826185, 1630675154,
1612244715, 1593538026, 1574558293, 1555308768, 1535792748,
1516013578, 1495974647, 1475679389, 1455131280, 1434333842,
1413290638, 1392005275, 1370481398, 1348722696, 1326732898,
1304515771, 1282075122, 1259414796, 1236538675, 1213450681,
1190154767, 1166654927, 1142955186, 1119059606, 1094972281,
1070697338, 1046238936, 1021601267, 996788551, 971805042,
946655018, 921342790, 895872694, 870249095, 844476384,
818558976, 792501312, 766307857, 739983099, 713531549,
686957739, 660266222, 633461572, 606548381, 579531262,
552414843, 525203770, 497902707, 470516330, 443049333,
415506422, 387892316, 360211746, 332469456, 304670200,
276818739, 248919847, 220978304, 192998897, 164986421,
136945676, 108881465, 80798598, 52701887, 24596146,
-3513810, -31623164, -59727099, -87820801, -115899455,
-143958250, -171992378, -199997036, -227967426, -255898755,
-283786237, -311625094, -339410555, -367137861, -394802258,
-422399009, -449923384, -477370666, -504736154, -532015158,
-559203003, -586295032, -613286603, -640173090, -666949886,
-693612404, -720156076, -746576352, -772868706, -799028633,
-825051651, -850933300, -876669146, -902254780, -927685817,
-952957899, -978066697, -1003007909, -1027777260, -1052370507,
-1076783436, -1101011863, -1125051638, -1148898640, -1172548785,
-1195998020, -1219242327, -1242277723, -1265100260, -1287706030,
-1310091157, -1332251808, -1354184184, -1375884527, -1397349119,
-1418574283, -1439556382, -1460291820, -1480777044, -1501008545,
-1520982856, -1540696555, -1560146263, -1579328647, -1598240423,
-1616878347, -1635239228, -1653319919, -1671117323, -1688628389,
-1705850117, -1722779556, -1739413807, -1755750017, -1771785389,
-1787517174, -1802942678, -1818059257, -1832864320, -1847355332,
-1861529809, -1875385322, -1888919498, -1902130017, -1915014616,
-1927571087, -1939797279, -1951691096, -1963250501, -1974473513,
-1985358210, -1995902725, -2006105253, -2015964045, -2025477412,
-2034643724, -2043461410, -2051928960, -2060044922, -2067807906,
-2075216581, -2082269679, -2088965991, -2095304370, -2101283728,
-2106903043, -2112161350, -2117057750, -2121591402, -2125761531,
-2129567422, -2133008422, -2136083942, -2138793455, -2141136497,
-2143112666, -2144721624, -2145963095, -2146836866, -2147342788,
2147472149, 2146552303, 2144161316, 2140300829, 2134973487,
2128182940, 2119933843, 2110231849, 2099083608, 2086496759,
2072479930, 2057042727, 2040195730, 2021950484, 2002319494,
1981316215, 1958955040, 1935251296, 1910221227, 1883881987,
1856251629, 1827349089, 1797194176, 1765807555, 1733210737,
1699426064, 1664476689, 1628386565, 1591180426, 1552883771,
1513522847, 1473124631, 1431716808, 1389327759, 1345986533,
1301722835, 1256567002, 1210549980, 1163703308, 1116059092,
1067649985, 1018509163, 968670307, 918167572, 867035571,
815309347, 763024350, 710216415, 656921734, 603176830,
549018540, 494483979, 439610524, 384435782, 328997567,
273333873, 217482850, 161482775, 105372028, 49189064,
-7027611, -63239471, -119407989, -175494670, -231461077,
-287268852, -342879747, -398255649, -453358607, -508150855,
-562594842, -616653255, -670289044, -723465451, -776146031,
-828294679, -879875655, -930853609, -981193602, -1030861133,
-1079822164, -1128043139, -1175491010, -1222133257, -1267937916,
-1312873593, -1356909492, -1400015434, -1442161874, -1483319929,
-1523461391, -1562558748, -1600585205, -1637514702, -1673321927,
-1707982341, -1741472190, -1773768520, -1804849198, -1834692923,
-1863279241, -1890588560, -1916602164, -1941302225, -1964671814,
-1986694916, -2007356435, -2026642214, -2044539032, -2061034626,
-2076117690, -2089777886, -2102005853, -2112793210, -2122132564,
-2130017514, -2136442657, -2141403589, -2144896910, -2146920225,
#else
32767, 32767, 32767, 32766, 32765,
32763, 32761, 32759, 32756, 32753,
32750, 32746, 32742, 32738, 32733,
32728, 32722, 32717, 32710, 32704,
32697, 32690, 32682, 32674, 32666,
32657, 32648, 32639, 32629, 32619,
32609, 32598, 32587, 32576, 32564,
32552, 32539, 32526, 32513, 32500,
32486, 32472, 32457, 32442, 32427,
32411, 32395, 32379, 32362, 32345,
32328, 32310, 32292, 32274, 32255,
32236, 32217, 32197, 32177, 32157,
32136, 32115, 32093, 32071, 32049,
32027, 32004, 31981, 31957, 31933,
31909, 31884, 31859, 31834, 31809,
31783, 31756, 31730, 31703, 31676,
31648, 31620, 31592, 31563, 31534,
31505, 31475, 31445, 31415, 31384,
31353, 31322, 31290, 31258, 31226,
31193, 31160, 31127, 31093, 31059,
31025, 30990, 30955, 30920, 30884,
30848, 30812, 30775, 30738, 30701,
30663, 30625, 30587, 30548, 30509,
30470, 30430, 30390, 30350, 30309,
30269, 30227, 30186, 30144, 30102,
30059, 30016, 29973, 29930, 29886,
29842, 29797, 29752, 29707, 29662,
29616, 29570, 29524, 29477, 29430,
29383, 29335, 29287, 29239, 29190,
29142, 29092, 29043, 28993, 28943,
28892, 28842, 28791, 28739, 28688,
28636, 28583, 28531, 28478, 28425,
28371, 28317, 28263, 28209, 28154,
28099, 28044, 27988, 27932, 27876,
27820, 27763, 27706, 27648, 27591,
27533, 27474, 27416, 27357, 27298,
27238, 27178, 27118, 27058, 26997,
26936, 26875, 26814, 26752, 26690,
26628, 26565, 26502, 26439, 26375,
26312, 26247, 26183, 26119, 26054,
25988, 25923, 25857, 25791, 25725,
25658, 25592, 25524, 25457, 25389,
25322, 25253, 25185, 25116, 25047,
24978, 24908, 24838, 24768, 24698,
24627, 24557, 24485, 24414, 24342,
24270, 24198, 24126, 24053, 23980,
23907, 23834, 23760, 23686, 23612,
23537, 23462, 23387, 23312, 23237,
23161, 23085, 23009, 22932, 22856,
22779, 22701, 22624, 22546, 22468,
22390, 22312, 22233, 22154, 22075,
21996, 21916, 21836, 21756, 21676,
21595, 21515, 21434, 21352, 21271,
21189, 21107, 21025, 20943, 20860,
20777, 20694, 20611, 20528, 20444,
20360, 20276, 20192, 20107, 20022,
19937, 19852, 19767, 19681, 19595,
19509, 19423, 19336, 19250, 19163,
19076, 18988, 18901, 18813, 18725,
18637, 18549, 18460, 18372, 18283,
18194, 18104, 18015, 17925, 17835,
17745, 17655, 17565, 17474, 17383,
17292, 17201, 17110, 17018, 16927,
16835, 16743, 16650, 16558, 16465,
16372, 16279, 16186, 16093, 15999,
15906, 15812, 15718, 15624, 15529,
15435, 15340, 15245, 15150, 15055,
14960, 14864, 14769, 14673, 14577,
14481, 14385, 14288, 14192, 14095,
13998, 13901, 13804, 13706, 13609,
13511, 13414, 13316, 13218, 13119,
13021, 12923, 12824, 12725, 12626,
12527, 12428, 12329, 12230, 12130,
12030, 11930, 11831, 11730, 11630,
11530, 11430, 11329, 11228, 11128,
11027, 10926, 10824, 10723, 10622,
10520, 10419, 10317, 10215, 10113,
10011, 9909, 9807, 9704, 9602,
9499, 9397, 9294, 9191, 9088,
8985, 8882, 8778, 8675, 8572,
8468, 8364, 8261, 8157, 8053,
7949, 7845, 7741, 7637, 7532,
7428, 7323, 7219, 7114, 7009,
6905, 6800, 6695, 6590, 6485,
6380, 6274, 6169, 6064, 5958,
5853, 5747, 5642, 5536, 5430,
5325, 5219, 5113, 5007, 4901,
4795, 4689, 4583, 4476, 4370,
4264, 4157, 4051, 3945, 3838,
3732, 3625, 3518, 3412, 3305,
3198, 3092, 2985, 2878, 2771,
2664, 2558, 2451, 2344, 2237,
2130, 2023, 1916, 1809, 1702,
1594, 1487, 1380, 1273, 1166,
1059, 952, 844, 737, 630,
523, 416, 308, 201, 94,
-13, -121, -228, -335, -442,
-550, -657, -764, -871, -978,
-1086, -1193, -1300, -1407, -1514,
-1621, -1728, -1835, -1942, -2049,
-2157, -2263, -2370, -2477, -2584,
-2691, -2798, -2905, -3012, -3118,
-3225, -3332, -3439, -3545, -3652,
-3758, -3865, -3971, -4078, -4184,
-4290, -4397, -4503, -4609, -4715,
-4821, -4927, -5033, -5139, -5245,
-5351, -5457, -5562, -5668, -5774,
-5879, -5985, -6090, -6195, -6301,
-6406, -6511, -6616, -6721, -6826,
-6931, -7036, -7140, -7245, -7349,
-7454, -7558, -7663, -7767, -7871,
-7975, -8079, -8183, -8287, -8390,
-8494, -8597, -8701, -8804, -8907,
-9011, -9114, -9217, -9319, -9422,
-9525, -9627, -9730, -9832, -9934,
-10037, -10139, -10241, -10342, -10444,
-10546, -10647, -10748, -10850, -10951,
-11052, -11153, -11253, -11354, -11455,
-11555, -11655, -11756, -11856, -11955,
-12055, -12155, -12254, -12354, -12453,
-12552, -12651, -12750, -12849, -12947,
-13046, -13144, -13242, -13340, -13438,
-13536, -13633, -13731, -13828, -13925,
-14022, -14119, -14216, -14312, -14409,
-14505, -14601, -14697, -14793, -14888,
-14984, -15079, -15174, -15269, -15364,
-15459, -15553, -15647, -15741, -15835,
-15929, -16023, -16116, -16210, -16303,
-16396, -16488, -16581, -16673, -16766,
-16858, -16949, -17041, -17133, -17224,
-17315, -17406, -17497, -17587, -17678,
-17768, -17858, -17948, -18037, -18127,
-18216, -18305, -18394, -18483, -18571,
-18659, -18747, -18835, -18923, -19010,
-19098, -19185, -19271, -19358, -19444,
-19531, -19617, -19702, -19788, -19873,
-19959, -20043, -20128, -20213, -20297,
-20381, -20465, -20549, -20632, -20715,
-20798, -20881, -20963, -21046, -21128,
-21210, -21291, -21373, -21454, -21535,
-21616, -21696, -21776, -21856, -21936,
-22016, -22095, -22174, -22253, -22331,
-22410, -22488, -22566, -22643, -22721,
-22798, -22875, -22951, -23028, -23104,
-23180, -23256, -23331, -23406, -23481,
-23556, -23630, -23704, -23778, -23852,
-23925, -23998, -24071, -24144, -24216,
-24288, -24360, -24432, -24503, -24574,
-24645, -24716, -24786, -24856, -24926,
-24995, -25064, -25133, -25202, -25270,
-25339, -25406, -25474, -25541, -25608,
-25675, -25742, -25808, -25874, -25939,
-26005, -26070, -26135, -26199, -26264,
-26327, -26391, -26455, -26518, -26581,
-26643, -26705, -26767, -26829, -26891,
-26952, -27013, -27073, -27133, -27193,
-27253, -27312, -27372, -27430, -27489,
-27547, -27605, -27663, -27720, -27777,
-27834, -27890, -27946, -28002, -28058,
-28113, -28168, -28223, -28277, -28331,
-28385, -28438, -28491, -28544, -28596,
-28649, -28701, -28752, -28803, -28854,
-28905, -28955, -29006, -29055, -29105,
-29154, -29203, -29251, -29299, -29347,
-29395, -29442, -29489, -29535, -29582,
-29628, -29673, -29719, -29764, -29808,
-29853, -29897, -29941, -29984, -30027,
-30070, -30112, -30154, -30196, -30238,
-30279, -30320, -30360, -30400, -30440,
-30480, -30519, -30558, -30596, -30635,
-30672, -30710, -30747, -30784, -30821,
-30857, -30893, -30929, -30964, -30999,
-31033, -31068, -31102, -31135, -31168,
-31201, -31234, -31266, -31298, -31330,
-31361, -31392, -31422, -31453, -31483,
-31512, -31541, -31570, -31599, -31627,
-31655, -31682, -31710, -31737, -31763,
-31789, -31815, -31841, -31866, -31891,
-31915, -31939, -31963, -31986, -32010,
-32032, -32055, -32077, -32099, -32120,
-32141, -32162, -32182, -32202, -32222,
-32241, -32260, -32279, -32297, -32315,
-32333, -32350, -32367, -32383, -32399,
-32415, -32431, -32446, -32461, -32475,
-32489, -32503, -32517, -32530, -32542,
-32555, -32567, -32579, -32590, -32601,
-32612, -32622, -32632, -32641, -32651,
-32659, -32668, -32676, -32684, -32692,
-32699, -32706, -32712, -32718, -32724,
-32729, -32734, -32739, -32743, -32747,
-32751, -32754, -32757, -32760, -32762,
-32764, -32765, -32767, -32767, -32767,
32767, 32767, 32765, 32761, 32756,
32750, 32742, 32732, 32722, 32710,
32696, 32681, 32665, 32647, 32628,
32608, 32586, 32562, 32538, 32512,
32484, 32455, 32425, 32393, 32360,
32326, 32290, 32253, 32214, 32174,
32133, 32090, 32046, 32001, 31954,
31906, 31856, 31805, 31753, 31700,
31645, 31588, 31530, 31471, 31411,
31349, 31286, 31222, 31156, 31089,
31020, 30951, 30880, 30807, 30733,
30658, 30582, 30504, 30425, 30345,
30263, 30181, 30096, 30011, 29924,
29836, 29747, 29656, 29564, 29471,
29377, 29281, 29184, 29086, 28987,
28886, 28784, 28681, 28577, 28471,
28365, 28257, 28147, 28037, 27925,
27812, 27698, 27583, 27467, 27349,
27231, 27111, 26990, 26868, 26744,
26620, 26494, 26367, 26239, 26110,
25980, 25849, 25717, 25583, 25449,
25313, 25176, 25038, 24900, 24760,
24619, 24477, 24333, 24189, 24044,
23898, 23751, 23602, 23453, 23303,
23152, 22999, 22846, 22692, 22537,
22380, 22223, 22065, 21906, 21746,
21585, 21423, 21261, 21097, 20933,
20767, 20601, 20434, 20265, 20096,
19927, 19756, 19584, 19412, 19239,
19065, 18890, 18714, 18538, 18361,
18183, 18004, 17824, 17644, 17463,
17281, 17098, 16915, 16731, 16546,
16361, 16175, 15988, 15800, 15612,
15423, 15234, 15043, 14852, 14661,
14469, 14276, 14083, 13889, 13694,
13499, 13303, 13107, 12910, 12713,
12515, 12317, 12118, 11918, 11718,
11517, 11316, 11115, 10913, 10710,
10508, 10304, 10100, 9896, 9691,
9486, 9281, 9075, 8869, 8662,
8455, 8248, 8040, 7832, 7623,
7415, 7206, 6996, 6787, 6577,
6366, 6156, 5945, 5734, 5523,
5311, 5100, 4888, 4675, 4463,
4251, 4038, 3825, 3612, 3399,
3185, 2972, 2758, 2544, 2330,
2116, 1902, 1688, 1474, 1260,
1045, 831, 617, 402, 188,
-27, -241, -456, -670, -885,
-1099, -1313, -1528, -1742, -1956,
-2170, -2384, -2598, -2811, -3025,
-3239, -3452, -3665, -3878, -4091,
-4304, -4516, -4728, -4941, -5153,
-5364, -5576, -5787, -5998, -6209,
-6419, -6629, -6839, -7049, -7258,
-7467, -7676, -7884, -8092, -8300,
-8507, -8714, -8920, -9127, -9332,
-9538, -9743, -9947, -10151, -10355,
-10558, -10761, -10963, -11165, -11367,
-11568, -11768, -11968, -12167, -12366,
-12565, -12762, -12960, -13156, -13352,
-13548, -13743, -13937, -14131, -14324,
-14517, -14709, -14900, -15091, -15281,
-15470, -15659, -15847, -16035, -16221,
-16407, -16593, -16777, -16961, -17144,
-17326, -17508, -17689, -17869, -18049,
-18227, -18405, -18582, -18758, -18934,
-19108, -19282, -19455, -19627, -19799,
-19969, -20139, -20308, -20475, -20642,
-20809, -20974, -21138, -21301, -21464,
-21626, -21786, -21946, -22105, -22263,
-22420, -22575, -22730, -22884, -23037,
-23189, -23340, -23490, -23640, -23788,
-23935, -24080, -24225, -24369, -24512,
-24654, -24795, -24934, -25073, -25211,
-25347, -25482, -25617, -25750, -25882,
-26013, -26143, -26272, -26399, -26526,
-26651, -26775, -26898, -27020, -27141,
-27260, -27379, -27496, -27612, -27727,
-27841, -27953, -28065, -28175, -28284,
-28391, -28498, -28603, -28707, -28810,
-28911, -29012, -29111, -29209, -29305,
-29401, -29495, -29587, -29679, -29769,
-29858, -29946, -30032, -30118, -30201,
-30284, -30365, -30445, -30524, -30601,
-30677, -30752, -30825, -30897, -30968,
-31038, -31106, -31172, -31238, -31302,
-31365, -31426, -31486, -31545, -31602,
-31658, -31713, -31766, -31818, -31869,
-31918, -31966, -32012, -32058, -32101,
-32144, -32185, -32224, -32262, -32299,
-32335, -32369, -32401, -32433, -32463,
-32491, -32518, -32544, -32568, -32591,
-32613, -32633, -32652, -32669, -32685,
-32700, -32713, -32724, -32735, -32744,
-32751, -32757, -32762, -32766, -32767,
32767, 32764, 32755, 32741, 32720,
32694, 32663, 32626, 32583, 32535,
32481, 32421, 32356, 32286, 32209,
32128, 32041, 31948, 31850, 31747,
31638, 31523, 31403, 31278, 31148,
31012, 30871, 30724, 30572, 30415,
30253, 30086, 29913, 29736, 29553,
29365, 29172, 28974, 28771, 28564,
28351, 28134, 27911, 27684, 27452,
27216, 26975, 26729, 26478, 26223,
25964, 25700, 25432, 25159, 24882,
24601, 24315, 24026, 23732, 23434,
23133, 22827, 22517, 22204, 21886,
21565, 21240, 20912, 20580, 20244,
19905, 19563, 19217, 18868, 18516,
18160, 17802, 17440, 17075, 16708,
16338, 15964, 15588, 15210, 14829,
14445, 14059, 13670, 13279, 12886,
12490, 12093, 11693, 11291, 10888,
10482, 10075, 9666, 9255, 8843,
8429, 8014, 7597, 7180, 6760,
6340, 5919, 5496, 5073, 4649,
4224, 3798, 3372, 2945, 2517,
2090, 1661, 1233, 804, 375,
-54, -483, -911, -1340, -1768,
-2197, -2624, -3052, -3479, -3905,
-4330, -4755, -5179, -5602, -6024,
-6445, -6865, -7284, -7702, -8118,
-8533, -8946, -9358, -9768, -10177,
-10584, -10989, -11392, -11793, -12192,
-12589, -12984, -13377, -13767, -14155,
-14541, -14924, -15305, -15683, -16058,
-16430, -16800, -17167, -17531, -17892,
-18249, -18604, -18956, -19304, -19649,
-19990, -20329, -20663, -20994, -21322,
-21646, -21966, -22282, -22595, -22904,
-23208, -23509, -23806, -24099, -24387,
-24672, -24952, -25228, -25499, -25766,
-26029, -26288, -26541, -26791, -27035,
-27275, -27511, -27741, -27967, -28188,
-28405, -28616, -28823, -29024, -29221,
-29412, -29599, -29780, -29957, -30128,
-30294, -30455, -30611, -30761, -30906,
-31046, -31181, -31310, -31434, -31552,
-31665, -31773, -31875, -31972, -32063,
-32149, -32229, -32304, -32373, -32437,
-32495, -32547, -32594, -32635, -32671,
-32701, -32726, -32745, -32758, -32766,
32767, 32754, 32717, 32658, 32577,
32473, 32348, 32200, 32029, 31837,
31624, 31388, 31131, 30853, 30553,
30232, 29891, 29530, 29148, 28746,
28324, 27883, 27423, 26944, 26447,
25931, 25398, 24847, 24279, 23695,
23095, 22478, 21846, 21199, 20538,
19863, 19174, 18472, 17757, 17030,
16291, 15541, 14781, 14010, 13230,
12441, 11643, 10837, 10024, 9204,
8377, 7545, 6708, 5866, 5020,
4171, 3319, 2464, 1608, 751,
-107, -965, -1822, -2678, -3532,
-4383, -5232, -6077, -6918, -7754,
-8585, -9409, -10228, -11039, -11843,
-12639, -13426, -14204, -14972, -15730,
-16477, -17213, -17937, -18648, -19347,
-20033, -20705, -21363, -22006, -22634,
-23246, -23843, -24423, -24986, -25533,
-26062, -26573, -27066, -27540, -27995,
-28431, -28848, -29245, -29622, -29979,
-30315, -30630, -30924, -31197, -31449,
-31679, -31887, -32074, -32239, -32381,
-32501, -32600, -32675, -32729, -32759,
#endif
};
#endif

static const CELTMode mode48000_960_120 = {
48000,    /* Fs */
120,    /* overlap */
21,    /* nbEBands */
21,    /* effEBands */
{27853, 0, 4096, 8192, },    /* preemph */
eband5ms,    /* eBands */
3,    /* maxLM */
8,    /* nbShortMdcts */
120,    /* shortMdctSize */
11,    /* nbAllocVectors */
band_allocation,    /* allocVectors */
logN400,    /* logN */
window120,    /* window */
{1920, 3, {&fft_state48000_960_0, &fft_state48000_960_1, &fft_state48000_960_2, &fft_state48000_960_3, }, mdct_twiddles960},    /* mdct */
{392, cache_index50, cache_bits50, cache_caps50},    /* cache */
#ifdef ENABLE_QEXT
{86, qext_cache_index50, qext_cache_bits50, qext_cache_caps50},    /* qext_cache */
#endif
};

#ifdef ENABLE_QEXT
#ifndef DEF_WINDOW240
#define DEF_WINDOW240
static const celt_coef window240[240] = {
#ifdef ENABLE_QEXT
36124, 325113, 903042, 1769811, 2925272,
4369225, 6101422, 8121563, 10429297, 13024223,
15905885, 19073777, 22527339, 26265958, 30288963,
34595631, 39185180, 44056771, 49209509, 54642435,
60354533, 66344724, 72611866, 79154752, 85972112,
93062609, 100424835, 108057317, 115958510, 124126796,
132560487, 141257817, 150216948, 159435962, 168912864,
178645581, 188631957, 198869754, 209356654, 220090250,
231068053, 242287487, 253745886, 265440499, 277368483,
289526906, 301912744, 314522883, 327354113, 340403136,
353666556, 367140886, 380822544, 394707853, 408793044,
423074251, 437547515, 452208783, 467053909, 482078654,
497278684, 512649576, 528186815, 543885797, 559741828,
575750127, 591905825, 608203972, 624639532, 641207388,
657902345, 674719130, 691652394, 708696716, 725846605,
743096501, 760440782, 777873759, 795389689, 812982769,
830647145, 848376914, 866166126, 884008788, 901898872,
919830310, 937797006, 955792839, 973811661, 991847308,
1009893601, 1027944353, 1045993369, 1064034454, 1082061416,
1100068075, 1118048258, 1135995815, 1153904614, 1171768555,
1189581567, 1207337616, 1225030710, 1242654904, 1260204305,
1277673075, 1295055437, 1312345681, 1329538165, 1346627326,
1363607677, 1380473817, 1397220435, 1413842311, 1430334323,
1446691453, 1462908786, 1478981520, 1494904965, 1510674550,
1526285825, 1541734465, 1557016274, 1572127189, 1587063280,
1601820758, 1616395971, 1630785416, 1644985731, 1658993707,
1672806283, 1686420553, 1699833765, 1713043324, 1726046792,
1738841892, 1751426506, 1763798678, 1775956615, 1787898686,
1799623424, 1811129525, 1822415848, 1833481417, 1844325418,
1854947198, 1865346267, 1875522297, 1885475119, 1895204720,
1904711247, 1913995001, 1923056438, 1931896164, 1940514936,
1948913657, 1957093375, 1965055281, 1972800706, 1980331118,
1987648116, 1994753433, 2001648928, 2008336584, 2014818504,
2021096911, 2027174137, 2033052626, 2038734929, 2044223696,
2049521676, 2054631712, 2059556735, 2064299763, 2068863893,
2073252301, 2077468232, 2081515002, 2085395988, 2089114627,
2092674410, 2096078878, 2099331616, 2102436251, 2105396446,
2108215896, 2110898322, 2113447469, 2115867100, 2118160991,
2120332927, 2122386699, 2124326098, 2126154912, 2127876920,
2129495889, 2131015570, 2132439692, 2133771963, 2135016059,
2136175624, 2137254268, 2138255559, 2139183022, 2140040133,
2140830320, 2141556955, 2142223351, 2142832762, 2143388377,
2143893317, 2144350634, 2144763305, 2145134231, 2145466235,
2145762059, 2146024357, 2146255701, 2146458570, 2146635355,
2146788350, 2146919756, 2147031676, 2147126111, 2147204964,
2147270033, 2147323012, 2147365487, 2147398940, 2147424741,
2147444152, 2147458322, 2147468290, 2147474980, 2147479203,
2147481655, 2147482918, 2147483458, 2147483623, 2147483647,
#else
1, 5, 14, 27, 45,
67, 93, 124, 159, 199,
243, 291, 344, 401, 462,
528, 598, 672, 751, 834,
921, 1012, 1108, 1208, 1312,
1420, 1532, 1649, 1769, 1894,
2023, 2155, 2292, 2433, 2577,
2726, 2878, 3035, 3195, 3358,
3526, 3697, 3872, 4050, 4232,
4418, 4607, 4799, 4995, 5194,
5397, 5602, 5811, 6023, 6238,
6456, 6676, 6900, 7127, 7356,
7588, 7822, 8059, 8299, 8541,
8785, 9032, 9280, 9531, 9784,
10039, 10295, 10554, 10814, 11076,
11339, 11603, 11869, 12137, 12405,
12675, 12945, 13217, 13489, 13762,
14035, 14310, 14584, 14859, 15134,
15410, 15685, 15961, 16236, 16511,
16786, 17060, 17334, 17607, 17880,
18152, 18423, 18692, 18961, 19229,
19496, 19761, 20025, 20287, 20548,
20807, 21064, 21320, 21574, 21825,
22075, 22322, 22567, 22810, 23051,
23289, 23525, 23758, 23989, 24217,
24442, 24664, 24884, 25100, 25314,
25525, 25733, 25937, 26139, 26337,
26533, 26725, 26913, 27099, 27281,
27460, 27636, 27808, 27977, 28142,
28304, 28463, 28618, 28770, 28919,
29064, 29205, 29344, 29478, 29610,
29738, 29863, 29984, 30103, 30217,
30329, 30438, 30543, 30645, 30744,
30839, 30932, 31022, 31109, 31192,
31273, 31351, 31426, 31499, 31568,
31635, 31700, 31761, 31821, 31877,
31932, 31984, 32033, 32081, 32126,
32169, 32210, 32249, 32286, 32321,
32354, 32385, 32415, 32443, 32469,
32494, 32517, 32538, 32559, 32578,
32595, 32612, 32627, 32641, 32654,
32666, 32678, 32688, 32697, 32706,
32713, 32720, 32726, 32732, 32737,
32742, 32746, 32749, 32752, 32755,
32757, 32759, 32761, 32763, 32764,
32765, 32766, 32766, 32767, 32767,
32767, 32767, 32767, 32767, 32767,
32767, 32767, 32767, 32767, 32767,
#endif
};
#endif

#ifndef DEF_LOGN400
#define DEF_LOGN400
static const opus_int16 logN400[21] = {
0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 16, 16, 16, 21, 21, 24, 29, 34, 36, };
#endif

#ifndef DEF_PULSE_CACHE50
#define DEF_PULSE_CACHE50
static const opus_int16 cache_index50[105] = {
-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 41, 41, 41,
82, 82, 123, 164, 200, 222, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 123, 123, 123, 164, 164, 240, 266, 283, 295, 41, 41, 41,
41, 41, 41, 41, 41, 123, 123, 123, 123, 240, 240, 240, 266, 266, 305,
318, 328, 336, 123, 123, 123, 123, 123, 123, 123, 123, 240, 240, 240, 240,
305, 305, 305, 318, 318, 343, 351, 358, 364, 240, 240, 240, 240, 240, 240,
240, 240, 305, 305, 305, 305, 343, 343, 343, 351, 351, 370, 376, 382, 387,
};
static const unsigned char cache_bits50[392] = {
40, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 40, 15, 23, 28,
31, 34, 36, 38, 39, 41, 42, 43, 44, 45, 46, 47, 47, 49, 50,
51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 63, 65,
66, 67, 68, 69, 70, 71, 71, 40, 20, 33, 41, 48, 53, 57, 61,
64, 66, 69, 71, 73, 75, 76, 78, 80, 82, 85, 87, 89, 91, 92,
94, 96, 98, 101, 103, 105, 107, 108, 110, 112, 114, 117, 119, 121, 123,
124, 126, 128, 40, 23, 39, 51, 60, 67, 73, 79, 83, 87, 91, 94,
97, 100, 102, 105, 107, 111, 115, 118, 121, 124, 126, 129, 131, 135, 139,
142, 145, 148, 150, 153, 155, 159, 163, 166, 169, 172, 174, 177, 179, 35,
28, 49, 65, 78, 89, 99, 107, 114, 120, 126, 132, 136, 141, 145, 149,
153, 159, 165, 171, 176, 180, 185, 189, 192, 199, 205, 211, 216, 220, 225,
229, 232, 239, 245, 251, 21, 33, 58, 79, 97, 112, 125, 137, 148, 157,
166, 174, 182, 189, 195, 201, 207, 217, 227, 235, 243, 251, 17, 35, 63,
86, 106, 123, 139, 152, 165, 177, 187, 197, 206, 214, 222, 230, 237, 250,
25, 31, 55, 75, 91, 105, 117, 128, 138, 146, 154, 161, 168, 174, 180,
185, 190, 200, 208, 215, 222, 229, 235, 240, 245, 255, 16, 36, 65, 89,
110, 128, 144, 159, 173, 185, 196, 207, 217, 226, 234, 242, 250, 11, 41,
74, 103, 128, 151, 172, 191, 209, 225, 241, 255, 9, 43, 79, 110, 138,
163, 186, 207, 227, 246, 12, 39, 71, 99, 123, 144, 164, 182, 198, 214,
228, 241, 253, 9, 44, 81, 113, 142, 168, 192, 214, 235, 255, 7, 49,
90, 127, 160, 191, 220, 247, 6, 51, 95, 134, 170, 203, 234, 7, 47,
87, 123, 155, 184, 212, 237, 6, 52, 97, 137, 174, 208, 240, 5, 57,
106, 151, 192, 231, 5, 59, 111, 158, 202, 243, 5, 55, 103, 147, 187,
224, 5, 60, 113, 161, 206, 248, 4, 65, 122, 175, 224, 4, 67, 127,
182, 234, };
static const unsigned char cache_caps50[168] = {
224, 224, 224, 224, 224, 224, 224, 224, 160, 160, 160, 160, 185, 185, 185,
178, 178, 168, 134, 61, 37, 224, 224, 224, 224, 224, 224, 224, 224, 240,
240, 240, 240, 207, 207, 207, 198, 198, 183, 144, 66, 40, 160, 160, 160,
160, 160, 160, 160, 160, 185, 185, 185, 185, 193, 193, 193, 183, 183, 172,
138, 64, 38, 240, 240, 240, 240, 240, 240, 240, 240, 207, 207, 207, 207,
204, 204, 204, 193, 193, 180, 143, 66, 40, 185, 185, 185, 185, 185, 185,
185, 185, 193, 193, 193, 193, 193, 193, 193, 183, 183, 172, 138, 65, 39,
207, 207, 207, 207, 207, 207, 207, 207, 204, 204, 204, 204, 201, 201, 201,
188, 188, 176, 141, 66, 40, 193, 193, 193, 193, 193, 193, 193, 193, 193,
193, 193, 193, 194, 194, 194, 184, 184, 173, 139, 65, 39, 204, 204, 204,
204, 204, 204, 204, 204, 201, 201, 201, 201, 198, 198, 198, 187, 187, 175,
140, 66, 40, };
#endif

#ifdef ENABLE_QEXT
# ifndef DEF_QEXT_PULSE_CACHE50
# define DEF_QEXT_PULSE_CACHE50
static const opus_int16 qext_cache_index50[70] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 61, 61,
61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 72, 72, 72,
72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 80, 80, 80, 80,
80, 80, 80, 80, 80, 80, 80, 80, 80, 80, };
static const unsigned char qext_cache_bits50[86] = {
40, 26, 45, 59, 70, 79, 87, 94, 100, 105, 110, 114, 118, 122, 125,
128, 131, 136, 141, 146, 150, 153, 157, 160, 163, 168, 173, 178, 182, 185,
189, 192, 195, 200, 205, 210, 214, 217, 221, 224, 227, 19, 34, 61, 83,
101, 118, 132, 145, 157, 167, 177, 186, 194, 202, 209, 216, 222, 234, 245,
254, 10, 42, 77, 107, 133, 157, 179, 200, 219, 236, 253, 7, 50, 93,
131, 165, 197, 227, 255, 5, 58, 109, 155, 197, 237, };
static const unsigned char qext_cache_caps50[112] = {
159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 171,
171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 167, 167, 167,
167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 166, 166, 166, 166, 166,
166, 166, 166, 166, 166, 166, 166, 166, 166, 163, 163, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 165, 165, 165, 165, 165, 165, 165,
165, 165, 165, 165, 165, 165, 165, };
# endif
#endif

#ifndef FFT_TWIDDLES96000_1920
#define FFT_TWIDDLES96000_1920
static const kiss_twiddle_cpx fft_twiddles96000_1920[960] = {
#ifdef ENABLE_QEXT
{2147483647, 0}, {2147437652, -14055147},
{2147299668, -28109692}, {2147069700, -42163034},
{2146747759, -56214568}, {2146333858, -70263695},
{2145828016, -84309812}, {2145230253, -98352318},
{2144540596, -112390610}, {2143759074, -126424088},
{2142885721, -140452151}, {2141920573, -154474196},
{2140863673, -168489625}, {2139715065, -182497836},
{2138474799, -196498230}, {2137142927, -210490206},
{2135719508, -224473166}, {2134204601, -238446509},
{2132598273, -252409639}, {2130900591, -266361956},
{2129111628, -280302863}, {2127231461, -294231763},
{2125260170, -308148059}, {2123197841, -322051155},
{2121044561, -335940456}, {2118800422, -349815365},
{2116465521, -363675290}, {2114039958, -377519637},
{2111523836, -391347811}, {2108917263, -405159222},
{2106220352, -418953276}, {2103433217, -432729385},
{2100555978, -446486956}, {2097588758, -460225402},
{2094531684, -473944133}, {2091384888, -487642562},
{2088148504, -501320102}, {2084822670, -514976167},
{2081407530, -528610172}, {2077903229, -542221533},
{2074309917, -555809667}, {2070627749, -569373992},
{2066856882, -582913927}, {2062997478, -596428893},
{2059049702, -609918309}, {2055013723, -623381598},
{2050889714, -636818183}, {2046677852, -650227490},
{2042378317, -663608942}, {2037991293, -676961968},
{2033516969, -690285996}, {2028955535, -703580453},
{2024307188, -716844772}, {2019572126, -730078383},
{2014750553, -743280720}, {2009842674, -756451218},
{2004848700, -769589312}, {1999768845, -782694439},
{1994603327, -795766038}, {1989352366, -808803549},
{1984016189, -821806413}, {1978595022, -834774075},
{1973089100, -847705977}, {1967498656, -860601566},
{1961823932, -873460290}, {1956065170, -886281598},
{1950222616, -899064940}, {1944296521, -911809770},
{1938287139, -924515541}, {1932194727, -937181708},
{1926019547, -949807730}, {1919761862, -962393065},
{1913421941, -974937175}, {1907000055, -987439521},
{1900496480, -999899569}, {1893911494, -1012316784},
{1887245379, -1024690635}, {1880498421, -1037020592},
{1873670908, -1049306126}, {1866763134, -1061546712},
{1859775393, -1073741824}, {1852707986, -1085890941},
{1845561216, -1097993542}, {1838335387, -1110049108},
{1831030811, -1122057124}, {1823647799, -1134017074},
{1816186668, -1145928447}, {1808647737, -1157790732},
{1801031331, -1169603422}, {1793337774, -1181366009},
{1785567396, -1193077991}, {1777720531, -1204738865},
{1769797514, -1216348132}, {1761798685, -1227905295},
{1753724386, -1239409858}, {1745574963, -1250861329},
{1737350766, -1262259218}, {1729052147, -1273603035},
{1720679461, -1284892296}, {1712233066, -1296126516},
{1703713325, -1307305214}, {1695120603, -1318427912},
{1686455268, -1329494133}, {1677717690, -1340503402},
{1668908244, -1351455249}, {1660027308, -1362349204},
{1651075262, -1373184801}, {1642052490, -1383961574},
{1632959377, -1394679064}, {1623796314, -1405336810},
{1614563692, -1415934356}, {1605261909, -1426471249},
{1595891361, -1436947036}, {1586452450, -1447361268},
{1576945581, -1457713501}, {1567371161, -1468003290},
{1557729600, -1478230195}, {1548021312, -1488393778},
{1538246711, -1498493602}, {1528406216, -1508529236},
{1518500250, -1518500250}, {1508529236, -1528406216},
{1498493602, -1538246711}, {1488393778, -1548021312},
{1478230195, -1557729600}, {1468003290, -1567371161},
{1457713501, -1576945581}, {1447361268, -1586452450},
{1436947036, -1595891361}, {1426471249, -1605261909},
{1415934356, -1614563692}, {1405336810, -1623796314},
{1394679064, -1632959377}, {1383961574, -1642052490},
{1373184801, -1651075262}, {1362349204, -1660027308},
{1351455249, -1668908244}, {1340503402, -1677717690},
{1329494133, -1686455268}, {1318427912, -1695120603},
{1307305214, -1703713325}, {1296126516, -1712233066},
{1284892296, -1720679461}, {1273603035, -1729052147},
{1262259218, -1737350766}, {1250861329, -1745574963},
{1239409858, -1753724386}, {1227905295, -1761798685},
{1216348132, -1769797514}, {1204738865, -1777720531},
{1193077991, -1785567396}, {1181366009, -1793337774},
{1169603422, -1801031331}, {1157790732, -1808647737},
{1145928447, -1816186668}, {1134017074, -1823647799},
{1122057124, -1831030811}, {1110049108, -1838335387},
{1097993542, -1845561216}, {1085890941, -1852707986},
{1073741824, -1859775393}, {1061546712, -1866763134},
{1049306126, -1873670908}, {1037020592, -1880498421},
{1024690635, -1887245379}, {1012316784, -1893911494},
{999899569, -1900496480}, {987439521, -1907000055},
{974937175, -1913421941}, {962393065, -1919761862},
{949807730, -1926019547}, {937181708, -1932194727},
{924515541, -1938287139}, {911809770, -1944296521},
{899064940, -1950222616}, {886281598, -1956065170},
{873460290, -1961823932}, {860601566, -1967498656},
{847705977, -1973089100}, {834774075, -1978595022},
{821806413, -1984016189}, {808803549, -1989352366},
{795766038, -1994603327}, {782694439, -1999768845},
{769589312, -2004848700}, {756451218, -2009842674},
{743280720, -2014750553}, {730078383, -2019572126},
{716844772, -2024307188}, {703580453, -2028955535},
{690285996, -2033516969}, {676961968, -2037991293},
{663608942, -2042378317}, {650227490, -2046677852},
{636818183, -2050889714}, {623381598, -2055013723},
{609918309, -2059049702}, {596428893, -2062997478},
{582913927, -2066856882}, {569373992, -2070627749},
{555809667, -2074309917}, {542221533, -2077903229},
{528610172, -2081407530}, {514976167, -2084822670},
{501320102, -2088148504}, {487642562, -2091384888},
{473944133, -2094531684}, {460225402, -2097588758},
{446486956, -2100555978}, {432729385, -2103433217},
{418953276, -2106220352}, {405159222, -2108917263},
{391347811, -2111523836}, {377519637, -2114039958},
{363675290, -2116465521}, {349815365, -2118800422},
{335940456, -2121044561}, {322051155, -2123197841},
{308148059, -2125260170}, {294231763, -2127231461},
{280302863, -2129111628}, {266361956, -2130900591},
{252409639, -2132598273}, {238446509, -2134204601},
{224473166, -2135719508}, {210490206, -2137142927},
{196498230, -2138474799}, {182497836, -2139715065},
{168489625, -2140863673}, {154474196, -2141920573},
{140452151, -2142885721}, {126424088, -2143759074},
{112390610, -2144540596}, {98352318, -2145230253},
{84309812, -2145828016}, {70263695, -2146333858},
{56214568, -2146747759}, {42163034, -2147069700},
{28109692, -2147299668}, {14055147, -2147437652},
{0, -2147483648}, {-14055147, -2147437652},
{-28109692, -2147299668}, {-42163034, -2147069700},
{-56214568, -2146747759}, {-70263695, -2146333858},
{-84309812, -2145828016}, {-98352318, -2145230253},
{-112390610, -2144540596}, {-126424088, -2143759074},
{-140452151, -2142885721}, {-154474196, -2141920573},
{-168489625, -2140863673}, {-182497836, -2139715065},
{-196498230, -2138474799}, {-210490206, -2137142927},
{-224473166, -2135719508}, {-238446509, -2134204601},
{-252409639, -2132598273}, {-266361956, -2130900591},
{-280302863, -2129111628}, {-294231763, -2127231461},
{-308148059, -2125260170}, {-322051155, -2123197841},
{-335940456, -2121044561}, {-349815365, -2118800422},
{-363675290, -2116465521}, {-377519637, -2114039958},
{-391347811, -2111523836}, {-405159222, -2108917263},
{-418953276, -2106220352}, {-432729385, -2103433217},
{-446486956, -2100555978}, {-460225402, -2097588758},
{-473944133, -2094531684}, {-487642562, -2091384888},
{-501320102, -2088148504}, {-514976167, -2084822670},
{-528610172, -2081407530}, {-542221533, -2077903229},
{-555809667, -2074309917}, {-569373992, -2070627749},
{-582913927, -2066856882}, {-596428893, -2062997478},
{-609918309, -2059049702}, {-623381598, -2055013723},
{-636818183, -2050889714}, {-650227490, -2046677852},
{-663608942, -2042378317}, {-676961968, -2037991293},
{-690285996, -2033516969}, {-703580453, -2028955535},
{-716844772, -2024307188}, {-730078383, -2019572126},
{-743280720, -2014750553}, {-756451218, -2009842674},
{-769589312, -2004848700}, {-782694439, -1999768845},
{-795766038, -1994603327}, {-808803549, -1989352366},
{-821806413, -1984016189}, {-834774075, -1978595022},
{-847705977, -1973089100}, {-860601566, -1967498656},
{-873460290, -1961823932}, {-886281598, -1956065170},
{-899064940, -1950222616}, {-911809770, -1944296521},
{-924515541, -1938287139}, {-937181708, -1932194727},
{-949807730, -1926019547}, {-962393065, -1919761862},
{-974937175, -1913421941}, {-987439521, -1907000055},
{-999899569, -1900496480}, {-1012316784, -1893911494},
{-1024690635, -1887245379}, {-1037020592, -1880498421},
{-1049306126, -1873670908}, {-1061546712, -1866763134},
{-1073741824, -1859775393}, {-1085890941, -1852707986},
{-1097993542, -1845561216}, {-1110049108, -1838335387},
{-1122057124, -1831030811}, {-1134017074, -1823647799},
{-1145928447, -1816186668}, {-1157790732, -1808647737},
{-1169603422, -1801031331}, {-1181366009, -1793337774},
{-1193077991, -1785567396}, {-1204738865, -1777720531},
{-1216348132, -1769797514}, {-1227905295, -1761798685},
{-1239409858, -1753724386}, {-1250861329, -1745574963},
{-1262259218, -1737350766}, {-1273603035, -1729052147},
{-1284892296, -1720679461}, {-1296126516, -1712233066},
{-1307305214, -1703713325}, {-1318427912, -1695120603},
{-1329494133, -1686455268}, {-1340503402, -1677717690},
{-1351455249, -1668908244}, {-1362349204, -1660027308},
{-1373184801, -1651075262}, {-1383961574, -1642052490},
{-1394679064, -1632959377}, {-1405336810, -1623796314},
{-1415934356, -1614563692}, {-1426471249, -1605261909},
{-1436947036, -1595891361}, {-1447361268, -1586452450},
{-1457713501, -1576945581}, {-1468003290, -1567371161},
{-1478230195, -1557729600}, {-1488393778, -1548021312},
{-1498493602, -1538246711}, {-1508529236, -1528406216},
{-1518500250, -1518500250}, {-1528406216, -1508529236},
{-1538246711, -1498493602}, {-1548021312, -1488393778},
{-1557729600, -1478230195}, {-1567371161, -1468003290},
{-1576945581, -1457713501}, {-1586452450, -1447361268},
{-1595891361, -1436947036}, {-1605261909, -1426471249},
{-1614563692, -1415934356}, {-1623796314, -1405336810},
{-1632959377, -1394679064}, {-1642052490, -1383961574},
{-1651075262, -1373184801}, {-1660027308, -1362349204},
{-1668908244, -1351455249}, {-1677717690, -1340503402},
{-1686455268, -1329494133}, {-1695120603, -1318427912},
{-1703713325, -1307305214}, {-1712233066, -1296126516},
{-1720679461, -1284892296}, {-1729052147, -1273603035},
{-1737350766, -1262259218}, {-1745574963, -1250861329},
{-1753724386, -1239409858}, {-1761798685, -1227905295},
{-1769797514, -1216348132}, {-1777720531, -1204738865},
{-1785567396, -1193077991}, {-1793337774, -1181366009},
{-1801031331, -1169603422}, {-1808647737, -1157790732},
{-1816186668, -1145928447}, {-1823647799, -1134017074},
{-1831030811, -1122057124}, {-1838335387, -1110049108},
{-1845561216, -1097993542}, {-1852707986, -1085890941},
{-1859775393, -1073741824}, {-1866763134, -1061546712},
{-1873670908, -1049306126}, {-1880498421, -1037020592},
{-1887245379, -1024690635}, {-1893911494, -1012316784},
{-1900496480, -999899569}, {-1907000055, -987439521},
{-1913421941, -974937175}, {-1919761862, -962393065},
{-1926019547, -949807730}, {-1932194727, -937181708},
{-1938287139, -924515541}, {-1944296521, -911809770},
{-1950222616, -899064940}, {-1956065170, -886281598},
{-1961823932, -873460290}, {-1967498656, -860601566},
{-1973089100, -847705977}, {-1978595022, -834774075},
{-1984016189, -821806413}, {-1989352366, -808803549},
{-1994603327, -795766038}, {-1999768845, -782694439},
{-2004848700, -769589312}, {-2009842674, -756451218},
{-2014750553, -743280720}, {-2019572126, -730078383},
{-2024307188, -716844772}, {-2028955535, -703580453},
{-2033516969, -690285996}, {-2037991293, -676961968},
{-2042378317, -663608942}, {-2046677852, -650227490},
{-2050889714, -636818183}, {-2055013723, -623381598},
{-2059049702, -609918309}, {-2062997478, -596428893},
{-2066856882, -582913927}, {-2070627749, -569373992},
{-2074309917, -555809667}, {-2077903229, -542221533},
{-2081407530, -528610172}, {-2084822670, -514976167},
{-2088148504, -501320102}, {-2091384888, -487642562},
{-2094531684, -473944133}, {-2097588758, -460225402},
{-2100555978, -446486956}, {-2103433217, -432729385},
{-2106220352, -418953276}, {-2108917263, -405159222},
{-2111523836, -391347811}, {-2114039958, -377519637},
{-2116465521, -363675290}, {-2118800422, -349815365},
{-2121044561, -335940456}, {-2123197841, -322051155},
{-2125260170, -308148059}, {-2127231461, -294231763},
{-2129111628, -280302863}, {-2130900591, -266361956},
{-2132598273, -252409639}, {-2134204601, -238446509},
{-2135719508, -224473166}, {-2137142927, -210490206},
{-2138474799, -196498230}, {-2139715065, -182497836},
{-2140863673, -168489625}, {-2141920573, -154474196},
{-2142885721, -140452151}, {-2143759074, -126424088},
{-2144540596, -112390610}, {-2145230253, -98352318},
{-2145828016, -84309812}, {-2146333858, -70263695},
{-2146747759, -56214568}, {-2147069700, -42163034},
{-2147299668, -28109692}, {-2147437652, -14055147},
{-2147483648, 0}, {-2147437652, 14055147},
{-2147299668, 28109692}, {-2147069700, 42163034},
{-2146747759, 56214568}, {-2146333858, 70263695},
{-2145828016, 84309812}, {-2145230253, 98352318},
{-2144540596, 112390610}, {-2143759074, 126424088},
{-2142885721, 140452151}, {-2141920573, 154474196},
{-2140863673, 168489625}, {-2139715065, 182497836},
{-2138474799, 196498230}, {-2137142927, 210490206},
{-2135719508, 224473166}, {-2134204601, 238446509},
{-2132598273, 252409639}, {-2130900591, 266361956},
{-2129111628, 280302863}, {-2127231461, 294231763},
{-2125260170, 308148059}, {-2123197841, 322051155},
{-2121044561, 335940456}, {-2118800422, 349815365},
{-2116465521, 363675290}, {-2114039958, 377519637},
{-2111523836, 391347811}, {-2108917263, 405159222},
{-2106220352, 418953276}, {-2103433217, 432729385},
{-2100555978, 446486956}, {-2097588758, 460225402},
{-2094531684, 473944133}, {-2091384888, 487642562},
{-2088148504, 501320102}, {-2084822670, 514976167},
{-2081407530, 528610172}, {-2077903229, 542221533},
{-2074309917, 555809667}, {-2070627749, 569373992},
{-2066856882, 582913927}, {-2062997478, 596428893},
{-2059049702, 609918309}, {-2055013723, 623381598},
{-2050889714, 636818183}, {-2046677852, 650227490},
{-2042378317, 663608942}, {-2037991293, 676961968},
{-2033516969, 690285996}, {-2028955535, 703580453},
{-2024307188, 716844772}, {-2019572126, 730078383},
{-2014750553, 743280720}, {-2009842674, 756451218},
{-2004848700, 769589312}, {-1999768845, 782694439},
{-1994603327, 795766038}, {-1989352366, 808803549},
{-1984016189, 821806413}, {-1978595022, 834774075},
{-1973089100, 847705977}, {-1967498656, 860601566},
{-1961823932, 873460290}, {-1956065170, 886281598},
{-1950222616, 899064940}, {-1944296521, 911809770},
{-1938287139, 924515541}, {-1932194727, 937181708},
{-1926019547, 949807730}, {-1919761862, 962393065},
{-1913421941, 974937175}, {-1907000055, 987439521},
{-1900496480, 999899569}, {-1893911494, 1012316784},
{-1887245379, 1024690635}, {-1880498421, 1037020592},
{-1873670908, 1049306126}, {-1866763134, 1061546712},
{-1859775393, 1073741824}, {-1852707986, 1085890941},
{-1845561216, 1097993542}, {-1838335387, 1110049108},
{-1831030811, 1122057124}, {-1823647799, 1134017074},
{-1816186668, 1145928447}, {-1808647737, 1157790732},
{-1801031331, 1169603422}, {-1793337774, 1181366009},
{-1785567396, 1193077991}, {-1777720531, 1204738865},
{-1769797514, 1216348132}, {-1761798685, 1227905295},
{-1753724386, 1239409858}, {-1745574963, 1250861329},
{-1737350766, 1262259218}, {-1729052147, 1273603035},
{-1720679461, 1284892296}, {-1712233066, 1296126516},
{-1703713325, 1307305214}, {-1695120603, 1318427912},
{-1686455268, 1329494133}, {-1677717690, 1340503402},
{-1668908244, 1351455249}, {-1660027308, 1362349204},
{-1651075262, 1373184801}, {-1642052490, 1383961574},
{-1632959377, 1394679064}, {-1623796314, 1405336810},
{-1614563692, 1415934356}, {-1605261909, 1426471249},
{-1595891361, 1436947036}, {-1586452450, 1447361268},
{-1576945581, 1457713501}, {-1567371161, 1468003290},
{-1557729600, 1478230195}, {-1548021312, 1488393778},
{-1538246711, 1498493602}, {-1528406216, 1508529236},
{-1518500250, 1518500250}, {-1508529236, 1528406216},
{-1498493602, 1538246711}, {-1488393778, 1548021312},
{-1478230195, 1557729600}, {-1468003290, 1567371161},
{-1457713501, 1576945581}, {-1447361268, 1586452450},
{-1436947036, 1595891361}, {-1426471249, 1605261909},
{-1415934356, 1614563692}, {-1405336810, 1623796314},
{-1394679064, 1632959377}, {-1383961574, 1642052490},
{-1373184801, 1651075262}, {-1362349204, 1660027308},
{-1351455249, 1668908244}, {-1340503402, 1677717690},
{-1329494133, 1686455268}, {-1318427912, 1695120603},
{-1307305214, 1703713325}, {-1296126516, 1712233066},
{-1284892296, 1720679461}, {-1273603035, 1729052147},
{-1262259218, 1737350766}, {-1250861329, 1745574963},
{-1239409858, 1753724386}, {-1227905295, 1761798685},
{-1216348132, 1769797514}, {-1204738865, 1777720531},
{-1193077991, 1785567396}, {-1181366009, 1793337774},
{-1169603422, 1801031331}, {-1157790732, 1808647737},
{-1145928447, 1816186668}, {-1134017074, 1823647799},
{-1122057124, 1831030811}, {-1110049108, 1838335387},
{-1097993542, 1845561216}, {-1085890941, 1852707986},
{-1073741824, 1859775393}, {-1061546712, 1866763134},
{-1049306126, 1873670908}, {-1037020592, 1880498421},
{-1024690635, 1887245379}, {-1012316784, 1893911494},
{-999899569, 1900496480}, {-987439521, 1907000055},
{-974937175, 1913421941}, {-962393065, 1919761862},
{-949807730, 1926019547}, {-937181708, 1932194727},
{-924515541, 1938287139}, {-911809770, 1944296521},
{-899064940, 1950222616}, {-886281598, 1956065170},
{-873460290, 1961823932}, {-860601566, 1967498656},
{-847705977, 1973089100}, {-834774075, 1978595022},
{-821806413, 1984016189}, {-808803549, 1989352366},
{-795766038, 1994603327}, {-782694439, 1999768845},
{-769589312, 2004848700}, {-756451218, 2009842674},
{-743280720, 2014750553}, {-730078383, 2019572126},
{-716844772, 2024307188}, {-703580453, 2028955535},
{-690285996, 2033516969}, {-676961968, 2037991293},
{-663608942, 2042378317}, {-650227490, 2046677852},
{-636818183, 2050889714}, {-623381598, 2055013723},
{-609918309, 2059049702}, {-596428893, 2062997478},
{-582913927, 2066856882}, {-569373992, 2070627749},
{-555809667, 2074309917}, {-542221533, 2077903229},
{-528610172, 2081407530}, {-514976167, 2084822670},
{-501320102, 2088148504}, {-487642562, 2091384888},
{-473944133, 2094531684}, {-460225402, 2097588758},
{-446486956, 2100555978}, {-432729385, 2103433217},
{-418953276, 2106220352}, {-405159222, 2108917263},
{-391347811, 2111523836}, {-377519637, 2114039958},
{-363675290, 2116465521}, {-349815365, 2118800422},
{-335940456, 2121044561}, {-322051155, 2123197841},
{-308148059, 2125260170}, {-294231763, 2127231461},
{-280302863, 2129111628}, {-266361956, 2130900591},
{-252409639, 2132598273}, {-238446509, 2134204601},
{-224473166, 2135719508}, {-210490206, 2137142927},
{-196498230, 2138474799}, {-182497836, 2139715065},
{-168489625, 2140863673}, {-154474196, 2141920573},
{-140452151, 2142885721}, {-126424088, 2143759074},
{-112390610, 2144540596}, {-98352318, 2145230253},
{-84309812, 2145828016}, {-70263695, 2146333858},
{-56214568, 2146747759}, {-42163034, 2147069700},
{-28109692, 2147299668}, {-14055147, 2147437652},
{0, 2147483647}, {14055147, 2147437652},
{28109692, 2147299668}, {42163034, 2147069700},
{56214568, 2146747759}, {70263695, 2146333858},
{84309812, 2145828016}, {98352318, 2145230253},
{112390610, 2144540596}, {126424088, 2143759074},
{140452151, 2142885721}, {154474196, 2141920573},
{168489625, 2140863673}, {182497836, 2139715065},
{196498230, 2138474799}, {210490206, 2137142927},
{224473166, 2135719508}, {238446509, 2134204601},
{252409639, 2132598273}, {266361956, 2130900591},
{280302863, 2129111628}, {294231763, 2127231461},
{308148059, 2125260170}, {322051155, 2123197841},
{335940456, 2121044561}, {349815365, 2118800422},
{363675290, 2116465521}, {377519637, 2114039958},
{391347811, 2111523836}, {405159222, 2108917263},
{418953276, 2106220352}, {432729385, 2103433217},
{446486956, 2100555978}, {460225402, 2097588758},
{473944133, 2094531684}, {487642562, 2091384888},
{501320102, 2088148504}, {514976167, 2084822670},
{528610172, 2081407530}, {542221533, 2077903229},
{555809667, 2074309917}, {569373992, 2070627749},
{582913927, 2066856882}, {596428893, 2062997478},
{609918309, 2059049702}, {623381598, 2055013723},
{636818183, 2050889714}, {650227490, 2046677852},
{663608942, 2042378317}, {676961968, 2037991293},
{690285996, 2033516969}, {703580453, 2028955535},
{716844772, 2024307188}, {730078383, 2019572126},
{743280720, 2014750553}, {756451218, 2009842674},
{769589312, 2004848700}, {782694439, 1999768845},
{795766038, 1994603327}, {808803549, 1989352366},
{821806413, 1984016189}, {834774075, 1978595022},
{847705977, 1973089100}, {860601566, 1967498656},
{873460290, 1961823932}, {886281598, 1956065170},
{899064940, 1950222616}, {911809770, 1944296521},
{924515541, 1938287139}, {937181708, 1932194727},
{949807730, 1926019547}, {962393065, 1919761862},
{974937175, 1913421941}, {987439521, 1907000055},
{999899569, 1900496480}, {1012316784, 1893911494},
{1024690635, 1887245379}, {1037020592, 1880498421},
{1049306126, 1873670908}, {1061546712, 1866763134},
{1073741824, 1859775393}, {1085890941, 1852707986},
{1097993542, 1845561216}, {1110049108, 1838335387},
{1122057124, 1831030811}, {1134017074, 1823647799},
{1145928447, 1816186668}, {1157790732, 1808647737},
{1169603422, 1801031331}, {1181366009, 1793337774},
{1193077991, 1785567396}, {1204738865, 1777720531},
{1216348132, 1769797514}, {1227905295, 1761798685},
{1239409858, 1753724386}, {1250861329, 1745574963},
{1262259218, 1737350766}, {1273603035, 1729052147},
{1284892296, 1720679461}, {1296126516, 1712233066},
{1307305214, 1703713325}, {1318427912, 1695120603},
{1329494133, 1686455268}, {1340503402, 1677717690},
{1351455249, 1668908244}, {1362349204, 1660027308},
{1373184801, 1651075262}, {1383961574, 1642052490},
{1394679064, 1632959377}, {1405336810, 1623796314},
{1415934356, 1614563692}, {1426471249, 1605261909},
{1436947036, 1595891361}, {1447361268, 1586452450},
{1457713501, 1576945581}, {1468003290, 1567371161},
{1478230195, 1557729600}, {1488393778, 1548021312},
{1498493602, 1538246711}, {1508529236, 1528406216},
{1518500250, 1518500250}, {1528406216, 1508529236},
{1538246711, 1498493602}, {1548021312, 1488393778},
{1557729600, 1478230195}, {1567371161, 1468003290},
{1576945581, 1457713501}, {1586452450, 1447361268},
{1595891361, 1436947036}, {1605261909, 1426471249},
{1614563692, 1415934356}, {1623796314, 1405336810},
{1632959377, 1394679064}, {1642052490, 1383961574},
{1651075262, 1373184801}, {1660027308, 1362349204},
{1668908244, 1351455249}, {1677717690, 1340503402},
{1686455268, 1329494133}, {1695120603, 1318427912},
{1703713325, 1307305214}, {1712233066, 1296126516},
{1720679461, 1284892296}, {1729052147, 1273603035},
{1737350766, 1262259218}, {1745574963, 1250861329},
{1753724386, 1239409858}, {1761798685, 1227905295},
{1769797514, 1216348132}, {1777720531, 1204738865},
{1785567396, 1193077991}, {1793337774, 1181366009},
{1801031331, 1169603422}, {1808647737, 1157790732},
{1816186668, 1145928447}, {1823647799, 1134017074},
{1831030811, 1122057124}, {1838335387, 1110049108},
{1845561216, 1097993542}, {1852707986, 1085890941},
{1859775393, 1073741824}, {1866763134, 1061546712},
{1873670908, 1049306126}, {1880498421, 1037020592},
{1887245379, 1024690635}, {1893911494, 1012316784},
{1900496480, 999899569}, {1907000055, 987439521},
{1913421941, 974937175}, {1919761862, 962393065},
{1926019547, 949807730}, {1932194727, 937181708},
{1938287139, 924515541}, {1944296521, 911809770},
{1950222616, 899064940}, {1956065170, 886281598},
{1961823932, 873460290}, {1967498656, 860601566},
{1973089100, 847705977}, {1978595022, 834774075},
{1984016189, 821806413}, {1989352366, 808803549},
{1994603327, 795766038}, {1999768845, 782694439},
{2004848700, 769589312}, {2009842674, 756451218},
{2014750553, 743280720}, {2019572126, 730078383},
{2024307188, 716844772}, {2028955535, 703580453},
{2033516969, 690285996}, {2037991293, 676961968},
{2042378317, 663608942}, {2046677852, 650227490},
{2050889714, 636818183}, {2055013723, 623381598},
{2059049702, 609918309}, {2062997478, 596428893},
{2066856882, 582913927}, {2070627749, 569373992},
{2074309917, 555809667}, {2077903229, 542221533},
{2081407530, 528610172}, {2084822670, 514976167},
{2088148504, 501320102}, {2091384888, 487642562},
{2094531684, 473944133}, {2097588758, 460225402},
{2100555978, 446486956}, {2103433217, 432729385},
{2106220352, 418953276}, {2108917263, 405159222},
{2111523836, 391347811}, {2114039958, 377519637},
{2116465521, 363675290}, {2118800422, 349815365},
{2121044561, 335940456}, {2123197841, 322051155},
{2125260170, 308148059}, {2127231461, 294231763},
{2129111628, 280302863}, {2130900591, 266361956},
{2132598273, 252409639}, {2134204601, 238446509},
{2135719508, 224473166}, {2137142927, 210490206},
{2138474799, 196498230}, {2139715065, 182497836},
{2140863673, 168489625}, {2141920573, 154474196},
{2142885721, 140452151}, {2143759074, 126424088},
{2144540596, 112390610}, {2145230253, 98352318},
{2145828016, 84309812}, {2146333858, 70263695},
{2146747759, 56214568}, {2147069700, 42163034},
{2147299668, 28109692}, {2147437652, 14055147},
#else
{32767, 0}, {32767, -214},
{32765, -429}, {32762, -643},
{32757, -858}, {32750, -1072},
{32743, -1286}, {32734, -1501},
{32723, -1715}, {32711, -1929},
{32698, -2143}, {32683, -2357},
{32667, -2571}, {32649, -2785},
{32631, -2998}, {32610, -3212},
{32588, -3425}, {32565, -3638},
{32541, -3851}, {32515, -4064},
{32488, -4277}, {32459, -4490},
{32429, -4702}, {32397, -4914},
{32365, -5126}, {32330, -5338},
{32295, -5549}, {32258, -5760},
{32219, -5971}, {32180, -6182},
{32138, -6393}, {32096, -6603},
{32052, -6813}, {32007, -7022},
{31960, -7232}, {31912, -7441},
{31863, -7650}, {31812, -7858},
{31760, -8066}, {31706, -8274},
{31651, -8481}, {31595, -8688},
{31538, -8895}, {31479, -9101},
{31419, -9307}, {31357, -9512},
{31294, -9717}, {31230, -9922},
{31164, -10126}, {31097, -10330},
{31029, -10533}, {30959, -10736},
{30888, -10938}, {30816, -11140},
{30743, -11342}, {30668, -11543},
{30592, -11743}, {30514, -11943},
{30435, -12142}, {30355, -12341},
{30274, -12540}, {30191, -12738},
{30107, -12935}, {30022, -13132},
{29935, -13328}, {29847, -13524},
{29758, -13719}, {29668, -13913},
{29576, -14107}, {29483, -14300},
{29389, -14493}, {29293, -14685},
{29197, -14876}, {29099, -15067},
{28999, -15257}, {28899, -15447},
{28797, -15636}, {28694, -15824},
{28590, -16011}, {28485, -16198},
{28378, -16384}, {28270, -16569},
{28161, -16754}, {28051, -16938},
{27939, -17121}, {27827, -17304},
{27713, -17485}, {27598, -17666},
{27482, -17847}, {27364, -18026},
{27246, -18205}, {27126, -18383},
{27005, -18560}, {26883, -18736},
{26760, -18912}, {26635, -19087},
{26510, -19261}, {26383, -19434},
{26255, -19606}, {26127, -19777},
{25997, -19948}, {25865, -20118},
{25733, -20286}, {25600, -20454},
{25466, -20622}, {25330, -20788},
{25193, -20953}, {25056, -21118},
{24917, -21281}, {24777, -21444},
{24636, -21605}, {24494, -21766},
{24351, -21926}, {24207, -22085},
{24062, -22243}, {23916, -22400},
{23769, -22556}, {23621, -22711},
{23472, -22865}, {23322, -23018},
{23170, -23170}, {23018, -23322},
{22865, -23472}, {22711, -23621},
{22556, -23769}, {22400, -23916},
{22243, -24062}, {22085, -24207},
{21926, -24351}, {21766, -24494},
{21605, -24636}, {21444, -24777},
{21281, -24917}, {21118, -25056},
{20953, -25193}, {20788, -25330},
{20622, -25466}, {20454, -25600},
{20286, -25733}, {20118, -25865},
{19948, -25997}, {19777, -26127},
{19606, -26255}, {19434, -26383},
{19261, -26510}, {19087, -26635},
{18912, -26760}, {18736, -26883},
{18560, -27005}, {18383, -27126},
{18205, -27246}, {18026, -27364},
{17847, -27482}, {17666, -27598},
{17485, -27713}, {17304, -27827},
{17121, -27939}, {16938, -28051},
{16754, -28161}, {16569, -28270},
{16384, -28378}, {16198, -28485},
{16011, -28590}, {15824, -28694},
{15636, -28797}, {15447, -28899},
{15257, -28999}, {15067, -29099},
{14876, -29197}, {14685, -29293},
{14493, -29389}, {14300, -29483},
{14107, -29576}, {13913, -29668},
{13719, -29758}, {13524, -29847},
{13328, -29935}, {13132, -30022},
{12935, -30107}, {12738, -30191},
{12540, -30274}, {12341, -30355},
{12142, -30435}, {11943, -30514},
{11743, -30592}, {11543, -30668},
{11342, -30743}, {11140, -30816},
{10938, -30888}, {10736, -30959},
{10533, -31029}, {10330, -31097},
{10126, -31164}, {9922, -31230},
{9717, -31294}, {9512, -31357},
{9307, -31419}, {9101, -31479},
{8895, -31538}, {8688, -31595},
{8481, -31651}, {8274, -31706},
{8066, -31760}, {7858, -31812},
{7650, -31863}, {7441, -31912},
{7232, -31960}, {7022, -32007},
{6813, -32052}, {6603, -32096},
{6393, -32138}, {6182, -32180},
{5971, -32219}, {5760, -32258},
{5549, -32295}, {5338, -32330},
{5126, -32365}, {4914, -32397},
{4702, -32429}, {4490, -32459},
{4277, -32488}, {4064, -32515},
{3851, -32541}, {3638, -32565},
{3425, -32588}, {3212, -32610},
{2998, -32631}, {2785, -32649},
{2571, -32667}, {2357, -32683},
{2143, -32698}, {1929, -32711},
{1715, -32723}, {1501, -32734},
{1286, -32743}, {1072, -32750},
{858, -32757}, {643, -32762},
{429, -32765}, {214, -32767},
{0, -32767}, {-214, -32767},
{-429, -32765}, {-643, -32762},
{-858, -32757}, {-1072, -32750},
{-1286, -32743}, {-1501, -32734},
{-1715, -32723}, {-1929, -32711},
{-2143, -32698}, {-2357, -32683},
{-2571, -32667}, {-2785, -32649},
{-2998, -32631}, {-3212, -32610},
{-3425, -32588}, {-3638, -32565},
{-3851, -32541}, {-4064, -32515},
{-4277, -32488}, {-4490, -32459},
{-4702, -32429}, {-4914, -32397},
{-5126, -32365}, {-5338, -32330},
{-5549, -32295}, {-5760, -32258},
{-5971, -32219}, {-6182, -32180},
{-6393, -32138}, {-6603, -32096},
{-6813, -32052}, {-7022, -32007},
{-7232, -31960}, {-7441, -31912},
{-7650, -31863}, {-7858, -31812},
{-8066, -31760}, {-8274, -31706},
{-8481, -31651}, {-8688, -31595},
{-8895, -31538}, {-9101, -31479},
{-9307, -31419}, {-9512, -31357},
{-9717, -31294}, {-9922, -31230},
{-10126, -31164}, {-10330, -31097},
{-10533, -31029}, {-10736, -30959},
{-10938, -30888}, {-11140, -30816},
{-11342, -30743}, {-11543, -30668},
{-11743, -30592}, {-11943, -30514},
{-12142, -30435}, {-12341, -30355},
{-12540, -30274}, {-12738, -30191},
{-12935, -30107}, {-13132, -30022},
{-13328, -29935}, {-13524, -29847},
{-13719, -29758}, {-13913, -29668},
{-14107, -29576}, {-14300, -29483},
{-14493, -29389}, {-14685, -29293},
{-14876, -29197}, {-15067, -29099},
{-15257, -28999}, {-15447, -28899},
{-15636, -28797}, {-15824, -28694},
{-16011, -28590}, {-16198, -28485},
{-16384, -28378}, {-16569, -28270},
{-16754, -28161}, {-16938, -28051},
{-17121, -27939}, {-17304, -27827},
{-17485, -27713}, {-17666, -27598},
{-17847, -27482}, {-18026, -27364},
{-18205, -27246}, {-18383, -27126},
{-18560, -27005}, {-18736, -26883},
{-18912, -26760}, {-19087, -26635},
{-19261, -26510}, {-19434, -26383},
{-19606, -26255}, {-19777, -26127},
{-19948, -25997}, {-20118, -25865},
{-20286, -25733}, {-20454, -25600},
{-20622, -25466}, {-20788, -25330},
{-20953, -25193}, {-21118, -25056},
{-21281, -24917}, {-21444, -24777},
{-21605, -24636}, {-21766, -24494},
{-21926, -24351}, {-22085, -24207},
{-22243, -24062}, {-22400, -23916},
{-22556, -23769}, {-22711, -23621},
{-22865, -23472}, {-23018, -23322},
{-23170, -23170}, {-23322, -23018},
{-23472, -22865}, {-23621, -22711},
{-23769, -22556}, {-23916, -22400},
{-24062, -22243}, {-24207, -22085},
{-24351, -21926}, {-24494, -21766},
{-24636, -21605}, {-24777, -21444},
{-24917, -21281}, {-25056, -21118},
{-25193, -20953}, {-25330, -20788},
{-25466, -20622}, {-25600, -20454},
{-25733, -20286}, {-25865, -20118},
{-25997, -19948}, {-26127, -19777},
{-26255, -19606}, {-26383, -19434},
{-26510, -19261}, {-26635, -19087},
{-26760, -18912}, {-26883, -18736},
{-27005, -18560}, {-27126, -18383},
{-27246, -18205}, {-27364, -18026},
{-27482, -17847}, {-27598, -17666},
{-27713, -17485}, {-27827, -17304},
{-27939, -17121}, {-28051, -16938},
{-28161, -16754}, {-28270, -16569},
{-28378, -16384}, {-28485, -16198},
{-28590, -16011}, {-28694, -15824},
{-28797, -15636}, {-28899, -15447},
{-28999, -15257}, {-29099, -15067},
{-29197, -14876}, {-29293, -14685},
{-29389, -14493}, {-29483, -14300},
{-29576, -14107}, {-29668, -13913},
{-29758, -13719}, {-29847, -13524},
{-29935, -13328}, {-30022, -13132},
{-30107, -12935}, {-30191, -12738},
{-30274, -12540}, {-30355, -12341},
{-30435, -12142}, {-30514, -11943},
{-30592, -11743}, {-30668, -11543},
{-30743, -11342}, {-30816, -11140},
{-30888, -10938}, {-30959, -10736},
{-31029, -10533}, {-31097, -10330},
{-31164, -10126}, {-31230, -9922},
{-31294, -9717}, {-31357, -9512},
{-31419, -9307}, {-31479, -9101},
{-31538, -8895}, {-31595, -8688},
{-31651, -8481}, {-31706, -8274},
{-31760, -8066}, {-31812, -7858},
{-31863, -7650}, {-31912, -7441},
{-31960, -7232}, {-32007, -7022},
{-32052, -6813}, {-32096, -6603},
{-32138, -6393}, {-32180, -6182},
{-32219, -5971}, {-32258, -5760},
{-32295, -5549}, {-32330, -5338},
{-32365, -5126}, {-32397, -4914},
{-32429, -4702}, {-32459, -4490},
{-32488, -4277}, {-32515, -4064},
{-32541, -3851}, {-32565, -3638},
{-32588, -3425}, {-32610, -3212},
{-32631, -2998}, {-32649, -2785},
{-32667, -2571}, {-32683, -2357},
{-32698, -2143}, {-32711, -1929},
{-32723, -1715}, {-32734, -1501},
{-32743, -1286}, {-32750, -1072},
{-32757, -858}, {-32762, -643},
{-32765, -429}, {-32767, -214},
{-32767, 0}, {-32767, 214},
{-32765, 429}, {-32762, 643},
{-32757, 858}, {-32750, 1072},
{-32743, 1286}, {-32734, 1501},
{-32723, 1715}, {-32711, 1929},
{-32698, 2143}, {-32683, 2357},
{-32667, 2571}, {-32649, 2785},
{-32631, 2998}, {-32610, 3212},
{-32588, 3425}, {-32565, 3638},
{-32541, 3851}, {-32515, 4064},
{-32488, 4277}, {-32459, 4490},
{-32429, 4702}, {-32397, 4914},
{-32365, 5126}, {-32330, 5338},
{-32295, 5549}, {-32258, 5760},
{-32219, 5971}, {-32180, 6182},
{-32138, 6393}, {-32096, 6603},
{-32052, 6813}, {-32007, 7022},
{-31960, 7232}, {-31912, 7441},
{-31863, 7650}, {-31812, 7858},
{-31760, 8066}, {-31706, 8274},
{-31651, 8481}, {-31595, 8688},
{-31538, 8895}, {-31479, 9101},
{-31419, 9307}, {-31357, 9512},
{-31294, 9717}, {-31230, 9922},
{-31164, 10126}, {-31097, 10330},
{-31029, 10533}, {-30959, 10736},
{-30888, 10938}, {-30816, 11140},
{-30743, 11342}, {-30668, 11543},
{-30592, 11743}, {-30514, 11943},
{-30435, 12142}, {-30355, 12341},
{-30274, 12540}, {-30191, 12738},
{-30107, 12935}, {-30022, 13132},
{-29935, 13328}, {-29847, 13524},
{-29758, 13719}, {-29668, 13913},
{-29576, 14107}, {-29483, 14300},
{-29389, 14493}, {-29293, 14685},
{-29197, 14876}, {-29099, 15067},
{-28999, 15257}, {-28899, 15447},
{-28797, 15636}, {-28694, 15824},
{-28590, 16011}, {-28485, 16198},
{-28378, 16384}, {-28270, 16569},
{-28161, 16754}, {-28051, 16938},
{-27939, 17121}, {-27827, 17304},
{-27713, 17485}, {-27598, 17666},
{-27482, 17847}, {-27364, 18026},
{-27246, 18205}, {-27126, 18383},
{-27005, 18560}, {-26883, 18736},
{-26760, 18912}, {-26635, 19087},
{-26510, 19261}, {-26383, 19434},
{-26255, 19606}, {-26127, 19777},
{-25997, 19948}, {-25865, 20118},
{-25733, 20286}, {-25600, 20454},
{-25466, 20622}, {-25330, 20788},
{-25193, 20953}, {-25056, 21118},
{-24917, 21281}, {-24777, 21444},
{-24636, 21605}, {-24494, 21766},
{-24351, 21926}, {-24207, 22085},
{-24062, 22243}, {-23916, 22400},
{-23769, 22556}, {-23621, 22711},
{-23472, 22865}, {-23322, 23018},
{-23170, 23170}, {-23018, 23322},
{-22865, 23472}, {-22711, 23621},
{-22556, 23769}, {-22400, 23916},
{-22243, 24062}, {-22085, 24207},
{-21926, 24351}, {-21766, 24494},
{-21605, 24636}, {-21444, 24777},
{-21281, 24917}, {-21118, 25056},
{-20953, 25193}, {-20788, 25330},
{-20622, 25466}, {-20454, 25600},
{-20286, 25733}, {-20118, 25865},
{-19948, 25997}, {-19777, 26127},
{-19606, 26255}, {-19434, 26383},
{-19261, 26510}, {-19087, 26635},
{-18912, 26760}, {-18736, 26883},
{-18560, 27005}, {-18383, 27126},
{-18205, 27246}, {-18026, 27364},
{-17847, 27482}, {-17666, 27598},
{-17485, 27713}, {-17304, 27827},
{-17121, 27939}, {-16938, 28051},
{-16754, 28161}, {-16569, 28270},
{-16384, 28378}, {-16198, 28485},
{-16011, 28590}, {-15824, 28694},
{-15636, 28797}, {-15447, 28899},
{-15257, 28999}, {-15067, 29099},
{-14876, 29197}, {-14685, 29293},
{-14493, 29389}, {-14300, 29483},
{-14107, 29576}, {-13913, 29668},
{-13719, 29758}, {-13524, 29847},
{-13328, 29935}, {-13132, 30022},
{-12935, 30107}, {-12738, 30191},
{-12540, 30274}, {-12341, 30355},
{-12142, 30435}, {-11943, 30514},
{-11743, 30592}, {-11543, 30668},
{-11342, 30743}, {-11140, 30816},
{-10938, 30888}, {-10736, 30959},
{-10533, 31029}, {-10330, 31097},
{-10126, 31164}, {-9922, 31230},
{-9717, 31294}, {-9512, 31357},
{-9307, 31419}, {-9101, 31479},
{-8895, 31538}, {-8688, 31595},
{-8481, 31651}, {-8274, 31706},
{-8066, 31760}, {-7858, 31812},
{-7650, 31863}, {-7441, 31912},
{-7232, 31960}, {-7022, 32007},
{-6813, 32052}, {-6603, 32096},
{-6393, 32138}, {-6182, 32180},
{-5971, 32219}, {-5760, 32258},
{-5549, 32295}, {-5338, 32330},
{-5126, 32365}, {-4914, 32397},
{-4702, 32429}, {-4490, 32459},
{-4277, 32488}, {-4064, 32515},
{-3851, 32541}, {-3638, 32565},
{-3425, 32588}, {-3212, 32610},
{-2998, 32631}, {-2785, 32649},
{-2571, 32667}, {-2357, 32683},
{-2143, 32698}, {-1929, 32711},
{-1715, 32723}, {-1501, 32734},
{-1286, 32743}, {-1072, 32750},
{-858, 32757}, {-643, 32762},
{-429, 32765}, {-214, 32767},
{0, 32767}, {214, 32767},
{429, 32765}, {643, 32762},
{858, 32757}, {1072, 32750},
{1286, 32743}, {1501, 32734},
{1715, 32723}, {1929, 32711},
{2143, 32698}, {2357, 32683},
{2571, 32667}, {2785, 32649},
{2998, 32631}, {3212, 32610},
{3425, 32588}, {3638, 32565},
{3851, 32541}, {4064, 32515},
{4277, 32488}, {4490, 32459},
{4702, 32429}, {4914, 32397},
{5126, 32365}, {5338, 32330},
{5549, 32295}, {5760, 32258},
{5971, 32219}, {6182, 32180},
{6393, 32138}, {6603, 32096},
{6813, 32052}, {7022, 32007},
{7232, 31960}, {7441, 31912},
{7650, 31863}, {7858, 31812},
{8066, 31760}, {8274, 31706},
{8481, 31651}, {8688, 31595},
{8895, 31538}, {9101, 31479},
{9307, 31419}, {9512, 31357},
{9717, 31294}, {9922, 31230},
{10126, 31164}, {10330, 31097},
{10533, 31029}, {10736, 30959},
{10938, 30888}, {11140, 30816},
{11342, 30743}, {11543, 30668},
{11743, 30592}, {11943, 30514},
{12142, 30435}, {12341, 30355},
{12540, 30274}, {12738, 30191},
{12935, 30107}, {13132, 30022},
{13328, 29935}, {13524, 29847},
{13719, 29758}, {13913, 29668},
{14107, 29576}, {14300, 29483},
{14493, 29389}, {14685, 29293},
{14876, 29197}, {15067, 29099},
{15257, 28999}, {15447, 28899},
{15636, 28797}, {15824, 28694},
{16011, 28590}, {16198, 28485},
{16384, 28378}, {16569, 28270},
{16754, 28161}, {16938, 28051},
{17121, 27939}, {17304, 27827},
{17485, 27713}, {17666, 27598},
{17847, 27482}, {18026, 27364},
{18205, 27246}, {18383, 27126},
{18560, 27005}, {18736, 26883},
{18912, 26760}, {19087, 26635},
{19261, 26510}, {19434, 26383},
{19606, 26255}, {19777, 26127},
{19948, 25997}, {20118, 25865},
{20286, 25733}, {20454, 25600},
{20622, 25466}, {20788, 25330},
{20953, 25193}, {21118, 25056},
{21281, 24917}, {21444, 24777},
{21605, 24636}, {21766, 24494},
{21926, 24351}, {22085, 24207},
{22243, 24062}, {22400, 23916},
{22556, 23769}, {22711, 23621},
{22865, 23472}, {23018, 23322},
{23170, 23170}, {23322, 23018},
{23472, 22865}, {23621, 22711},
{23769, 22556}, {23916, 22400},
{24062, 22243}, {24207, 22085},
{24351, 21926}, {24494, 21766},
{24636, 21605}, {24777, 21444},
{24917, 21281}, {25056, 21118},
{25193, 20953}, {25330, 20788},
{25466, 20622}, {25600, 20454},
{25733, 20286}, {25865, 20118},
{25997, 19948}, {26127, 19777},
{26255, 19606}, {26383, 19434},
{26510, 19261}, {26635, 19087},
{26760, 18912}, {26883, 18736},
{27005, 18560}, {27126, 18383},
{27246, 18205}, {27364, 18026},
{27482, 17847}, {27598, 17666},
{27713, 17485}, {27827, 17304},
{27939, 17121}, {28051, 16938},
{28161, 16754}, {28270, 16569},
{28378, 16384}, {28485, 16198},
{28590, 16011}, {28694, 15824},
{28797, 15636}, {28899, 15447},
{28999, 15257}, {29099, 15067},
{29197, 14876}, {29293, 14685},
{29389, 14493}, {29483, 14300},
{29576, 14107}, {29668, 13913},
{29758, 13719}, {29847, 13524},
{29935, 13328}, {30022, 13132},
{30107, 12935}, {30191, 12738},
{30274, 12540}, {30355, 12341},
{30435, 12142}, {30514, 11943},
{30592, 11743}, {30668, 11543},
{30743, 11342}, {30816, 11140},
{30888, 10938}, {30959, 10736},
{31029, 10533}, {31097, 10330},
{31164, 10126}, {31230, 9922},
{31294, 9717}, {31357, 9512},
{31419, 9307}, {31479, 9101},
{31538, 8895}, {31595, 8688},
{31651, 8481}, {31706, 8274},
{31760, 8066}, {31812, 7858},
{31863, 7650}, {31912, 7441},
{31960, 7232}, {32007, 7022},
{32052, 6813}, {32096, 6603},
{32138, 6393}, {32180, 6182},
{32219, 5971}, {32258, 5760},
{32295, 5549}, {32330, 5338},
{32365, 5126}, {32397, 4914},
{32429, 4702}, {32459, 4490},
{32488, 4277}, {32515, 4064},
{32541, 3851}, {32565, 3638},
{32588, 3425}, {32610, 3212},
{32631, 2998}, {32649, 2785},
{32667, 2571}, {32683, 2357},
{32698, 2143}, {32711, 1929},
{32723, 1715}, {32734, 1501},
{32743, 1286}, {32750, 1072},
{32757, 858}, {32762, 643},
{32765, 429}, {32767, 214},
#endif
};
#ifndef FFT_BITREV960
#define FFT_BITREV960
static const opus_int16 fft_bitrev960[960] = {
0, 192, 384, 576, 768, 64, 256, 448, 640, 832, 128, 320, 512, 704, 896,
16, 208, 400, 592, 784, 80, 272, 464, 656, 848, 144, 336, 528, 720, 912,
32, 224, 416, 608, 800, 96, 288, 480, 672, 864, 160, 352, 544, 736, 928,
48, 240, 432, 624, 816, 112, 304, 496, 688, 880, 176, 368, 560, 752, 944,
4, 196, 388, 580, 772, 68, 260, 452, 644, 836, 132, 324, 516, 708, 900,
20, 212, 404, 596, 788, 84, 276, 468, 660, 852, 148, 340, 532, 724, 916,
36, 228, 420, 612, 804, 100, 292, 484, 676, 868, 164, 356, 548, 740, 932,
52, 244, 436, 628, 820, 116, 308, 500, 692, 884, 180, 372, 564, 756, 948,
8, 200, 392, 584, 776, 72, 264, 456, 648, 840, 136, 328, 520, 712, 904,
24, 216, 408, 600, 792, 88, 280, 472, 664, 856, 152, 344, 536, 728, 920,
40, 232, 424, 616, 808, 104, 296, 488, 680, 872, 168, 360, 552, 744, 936,
56, 248, 440, 632, 824, 120, 312, 504, 696, 888, 184, 376, 568, 760, 952,
12, 204, 396, 588, 780, 76, 268, 460, 652, 844, 140, 332, 524, 716, 908,
28, 220, 412, 604, 796, 92, 284, 476, 668, 860, 156, 348, 540, 732, 924,
44, 236, 428, 620, 812, 108, 300, 492, 684, 876, 172, 364, 556, 748, 940,
60, 252, 444, 636, 828, 124, 316, 508, 700, 892, 188, 380, 572, 764, 956,
1, 193, 385, 577, 769, 65, 257, 449, 641, 833, 129, 321, 513, 705, 897,
17, 209, 401, 593, 785, 81, 273, 465, 657, 849, 145, 337, 529, 721, 913,
33, 225, 417, 609, 801, 97, 289, 481, 673, 865, 161, 353, 545, 737, 929,
49, 241, 433, 625, 817, 113, 305, 497, 689, 881, 177, 369, 561, 753, 945,
5, 197, 389, 581, 773, 69, 261, 453, 645, 837, 133, 325, 517, 709, 901,
21, 213, 405, 597, 789, 85, 277, 469, 661, 853, 149, 341, 533, 725, 917,
37, 229, 421, 613, 805, 101, 293, 485, 677, 869, 165, 357, 549, 741, 933,
53, 245, 437, 629, 821, 117, 309, 501, 693, 885, 181, 373, 565, 757, 949,
9, 201, 393, 585, 777, 73, 265, 457, 649, 841, 137, 329, 521, 713, 905,
25, 217, 409, 601, 793, 89, 281, 473, 665, 857, 153, 345, 537, 729, 921,
41, 233, 425, 617, 809, 105, 297, 489, 681, 873, 169, 361, 553, 745, 937,
57, 249, 441, 633, 825, 121, 313, 505, 697, 889, 185, 377, 569, 761, 953,
13, 205, 397, 589, 781, 77, 269, 461, 653, 845, 141, 333, 525, 717, 909,
29, 221, 413, 605, 797, 93, 285, 477, 669, 861, 157, 349, 541, 733, 925,
45, 237, 429, 621, 813, 109, 301, 493, 685, 877, 173, 365, 557, 749, 941,
61, 253, 445, 637, 829, 125, 317, 509, 701, 893, 189, 381, 573, 765, 957,
2, 194, 386, 578, 770, 66, 258, 450, 642, 834, 130, 322, 514, 706, 898,
18, 210, 402, 594, 786, 82, 274, 466, 658, 850, 146, 338, 530, 722, 914,
34, 226, 418, 610, 802, 98, 290, 482, 674, 866, 162, 354, 546, 738, 930,
50, 242, 434, 626, 818, 114, 306, 498, 690, 882, 178, 370, 562, 754, 946,
6, 198, 390, 582, 774, 70, 262, 454, 646, 838, 134, 326, 518, 710, 902,
22, 214, 406, 598, 790, 86, 278, 470, 662, 854, 150, 342, 534, 726, 918,
38, 230, 422, 614, 806, 102, 294, 486, 678, 870, 166, 358, 550, 742, 934,
54, 246, 438, 630, 822, 118, 310, 502, 694, 886, 182, 374, 566, 758, 950,
10, 202, 394, 586, 778, 74, 266, 458, 650, 842, 138, 330, 522, 714, 906,
26, 218, 410, 602, 794, 90, 282, 474, 666, 858, 154, 346, 538, 730, 922,
42, 234, 426, 618, 810, 106, 298, 490, 682, 874, 170, 362, 554, 746, 938,
58, 250, 442, 634, 826, 122, 314, 506, 698, 890, 186, 378, 570, 762, 954,
14, 206, 398, 590, 782, 78, 270, 462, 654, 846, 142, 334, 526, 718, 910,
30, 222, 414, 606, 798, 94, 286, 478, 670, 862, 158, 350, 542, 734, 926,
46, 238, 430, 622, 814, 110, 302, 494, 686, 878, 174, 366, 558, 750, 942,
62, 254, 446, 638, 830, 126, 318, 510, 702, 894, 190, 382, 574, 766, 958,
3, 195, 387, 579, 771, 67, 259, 451, 643, 835, 131, 323, 515, 707, 899,
19, 211, 403, 595, 787, 83, 275, 467, 659, 851, 147, 339, 531, 723, 915,
35, 227, 419, 611, 803, 99, 291, 483, 675, 867, 163, 355, 547, 739, 931,
51, 243, 435, 627, 819, 115, 307, 499, 691, 883, 179, 371, 563, 755, 947,
7, 199, 391, 583, 775, 71, 263, 455, 647, 839, 135, 327, 519, 711, 903,
23, 215, 407, 599, 791, 87, 279, 471, 663, 855, 151, 343, 535, 727, 919,
39, 231, 423, 615, 807, 103, 295, 487, 679, 871, 167, 359, 551, 743, 935,
55, 247, 439, 631, 823, 119, 311, 503, 695, 887, 183, 375, 567, 759, 951,
11, 203, 395, 587, 779, 75, 267, 459, 651, 843, 139, 331, 523, 715, 907,
27, 219, 411, 603, 795, 91, 283, 475, 667, 859, 155, 347, 539, 731, 923,
43, 235, 427, 619, 811, 107, 299, 491, 683, 875, 171, 363, 555, 747, 939,
59, 251, 443, 635, 827, 123, 315, 507, 699, 891, 187, 379, 571, 763, 955,
15, 207, 399, 591, 783, 79, 271, 463, 655, 847, 143, 335, 527, 719, 911,
31, 223, 415, 607, 799, 95, 287, 479, 671, 863, 159, 351, 543, 735, 927,
47, 239, 431, 623, 815, 111, 303, 495, 687, 879, 175, 367, 559, 751, 943,
63, 255, 447, 639, 831, 127, 319, 511, 703, 895, 191, 383, 575, 767, 959,
};
#endif

#ifndef FFT_BITREV480
#define FFT_BITREV480
static const opus_int16 fft_bitrev480[480] = {
0, 96, 192, 288, 384, 32, 128, 224, 320, 416, 64, 160, 256, 352, 448,
8, 104, 200, 296, 392, 40, 136, 232, 328, 424, 72, 168, 264, 360, 456,
16, 112, 208, 304, 400, 48, 144, 240, 336, 432, 80, 176, 272, 368, 464,
24, 120, 216, 312, 408, 56, 152, 248, 344, 440, 88, 184, 280, 376, 472,
4, 100, 196, 292, 388, 36, 132, 228, 324, 420, 68, 164, 260, 356, 452,
12, 108, 204, 300, 396, 44, 140, 236, 332, 428, 76, 172, 268, 364, 460,
20, 116, 212, 308, 404, 52, 148, 244, 340, 436, 84, 180, 276, 372, 468,
28, 124, 220, 316, 412, 60, 156, 252, 348, 444, 92, 188, 284, 380, 476,
1, 97, 193, 289, 385, 33, 129, 225, 321, 417, 65, 161, 257, 353, 449,
9, 105, 201, 297, 393, 41, 137, 233, 329, 425, 73, 169, 265, 361, 457,
17, 113, 209, 305, 401, 49, 145, 241, 337, 433, 81, 177, 273, 369, 465,
25, 121, 217, 313, 409, 57, 153, 249, 345, 441, 89, 185, 281, 377, 473,
5, 101, 197, 293, 389, 37, 133, 229, 325, 421, 69, 165, 261, 357, 453,
13, 109, 205, 301, 397, 45, 141, 237, 333, 429, 77, 173, 269, 365, 461,
21, 117, 213, 309, 405, 53, 149, 245, 341, 437, 85, 181, 277, 373, 469,
29, 125, 221, 317, 413, 61, 157, 253, 349, 445, 93, 189, 285, 381, 477,
2, 98, 194, 290, 386, 34, 130, 226, 322, 418, 66, 162, 258, 354, 450,
10, 106, 202, 298, 394, 42, 138, 234, 330, 426, 74, 170, 266, 362, 458,
18, 114, 210, 306, 402, 50, 146, 242, 338, 434, 82, 178, 274, 370, 466,
26, 122, 218, 314, 410, 58, 154, 250, 346, 442, 90, 186, 282, 378, 474,
6, 102, 198, 294, 390, 38, 134, 230, 326, 422, 70, 166, 262, 358, 454,
14, 110, 206, 302, 398, 46, 142, 238, 334, 430, 78, 174, 270, 366, 462,
22, 118, 214, 310, 406, 54, 150, 246, 342, 438, 86, 182, 278, 374, 470,
30, 126, 222, 318, 414, 62, 158, 254, 350, 446, 94, 190, 286, 382, 478,
3, 99, 195, 291, 387, 35, 131, 227, 323, 419, 67, 163, 259, 355, 451,
11, 107, 203, 299, 395, 43, 139, 235, 331, 427, 75, 171, 267, 363, 459,
19, 115, 211, 307, 403, 51, 147, 243, 339, 435, 83, 179, 275, 371, 467,
27, 123, 219, 315, 411, 59, 155, 251, 347, 443, 91, 187, 283, 379, 475,
7, 103, 199, 295, 391, 39, 135, 231, 327, 423, 71, 167, 263, 359, 455,
15, 111, 207, 303, 399, 47, 143, 239, 335, 431, 79, 175, 271, 367, 463,
23, 119, 215, 311, 407, 55, 151, 247, 343, 439, 87, 183, 279, 375, 471,
31, 127, 223, 319, 415, 63, 159, 255, 351, 447, 95, 191, 287, 383, 479,
};
#endif

#ifndef FFT_BITREV240
#define FFT_BITREV240
static const opus_int16 fft_bitrev240[240] = {
0, 48, 96, 144, 192, 16, 64, 112, 160, 208, 32, 80, 128, 176, 224,
4, 52, 100, 148, 196, 20, 68, 116, 164, 212, 36, 84, 132, 180, 228,
8, 56, 104, 152, 200, 24, 72, 120, 168, 216, 40, 88, 136, 184, 232,
12, 60, 108, 156, 204, 28, 76, 124, 172, 220, 44, 92, 140, 188, 236,
1, 49, 97, 145, 193, 17, 65, 113, 161, 209, 33, 81, 129, 177, 225,
5, 53, 101, 149, 197, 21, 69, 117, 165, 213, 37, 85, 133, 181, 229,
9, 57, 105, 153, 201, 25, 73, 121, 169, 217, 41, 89, 137, 185, 233,
13, 61, 109, 157, 205, 29, 77, 125, 173, 221, 45, 93, 141, 189, 237,
2, 50, 98, 146, 194, 18, 66, 114, 162, 210, 34, 82, 130, 178, 226,
6, 54, 102, 150, 198, 22, 70, 118, 166, 214, 38, 86, 134, 182, 230,
10, 58, 106, 154, 202, 26, 74, 122, 170, 218, 42, 90, 138, 186, 234,
14, 62, 110, 158, 206, 30, 78, 126, 174, 222, 46, 94, 142, 190, 238,
3, 51, 99, 147, 195, 19, 67, 115, 163, 211, 35, 83, 131, 179, 227,
7, 55, 103, 151, 199, 23, 71, 119, 167, 215, 39, 87, 135, 183, 231,
11, 59, 107, 155, 203, 27, 75, 123, 171, 219, 43, 91, 139, 187, 235,
15, 63, 111, 159, 207, 31, 79, 127, 175, 223, 47, 95, 143, 191, 239,
};
#endif

#ifndef FFT_BITREV120
#define FFT_BITREV120
static const opus_int16 fft_bitrev120[120] = {
0, 24, 48, 72, 96, 8, 32, 56, 80, 104, 16, 40, 64, 88, 112,
4, 28, 52, 76, 100, 12, 36, 60, 84, 108, 20, 44, 68, 92, 116,
1, 25, 49, 73, 97, 9, 33, 57, 81, 105, 17, 41, 65, 89, 113,
5, 29, 53, 77, 101, 13, 37, 61, 85, 109, 21, 45, 69, 93, 117,
2, 26, 50, 74, 98, 10, 34, 58, 82, 106, 18, 42, 66, 90, 114,
6, 30, 54, 78, 102, 14, 38, 62, 86, 110, 22, 46, 70, 94, 118,
3, 27, 51, 75, 99, 11, 35, 59, 83, 107, 19, 43, 67, 91, 115,
7, 31, 55, 79, 103, 15, 39, 63, 87, 111, 23, 47, 71, 95, 119,
};
#endif

#ifndef FFT_STATE96000_1920_0
#define FFT_STATE96000_1920_0
static const kiss_fft_state fft_state96000_1920_0 = {
960,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
9,    /* scale_shift */
-1,    /* shift */
{5, 192, 3, 64, 4, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev960,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_960,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE96000_1920_1
#define FFT_STATE96000_1920_1
static const kiss_fft_state fft_state96000_1920_1 = {
480,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
8,    /* scale_shift */
1,    /* shift */
{5, 96, 3, 32, 4, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev480,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_480,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE96000_1920_2
#define FFT_STATE96000_1920_2
static const kiss_fft_state fft_state96000_1920_2 = {
240,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
7,    /* scale_shift */
2,    /* shift */
{5, 48, 3, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev240,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_240,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE96000_1920_3
#define FFT_STATE96000_1920_3
static const kiss_fft_state fft_state96000_1920_3 = {
120,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
6,    /* scale_shift */
3,    /* shift */
{5, 24, 3, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev120,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_120,
#else
NULL,
#endif
};
#endif

#endif

#ifndef MDCT_TWIDDLES1920
#define MDCT_TWIDDLES1920
static const celt_coef mdct_twiddles1920[3600] = {
#ifdef ENABLE_QEXT
2147483603, 2147480010, 2147470667, 2147455575, 2147434733,
2147408142, 2147375802, 2147337712, 2147293874, 2147244286,
2147188950, 2147127865, 2147061032, 2146988450, 2146910120,
2146826042, 2146736216, 2146640643, 2146539323, 2146432256,
2146319442, 2146200882, 2146076576, 2145946524, 2145810727,
2145669185, 2145521898, 2145368867, 2145210092, 2145045574,
2144875313, 2144699310, 2144517564, 2144330077, 2144136849,
2143937880, 2143733172, 2143522724, 2143306537, 2143084612,
2142856949, 2142623549, 2142384413, 2142139541, 2141888933,
2141632592, 2141370516, 2141102708, 2140829167, 2140549894,
2140264890, 2139974157, 2139677694, 2139375502, 2139067583,
2138753936, 2138434564, 2138109466, 2137778644, 2137442099,
2137099831, 2136751841, 2136398131, 2136038701, 2135673552,
2135302685, 2134926101, 2134543801, 2134155787, 2133762059,
2133362618, 2132957466, 2132546603, 2132130030, 2131707749,
2131279761, 2130846067, 2130406668, 2129961565, 2129510759,
2129054253, 2128592046, 2128124140, 2127650537, 2127171237,
2126686242, 2126195553, 2125699172, 2125197100, 2124689338,
2124175888, 2123656750, 2123131927, 2122601420, 2122065230,
2121523358, 2120975806, 2120422576, 2119863669, 2119299086,
2118728830, 2118152901, 2117571301, 2116984031, 2116391094,
2115792491, 2115188222, 2114578291, 2113962699, 2113341447,
2112714537, 2112081970, 2111443749, 2110799875, 2110150349,
2109495174, 2108834352, 2108167883, 2107495770, 2106818015,
2106134619, 2105445584, 2104750913, 2104050606, 2103344666,
2102633095, 2101915895, 2101193067, 2100464614, 2099730537,
2098990838, 2098245520, 2097494584, 2096738032, 2095975867,
2095208091, 2094434705, 2093655711, 2092871112, 2092080910,
2091285107, 2090483704, 2089676705, 2088864111, 2088045925,
2087222148, 2086392783, 2085557833, 2084717298, 2083871182,
2083019487, 2082162216, 2081299369, 2080430950, 2079556962,
2078677406, 2077792284, 2076901600, 2076005355, 2075103552,
2074196194, 2073283282, 2072364819, 2071440808, 2070511251,
2069576151, 2068635510, 2067689330, 2066737615, 2065780367,
2064817587, 2063849280, 2062875447, 2061896091, 2060911215,
2059920821, 2058924912, 2057923491, 2056916560, 2055904122,
2054886179, 2053862736, 2052833793, 2051799354, 2050759422,
2049714000, 2048663090, 2047606695, 2046544818, 2045477461,
2044404629, 2043326323, 2042242546, 2041153301, 2040058592,
2038958421, 2037852791, 2036741705, 2035625166, 2034503177,
2033375742, 2032242862, 2031104541, 2029960782, 2028811589,
2027656964, 2026496910, 2025331431, 2024160529, 2022984208,
2021802471, 2020615320, 2019422760, 2018224794, 2017021424,
2015812654, 2014598487, 2013378926, 2012153975, 2010923636,
2009687914, 2008446811, 2007200332, 2005948478, 2004691253,
2003428662, 2002160707, 2000887391, 1999608718, 1998324692,
1997035316, 1995740593, 1994440527, 1993135121, 1991824379,
1990508304, 1989186900, 1987860170, 1986528118, 1985190748,
1983848063, 1982500066, 1981146762, 1979788153, 1978424244,
1977055038, 1975680539, 1974300751, 1972915676, 1971525320,
1970129685, 1968728776, 1967322596, 1965911148, 1964494438,
1963072467, 1961645241, 1960212764, 1958775038, 1957332067,
1955883857, 1954430410, 1952971730, 1951507822, 1950038689,
1948564335, 1947084764, 1945599980, 1944109987, 1942614790,
1941114391, 1939608795, 1938098007, 1936582029, 1935060867,
1933534524, 1932003004, 1930466312, 1928924452, 1927377427,
1925825242, 1924267900, 1922705408, 1921137767, 1919564983,
1917987059, 1916404001, 1914815812, 1913222496, 1911624058,
1910020502, 1908411833, 1906798054, 1905179170, 1903555185,
1901926103, 1900291930, 1898652669, 1897008325, 1895358902,
1893704404, 1892044837, 1890380204, 1888710510, 1887035759,
1885355956, 1883671105, 1881981211, 1880286279, 1878586312,
1876881316, 1875171295, 1873456254, 1871736196, 1870011128,
1868281053, 1866545976, 1864805901, 1863060834, 1861310779,
1859555741, 1857795724, 1856030734, 1854260774, 1852485850,
1850705966, 1848921127, 1847131338, 1845336604, 1843536929,
1841732318, 1839922777, 1838108310, 1836288921, 1834464616,
1832635400, 1830801277, 1828962253, 1827118332, 1825269519,
1823415819, 1821557238, 1819693779, 1817825449, 1815952252,
1814074193, 1812191278, 1810303510, 1808410896, 1806513440,
1804611147, 1802704023, 1800792073, 1798875302, 1796953714,
1795027315, 1793096111, 1791160105, 1789219305, 1787273714,
1785323338, 1783368182, 1781408251, 1779443552, 1777474088,
1775499865, 1773520888, 1771537164, 1769548696, 1767555491,
1765557554, 1763554889, 1761547504, 1759535401, 1757518588,
1755497070, 1753470852, 1751439939, 1749404337, 1747364051,
1745319087, 1743269451, 1741215147, 1739156181, 1737092559,
1735024287, 1732951369, 1730873811, 1728791620, 1726704800,
1724613357, 1722517297, 1720416625, 1718311347, 1716201468,
1714086995, 1711967933, 1709844287, 1707716063, 1705583268,
1703445906, 1701303983, 1699157505, 1697006479, 1694850909,
1692690801, 1690526161, 1688356996, 1686183310, 1684005110,
1681822401, 1679635189, 1677443481, 1675247281, 1673046596,
1670841433, 1668631795, 1666417691, 1664199124, 1661976103,
1659748631, 1657516716, 1655280364, 1653039579, 1650794369,
1648544739, 1646290696, 1644032245, 1641769393, 1639502145,
1637230507, 1634954486, 1632674088, 1630389319, 1628100184,
1625806691, 1623508845, 1621206653, 1618900119, 1616589252,
1614274057, 1611954539, 1609630706, 1607302564, 1604970118,
1602633375, 1600292342, 1597947024, 1595597428, 1593243560,
1590885426, 1588523033, 1586156387, 1583785495, 1581410362,
1579030995, 1576647401, 1574259586, 1571867556, 1569471317,
1567070877, 1564666241, 1562257416, 1559844408, 1557427224,
1555005871, 1552580354, 1550150681, 1547716857, 1545278889,
1542836785, 1540390550, 1537940190, 1535485713, 1533027126,
1530564434, 1528097644, 1525626762, 1523151797, 1520672753,
1518189638, 1515702459, 1513211221, 1510715932, 1508216599,
1505713227, 1503205824, 1500694397, 1498178952, 1495659496,
1493136035, 1490608577, 1488077129, 1485541696, 1483002286,
1480458905, 1477911561, 1475360260, 1472805009, 1470245815,
1467682684, 1465115624, 1462544642, 1459969744, 1457390937,
1454808228, 1452221624, 1449631133, 1447036760, 1444438513,
1441836399, 1439230424, 1436620597, 1434006923, 1431389409,
1428768064, 1426142893, 1423513904, 1420881104, 1418244500,
1415604099, 1412959907, 1410311933, 1407660183, 1405004664,
1402345384, 1399682349, 1397015567, 1394345044, 1391670789,
1388992807, 1386311107, 1383625695, 1380936579, 1378243766,
1375547262, 1372847076, 1370143215, 1367435685, 1364724494,
1362009649, 1359291158, 1356569027, 1353843265, 1351113878,
1348380873, 1345644259, 1342904042, 1340160229, 1337412829,
1334661848, 1331907293, 1329149173, 1326387494, 1323622264,
1320853490, 1318081180, 1315305341, 1312525981, 1309743106,
1306956725, 1304166845, 1301373473, 1298576617, 1295776285,
1292972483, 1290165219, 1287354501, 1284540337, 1281722734,
1278901699, 1276077240, 1273249364, 1270418080, 1267583394,
1264745315, 1261903850, 1259059006, 1256210791, 1253359213,
1250504279, 1247645998, 1244784376, 1241919421, 1239051142,
1236179545, 1233304638, 1230426430, 1227544927, 1224660138,
1221772070, 1218880731, 1215986128, 1213088271, 1210187165,
1207282819, 1204375241, 1201464439, 1198550419, 1195633191,
1192712762, 1189789140, 1186862332, 1183932347, 1180999192,
1178062875, 1175123404, 1172180786, 1169235031, 1166286145,
1163334137, 1160379014, 1157420784, 1154459456, 1151495036,
1148527534, 1145556957, 1142583313, 1139606610, 1136626856,
1133644058, 1130658226, 1127669367, 1124677488, 1121682598,
1118684705, 1115683818, 1112679943, 1109673089, 1106663264,
1103650476, 1100634734, 1097616045, 1094594417, 1091569858,
1088542378, 1085511982, 1082478681, 1079442481, 1076403392,
1073361420, 1070316575, 1067268864, 1064218296, 1061164879,
1058108621, 1055049529, 1051987613, 1048922881, 1045855340,
1042784999, 1039711867, 1036635950, 1033557259, 1030475800,
1027391582, 1024304614, 1021214903, 1018122458, 1015027288,
1011929400, 1008828802, 1005725504, 1002619513, 999510838,
996399486, 993285468, 990168789, 987049460, 983927488,
980802882, 977675650, 974545800, 971413342, 968278282,
965140630, 962000395, 958857583, 955712205, 952564267,
949413780, 946260750, 943105188, 939947100, 936786495,
933623383, 930457771, 927289668, 924119082, 920946022,
917770497, 914592514, 911412082, 908229211, 905043908,
901856182, 898666041, 895473494, 892278550, 889081217,
885881504, 882679419, 879474970, 876268167, 873059018,
869847532, 866633717, 863417581, 860199134, 856978384,
853755339, 850530009, 847302402, 844072526, 840840390,
837606003, 834369373, 831130510, 827889422, 824646117,
821400604, 818152892, 814902989, 811650905, 808396648,
805140227, 801881649, 798620925, 795358063, 792093072,
788825960, 785556735, 782285408, 779011986, 775736479,
772458895, 769179242, 765897531, 762613768, 759327964,
756040127, 752750266, 749458390, 746164507, 742868626,
739570757, 736270907, 732969086, 729665303, 726359567,
723051885, 719742268, 716430724, 713117261, 709801890,
706484618, 703165455, 699844409, 696521489, 693196705,
689870064, 686541577, 683211252, 679879097, 676545122,
673209336, 669871748, 666532366, 663191199, 659848257,
656503549, 653157082, 649808867, 646458913, 643107227,
639753820, 636398700, 633041876, 629683357, 626323153,
622961271, 619597722, 616232514, 612865656, 609497157,
606127026, 602755273, 599381905, 596006934, 592630366,
589252212, 585872480, 582491179, 579108320, 575723909,
572337957, 568950473, 565561466, 562170945, 558778918,
555385395, 551990386, 548593898, 545195942, 541796526,
538395660, 534993352, 531589612, 528184449, 524777871,
521369889, 517960510, 514549745, 511137603, 507724092,
504309221, 500893000, 497475439, 494056545, 490636329,
487214799, 483791965, 480367835, 476942419, 473515727,
470087766, 466658548, 463228079, 459796371, 456363431,
452929270, 449493896, 446057319, 442619547, 439180590,
435740458, 432299159, 428856702, 425413098, 421968354,
418522481, 415075487, 411627382, 408178175, 404727875,
401276491, 397824033, 394370510, 390915931, 387460306,
384003643, 380545952, 377087242, 373627523, 370166803,
366705093, 363242400, 359778735, 356314107, 352848525,
349381998, 345914536, 342446148, 338976842, 335506630,
332035519, 328563519, 325090639, 321616889, 318142278,
314666815, 311190510, 307713372, 304235410, 300756633,
297277051, 293796673, 290315508, 286833567, 283350857,
279867389, 276383171, 272898214, 269412525, 265926116,
262438995, 258951170, 255462653, 251973452, 248483576,
244993035, 241501838, 238009994, 234517513, 231024404,
227530677, 224036341, 220541404, 217045878, 213549770,
210053090, 206555848, 203058053, 199559715, 196060842,
192561444, 189061531, 185561111, 182060195, 178558791,
175056909, 171554559, 168051749, 164548489, 161044789,
157540658, 154036105, 150531139, 147025770, 143520008,
140013862, 136507340, 133000453, 129493210, 125985621,
122477694, 118969439, 115460866, 111951983, 108442801,
104933329, 101423575, 97913550, 94403263, 90892723,
87381940, 83870923, 80359681, 76848224, 73336562,
69824703, 66312657, 62800433, 59288042, 55775491,
52262792, 48749952, 45236982, 41723891, 38210688,
34697383, 31183985, 27670503, 24156947, 20643327,
17129651, 13615930, 10102172, 6588387, 3074584,
-439226, -3953036, -7466835, -10980614, -14494364,
-18008075, -21521738, -25035343, -28548881, -32062342,
-35575718, -39088999, -42602174, -46115236, -49628175,
-53140980, -56653643, -60166155, -63678505, -67190685,
-70702685, -74214496, -77726108, -81237512, -84748698,
-88259658, -91770381, -95280859, -98791081, -102301039,
-105810723, -109320124, -112829232, -116338038, -119846533,
-123354707, -126862550, -130370054, -133877209, -137384005,
-140890434, -144396485, -147902150, -151407418, -154912282,
-158416730, -161920755, -165424346, -168927494, -172430190,
-175932424, -179434187, -182935470, -186436263, -189936557,
-193436342, -196935610, -200434350, -203932553, -207430211,
-210927313, -214423851, -217919814, -221415194, -224909981,
-228404166, -231897740, -235390693, -238883015, -242374698,
-245865732, -249356108, -252845816, -256334847, -259823192,
-263310841, -266797785, -270284015, -273769522, -277254295,
-280738326, -284221606, -287704124, -291185873, -294666841,
-298147021, -301626403, -305104977, -308582734, -312059665,
-315535760, -319011011, -322485408, -325958941, -329431602,
-332903380, -336374268, -339844254, -343313331, -346781489,
-350248718, -353715010, -357180354, -360644742, -364108165,
-367570613, -371032077, -374492547, -377952015, -381410471,
-384867905, -388324310, -391779674, -395233990, -398687248,
-402139438, -405590552, -409040579, -412489512, -415937340,
-419384055, -422829646, -426274106, -429717424, -433159592,
-436600601, -440040440, -443479101, -446916575, -450352853,
-453787924, -457221781, -460654414, -464085813, -467515970,
-470944875, -474372519, -477798893, -481223988, -484647795,
-488070304, -491491506, -494911393, -498329954, -501747182,
-505163066, -508577597, -511990767, -515402566, -518812985,
-522222016, -525629648, -529035873, -532440681, -535844064,
-539246012, -542646517, -546045568, -549443158, -552839277,
-556233916, -559627065, -563018716, -566408860, -569797488,
-573184589, -576570157, -579954180, -583336651, -586717560,
-590096899, -593474657, -596850827, -600225398, -603598363,
-606969711, -610339435, -613707524, -617073971, -620438765,
-623801898, -627163361, -630523145, -633881241, -637237640,
-640592333, -643945310, -647296564, -650646085, -653993863,
-657339891, -660684159, -664026658, -667367379, -670706313,
-674043452, -677378786, -680712307, -684044005, -687373872,
-690701898, -694028075, -697352394, -700674846, -703995422,
-707314114, -710630911, -713945806, -717258790, -720569853,
-723878987, -727186183, -730491433, -733794726, -737096055,
-740395410, -743692783, -746988165, -750281547, -753572921,
-756862277, -760149606, -763434901, -766718151, -769999349,
-773278485, -776555551, -779830538, -783103437, -786374239,
-789642936, -792909519, -796173979, -799436307, -802696495,
-805954534, -809210416, -812464130, -815715670, -818965026,
-822212189, -825457150, -828699902, -831940435, -835178741,
-838414810, -841648635, -844880207, -848109516, -851336555,
-854561315, -857783787, -861003962, -864221832, -867437388,
-870650622, -873861525, -877070088, -880276304, -883480162,
-886681655, -889880774, -893077511, -896271856, -899463802,
-902653340, -905840461, -909025157, -912207419, -915387239,
-918564609, -921739519, -924911961, -928081927, -931249408,
-934414396, -937576882, -940736858, -943894315, -947049246,
-950201640, -953351491, -956498790, -959643527, -962785695,
-965925286, -969062291, -972196701, -975328508, -978457704,
-981584280, -984708228, -987829540, -990948208, -994064222,
-997177575, -1000288258, -1003396263, -1006501581, -1009604205,
-1012704126, -1015801336, -1018895826, -1021987588, -1025076613,
-1028162895, -1031246424, -1034327191, -1037405190, -1040480411,
-1043552847, -1046622488, -1049689328, -1052753357, -1055814567,
-1058872951, -1061928500, -1064981206, -1068031060, -1071078055,
-1074122183, -1077163435, -1080201802, -1083237278, -1086269854,
-1089299521, -1092326272, -1095350099, -1098370993, -1101388946,
-1104403951, -1107415998, -1110425081, -1113431191, -1116434320,
-1119434460, -1122431603, -1125425740, -1128416865, -1131404968,
-1134390043, -1137372080, -1140351072, -1143327011, -1146299889,
-1149269698, -1152236431, -1155200078, -1158160632, -1161118086,
-1164072431, -1167023660, -1169971764, -1172916735, -1175858567,
-1178797250, -1181732777, -1184665141, -1187594332, -1190520344,
-1193443169, -1196362799, -1199279225, -1202192441, -1205102438,
-1208009209, -1210912745, -1213813040, -1216710085, -1219603872,
-1222494394, -1225381643, -1228265611, -1231146291, -1234023675,
-1236897754, -1239768523, -1242635972, -1245500094, -1248360882,
-1251218327, -1254072422, -1256923160, -1259770533, -1262614533,
-1265455153, -1268292384, -1271126220, -1273956653, -1276783675,
-1279607279, -1282427457, -1285244201, -1288057504, -1290867359,
-1293673758, -1296476693, -1299276157, -1302072143, -1304864643,
-1307653649, -1310439154, -1313221151, -1315999631, -1318774589,
-1321546016, -1324313904, -1327078247, -1329839037, -1332596266,
-1335349928, -1338100015, -1340846519, -1343589433, -1346328751,
-1349064463, -1351796564, -1354525046, -1357249901, -1359971122,
-1362688702, -1365402634, -1368112911, -1370819524, -1373522468,
-1376221734, -1378917315, -1381609205, -1384297396, -1386981880,
-1389662652, -1392339702, -1395013025, -1397682613, -1400348459,
-1403010556, -1405668897, -1408323474, -1410974281, -1413621310,
-1416264555, -1418904007, -1421539661, -1424171509, -1426799544,
-1429423759, -1432044147, -1434660701, -1437273414, -1439882279,
-1442487289, -1445088437, -1447685717, -1450279120, -1452868640,
-1455454271, -1458036005, -1460613835, -1463187755, -1465757757,
-1468323835, -1470885982, -1473444191, -1475998456, -1478548768,
-1481095122, -1483637511, -1486175927, -1488710365, -1491240816,
-1493767276, -1496289736, -1498808190, -1501322631, -1503833053,
-1506339448, -1508841811, -1511340134, -1513834411, -1516324634,
-1518810798, -1521292896, -1523770921, -1526244866, -1528714725,
-1531180491, -1533642158, -1536099718, -1538553166, -1541002495,
-1543447698, -1545888769, -1548325701, -1550758488, -1553187123,
-1555611600, -1558031911, -1560448052, -1562860014, -1565267793,
-1567671380, -1570070771, -1572465958, -1574856935, -1577243696,
-1579626234, -1582004542, -1584378616, -1586748447, -1589114030,
-1591475359, -1593832427, -1596185227, -1598533754, -1600878002,
-1603217963, -1605553632, -1607885003, -1610212069, -1612534823,
-1614853261, -1617167375, -1619477159, -1621782608, -1624083714,
-1626380473, -1628672877, -1630960921, -1633244598, -1635523902,
-1637798828, -1640069368, -1642335518, -1644597271, -1646854620,
-1649107561, -1651356086, -1653600190, -1655839867, -1658075111,
-1660305916, -1662532275, -1664754184, -1666971635, -1669184624,
-1671393143, -1673597188, -1675796752, -1677991829, -1680182414,
-1682368500, -1684550083, -1686727155, -1688899711, -1691067746,
-1693231253, -1695390227, -1697544662, -1699694551, -1701839891,
-1703980674, -1706116895, -1708248548, -1710375628, -1712498128,
-1714616044, -1716729369, -1718838098, -1720942225, -1723041744,
-1725136651, -1727226938, -1729312602, -1731393635, -1733470033,
-1735541790, -1737608901, -1739671359, -1741729160, -1743782298,
-1745830767, -1747874561, -1749913677, -1751948107, -1753977847,
-1756002891, -1758023233, -1760038869, -1762049792, -1764055998,
-1766057481, -1768054236, -1770046258, -1772033540, -1774016078,
-1775993866, -1777966900, -1779935173, -1781898681, -1783857419,
-1785811380, -1787760560, -1789704954, -1791644556, -1793579362,
-1795509366, -1797434562, -1799354946, -1801270513, -1803181257,
-1805087174, -1806988258, -1808884503, -1810775906, -1812662462,
-1814544164, -1816421007, -1818292988, -1820160101, -1822022340,
-1823879702, -1825732180, -1827579771, -1829422468, -1831260267,
-1833093164, -1834921153, -1836744229, -1838562388, -1840375624,
-1842183933, -1843987310, -1845785751, -1847579249, -1849367801,
-1851151401, -1852930046, -1854703729, -1856472447, -1858236195,
-1859994968, -1861748761, -1863497569, -1865241388, -1866980214,
-1868714041, -1870442864, -1872166681, -1873885484, -1875599271,
-1877308036, -1879011776, -1880710484, -1882404157, -1884092791,
-1885776380, -1887454920, -1889128407, -1890796837, -1892460204,
-1894118504, -1895771734, -1897419887, -1899062961, -1900700951,
-1902333851, -1903961659, -1905584369, -1907201977, -1908814479,
-1910421871, -1912024148, -1913621306, -1915213340, -1916800247,
-1918382022, -1919958661, -1921530159, -1923096514, -1924657719,
-1926213771, -1927764667, -1929310401, -1930850970, -1932386369,
-1933916595, -1935441643, -1936961510, -1938476190, -1939985681,
-1941489978, -1942989077, -1944482974, -1945971664, -1947455145,
-1948933412, -1950406461, -1951874289, -1953336890, -1954794262,
-1956246401, -1957693301, -1959134961, -1960571375, -1962002540,
-1963428453, -1964849109, -1966264504, -1967674635, -1969079498,
-1970479089, -1971873404, -1973262440, -1974646194, -1976024660,
-1977397836, -1978765718, -1980128302, -1981485585, -1982837563,
-1984184232, -1985525589, -1986861630, -1988192351, -1989517750,
-1990837822, -1992152564, -1993461973, -1994766044, -1996064775,
-1997358161, -1998646200, -1999928888, -2001206222, -2002478198,
-2003744813, -2005006063, -2006261945, -2007512455, -2008757591,
-2009997349, -2011231726, -2012460718, -2013684322, -2014902534,
-2016115352, -2017322773, -2018524792, -2019721407, -2020912615,
-2022098413, -2023278796, -2024453763, -2025623309, -2026787432,
-2027946129, -2029099397, -2030247232, -2031389631, -2032526592,
-2033658111, -2034784185, -2035904812, -2037019988, -2038129710,
-2039233976, -2040332782, -2041426125, -2042514003, -2043596412,
-2044673350, -2045744814, -2046810801, -2047871308, -2048926332,
-2049975870, -2051019920, -2052058479, -2053091544, -2054119112,
-2055141181, -2056157747, -2057168809, -2058174363, -2059174406,
-2060168936, -2061157951, -2062141448, -2063119423, -2064091875,
-2065058800, -2066020197, -2066976063, -2067926394, -2068871190,
-2069810446, -2070744160, -2071672331, -2072594955, -2073512030,
-2074423554, -2075329524, -2076229937, -2077124792, -2078014086,
-2078897817, -2079775981, -2080648577, -2081515603, -2082377056,
-2083232934, -2084083234, -2084927955, -2085767094, -2086600648,
-2087428616, -2088250996, -2089067784, -2089878979, -2090684580,
-2091484582, -2092278986, -2093067787, -2093850985, -2094628577,
-2095400561, -2096166935, -2096927697, -2097682844, -2098432376,
-2099176290, -2099914583, -2100647254, -2101374302, -2102095723,
-2102811516, -2103521679, -2104226211, -2104925109, -2105618372,
-2106305997, -2106987983, -2107664327, -2108335029, -2109000087,
-2109659498, -2110313260, -2110961373, -2111603834, -2112240642,
-2112871795, -2113497290, -2114117128, -2114731305, -2115339820,
-2115942673, -2116539860, -2117131380, -2117717232, -2118297415,
-2118871926, -2119440764, -2120003928, -2120561416, -2121113227,
-2121659358, -2122199810, -2122734579, -2123263666, -2123787068,
-2124304784, -2124816812, -2125323152, -2125823801, -2126318759,
-2126808025, -2127291596, -2127769472, -2128241651, -2128708132,
-2129168914, -2129623995, -2130073375, -2130517052, -2130955025,
-2131387293, -2131813854, -2132234708, -2132649854, -2133059289,
-2133463014, -2133861027, -2134253326, -2134639912, -2135020783,
-2135395937, -2135765375, -2136129094, -2136487095, -2136839375,
-2137185934, -2137526772, -2137861886, -2138191277, -2138514944,
-2138832885, -2139145099, -2139451587, -2139752346, -2140047377,
-2140336678, -2140620249, -2140898089, -2141170197, -2141436573,
-2141697215, -2141952123, -2142201296, -2142444735, -2142682437,
-2142914403, -2143140631, -2143361122, -2143575874, -2143784887,
-2143988161, -2144185694, -2144377487, -2144563539, -2144743849,
-2144918417, -2145087242, -2145250325, -2145407663, -2145559258,
-2145705109, -2145845215, -2145979576, -2146108191, -2146231061,
-2146348185, -2146459562, -2146565192, -2146665076, -2146759212,
-2146847600, -2146930241, -2147007134, -2147078279, -2147143675,
-2147203323, -2147257222, -2147305372, -2147347773, -2147384426,
-2147415329, -2147440482, -2147459887, -2147473542, -2147481447,
2147483468, 2147469095, 2147431723, 2147371355, 2147287990,
2147181629, 2147052273, 2146899924, 2146724584, 2146526254,
2146304937, 2146060634, 2145793349, 2145503083, 2145189842,
2144853627, 2144494442, 2144112292, 2143707180, 2143279110,
2142828088, 2142354118, 2141857204, 2141337354, 2140794571,
2140228862, 2139640233, 2139028690, 2138394240, 2137736889,
2137056645, 2136353515, 2135627506, 2134878626, 2134106884,
2133312286, 2132494843, 2131654563, 2130791454, 2129905526,
2128996788, 2128065251, 2127110924, 2126133817, 2125133941,
2124111307, 2123065925, 2121997806, 2120906963, 2119793407,
2118657149, 2117498202, 2116316578, 2115112291, 2113885352,
2112635775, 2111363574, 2110068761, 2108751352, 2107411359,
2106048798, 2104663683, 2103256028, 2101825849, 2100373162,
2098897981, 2097400322, 2095880202, 2094337637, 2092772643,
2091185237, 2089575437, 2087943258, 2086288720, 2084611839,
2082912633, 2081191122, 2079447322, 2077681253, 2075892934,
2074082383, 2072249621, 2070394667, 2068517540, 2066618262,
2064696851, 2062753329, 2060787717, 2058800036, 2056790306,
2054758550, 2052704789, 2050629045, 2048531340, 2046411698,
2044270140, 2042106689, 2039921369, 2037714204, 2035485216,
2033234429, 2030961869, 2028667558, 2026351522, 2024013785,
2021654373, 2019273310, 2016870623, 2014446336, 2012000477,
2009533071, 2007044144, 2004533723, 2002001835, 1999448508,
1996873768, 1994277643, 1991660161, 1989021350, 1986361238,
1983679853, 1980977226, 1978253383, 1975508355, 1972742171,
1969954860, 1967146453, 1964316979, 1961466469, 1958594953,
1955702462, 1952789027, 1949854680, 1946899451, 1943923372,
1940926475, 1937908793, 1934870357, 1931811201, 1928731356,
1925630856, 1922509734, 1919368023, 1916205758, 1913022972,
1909819698, 1906595972, 1903351828, 1900087301, 1896802425,
1893497236, 1890171769, 1886826060, 1883460144, 1880074058,
1876667838, 1873241521, 1869795142, 1866328740, 1862842350,
1859336011, 1855809760, 1852263635, 1848697674, 1845111914,
1841506395, 1837881155, 1834236233, 1830571667, 1826887497,
1823183763, 1819460504, 1815717761, 1811955572, 1808173978,
1804373021, 1800552740, 1796713177, 1792854372, 1788976368,
1785079205, 1781162925, 1777227570, 1773273182, 1769299805,
1765307479, 1761296249, 1757266156, 1753217244, 1749149557,
1745063138, 1740958031, 1736834279, 1732691928, 1728531020,
1724351602, 1720153717, 1715937410, 1711702727, 1707449714,
1703178415, 1698888876, 1694581143, 1690255263, 1685911282,
1681549245, 1677169201, 1672771196, 1668355276, 1663921490,
1659469885, 1655000508, 1650513407, 1646008631, 1641486227,
1636946244, 1632388731, 1627813736, 1623221309, 1618611498,
1613984353, 1609339924, 1604678260, 1599999411, 1595303428,
1590590360, 1585860258, 1581113173, 1576349155, 1571568256,
1566770527, 1561956018, 1557124783, 1552276872, 1547412337,
1542531231, 1537633606, 1532719513, 1527789007, 1522842139,
1517878963, 1512899531, 1507903898, 1502892116, 1497864239,
1492820322, 1487760417, 1482684580, 1477592864, 1472485325,
1467362016, 1462222994, 1457068312, 1451898025, 1446712191,
1441510863, 1436294098, 1431061951, 1425814478, 1420551737,
1415273782, 1409980671, 1404672460, 1399349206, 1394010966,
1388657798, 1383289758, 1377906904, 1372509294, 1367096986,
1361670037, 1356228505, 1350772450, 1345301929, 1339817000,
1334317724, 1328804158, 1323276361, 1317734393, 1312178313,
1306608181, 1301024057, 1295425999, 1289814068, 1284188325,
1278548828, 1272895640, 1267228820, 1261548429, 1255854528,
1250147177, 1244426439, 1238692373, 1232945043, 1227184508,
1221410831, 1215624074, 1209824299, 1204011567, 1198185941,
1192347484, 1186496258, 1180632325, 1174755748, 1168866591,
1162964917, 1157050787, 1151124267, 1145185419, 1139234307,
1133270995, 1127295547, 1121308026, 1115308496, 1109297023,
1103273670, 1097238502, 1091191583, 1085132978, 1079062753,
1072980972, 1066887699, 1060783002, 1054666944, 1048539592,
1042401010, 1036251266, 1030090423, 1023918550, 1017735711,
1011541973, 1005337402, 999122065, 992896028, 986659358,
980412122, 974154386, 967886217, 961607684, 955318852,
949019790, 942710564, 936391243, 930061894, 923722585,
917373383, 911014357, 904645574, 898267104, 891879014,
885481373, 879074249, 872657710, 866231826, 859796666,
853352298, 846898791, 840436214, 833964638, 827484130,
820994760, 814496598, 807989714, 801474176, 794950056,
788417422, 781876345, 775326894, 768769141, 762203154,
755629005, 749046764, 742456501, 735858287, 729252193,
722638289, 716016646, 709387335, 702750427, 696105993,
689454104, 682794832, 676128248, 669454423, 662773428,
656085336, 649390218, 642688145, 635979190, 629263424,
622540918, 615811746, 609075979, 602333690, 595584950,
588829831, 582068407, 575300749, 568526931, 561747023,
554961100, 548169234, 541371497, 534567963, 527758704,
520943793, 514123303, 507297307, 500465878, 493629090,
486787016, 479939728, 473087301, 466229807, 459367320,
452499914, 445627662, 438750638, 431868915, 424982567,
418091668, 411196291, 404296511, 397392401, 390484035,
383571488, 376654833, 369734144, 362809495, 355880961,
348948616, 342012534, 335072790, 328129457, 321182610,
314232323, 307278671, 300321729, 293361570, 286398270,
279431902, 272462542, 265490265, 258515144, 251537254,
244556671, 237573469, 230587722, 223599506, 216608896,
209615966, 202620791, 195623446, 188624006, 181622546,
174619141, 167613866, 160606796, 153598006, 146587571,
139575567, 132562067, 125547148, 118530885, 111513352,
104494625, 97474778, 90453888, 83432030, 76409277,
69385707, 62361393, 55336412, 48310838, 41284746,
34258213, 27231312, 20204120, 13176712, 6149162,
-878453, -7906059, -14933580, -21960942, -28988068,
-36014884, -43041314, -50067283, -57092716, -64117537,
-71141672, -78165045, -85187581, -92209205, -99229841,
-106249414, -113267850, -120285073, -127301007, -134315578,
-141328711, -148340330, -155350361, -162358728, -169365356,
-176370170, -183373096, -190374058, -197372981, -204369791,
-211364411, -218356769, -225346788, -232334393, -239319511,
-246302065, -253281982, -260259186, -267233603, -274205159,
-281173778, -288139385, -295101907, -302061269, -309017396,
-315970213, -322919647, -329865622, -336808065, -343746901,
-350682056, -357613455, -364541025, -371464690, -378384377,
-385300013, -392211522, -399118830, -406021865, -412920551,
-419814815, -426704583, -433589782, -440470337, -447346176,
-454217223, -461083406, -467944652, -474800886, -481652035,
-488498026, -495338786, -502174241, -509004318, -515828944,
-522648046, -529461551, -536269386, -543071478, -549867754,
-556658141, -563442567, -570220959, -576993244, -583759350,
-590519205, -597272736, -604019870, -610760536, -617494660,
-624222173, -630943000, -637657070, -644364312, -651064652,
-657758021, -664444345, -671123554, -677795576, -684460338,
-691117771, -697767803, -704410362, -711045377, -717672778,
-724292493, -730904451, -737508582, -744104815, -750693079,
-757273304, -763845419, -770409354, -776965038, -783512402,
-790051375, -796581887, -803103868, -809617249, -816121959,
-822617929, -829105090, -835583372, -842052705, -848513021,
-854964249, -861406322, -867839170, -874262724, -880676915,
-887081675, -893476935, -899862626, -906238681, -912605031,
-918961607, -925308342, -931645168, -937972016, -944288820,
-950595511, -956892022, -963178285, -969454234, -975719800,
-981974918, -988219519, -994453537, -1000676905, -1006889557,
-1013091426, -1019282445, -1025462549, -1031631671, -1037789745,
-1043936705, -1050072485, -1056197020, -1062310244, -1068412091,
-1074502497, -1080581395, -1086648722, -1092704411, -1098748398,
-1104780618, -1110801008, -1116809501, -1122806034, -1128790543,
-1134762964, -1140723232, -1146671283, -1152607055, -1158530484,
-1164441505, -1170340057, -1176226074, -1182099496, -1187960258,
-1193808298, -1199643553, -1205465961, -1211275460, -1217071986,
-1222855479, -1228625876, -1234383115, -1240127136, -1245857875,
-1251575272, -1257279266, -1262969796, -1268646800, -1274310217,
-1279959989, -1285596052, -1291218348, -1296826816, -1302421396,
-1308002029, -1313568653, -1319121210, -1324659641, -1330183885,
-1335693885, -1341189580, -1346670912, -1352137822, -1357590252,
-1363028143, -1368451438, -1373860077, -1379254004, -1384633159,
-1389997487, -1395346928, -1400681427, -1406000925, -1411305366,
-1416594694, -1421868850, -1427127780, -1432371426, -1437599733,
-1442812644, -1448010104, -1453192057, -1458358447, -1463509220,
-1468644319, -1473763690, -1478867279, -1483955030, -1489026889,
-1494082802, -1499122714, -1504146572, -1509154322, -1514145910,
-1519121283, -1524080387, -1529023170, -1533949577, -1538859558,
-1543753058, -1548630027, -1553490410, -1558334157, -1563161216,
-1567971534, -1572765060, -1577541744, -1582301533, -1587044377,
-1591770225, -1596479027, -1601170732, -1605845289, -1610502649,
-1615142762, -1619765578, -1624371047, -1628959121, -1633529750,
-1638082885, -1642618478, -1647136479, -1651636841, -1656119516,
-1660584454, -1665031609, -1669460933, -1673872378, -1678265898,
-1682641444, -1686998971, -1691338432, -1695659779, -1699962968,
-1704247951, -1708514683, -1712763118, -1716993211, -1721204917,
-1725398189, -1729572984, -1733729257, -1737866963, -1741986057,
-1746086497, -1750168237, -1754231234, -1758275445, -1762300826,
-1766307335, -1770294927, -1774263561, -1778213194, -1782143784,
-1786055289, -1789947667, -1793820875, -1797674873, -1801509620,
-1805325074, -1809121194, -1812897940, -1816655271, -1820393147,
-1824111529, -1827810376, -1831489648, -1835149306, -1838789312,
-1842409625, -1846010208, -1849591022, -1853152028, -1856693188,
-1860214464, -1863715819, -1867197215, -1870658615, -1874099982,
-1877521279, -1880922469, -1884303515, -1887664383, -1891005035,
-1894325435, -1897625550, -1900905342, -1904164776, -1907403819,
-1910622435, -1913820590, -1916998250, -1920155379, -1923291946,
-1926407915, -1929503255, -1932577931, -1935631910, -1938665161,
-1941677650, -1944669345, -1947640214, -1950590226, -1953519348,
-1956427550, -1959314800, -1962181067, -1965026321, -1967850531,
-1970653667, -1973435699, -1976196596, -1978936331, -1981654873,
-1984352192, -1987028261, -1989683050, -1992316532, -1994928677,
-1997519459, -2000088848, -2002636818, -2005163342, -2007668391,
-2010151941, -2012613963, -2015054432, -2017473321, -2019870604,
-2022246257, -2024600252, -2026932566, -2029243173, -2031532049,
-2033799168, -2036044507, -2038268042, -2040469748, -2042649603,
-2044807583, -2046943664, -2049057824, -2051150040, -2053220291,
-2055268553, -2057294804, -2059299024, -2061281190, -2063241282,
-2065179277, -2067095157, -2068988899, -2070860485, -2072709893,
-2074537104, -2076342098, -2078124857, -2079885360, -2081623590,
-2083339527, -2085033153, -2086704450, -2088353400, -2089979985,
-2091584189, -2093165993, -2094725382, -2096262337, -2097776843,
-2099268884, -2100738443, -2102185505, -2103610054, -2105012075,
-2106391553, -2107748474, -2109082822, -2110394584, -2111683744,
-2112950291, -2114194210, -2115415487, -2116614110, -2117790065,
-2118943341, -2120073924, -2121181804, -2122266967, -2123329402,
-2124369098, -2125386044, -2126380229, -2127351642, -2128300272,
-2129226111, -2130129147, -2131009371, -2131866773, -2132701345,
-2133513078, -2134301962, -2135067990, -2135811153, -2136531442,
-2137228852, -2137903373, -2138555000, -2139183723, -2139789539,
-2140372438, -2140932416, -2141469466, -2141983583, -2142474761,
-2142942995, -2143388280, -2143810610, -2144209982, -2144586392,
-2144939834, -2145270306, -2145577804, -2145862324, -2146123864,
-2146362421, -2146577992, -2146770575, -2146940167, -2147086768,
-2147210375, -2147310987, -2147388603, -2147443222, -2147474844,
2147482929, 2147425435, 2147275952, 2147034487, 2146701050,
2146275656, 2145758322, 2145149071, 2144447929, 2143654926,
2142770096, 2141793477, 2140725111, 2139565043, 2138313323,
2136970005, 2135535146, 2134008809, 2132391057, 2130681961,
2128881593, 2126990031, 2125007356, 2122933653, 2120769010,
2118513521, 2116167282, 2113730393, 2111202959, 2108585087,
2105876892, 2103078487, 2100189994, 2097211535, 2094143239,
2090985237, 2087737664, 2084400659, 2080974365, 2077458929,
2073854502, 2070161238, 2066379295, 2062508835, 2058550025,
2054503033, 2050368032, 2046145201, 2041834720, 2037436773,
2032951550, 2028379241, 2023720043, 2018974156, 2014141783,
2009223131, 2004218410, 1999127836, 1993951625, 1988690000,
1983343186, 1977911412, 1972394912, 1966793920, 1961108677,
1955339428, 1949486417, 1943549898, 1937530123, 1931427351,
1925241843, 1918973864, 1912623682, 1906191570, 1899677803,
1893082661, 1886406424, 1879649381, 1872811820, 1865894033,
1858896318, 1851818974, 1844662304, 1837426615, 1830112217,
1822719423, 1815248550, 1807699917, 1800073849, 1792370671,
1784590714, 1776734311, 1768801799, 1760793518, 1752709809,
1744551021, 1736317502, 1728009604, 1719627685, 1711172102,
1702643219, 1694041400, 1685367013, 1676620432, 1667802029,
1658912184, 1649951276, 1640919689, 1631817811, 1622646032,
1613404744, 1604094343, 1594715227, 1585267800, 1575752465,
1566169630, 1556519705, 1546803104, 1537020244, 1527171542,
1517257422, 1507278307, 1497234626, 1487126808, 1476955286,
1466720497, 1456422878, 1446062871, 1435640919, 1425157469,
1414612971, 1404007875, 1393342636, 1382617710, 1371833558,
1360990642, 1350089425, 1339130374, 1328113960, 1317040654,
1305910930, 1294725265, 1283484138, 1272188032, 1260837429,
1249432816, 1237974681, 1226463516, 1214899813, 1203284068,
1191616778, 1179898443, 1168129565, 1156310649, 1144442200,
1132524727, 1120558740, 1108544752, 1096483278, 1084374834,
1072219940, 1060019115, 1047772882, 1035481766, 1023146293,
1010766993, 998344394, 985879030, 973371434, 960822142,
948231691, 935600622, 922929474, 910218791, 897469118,
884680999, 871854984, 858991622, 846091463, 833155061,
820182969, 807175743, 794133941, 781058120, 767948841,
754806666, 741632158, 728425880, 715188400, 701920283,
688622098, 675294414, 661937804, 648552838, 635140090,
621700135, 608233549, 594740907, 581222789, 567679774,
554112440, 540521371, 526907147, 513270353, 499611571,
485931388, 472230390, 458509162, 444768294, 431008373,
417229989, 403433732, 389620194, 375789965, 361943639,
348081809, 334205068, 320314011, 306409232, 292491328,
278560894, 264618528, 250664827, 236700388, 222725809,
208741690, 194748629, 180747225, 166738079, 152721790,
138698959, 124670187, 110636075, 96597223, 82554233,
68507707, 54458246, 40406452, 26352928, 12298274,
-1756906, -15812011, -29866438, -43919586, -57970853,
-72019637, -86065335, -100107347, -114145071, -128177904,
-142205248, -156226499, -170241059, -184248325, -198247699,
-212238581, -226220372, -240192472, -254154282, -268105206,
-282044645, -295972002, -309886680, -323788084, -337675619,
-351548688, -365406698, -379249055, -393075166, -406884440,
-420676284, -434450107, -448205320, -461941333, -475657559,
-489353409, -503028296, -516681636, -530312842, -543921332,
-557506522, -571067830, -584604676, -598116479, -611602660,
-625062643, -638495850, -651901706, -665279637, -678629069,
-691949432, -705240153, -718500664, -731730397, -744928785,
-758095263, -771229267, -784330234, -797397602, -810430813,
-823429308, -836392529, -849319923, -862210934, -875065011,
-887881603, -900660162, -913400139, -926100989, -938762167,
-951383133, -963963344, -976502263, -988999351, -1001454074,
-1013865898, -1026234291, -1038558724, -1050838668, -1063073598,
-1075262990, -1087406320, -1099503070, -1111552721, -1123554757,
-1135508663, -1147413928, -1159270041, -1171076495, -1182832785,
-1194538405, -1206192856, -1217795637, -1229346252, -1240844206,
-1252289006, -1263680162, -1275017186, -1286299593, -1297526899,
-1308698624, -1319814288, -1330873416, -1341875533, -1352820169,
-1363706855, -1374535124, -1385304512, -1396014559, -1406664805,
-1417254794, -1427784073, -1438252190, -1448658697, -1459003149,
-1469285102, -1479504115, -1489659751, -1499751576, -1509779156,
-1519742062, -1529639867, -1539472148, -1549238483, -1558938453,
-1568571644, -1578137643, -1587636039, -1597066426, -1606428400,
-1615721561, -1624945509, -1634099849, -1643184191, -1652198144,
-1661141322, -1670013342, -1678813825, -1687542393, -1696198672,
-1704782292, -1713292884, -1721730085, -1730093532, -1738382868,
-1746597738, -1754737789, -1762802673, -1770792044, -1778705561,
-1786542883, -1794303676, -1801987607, -1809594347, -1817123570,
-1824574954, -1831948179, -1839242929, -1846458892, -1853595759,
-1860653224, -1867630985, -1874528743, -1881346202, -1888083070,
-1894739060, -1901313885, -1907807264, -1914218919, -1920548575,
-1926795962, -1932960811, -1939042858, -1945041843, -1950957509,
-1956789602, -1962537873, -1968202076, -1973781967, -1979277308,
-1984687864, -1990013401, -1995253694, -2000408516, -2005477648,
-2010460871, -2015357973, -2020168744, -2024892978, -2029530472,
-2034081027, -2038544449, -2042920547, -2047209133, -2051410023,
-2055523038, -2059548001, -2063484740, -2067333086, -2071092874,
-2074763944, -2078346137, -2081839301, -2085243286, -2088557947,
-2091783140, -2094918728, -2097964577, -2100920556, -2103786539,
-2106562402, -2109248028, -2111843300, -2114348108, -2116762344,
-2119085905, -2121318692, -2123460608, -2125511562, -2127471467,
-2129340237, -2131117794, -2132804061, -2134398966, -2135902440,
-2137314419, -2138634843, -2139863654, -2141000801, -2142046235,
-2142999911, -2143861787, -2144631828, -2145310000, -2145896274,
-2146390624, -2146793031, -2147103476, -2147321946, -2147448433,
2147480773, 2147250799, 2146652904, 2145687192, 2144353827,
2142653038, 2140585116, 2138150417, 2135349356, 2132182414,
2128650133, 2124753120, 2120492040, 2115867626, 2110880668,
2105532022, 2099822604, 2093753392, 2087325426, 2080539807,
2073397699, 2065900325, 2058048970, 2049844978, 2041289756,
2032384769, 2023131544, 2013531666, 2003586779, 1993298588,
1982668856, 1971699403, 1960392110, 1948748914, 1936771810,
1924462850, 1911824143, 1898857855, 1885566207, 1871951478,
1858015999, 1843762158, 1829192399, 1814309216, 1799115162,
1783612838, 1767804901, 1751694060, 1735283075, 1718574758,
1701571972, 1684277631, 1666694698, 1648826185, 1630675154,
1612244715, 1593538026, 1574558293, 1555308768, 1535792748,
1516013578, 1495974647, 1475679389, 1455131280, 1434333842,
1413290638, 1392005275, 1370481398, 1348722696, 1326732898,
1304515771, 1282075122, 1259414796, 1236538675, 1213450681,
1190154767, 1166654927, 1142955186, 1119059606, 1094972281,
1070697338, 1046238936, 1021601267, 996788551, 971805042,
946655018, 921342790, 895872694, 870249095, 844476384,
818558976, 792501312, 766307857, 739983099, 713531549,
686957739, 660266222, 633461572, 606548381, 579531262,
552414843, 525203770, 497902707, 470516330, 443049333,
415506422, 387892316, 360211746, 332469456, 304670200,
276818739, 248919847, 220978304, 192998897, 164986421,
136945676, 108881465, 80798598, 52701887, 24596146,
-3513810, -31623164, -59727099, -87820801, -115899455,
-143958250, -171992378, -199997036, -227967426, -255898755,
-283786237, -311625094, -339410555, -367137861, -394802258,
-422399009, -449923384, -477370666, -504736154, -532015158,
-559203003, -586295032, -613286603, -640173090, -666949886,
-693612404, -720156076, -746576352, -772868706, -799028633,
-825051651, -850933300, -876669146, -902254780, -927685817,
-952957899, -978066697, -1003007909, -1027777260, -1052370507,
-1076783436, -1101011863, -1125051638, -1148898640, -1172548785,
-1195998020, -1219242327, -1242277723, -1265100260, -1287706030,
-1310091157, -1332251808, -1354184184, -1375884527, -1397349119,
-1418574283, -1439556382, -1460291820, -1480777044, -1501008545,
-1520982856, -1540696555, -1560146263, -1579328647, -1598240423,
-1616878347, -1635239228, -1653319919, -1671117323, -1688628389,
-1705850117, -1722779556, -1739413807, -1755750017, -1771785389,
-1787517174, -1802942678, -1818059257, -1832864320, -1847355332,
-1861529809, -1875385322, -1888919498, -1902130017, -1915014616,
-1927571087, -1939797279, -1951691096, -1963250501, -1974473513,
-1985358210, -1995902725, -2006105253, -2015964045, -2025477412,
-2034643724, -2043461410, -2051928960, -2060044922, -2067807906,
-2075216581, -2082269679, -2088965991, -2095304370, -2101283728,
-2106903043, -2112161350, -2117057750, -2121591402, -2125761531,
-2129567422, -2133008422, -2136083942, -2138793455, -2141136497,
-2143112666, -2144721624, -2145963095, -2146836866, -2147342788,
#else
32767, 32767, 32767, 32767, 32767,
32767, 32766, 32766, 32765, 32764,
32764, 32763, 32762, 32760, 32759,
32758, 32757, 32755, 32754, 32752,
32750, 32748, 32747, 32745, 32742,
32740, 32738, 32736, 32733, 32731,
32728, 32726, 32723, 32720, 32717,
32714, 32711, 32708, 32704, 32701,
32697, 32694, 32690, 32686, 32683,
32679, 32675, 32671, 32666, 32662,
32658, 32653, 32649, 32644, 32640,
32635, 32630, 32625, 32620, 32615,
32610, 32604, 32599, 32593, 32588,
32582, 32576, 32571, 32565, 32559,
32553, 32546, 32540, 32534, 32527,
32521, 32514, 32507, 32501, 32494,
32487, 32480, 32473, 32465, 32458,
32451, 32443, 32436, 32428, 32420,
32412, 32404, 32396, 32388, 32380,
32372, 32364, 32355, 32347, 32338,
32329, 32320, 32312, 32303, 32294,
32284, 32275, 32266, 32257, 32247,
32237, 32228, 32218, 32208, 32198,
32188, 32178, 32168, 32158, 32147,
32137, 32127, 32116, 32105, 32094,
32084, 32073, 32062, 32051, 32039,
32028, 32017, 32005, 31994, 31982,
31970, 31959, 31947, 31935, 31923,
31910, 31898, 31886, 31874, 31861,
31848, 31836, 31823, 31810, 31797,
31784, 31771, 31758, 31745, 31732,
31718, 31705, 31691, 31677, 31664,
31650, 31636, 31622, 31608, 31593,
31579, 31565, 31550, 31536, 31521,
31507, 31492, 31477, 31462, 31447,
31432, 31417, 31401, 31386, 31371,
31355, 31339, 31324, 31308, 31292,
31276, 31260, 31244, 31228, 31212,
31195, 31179, 31162, 31146, 31129,
31112, 31095, 31078, 31061, 31044,
31027, 31010, 30992, 30975, 30957,
30940, 30922, 30904, 30886, 30868,
30850, 30832, 30814, 30796, 30777,
30759, 30740, 30722, 30703, 30684,
30665, 30646, 30627, 30608, 30589,
30570, 30551, 30531, 30512, 30492,
30472, 30453, 30433, 30413, 30393,
30373, 30353, 30332, 30312, 30292,
30271, 30251, 30230, 30209, 30188,
30167, 30146, 30125, 30104, 30083,
30062, 30040, 30019, 29997, 29976,
29954, 29932, 29910, 29889, 29867,
29844, 29822, 29800, 29778, 29755,
29733, 29710, 29687, 29665, 29642,
29619, 29596, 29573, 29550, 29527,
29503, 29480, 29457, 29433, 29409,
29386, 29362, 29338, 29314, 29290,
29266, 29242, 29218, 29193, 29169,
29145, 29120, 29095, 29071, 29046,
29021, 28996, 28971, 28946, 28921,
28896, 28870, 28845, 28819, 28794,
28768, 28743, 28717, 28691, 28665,
28639, 28613, 28587, 28560, 28534,
28508, 28481, 28455, 28428, 28401,
28375, 28348, 28321, 28294, 28267,
28240, 28212, 28185, 28158, 28130,
28103, 28075, 28047, 28020, 27992,
27964, 27936, 27908, 27880, 27851,
27823, 27795, 27766, 27738, 27709,
27681, 27652, 27623, 27594, 27565,
27536, 27507, 27478, 27449, 27419,
27390, 27360, 27331, 27301, 27272,
27242, 27212, 27182, 27152, 27122,
27092, 27062, 27032, 27001, 26971,
26940, 26910, 26879, 26848, 26818,
26787, 26756, 26725, 26694, 26663,
26631, 26600, 26569, 26537, 26506,
26474, 26443, 26411, 26379, 26347,
26316, 26284, 26251, 26219, 26187,
26155, 26123, 26090, 26058, 26025,
25993, 25960, 25927, 25894, 25861,
25828, 25795, 25762, 25729, 25696,
25663, 25629, 25596, 25562, 25529,
25495, 25461, 25428, 25394, 25360,
25326, 25292, 25258, 25223, 25189,
25155, 25120, 25086, 25051, 25017,
24982, 24947, 24913, 24878, 24843,
24808, 24773, 24738, 24702, 24667,
24632, 24596, 24561, 24525, 24490,
24454, 24419, 24383, 24347, 24311,
24275, 24239, 24203, 24167, 24130,
24094, 24058, 24021, 23985, 23948,
23912, 23875, 23838, 23801, 23764,
23728, 23690, 23653, 23616, 23579,
23542, 23504, 23467, 23430, 23392,
23355, 23317, 23279, 23241, 23204,
23166, 23128, 23090, 23052, 23014,
22975, 22937, 22899, 22860, 22822,
22783, 22745, 22706, 22668, 22629,
22590, 22551, 22512, 22473, 22434,
22395, 22356, 22317, 22277, 22238,
22199, 22159, 22120, 22080, 22040,
22001, 21961, 21921, 21881, 21841,
21801, 21761, 21721, 21681, 21641,
21600, 21560, 21520, 21479, 21439,
21398, 21357, 21317, 21276, 21235,
21194, 21153, 21112, 21071, 21030,
20989, 20948, 20907, 20865, 20824,
20783, 20741, 20700, 20658, 20616,
20575, 20533, 20491, 20449, 20407,
20365, 20323, 20281, 20239, 20197,
20155, 20112, 20070, 20028, 19985,
19943, 19900, 19857, 19815, 19772,
19729, 19686, 19643, 19601, 19558,
19514, 19471, 19428, 19385, 19342,
19298, 19255, 19212, 19168, 19125,
19081, 19038, 18994, 18950, 18906,
18863, 18819, 18775, 18731, 18687,
18643, 18599, 18554, 18510, 18466,
18422, 18377, 18333, 18288, 18244,
18199, 18155, 18110, 18065, 18021,
17976, 17931, 17886, 17841, 17796,
17751, 17706, 17661, 17616, 17570,
17525, 17480, 17434, 17389, 17344,
17298, 17252, 17207, 17161, 17116,
17070, 17024, 16978, 16932, 16886,
16840, 16794, 16748, 16702, 16656,
16610, 16564, 16517, 16471, 16425,
16378, 16332, 16285, 16239, 16192,
16145, 16099, 16052, 16005, 15958,
15912, 15865, 15818, 15771, 15724,
15677, 15630, 15583, 15535, 15488,
15441, 15394, 15346, 15299, 15251,
15204, 15156, 15109, 15061, 15014,
14966, 14918, 14870, 14823, 14775,
14727, 14679, 14631, 14583, 14535,
14487, 14439, 14391, 14342, 14294,
14246, 14198, 14149, 14101, 14053,
14004, 13956, 13907, 13858, 13810,
13761, 13713, 13664, 13615, 13566,
13517, 13469, 13420, 13371, 13322,
13273, 13224, 13175, 13126, 13076,
13027, 12978, 12929, 12880, 12830,
12781, 12731, 12682, 12633, 12583,
12534, 12484, 12434, 12385, 12335,
12285, 12236, 12186, 12136, 12086,
12037, 11987, 11937, 11887, 11837,
11787, 11737, 11687, 11637, 11586,
11536, 11486, 11436, 11386, 11335,
11285, 11235, 11184, 11134, 11083,
11033, 10982, 10932, 10881, 10831,
10780, 10729, 10679, 10628, 10577,
10527, 10476, 10425, 10374, 10323,
10272, 10221, 10170, 10119, 10068,
10017, 9966, 9915, 9864, 9813,
9762, 9711, 9659, 9608, 9557,
9506, 9454, 9403, 9352, 9300,
9249, 9197, 9146, 9094, 9043,
8991, 8940, 8888, 8836, 8785,
8733, 8681, 8630, 8578, 8526,
8475, 8423, 8371, 8319, 8267,
8215, 8163, 8111, 8059, 8007,
7955, 7903, 7851, 7799, 7747,
7695, 7643, 7591, 7539, 7487,
7434, 7382, 7330, 7278, 7225,
7173, 7121, 7068, 7016, 6964,
6911, 6859, 6806, 6754, 6701,
6649, 6596, 6544, 6491, 6439,
6386, 6334, 6281, 6228, 6176,
6123, 6070, 6018, 5965, 5912,
5859, 5807, 5754, 5701, 5648,
5595, 5543, 5490, 5437, 5384,
5331, 5278, 5225, 5172, 5119,
5066, 5013, 4960, 4907, 4854,
4801, 4748, 4695, 4642, 4589,
4536, 4483, 4430, 4377, 4324,
4270, 4217, 4164, 4111, 4058,
4005, 3951, 3898, 3845, 3792,
3738, 3685, 3632, 3578, 3525,
3472, 3419, 3365, 3312, 3259,
3205, 3152, 3098, 3045, 2992,
2938, 2885, 2831, 2778, 2725,
2671, 2618, 2564, 2511, 2457,
2404, 2350, 2297, 2243, 2190,
2136, 2083, 2029, 1976, 1922,
1869, 1815, 1762, 1708, 1655,
1601, 1548, 1494, 1440, 1387,
1333, 1280, 1226, 1173, 1119,
1065, 1012, 958, 905, 851,
797, 744, 690, 637, 583,
529, 476, 422, 369, 315,
261, 208, 154, 101, 47,
-7, -60, -114, -168, -221,
-275, -328, -382, -436, -489,
-543, -596, -650, -704, -757,
-811, -864, -918, -972, -1025,
-1079, -1132, -1186, -1240, -1293,
-1347, -1400, -1454, -1507, -1561,
-1615, -1668, -1722, -1775, -1829,
-1882, -1936, -1989, -2043, -2096,
-2150, -2203, -2257, -2310, -2364,
-2417, -2471, -2524, -2578, -2631,
-2685, -2738, -2791, -2845, -2898,
-2952, -3005, -3058, -3112, -3165,
-3218, -3272, -3325, -3379, -3432,
-3485, -3538, -3592, -3645, -3698,
-3752, -3805, -3858, -3911, -3965,
-4018, -4071, -4124, -4177, -4231,
-4284, -4337, -4390, -4443, -4496,
-4549, -4602, -4656, -4709, -4762,
-4815, -4868, -4921, -4974, -5027,
-5080, -5133, -5186, -5239, -5291,
-5344, -5397, -5450, -5503, -5556,
-5609, -5662, -5714, -5767, -5820,
-5873, -5925, -5978, -6031, -6083,
-6136, -6189, -6241, -6294, -6347,
-6399, -6452, -6504, -6557, -6609,
-6662, -6714, -6767, -6819, -6872,
-6924, -6977, -7029, -7081, -7134,
-7186, -7238, -7291, -7343, -7395,
-7447, -7500, -7552, -7604, -7656,
-7708, -7760, -7812, -7864, -7916,
-7968, -8020, -8072, -8124, -8176,
-8228, -8280, -8332, -8384, -8436,
-8487, -8539, -8591, -8643, -8694,
-8746, -8798, -8849, -8901, -8953,
-9004, -9056, -9107, -9159, -9210,
-9262, -9313, -9364, -9416, -9467,
-9518, -9570, -9621, -9672, -9723,
-9775, -9826, -9877, -9928, -9979,
-10030, -10081, -10132, -10183, -10234,
-10285, -10336, -10387, -10438, -10488,
-10539, -10590, -10641, -10691, -10742,
-10793, -10843, -10894, -10945, -10995,
-11046, -11096, -11146, -11197, -11247,
-11298, -11348, -11398, -11448, -11499,
-11549, -11599, -11649, -11699, -11749,
-11799, -11849, -11899, -11949, -11999,
-12049, -12099, -12149, -12198, -12248,
-12298, -12348, -12397, -12447, -12496,
-12546, -12595, -12645, -12694, -12744,
-12793, -12843, -12892, -12941, -12990,
-13040, -13089, -13138, -13187, -13236,
-13285, -13334, -13383, -13432, -13481,
-13530, -13579, -13627, -13676, -13725,
-13773, -13822, -13871, -13919, -13968,
-14016, -14065, -14113, -14161, -14210,
-14258, -14306, -14355, -14403, -14451,
-14499, -14547, -14595, -14643, -14691,
-14739, -14787, -14835, -14882, -14930,
-14978, -15025, -15073, -15121, -15168,
-15216, -15263, -15311, -15358, -15405,
-15453, -15500, -15547, -15594, -15641,
-15689, -15736, -15783, -15830, -15876,
-15923, -15970, -16017, -16064, -16110,
-16157, -16204, -16250, -16297, -16343,
-16390, -16436, -16483, -16529, -16575,
-16621, -16668, -16714, -16760, -16806,
-16852, -16898, -16944, -16990, -17035,
-17081, -17127, -17173, -17218, -17264,
-17309, -17355, -17400, -17446, -17491,
-17536, -17582, -17627, -17672, -17717,
-17762, -17807, -17852, -17897, -17942,
-17987, -18032, -18077, -18121, -18166,
-18210, -18255, -18300, -18344, -18388,
-18433, -18477, -18521, -18566, -18610,
-18654, -18698, -18742, -18786, -18830,
-18874, -18917, -18961, -19005, -19048,
-19092, -19136, -19179, -19223, -19266,
-19309, -19353, -19396, -19439, -19482,
-19525, -19568, -19611, -19654, -19697,
-19740, -19783, -19825, -19868, -19911,
-19953, -19996, -20038, -20081, -20123,
-20165, -20207, -20250, -20292, -20334,
-20376, -20418, -20460, -20502, -20543,
-20585, -20627, -20668, -20710, -20752,
-20793, -20834, -20876, -20917, -20958,
-20999, -21041, -21082, -21123, -21164,
-21205, -21245, -21286, -21327, -21368,
-21408, -21449, -21489, -21530, -21570,
-21610, -21651, -21691, -21731, -21771,
-21811, -21851, -21891, -21931, -21971,
-22011, -22050, -22090, -22130, -22169,
-22208, -22248, -22287, -22326, -22366,
-22405, -22444, -22483, -22522, -22561,
-22600, -22639, -22677, -22716, -22755,
-22793, -22832, -22870, -22908, -22947,
-22985, -23023, -23061, -23099, -23137,
-23175, -23213, -23251, -23289, -23326,
-23364, -23402, -23439, -23476, -23514,
-23551, -23588, -23626, -23663, -23700,
-23737, -23774, -23811, -23847, -23884,
-23921, -23957, -23994, -24030, -24067,
-24103, -24139, -24176, -24212, -24248,
-24284, -24320, -24356, -24392, -24427,
-24463, -24499, -24534, -24570, -24605,
-24641, -24676, -24711, -24746, -24782,
-24817, -24852, -24886, -24921, -24956,
-24991, -25025, -25060, -25095, -25129,
-25163, -25198, -25232, -25266, -25300,
-25334, -25368, -25402, -25436, -25470,
-25503, -25537, -25571, -25604, -25638,
-25671, -25704, -25737, -25771, -25804,
-25837, -25870, -25902, -25935, -25968,
-26001, -26033, -26066, -26098, -26131,
-26163, -26195, -26227, -26259, -26292,
-26323, -26355, -26387, -26419, -26451,
-26482, -26514, -26545, -26577, -26608,
-26639, -26670, -26702, -26733, -26764,
-26794, -26825, -26856, -26887, -26917,
-26948, -26978, -27009, -27039, -27069,
-27100, -27130, -27160, -27190, -27220,
-27249, -27279, -27309, -27338, -27368,
-27397, -27427, -27456, -27485, -27514,
-27543, -27572, -27601, -27630, -27659,
-27688, -27716, -27745, -27773, -27802,
-27830, -27858, -27887, -27915, -27943,
-27971, -27999, -28026, -28054, -28082,
-28109, -28137, -28164, -28192, -28219,
-28246, -28273, -28301, -28328, -28354,
-28381, -28408, -28435, -28461, -28488,
-28514, -28541, -28567, -28593, -28619,
-28645, -28671, -28697, -28723, -28749,
-28775, -28800, -28826, -28851, -28877,
-28902, -28927, -28952, -28977, -29002,
-29027, -29052, -29077, -29102, -29126,
-29151, -29175, -29200, -29224, -29248,
-29272, -29296, -29320, -29344, -29368,
-29392, -29415, -29439, -29462, -29486,
-29509, -29532, -29556, -29579, -29602,
-29625, -29648, -29670, -29693, -29716,
-29738, -29761, -29783, -29806, -29828,
-29850, -29872, -29894, -29916, -29938,
-29960, -29981, -30003, -30024, -30046,
-30067, -30088, -30110, -30131, -30152,
-30173, -30194, -30214, -30235, -30256,
-30276, -30297, -30317, -30337, -30358,
-30378, -30398, -30418, -30438, -30458,
-30477, -30497, -30516, -30536, -30555,
-30575, -30594, -30613, -30632, -30651,
-30670, -30689, -30708, -30726, -30745,
-30763, -30782, -30800, -30819, -30837,
-30855, -30873, -30891, -30909, -30926,
-30944, -30962, -30979, -30997, -31014,
-31031, -31048, -31065, -31082, -31099,
-31116, -31133, -31150, -31166, -31183,
-31199, -31216, -31232, -31248, -31264,
-31280, -31296, -31312, -31328, -31343,
-31359, -31374, -31390, -31405, -31421,
-31436, -31451, -31466, -31481, -31496,
-31510, -31525, -31540, -31554, -31568,
-31583, -31597, -31611, -31625, -31639,
-31653, -31667, -31681, -31694, -31708,
-31721, -31735, -31748, -31761, -31775,
-31788, -31801, -31813, -31826, -31839,
-31852, -31864, -31877, -31889, -31901,
-31914, -31926, -31938, -31950, -31961,
-31973, -31985, -31997, -32008, -32020,
-32031, -32042, -32053, -32064, -32075,
-32086, -32097, -32108, -32119, -32129,
-32140, -32150, -32160, -32171, -32181,
-32191, -32201, -32211, -32221, -32230,
-32240, -32249, -32259, -32268, -32278,
-32287, -32296, -32305, -32314, -32323,
-32331, -32340, -32349, -32357, -32366,
-32374, -32382, -32390, -32398, -32406,
-32414, -32422, -32430, -32437, -32445,
-32453, -32460, -32467, -32474, -32482,
-32489, -32495, -32502, -32509, -32516,
-32522, -32529, -32535, -32542, -32548,
-32554, -32560, -32566, -32572, -32578,
-32584, -32589, -32595, -32600, -32606,
-32611, -32616, -32621, -32626, -32631,
-32636, -32641, -32645, -32650, -32655,
-32659, -32663, -32668, -32672, -32676,
-32680, -32684, -32687, -32691, -32695,
-32698, -32702, -32705, -32708, -32712,
-32715, -32718, -32721, -32723, -32726,
-32729, -32731, -32734, -32736, -32739,
-32741, -32743, -32745, -32747, -32749,
-32751, -32752, -32754, -32756, -32757,
-32758, -32760, -32761, -32762, -32763,
-32764, -32765, -32765, -32766, -32766,
-32767, -32767, -32767, -32767, -32767,
32767, 32767, 32767, 32766, 32765,
32763, 32761, 32759, 32756, 32753,
32750, 32746, 32742, 32738, 32733,
32728, 32722, 32717, 32710, 32704,
32697, 32690, 32682, 32674, 32666,
32657, 32648, 32639, 32629, 32619,
32609, 32598, 32587, 32576, 32564,
32552, 32539, 32526, 32513, 32500,
32486, 32472, 32457, 32442, 32427,
32411, 32395, 32379, 32362, 32345,
32328, 32310, 32292, 32274, 32255,
32236, 32217, 32197, 32177, 32157,
32136, 32115, 32093, 32071, 32049,
32027, 32004, 31981, 31957, 31933,
31909, 31884, 31859, 31834, 31809,
31783, 31756, 31730, 31703, 31676,
31648, 31620, 31592, 31563, 31534,
31505, 31475, 31445, 31415, 31384,
31353, 31322, 31290, 31258, 31226,
31193, 31160, 31127, 31093, 31059,
31025, 30990, 30955, 30920, 30884,
30848, 30812, 30775, 30738, 30701,
30663, 30625, 30587, 30548, 30509,
30470, 30430, 30390, 30350, 30309,
30269, 30227, 30186, 30144, 30102,
30059, 30016, 29973, 29930, 29886,
29842, 29797, 29752, 29707, 29662,
29616, 29570, 29524, 29477, 29430,
29383, 29335, 29287, 29239, 29190,
29142, 29092, 29043, 28993, 28943,
28892, 28842, 28791, 28739, 28688,
28636, 28583, 28531, 28478, 28425,
28371, 28317, 28263, 28209, 28154,
28099, 28044, 27988, 27932, 27876,
27820, 27763, 27706, 27648, 27591,
27533, 27474, 27416, 27357, 27298,
27238, 27178, 27118, 27058, 26997,
26936, 26875, 26814, 26752, 26690,
26628, 26565, 26502, 26439, 26375,
26312, 26247, 26183, 26119, 26054,
25988, 25923, 25857, 25791, 25725,
25658, 25592, 25524, 25457, 25389,
25322, 25253, 25185, 25116, 25047,
24978, 24908, 24838, 24768, 24698,
24627, 24557, 24485, 24414, 24342,
24270, 24198, 24126, 24053, 23980,
23907, 23834, 23760, 23686, 23612,
23537, 23462, 23387, 23312, 23237,
23161, 23085, 23009, 22932, 22856,
22779, 22701, 22624, 22546, 22468,
22390, 22312, 22233, 22154, 22075,
21996, 21916, 21836, 21756, 21676,
21595, 21515, 21434, 21352, 21271,
21189, 21107, 21025, 20943, 20860,
20777, 20694, 20611, 20528, 20444,
20360, 20276, 20192, 20107, 20022,
19937, 19852, 19767, 19681, 19595,
19509, 19423, 19336, 19250, 19163,
19076, 18988, 18901, 18813, 18725,
18637, 18549, 18460, 18372, 18283,
18194, 18104, 18015, 17925, 17835,
17745, 17655, 17565, 17474, 17383,
17292, 17201, 17110, 17018, 16927,
16835, 16743, 16650, 16558, 16465,
16372, 16279, 16186, 16093, 15999,
15906, 15812, 15718, 15624, 15529,
15435, 15340, 15245, 15150, 15055,
14960, 14864, 14769, 14673, 14577,
14481, 14385, 14288, 14192, 14095,
13998, 13901, 13804, 13706, 13609,
13511, 13414, 13316, 13218, 13119,
13021, 12923, 12824, 12725, 12626,
12527, 12428, 12329, 12230, 12130,
12030, 11930, 11831, 11730, 11630,
11530, 11430, 11329, 11228, 11128,
11027, 10926, 10824, 10723, 10622,
10520, 10419, 10317, 10215, 10113,
10011, 9909, 9807, 9704, 9602,
9499, 9397, 9294, 9191, 9088,
8985, 8882, 8778, 8675, 8572,
8468, 8364, 8261, 8157, 8053,
7949, 7845, 7741, 7637, 7532,
7428, 7323, 7219, 7114, 7009,
6905, 6800, 6695, 6590, 6485,
6380, 6274, 6169, 6064, 5958,
5853, 5747, 5642, 5536, 5430,
5325, 5219, 5113, 5007, 4901,
4795, 4689, 4583, 4476, 4370,
4264, 4157, 4051, 3945, 3838,
3732, 3625, 3518, 3412, 3305,
3198, 3092, 2985, 2878, 2771,
2664, 2558, 2451, 2344, 2237,
2130, 2023, 1916, 1809, 1702,
1594, 1487, 1380, 1273, 1166,
1059, 952, 844, 737, 630,
523, 416, 308, 201, 94,
-13, -121, -228, -335, -442,
-550, -657, -764, -871, -978,
-1086, -1193, -1300, -1407, -1514,
-1621, -1728, -1835, -1942, -2049,
-2157, -2263, -2370, -2477, -2584,
-2691, -2798, -2905, -3012, -3118,
-3225, -3332, -3439, -3545, -3652,
-3758, -3865, -3971, -4078, -4184,
-4290, -4397, -4503, -4609, -4715,
-4821, -4927, -5033, -5139, -5245,
-5351, -5457, -5562, -5668, -5774,
-5879, -5985, -6090, -6195, -6301,
-6406, -6511, -6616, -6721, -6826,
-6931, -7036, -7140, -7245, -7349,
-7454, -7558, -7663, -7767, -7871,
-7975, -8079, -8183, -8287, -8390,
-8494, -8597, -8701, -8804, -8907,
-9011, -9114, -9217, -9319, -9422,
-9525, -9627, -9730, -9832, -9934,
-10037, -10139, -10241, -10342, -10444,
-10546, -10647, -10748, -10850, -10951,
-11052, -11153, -11253, -11354, -11455,
-11555, -11655, -11756, -11856, -11955,
-12055, -12155, -12254, -12354, -12453,
-12552, -12651, -12750, -12849, -12947,
-13046, -13144, -13242, -13340, -13438,
-13536, -13633, -13731, -13828, -13925,
-14022, -14119, -14216, -14312, -14409,
-14505, -14601, -14697, -14793, -14888,
-14984, -15079, -15174, -15269, -15364,
-15459, -15553, -15647, -15741, -15835,
-15929, -16023, -16116, -16210, -16303,
-16396, -16488, -16581, -16673, -16766,
-16858, -16949, -17041, -17133, -17224,
-17315, -17406, -17497, -17587, -17678,
-17768, -17858, -17948, -18037, -18127,
-18216, -18305, -18394, -18483, -18571,
-18659, -18747, -18835, -18923, -19010,
-19098, -19185, -19271, -19358, -19444,
-19531, -19617, -19702, -19788, -19873,
-19959, -20043, -20128, -20213, -20297,
-20381, -20465, -20549, -20632, -20715,
-20798, -20881, -20963, -21046, -21128,
-21210, -21291, -21373, -21454, -21535,
-21616, -21696, -21776, -21856, -21936,
-22016, -22095, -22174, -22253, -22331,
-22410, -22488, -22566, -22643, -22721,
-22798, -22875, -22951, -23028, -23104,
-23180, -23256, -23331, -23406, -23481,
-23556, -23630, -23704, -23778, -23852,
-23925, -23998, -24071, -24144, -24216,
-24288, -24360, -24432, -24503, -24574,
-24645, -24716, -24786, -24856, -24926,
-24995, -25064, -25133, -25202, -25270,
-25339, -25406, -25474, -25541, -25608,
-25675, -25742, -25808, -25874, -25939,
-26005, -26070, -26135, -26199, -26264,
-26327, -26391, -26455, -26518, -26581,
-26643, -26705, -26767, -26829, -26891,
-26952, -27013, -27073, -27133, -27193,
-27253, -27312, -27372, -27430, -27489,
-27547, -27605, -27663, -27720, -27777,
-27834, -27890, -27946, -28002, -28058,
-28113, -28168, -28223, -28277, -28331,
-28385, -28438, -28491, -28544, -28596,
-28649, -28701, -28752, -28803, -28854,
-28905, -28955, -29006, -29055, -29105,
-29154, -29203, -29251, -29299, -29347,
-29395, -29442, -29489, -29535, -29582,
-29628, -29673, -29719, -29764, -29808,
-29853, -29897, -29941, -29984, -30027,
-30070, -30112, -30154, -30196, -30238,
-30279, -30320, -30360, -30400, -30440,
-30480, -30519, -30558, -30596, -30635,
-30672, -30710, -30747, -30784, -30821,
-30857, -30893, -30929, -30964, -30999,
-31033, -31068, -31102, -31135, -31168,
-31201, -31234, -31266, -31298, -31330,
-31361, -31392, -31422, -31453, -31483,
-31512, -31541, -31570, -31599, -31627,
-31655, -31682, -31710, -31737, -31763,
-31789, -31815, -31841, -31866, -31891,
-31915, -31939, -31963, -31986, -32010,
-32032, -32055, -32077, -32099, -32120,
-32141, -32162, -32182, -32202, -32222,
-32241, -32260, -32279, -32297, -32315,
-32333, -32350, -32367, -32383, -32399,
-32415, -32431, -32446, -32461, -32475,
-32489, -32503, -32517, -32530, -32542,
-32555, -32567, -32579, -32590, -32601,
-32612, -32622, -32632, -32641, -32651,
-32659, -32668, -32676, -32684, -32692,
-32699, -32706, -32712, -32718, -32724,
-32729, -32734, -32739, -32743, -32747,
-32751, -32754, -32757, -32760, -32762,
-32764, -32765, -32767, -32767, -32767,
32767, 32767, 32765, 32761, 32756,
32750, 32742, 32732, 32722, 32710,
32696, 32681, 32665, 32647, 32628,
32608, 32586, 32562, 32538, 32512,
32484, 32455, 32425, 32393, 32360,
32326, 32290, 32253, 32214, 32174,
32133, 32090, 32046, 32001, 31954,
31906, 31856, 31805, 31753, 31700,
31645, 31588, 31530, 31471, 31411,
31349, 31286, 31222, 31156, 31089,
31020, 30951, 30880, 30807, 30733,
30658, 30582, 30504, 30425, 30345,
30263, 30181, 30096, 30011, 29924,
29836, 29747, 29656, 29564, 29471,
29377, 29281, 29184, 29086, 28987,
28886, 28784, 28681, 28577, 28471,
28365, 28257, 28147, 28037, 27925,
27812, 27698, 27583, 27467, 27349,
27231, 27111, 26990, 26868, 26744,
26620, 26494, 26367, 26239, 26110,
25980, 25849, 25717, 25583, 25449,
25313, 25176, 25038, 24900, 24760,
24619, 24477, 24333, 24189, 24044,
23898, 23751, 23602, 23453, 23303,
23152, 22999, 22846, 22692, 22537,
22380, 22223, 22065, 21906, 21746,
21585, 21423, 21261, 21097, 20933,
20767, 20601, 20434, 20265, 20096,
19927, 19756, 19584, 19412, 19239,
19065, 18890, 18714, 18538, 18361,
18183, 18004, 17824, 17644, 17463,
17281, 17098, 16915, 16731, 16546,
16361, 16175, 15988, 15800, 15612,
15423, 15234, 15043, 14852, 14661,
14469, 14276, 14083, 13889, 13694,
13499, 13303, 13107, 12910, 12713,
12515, 12317, 12118, 11918, 11718,
11517, 11316, 11115, 10913, 10710,
10508, 10304, 10100, 9896, 9691,
9486, 9281, 9075, 8869, 8662,
8455, 8248, 8040, 7832, 7623,
7415, 7206, 6996, 6787, 6577,
6366, 6156, 5945, 5734, 5523,
5311, 5100, 4888, 4675, 4463,
4251, 4038, 3825, 3612, 3399,
3185, 2972, 2758, 2544, 2330,
2116, 1902, 1688, 1474, 1260,
1045, 831, 617, 402, 188,
-27, -241, -456, -670, -885,
-1099, -1313, -1528, -1742, -1956,
-2170, -2384, -2598, -2811, -3025,
-3239, -3452, -3665, -3878, -4091,
-4304, -4516, -4728, -4941, -5153,
-5364, -5576, -5787, -5998, -6209,
-6419, -6629, -6839, -7049, -7258,
-7467, -7676, -7884, -8092, -8300,
-8507, -8714, -8920, -9127, -9332,
-9538, -9743, -9947, -10151, -10355,
-10558, -10761, -10963, -11165, -11367,
-11568, -11768, -11968, -12167, -12366,
-12565, -12762, -12960, -13156, -13352,
-13548, -13743, -13937, -14131, -14324,
-14517, -14709, -14900, -15091, -15281,
-15470, -15659, -15847, -16035, -16221,
-16407, -16593, -16777, -16961, -17144,
-17326, -17508, -17689, -17869, -18049,
-18227, -18405, -18582, -18758, -18934,
-19108, -19282, -19455, -19627, -19799,
-19969, -20139, -20308, -20475, -20642,
-20809, -20974, -21138, -21301, -21464,
-21626, -21786, -21946, -22105, -22263,
-22420, -22575, -22730, -22884, -23037,
-23189, -23340, -23490, -23640, -23788,
-23935, -24080, -24225, -24369, -24512,
-24654, -24795, -24934, -25073, -25211,
-25347, -25482, -25617, -25750, -25882,
-26013, -26143, -26272, -26399, -26526,
-26651, -26775, -26898, -27020, -27141,
-27260, -27379, -27496, -27612, -27727,
-27841, -27953, -28065, -28175, -28284,
-28391, -28498, -28603, -28707, -28810,
-28911, -29012, -29111, -29209, -29305,
-29401, -29495, -29587, -29679, -29769,
-29858, -29946, -30032, -30118, -30201,
-30284, -30365, -30445, -30524, -30601,
-30677, -30752, -30825, -30897, -30968,
-31038, -31106, -31172, -31238, -31302,
-31365, -31426, -31486, -31545, -31602,
-31658, -31713, -31766, -31818, -31869,
-31918, -31966, -32012, -32058, -32101,
-32144, -32185, -32224, -32262, -32299,
-32335, -32369, -32401, -32433, -32463,
-32491, -32518, -32544, -32568, -32591,
-32613, -32633, -32652, -32669, -32685,
-32700, -32713, -32724, -32735, -32744,
-32751, -32757, -32762, -32766, -32767,
32767, 32764, 32755, 32741, 32720,
32694, 32663, 32626, 32583, 32535,
32481, 32421, 32356, 32286, 32209,
32128, 32041, 31948, 31850, 31747,
31638, 31523, 31403, 31278, 31148,
31012, 30871, 30724, 30572, 30415,
30253, 30086, 29913, 29736, 29553,
29365, 29172, 28974, 28771, 28564,
28351, 28134, 27911, 27684, 27452,
27216, 26975, 26729, 26478, 26223,
25964, 25700, 25432, 25159, 24882,
24601, 24315, 24026, 23732, 23434,
23133, 22827, 22517, 22204, 21886,
21565, 21240, 20912, 20580, 20244,
19905, 19563, 19217, 18868, 18516,
18160, 17802, 17440, 17075, 16708,
16338, 15964, 15588, 15210, 14829,
14445, 14059, 13670, 13279, 12886,
12490, 12093, 11693, 11291, 10888,
10482, 10075, 9666, 9255, 8843,
8429, 8014, 7597, 7180, 6760,
6340, 5919, 5496, 5073, 4649,
4224, 3798, 3372, 2945, 2517,
2090, 1661, 1233, 804, 375,
-54, -483, -911, -1340, -1768,
-2197, -2624, -3052, -3479, -3905,
-4330, -4755, -5179, -5602, -6024,
-6445, -6865, -7284, -7702, -8118,
-8533, -8946, -9358, -9768, -10177,
-10584, -10989, -11392, -11793, -12192,
-12589, -12984, -13377, -13767, -14155,
-14541, -14924, -15305, -15683, -16058,
-16430, -16800, -17167, -17531, -17892,
-18249, -18604, -18956, -19304, -19649,
-19990, -20329, -20663, -20994, -21322,
-21646, -21966, -22282, -22595, -22904,
-23208, -23509, -23806, -24099, -24387,
-24672, -24952, -25228, -25499, -25766,
-26029, -26288, -26541, -26791, -27035,
-27275, -27511, -27741, -27967, -28188,
-28405, -28616, -28823, -29024, -29221,
-29412, -29599, -29780, -29957, -30128,
-30294, -30455, -30611, -30761, -30906,
-31046, -31181, -31310, -31434, -31552,
-31665, -31773, -31875, -31972, -32063,
-32149, -32229, -32304, -32373, -32437,
-32495, -32547, -32594, -32635, -32671,
-32701, -32726, -32745, -32758, -32766,
#endif
};
#endif

static const CELTMode mode96000_1920_240 = {
96000,    /* Fs */
240,    /* overlap */
21,    /* nbEBands */
21,    /* effEBands */
{30245, 7209, 6197, 5415, },    /* preemph */
eband5ms,    /* eBands */
3,    /* maxLM */
8,    /* nbShortMdcts */
240,    /* shortMdctSize */
11,    /* nbAllocVectors */
band_allocation,    /* allocVectors */
logN400,    /* logN */
window240,    /* window */
{3840, 3, {&fft_state96000_1920_0, &fft_state96000_1920_1, &fft_state96000_1920_2, &fft_state96000_1920_3, }, mdct_twiddles1920},    /* mdct */
{392, cache_index50, cache_bits50, cache_caps50},    /* cache */
#ifdef ENABLE_QEXT
{86, qext_cache_index50, qext_cache_bits50, qext_cache_caps50},    /* qext_cache */
#endif
};
#endif /* ENABLE_QEXT */

/* List of all the available modes */
#ifdef ENABLE_QEXT
#define TOTAL_MODES 2
static const CELTMode * const static_mode_list[TOTAL_MODES] = {
&mode48000_960_120,
&mode96000_1920_240,
};
#else
#define TOTAL_MODES 1
static const CELTMode * const static_mode_list[TOTAL_MODES] = {
&mode48000_960_120,
};
#endif
