#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cats Hidden in Places expansions:
# - Cats Hidden in Paris - Extra level
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241016.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID_PARIS='cats-hidden-in-paris'
GAME_NAME_PARIS='Cats Hidden in Paris'

EXPANSION_ID_PARIS='extra-level'
EXPANSION_NAME_PARIS='Extra level'

# Archives

## Cats Hidden in Paris - Extra level

ARCHIVE_BASE_PARIS_0_NAME='setup_cats_hidden_in_paris_-_extra_level_1.0_gog_dlc_fix6_(69829).exe'
ARCHIVE_BASE_PARIS_0_MD5='d440ba3300af973579e5cef269b94962'
ARCHIVE_BASE_PARIS_0_TYPE='innosetup'
ARCHIVE_BASE_PARIS_0_SIZE='6687'
ARCHIVE_BASE_PARIS_0_VERSION='1.0-gog69829'
ARCHIVE_BASE_PARIS_0_URL='https://www.gog.com/game/cats_hidden_in_paris_extra_level'


CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES_PARIS='
goggame-2143975614.info'

PKG_PARENT_ID_PARIS="$GAME_ID_PARIS"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
