#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Grim Legends series:
# - Grim Legends: The Forsaken Bride
# - Grim Legends 2: Song of the Dark Swan
# - Grim Legends 3: The Dark City
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241224.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID_BRIDE='grim-legends-1'
GAME_NAME_BRIDE='Grim Legends: The Forsaken Bride'

GAME_ID_SWAN='grim-legends-2'
GAME_NAME_SWAN='Grim Legends 2: Song of the Dark Swan'

GAME_ID_CITY='grim-legends-3'
GAME_NAME_CITY='Grim Legends 3: The Dark City'

ARCHIVE_BASE_BRIDE_EN_0_NAME='grim_legends_the_forsaken_bride_gog_1_25983.sh'
ARCHIVE_BASE_BRIDE_EN_0_MD5='3200efbc08fd59726bf9cedaadc8dee4'
ARCHIVE_BASE_BRIDE_EN_0_SIZE='2507375'
ARCHIVE_BASE_BRIDE_EN_0_VERSION='1.0-gog25983'
ARCHIVE_BASE_BRIDE_EN_0_URL='https://www.gog.com/game/grim_legends_the_forsaken_bride'

ARCHIVE_BASE_BRIDE_FR_0_NAME='grim_legends_the_forsaken_bride_french_gog_1_25983.sh'
ARCHIVE_BASE_BRIDE_FR_0_MD5='ef7c7798d16b384eae58f89c8c09a753'
ARCHIVE_BASE_BRIDE_FR_0_SIZE='2507374'
ARCHIVE_BASE_BRIDE_FR_0_VERSION='1.0-gog25983'
ARCHIVE_BASE_BRIDE_FR_0_URL='https://www.gog.com/game/grim_legends_the_forsaken_bride'

ARCHIVE_BASE_SWAN_EN_0_NAME='grim_legends_2_song_of_the_dark_swan_gog_1_25983.sh'
ARCHIVE_BASE_SWAN_EN_0_MD5='6add597284fece79a12410cd50c914d8'
ARCHIVE_BASE_SWAN_EN_0_SIZE='1007775'
ARCHIVE_BASE_SWAN_EN_0_VERSION='1.0-gog25983'
ARCHIVE_BASE_SWAN_EN_0_URL='https://www.gog.com/game/grim_legends_2_song_of_the_dark_swan'

ARCHIVE_BASE_SWAN_FR_0_NAME='grim_legends_2_song_of_the_dark_swan_french_gog_1_25983.sh'
ARCHIVE_BASE_SWAN_FR_0_MD5='c87bffef7cbd2450ebda37cb5242b9af'
ARCHIVE_BASE_SWAN_FR_0_SIZE='1007755'
ARCHIVE_BASE_SWAN_FR_0_VERSION='1.0-gog25983'
ARCHIVE_BASE_SWAN_FR_0_URL='https://www.gog.com/game/grim_legends_2_song_of_the_dark_swan'

ARCHIVE_BASE_CITY_EN_0_NAME='grim_legends_3_the_dark_city_gog_1_25984.sh'
ARCHIVE_BASE_CITY_EN_0_MD5='57cb3309f7207a6d2a1a7db811d63117'
ARCHIVE_BASE_CITY_EN_0_SIZE='1131903'
ARCHIVE_BASE_CITY_EN_0_VERSION='1.0-gog25984'
ARCHIVE_BASE_CITY_EN_0_URL='https://www.gog.com/game/grim_legends_3_the_dark_city'

ARCHIVE_BASE_CITY_FR_0_NAME='grim_legends_3_the_dark_city_french_gog_1_25984.sh'
ARCHIVE_BASE_CITY_FR_0_MD5='9c6d027fe97b10d6dbc7b1544288aaea'
ARCHIVE_BASE_CITY_FR_0_SIZE='1132071'
ARCHIVE_BASE_CITY_FR_0_VERSION='1.0-gog25984'
ARCHIVE_BASE_CITY_FR_0_URL='https://www.gog.com/game/grim_legends_3_the_dark_city'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
*_amd64'
CONTENT_GAME_BIN32_FILES='
*_i386'
CONTENT_GAME_L10N_FILES='
Game_??.cub
Game_768_??.cub
Game_900_??.cub
Game_1080_??.cub
Game_1080_900_??.cub'
CONTENT_GAME_DATA_FILES='
Game
Game.cub
Game_768.cub
Game_900.cub
Game_1080.cub
Game_1080_900.cub
*.json'

FAKE_HOME_PERSISTENT_DIRECTORIES='
.Artifex Mundi'

APP_MAIN_EXE_BIN64_BRIDE='GrimLegends_TheForsakenBride_amd64'
APP_MAIN_EXE_BIN64_SWAN='GrimLegends_SongOfTheDarkSwan_amd64'
APP_MAIN_EXE_BIN64_CITY='DarkCity_amd64'
APP_MAIN_EXE_BIN32_BRIDE='GrimLegends_TheForsakenBride_i386'
APP_MAIN_EXE_BIN32_SWAN='GrimLegends_SongOfTheDarkSwan_i386'
APP_MAIN_EXE_BIN32_CITY='DarkCity_i386'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_L10N
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXinerama.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN_DEPENDENCIES_LIBRARIES_CITY="$PKG_BIN_DEPENDENCIES_LIBRARIES
libidn.so.11"
PKG_BIN64_DEPENDENCIES_LIBRARIES_CITY="$PKG_BIN_DEPENDENCIES_LIBRARIES_CITY"
PKG_BIN32_DEPENDENCIES_LIBRARIES_CITY="$PKG_BIN_DEPENDENCIES_LIBRARIES_CITY"

PKG_L10N_BASE_ID_BRIDE="${GAME_ID_BRIDE}-l10n"
PKG_L10N_BASE_ID_SWAN="${GAME_ID_SWAN}-l10n"
PKG_L10N_BASE_ID_CITY="${GAME_ID_CITY}-l10n"
PKG_L10N_ID_BRIDE_EN="${PKG_L10N_BASE_ID_BRIDE}-en"
PKG_L10N_ID_BRIDE_FR="${PKG_L10N_BASE_ID_BRIDE}-fr"
PKG_L10N_ID_SWAN_EN="${PKG_L10N_BASE_ID_SWAN}-en"
PKG_L10N_ID_SWAN_FR="${PKG_L10N_BASE_ID_SWAN}-fr"
PKG_L10N_ID_CITY_EN="${PKG_L10N_BASE_ID_CITY}-en"
PKG_L10N_ID_CITY_FR="${PKG_L10N_BASE_ID_CITY}-fr"
PKG_L10N_PROVIDES_BRIDE="
$PKG_L10N_BASE_ID_BRIDE"
PKG_L10N_PROVIDES_SWAN="
$PKG_L10N_BASE_ID_SWAN"
PKG_L10N_PROVIDES_CITY="
$PKG_L10N_BASE_ID_CITY"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='English localization'
PKG_L10N_DESCRIPTION_BRIDE_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_BRIDE_FR="$PKG_L10N_DESCRIPTION_FR"
PKG_L10N_DESCRIPTION_SWAN_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_SWAN_FR="$PKG_L10N_DESCRIPTION_FR"
PKG_L10N_DESCRIPTION_CITY_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_CITY_FR="$PKG_L10N_DESCRIPTION_FR"

PKG_DATA_ID_BRIDE="${GAME_ID_BRIDE}-data"
PKG_DATA_ID_SWAN="${GAME_ID_SWAN}-data"
PKG_DATA_ID_CITY="${GAME_ID_CITY}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

APP_MAIN_EXE_BIN64=$(context_value 'APP_MAIN_EXE_BIN64')
APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')
launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
