Notable changes in 0.33.4 since 0.33.3
======================================

May require attention
---------------------

* The `par2` command (invoked by `bup fsck -g`) may generate empty
  recovery files if interrupted (say via C-c).  To mitigate this, bup
  now runs `par2` in a temporary directory, and only moves the
  recovery files into place if the generation succeeds.  It will also
  look for any empty par2 files, or incomplete sets, associated with
  packfiles that it has been asked to examine.  If found, they will
  provoke an error.  See also
  https://github.com/Parchive/par2cmdline/issues/84

* Previously, any `bup on REMOTE ...` commands that attempted to read
  from standard input (for example `bup on HOST split < something` or
  `bup on HOST split --git-ids ...`) would read nothing instead of the
  original content of standard input.  Now those commands will either
  reject the invocation, or just crash when they attempt to read a
  closed stream.

* When building bup, if your version of GNU make is not named `make`,
  prefer invoking it directly (e.g. `gmake -j4 check`) instead of
  relying on the ./Makefile to redirect to GNU make.  Some non-GNU
  makes now break this redirection.  For example, if you include a
  `-j` option in your build command one of them adds a `-J` to
  `MAKEFLAGS` that GNU make rejects.  In future releases, we're likely
  to drop the redirection entirely.

Bugs
----

* `bup-config(5)` has been added, and mentions that at the moment `bup
  on REMOTE ...` incorrectly reads the `pack.packSizeLimit` from the
  `REMOTE` repository.

* `bup fsck` no longer requires a repository via `BUP_DIR`, `-d`,
  etc. when paths are provided on the command line.

Thanks to (at least)
====================

Ed Maste, Greg Troxel, Johannes Berg, and Rob Browning
