; Script generated by the HM NIS Edit Script Wizard.

; a temporary fixed hack to not make guile, will be variable at some point
; Could make with a guile version
!define WITH_GUILE
; Do not make a guile version
!undef WITH_GUILE

;for bat change
!include "ReplaceOnLine.nsh"
!include "AdvReplaceInFile.nsh"
!include "TextCompare.nsh"

; for logicals
!include "LogicLib.nsh"

; for command line options
!include FileFunc.nsh
!insertmacro GetParameters
!insertmacro GetOptions

; for removal of installer
!include "StrStr.nsh"

; to detect windows version
!include "WinVer.nsh"

!ifndef top_dir
!define top_dir "C:\msys64\home\bernhard\autobuild\MINGW64_NT-10.0-bernie-pre-release-gtk4"
!endif
; pre setting of Coot version
; FIXME:: need to get coot version form somewhere else now...
; maybe from comparing version numbers!?
!include "${top_dir}\coot-version"

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "WinCoot"
!define PRODUCT_VERSION "${WinCootVersion}"
!define PRODUCT_PUBLISHER "Bernhard Lohkamp & Paul Emsley"
!define PRODUCT_WEB_SITE "http://bernhardcl.github.io/coot"
!define PRODUCT_WEB_SITE_2 "http://www2.mrc-lmb.cam.ac.uk/personal/pemsley/coot/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\uninst.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI2.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ABORTWARNING_TEXT "Are you sure you wish to abort installation?"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\coot_install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\coot_uninstall.ico"

; Some variables
Var ICONS_GROUP
Var STARTDIR

; Welcome page (allow 3 lines if long pre-release)
!define MUI_WELCOMEPAGE_TITLE_3LINES
!define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_WELCOMEFINISHPAGE_BITMAP "C:\msys64\home\bernhard\installer\coot_pic_welcome.bmp"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP_NOSTRETCH
!define MUI_HEADERIMAGE_BITMAP "C:\msys64\home\bernhard\installer\coot_pic_header.bmp"
!define MUI_PAGE_CUSTOMFUNCTION_PRE InitPreFunction
!insertmacro MUI_PAGE_WELCOME
; Components page
!define MUI_PAGE_CUSTOMFUNCTION_PRE CheckForUpdate
!insertmacro MUI_PAGE_COMPONENTS
; License page
!define MUI_PAGE_CUSTOMFUNCTION_PRE CheckForUpdate
!define MUI_LICENSEPAGE_TEXT_TOP "Coot licence"
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "C:\msys64\home\bernhard\autobuild\extras\COPYING"
!define MUI_PAGE_CUSTOMFUNCTION_PRE SkipProbeReduceInfo
!define MUI_LICENSEPAGE_TEXT_TOP "Probe && Reduce information"
!define MUI_LICENSEPAGE_TEXT_BOTTOM "This is just for your information. No licence as such is required."
!define MUI_LICENSEPAGE_BUTTON "Got it!"
!insertmacro MUI_PAGE_LICENSE "C:\msys64\home\bernhard\autobuild\extras\probe_reduce.txt"
; Directory page (install directory)
!define MUI_PAGE_CUSTOMFUNCTION_PRE ComponentPost
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "WinCoot"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!define MUI_PAGE_CUSTOMFUNCTION_PRE CheckForUpdate
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Directory page to set the start directory
!define MUI_DIRECTORYPAGE_VARIABLE $STARTDIR
!define MUI_PAGE_HEADER_TEXT "Choose WinCoot Start Location"
!define MUI_PAGE_HEADER_SUBTEXT "Choose the folder in which to start WinCoot."
!define MUI_DIRECTORYPAGE_TEXT_DESTINATION "WinCoot Start Folder"
!define MUI_DIRECTORYPAGE_TEXT_TOP "Setup will make WinCoot icon shortcuts to start in the following folder.$\r$\n$\r$\nTo install in a different folder, click Browse and select another folder. Click Install to continue the installation."
!define MUI_PAGE_CUSTOMFUNCTION_PRE CheckForUpdate
!insertmacro MUI_PAGE_DIRECTORY

; Instfiles page
; add custom function to allow cancel being active
!define MUI_PAGE_CUSTOMFUNCTION_SHOW InstFilesShow
!insertmacro MUI_PAGE_INSTFILES
; Finish page
; run the bat file changes and gdk-pixbuf before we finish the installation
!define MUI_PAGE_CUSTOMFUNCTION_PRE FinishPagePreFunction
!define MUI_FINISHPAGE_RUN "$INSTDIR\wincoot.bat"
!define MUI_FINISHPAGE_TITLE_3LINES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE English

; for replacing strings
!include "WordFunc.nsh"
!insertmacro WordReplace
; actually a macro wrapping the error handler function
; well, doesnt seem to work and always throws errors
; itself somewhere, so revert to old school if and repeating
; code. Keep in case it can be resolved at some point...
!macro MyErrorHandlerMacro un

Function ${un}ErrorHandlerFunction

  Pop $0  ; Abort Flag
  Pop $1  ; Message txt
  Pop $2  ; error code

; convert strings to ints
  IntOp $0 $0 + 0
  IntOp $2 $2 + 0

; the message box could be rather a question to abort!?
  IfSilent +2 0
  MessageBox MB_OK 'Error in Installation. Aborting!$\n$\r$\n$\r$1'

  DetailPrint $1
  SetErrorLevel $2
  ${If} $0 == 1
    Abort $1
  ${EndIf}

FunctionEnd
!macroend

; for error handling, need the second one for uninstall section
!define ErrorHandler "!insertmacro ErrorHandler"
!define UnErrorHandler "!insertmacro UnErrorHandler"

!insertmacro MyErrorHandlerMacro ""
!insertmacro MyErrorHandlerMacro "un."


; ErrorCode is returned by the installer, ErrorText is written in log
; AbortFlag is 1/"True" or 0/"False", (un)installer terminates upon error
!macro ErrorHandler ErrorCode ErrorText AbortFlag
  Push "${ErrorCode}"
  Push "${ErrorText}"
  Push "${AbortFlag}"
  Call ErrorHandlerFunction
!macroend

; same for uninstall (needs "un." in front of function)
!macro UnErrorHandler ErrorCode ErrorText AbortFlag
  Push "${ErrorCode}"
  Push "${ErrorText}"
  Push "${AbortFlag}"
  Call un.ErrorHandlerFunction
!macroend

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"

!ifndef binary_dir
; default to pre-release output dir
!define binary_dir "C:\msys64\home\bernhard\public_html\software\binaries\pre-release"
!endif
; just in case something goes wrong, we define src to be pre-release (default)
!ifndef top_dir
!define top_dir "C:\msys64\home\bernhard\autobuild\MINGW64_NT-10.0-bernie-pre-release-gtk4"
!endif
!ifndef src_dir
!define src_dir "C:\msys64\home\bernhard\Projects\coot-gtk4"
!endif
!define outputname "${binary_dir}\${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
OutFile "${outputname}"

; FIXME:: test what this does
XPStyle on

InstallDir "C:\WinCoot"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show



#####################
# SECTIONS
#####################

Section "!WinCoot" SEC01
  ClearErrors
  SectionIn RO

  Call createTaskIconProgress

  SetOverwrite ifnewer
  SetOutPath "$INSTDIR"

; check if wincoot.bat exists, if so make a backup copy
; (this is a tmp file, doesnt seem to be deleted, maybe virus thing? not sure what's happening)
; install new wincoot.bat
; deal with rest in FinishPagePreFunction
  Var /GLOBAL have_bat
  StrCpy $have_bat "False"

  IfFileExists "$INSTDIR\wincoot.bat" 0 +2
    StrCpy $have_bat "True"

  SetOverwrite on
  File /oname=$INSTDIR\wincoot.bat.tmp "${src_dir}\windows\wincoot.bat"

  SetOverwrite ifnewer
; bin DIR
  SetOutPath "$INSTDIR\bin"
  ; always install the newest exe
  SetOverwrite on
  File "${top_dir}\bin\coot-bin.exe"
  File "${top_dir}\bin\coot-bfactan.exe"
  File "${top_dir}\bin\coot-density-score-by-residue-bin.exe"
  File "${top_dir}\bin\coot-findligand-bin.exe"
  File "${top_dir}\bin\coot-findwaters-bin.exe"
  File "${top_dir}\bin\coot-make-ligands-db.exe"
  File "${top_dir}\bin\coot-mmrrcc.exe"
  File "${top_dir}\bin\layla.exe"
  File "${top_dir}\bin\mini-rsr-bin.exe"
  ; dynarama for now
;  File "${top_dir}\bin\dynarama-bin.exe"
  File "${top_dir}\bin\pyrogen.bat"
  File "${top_dir}\bin\python.exe"
;  File "${src_dir}\windows\dynarama.bat"
  File "${src_dir}\windows\coot-findligand.bat"
  File "${src_dir}\windows\coot-findwaters.bat"
  File "${src_dir}\windows\layla.bat"
  SetOverwrite ifnewer
  File "C:\msys64\home\bernhard\autobuild\extras\coot-icon.ico"
  File "C:\msys64\home\bernhard\autobuild\extras\rama_all.ico"
  File "C:\msys64\home\bernhard\autobuild\extras\layla.ico"
  File "${top_dir}\bin\*.dll"
  File "${top_dir}\bin\coot"
  File "${top_dir}\bin\coot-mini-rsr"
  File "${top_dir}\bin\coot-density-score-by-residue"
  File "${top_dir}\bin\coot-findligand"
  File "${top_dir}\bin\coot-findwaters"
  File "${top_dir}\bin\gdk-pixbuf-query-loaders.exe"
  ; render (or more?) from raster3d?!
  File "${top_dir}\bin\render.exe"
  ; clustalw2
  File "${top_dir}\bin\clustalw2.exe"
  ;gunzip needed?? dont think so
  File "C:\msys64\home\bernhard\autobuild\extras\gunzip"
  File "C:\msys64\home\bernhard\autobuild\extras\gzip.exe"
  ;still needed?
;  File "C:\msys64\home\bernhard\autobuild\extras\msvcr90.dll"
;  File "C:\msys64\home\bernhard\autobuild\extras\Microsoft.VC90.CRT.manifest"
;  File "${top_dir}\bin\pkg-config.exe"
  File "C:\msys64\home\bernhard\autobuild\extras\ppm2bmp.exe"
; SHARE
  SetOutPath "$INSTDIR\share"
  File /r /x monomers /x RDKit "${top_dir}\share\*.*"
; lib
  SetOutPath "$INSTDIR\lib"
  File /r /x cmake /x *.*a /x __pycache__ /x test "${top_dir}\lib\*.*"
; etc - for gtk theme
  SetOutPath "$INSTDIR\etc"
  File /r "${top_dir}\etc\*.*"
; FIXME - no guile!?
!ifdef WITH_GUILE
  ;guile things (shouldnt they be in Guile section?! Never mind)
  SetOutPath "$INSTDIR\bin"
  File "${top_dir}-guile\bin\*guile*"
  File "${top_dir}-guile\bin\libgmp-3.dll"
  File "${top_dir}-guile\bin\readline5.dll"
  File "${top_dir}-guile\bin\libltdl3.dll"
  SetOutPath "$INSTDIR\share\guile\1.8"
  File "${top_dir}-guile\share\guile\1.8\*"
  SetOutPath "$INSTDIR\share\guile\1.8\ice-9"
  File "${top_dir}-guile\share\guile\1.8\ice-9\*"
  SetOutPath "$INSTDIR\share\guile\1.8\ice-9\debugger"
  File "${top_dir}-guile\share\guile\1.8\ice-9\debugger\*"
  SetOutPath "$INSTDIR\share\guile\1.8\lang\elisp"
  File "${top_dir}-guile\share\guile\1.8\lang\elisp\*"
  SetOutPath "$INSTDIR\share\guile\1.8\lang\elisp\internals"
  File "${top_dir}-guile\share\guile\1.8\lang\elisp\internals\*"
  SetOutPath "$INSTDIR\share\guile\1.8\lang\elisp\primitives"
  File "${top_dir}-guile\share\guile\1.8\lang\elisp\primitives\*"
  SetOutPath "$INSTDIR\share\guile\1.8\oop"
  File "${top_dir}-guile\share\guile\1.8\oop\*"
  SetOutPath "$INSTDIR\share\guile\1.8\oop\goops"
  File "${top_dir}-guile\share\guile\1.8\oop\goops\*"
  SetOutPath "$INSTDIR\share\guile\1.8\scripts"
  File "${top_dir}-guile\share\guile\1.8\scripts\*"
  SetOutPath "$INSTDIR\share\guile\1.8\srfi"
  File "${top_dir}-guile\share\guile\1.8\srfi\*"
  SetOutPath "$INSTDIR\share\guile\gtk"
  File "${top_dir}-guile\share\guile\gtk\*"
  SetOutPath "$INSTDIR\share\guile\gtk-2.0"
  File "${top_dir}-guile\share\guile\gtk-2.0\*"
  SetOutPath "$INSTDIR\share\guile\gui"
  File "${top_dir}-guile\share\guile\gui\*"
  SetOutPath "$INSTDIR\share\guile\site"
  File "${top_dir}-guile\share\guile\site\*"
!endif
; WITH_GUILE
; docs
; Mmmh are these updated? Not really. FIXME!
  SetOutPath "$INSTDIR\doc"
  File "C:\msys64\home\bernhard\autobuild\extras\coot-user-manual.pdf"
  File "C:\msys64\home\bernhard\autobuild\extras\crib-sheet.pdf"
  File "C:\msys64\home\bernhard\autobuild\extras\tutorial.pdf"
  File "C:\msys64\home\bernhard\autobuild\extras\tutorial-2.pdf"
  ;;secondary structure(s)
  ;SetOutPath "$INSTDIR\share\coot\ss-reference-structures"
  ;File "C:\msys64\home\bernhard\autobuild\extras\ss-reference-structures\*"
  ; set outpath to $INSTDIR so that shortcuts are started in $INSTDIR
  SetOutPath "$INSTDIR"
  IfErrors 0 +6
;    ${ErrorHandler} 1 "Error in installation. Could not write files." 1
     DetailPrint "Error in installation. Could not write files."
     SetErrorLevel 1
     IfSilent +2 0
       MessageBox MB_OK 'Error in Installation. Aborting!$\n$\r$\n$\rCould not write files.'
     Abort "Abort. Could not write files."

SectionEnd


; not really needed any more, we give this anyway...
; Section /o "Windows feel" SEC02
;   ClearErrors
;   SetOverwrite on
;   SetOutPath "$INSTDIR\share\coot"
;   File "C:\msys64\home\bernhard\autobuild\extras\cootrc"
;   SetOverwrite ifnewer
; ;  maybe here the other guile things?!
;   IfErrors 0 +5
;   ;  ${ErrorHandler} 2 "Error in installation. Could not install Windows feel." 1
;      DetailPrint "Error in installation. Could not install Windows feel. Continuing."
;      SetErrorLevel 2
;      IfSilent +2 0
;         MessageBox MB_OK 'Error in Installation. Continuing!$\n$\r$\n$\rCould not install Windows feel'
;
; SectionEnd

Section /o "!Monomer Library" SEC03
  ; first download, then unzip
  ClearErrors
;  !define cif_dict_filename "cif.tar.gz"
  NScurl::http GET "https://github.com/bernhardcl/monomers/releases/download/for_Release_1.1.14/${cif_dict_filename}" "$TEMP\${cif_dict_filename}" /INSIST /CANCEL /Zone.Identifier /END
  Pop $0
  ${If} $0 == "OK"
    DetailPrint "Download of monomer library successful"
  ${Else}
    ; what shall we do here!? Abort or just warn!?
    DetailPrint "Download of monomer library failed with error $0."
    DetailPrint "  Use CCP4's library or download from:"
    DetailPrint "  https://github.com/MonomerLibrary/monomers/wiki/Installation"
    MessageBox MB_OK 'Installation couldnt download the Monomer library. Will continue with installation nevertheless!$\n$\r$\n$\r \
    If you have, WinCoot will use the library from a CCP4 (or Phenix) installation. \
    Otherwise you can install it manually from https://github.com/MonomerLibrary/monomers/wiki/Installation.'
    ; that's it. Just return.
    Return
  ${EndIf}

  ; only unzip and install of download ok.
  ${If} $0 == "OK"
    IfFileExists $TEMP\${cif_dict_filename} 0 +6
      ; have cif file so unzip
      untgz::extract "-u" "-d" "$INSTDIR\share\coot\lib\data\" "$TEMP\${cif_dict_filename}"
      StrCmp $R0 "success" +4
        DetailPrint "  Failed to extract ${cif_dict_filename}"
        MessageBox MB_OK|MB_ICONEXCLAMATION|MB_DEFBUTTON1 "Failed to extract the monomer library...$\n$\r$\n$\r \
        Check $TEMP for the ${cif_dict_filename} and extract manually to $INSTDIR\share\coot\lib\data\."
	; just return no delete
	Return
      ; delete tmp File after successfull extraction
      Delete "$TEMP\${cif_dict_filename}"
  ${EndIf}

SectionEnd

; probe and reduce here
Section /o "Add probe&reduce" SEC04
  ClearErrors
  SetOverwrite on
  ; This needs to go in another bin as to void conflicst with the libstd and
  ; libgcc dlls. Needs addition to PATH as well
  SetOutPath "$INSTDIR\bin\extras"
  File "C:\msys64\home\bernhard\autobuild\extras\probe.exe"
  File "C:\msys64\home\bernhard\autobuild\extras\reduce.exe"
  File "C:\msys64\home\bernhard\autobuild\extras\libstdc++-6.dll"
  File "C:\msys64\home\bernhard\autobuild\extras\libgcc_s_dw2-1.dll"
  SetOutPath "$INSTDIR\share\coot"
  File "C:\msys64\home\bernhard\autobuild\extras\reduce_wwPDB_het_dict.txt"
  SetOverwrite ifnewer

  IfErrors 0 +5
    ; ${ErrorHandler} 2 "Error in installation. Could not install probe&reduce." 1
     DetailPrint "Error in installation. Could not install probe&reduce. Continuing."
     SetErrorLevel 2
     IfSilent +2 0
        MessageBox MB_OK 'Error in Installation. Continuing!$\n$\r$\n$\rCould not install probe & reduce'

SectionEnd

!ifdef WITH_GUILE
; we dont want guile for now
; 3rd section for guile
Section /o "Guile/Scheme Add-On" SEC05
  SetOverwrite on
  SetOutPath "$INSTDIR\bin"
  File "${top_dir}-guile\bin\coot-real.exe"
  SetOverwrite ifnewer
  maybe here the other guile things?!
SectionEnd
!endif
; WITH_GUILE

Section -AddIcons
  ;; First install for all users, if anything fails, install
  ;; for current user only.
  ClearErrors

  SetShellVarContext all
  ; let's see what happens when we try for all
  Call MakeIcons
  ClearErrors

  ; if error delete what may be there (but there shouldnt be anything?)
  IfErrors 0 exit
  SetShellVarContext current
  Call MakeIcons

 exit:
   SetShellVarContext current
  ; in case we want to install silently (no user intervention)
  ; we have to call the finish page function, otherwise runwincoot.bat
  ; won't be edited.
  IfSilent 0 +2
    Call FinishPagePreFunction
  IfErrors 0 +5
    ; ${ErrorHandler} 3 "Error in installation. Could not install icons." 0
    DetailPrint "Error in installation. Could not install icons. Continuing."
    SetErrorLevel 3
    IfSilent +2 0
        MessageBox MB_OK 'Error in Installation. Continuing!$\n$\r$\n$\rCould not install icons.'
SectionEnd

Section -Post
  ClearErrors
  WriteUninstaller "$INSTDIR\uninst.exe"
;  NO MESSING WITH THE REGISTRY!!!!
;  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\uninst.exe"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  ClearErrors
  WriteUninstaller "$INSTDIR\uninst.exe"
;  NO MESSING WITH THE REGISTRY!!!!
;  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\uninst.exe"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\uninst.exe"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
;  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  IfErrors 0 +5
    ; ${ErrorHandler} 4 "Error in installation. Could not write uninstaller." 0
    DetailPrint "Error in installation. Could not write uninstaller."
    SetErrorLevel 4
    IfSilent +2 0
        MessageBox MB_OK 'Error in Installation. Continuing!$\n$\r$\n$\rCould not write uninstaller.'
SectionEnd



; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "This is 'default' WinCoot (${WinCootVersion}) $\n$\nPython scripting only"
;  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Tick if you want a $\nWindowsy feeling to WinCoot"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "Select if you want to download and install the Monomer library (restraints (cif) dictionary)$\nNote: Usually NOT required if you have CCP4 installed."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "Select if you want $\nprobe and reduce installed.$\nNote: Usually not required if you have CCP4 installed."
; disable guile for now
!ifdef WITH_GUILE
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} "Tick if you want additionally $\nGuile/Scheme scripting"
!endif
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Section Uninstall
  ClearErrors
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  RMDir /r "$INSTDIR\share"
  ; keep the next 2 in case it was there from previous installations
  Delete "$INSTDIR\bin\Lib\*"
  Delete "$INSTDIR\bin\DLLs\*"
  Delete "$INSTDIR\libexec\*.exe"
  ; only remove installed files in bin
  ; (in case there exists probe, reduce e.g.)
  Delete "$INSTDIR\bin\*.dll"
  Delete "$INSTDIR\bin\bfactan.exe"
  Delete "$INSTDIR\bin\coot-icon.ico"
  Delete "$INSTDIR\bin\coot-bfactan.exe"
  Delete "$INSTDIR\bin\coot"
  Delete "$INSTDIR\bin\coot-real.exe"
  Delete "$INSTDIR\bin\coot-bin.exe"
  Delete "$INSTDIR\bin\coot-density-score-by-residue"
  Delete "$INSTDIR\bin\density-score-by-residue-bin.exe"
  Delete "$INSTDIR\bin\density-score-by-residue"
  Delete "$INSTDIR\bin\dynarama-bin.exe"
  Delete "$INSTDIR\bin\dynarama.bat"
  Delete "$INSTDIR\bin\dynarama"
  Delete "$INSTDIR\bin\pyrogen.bat"
  Delete "$INSTDIR\bin\python.exe"
  Delete "$INSTDIR\bin\rama_all.ico"
  Delete "$INSTDIR\bin\findligand-bin.exe"
  Delete "$INSTDIR\bin\findligand-real.exe"
  Delete "$INSTDIR\bin\findligand.bat"
  Delete "$INSTDIR\bin\findligand"
  Delete "$INSTDIR\bin\coot-findligand"
  Delete "$INSTDIR\bin\coot-findligand-bin.exe"
  Delete "$INSTDIR\bin\coot-findligand.bat"
  Delete "$INSTDIR\bin\coot-findwaters"
  Delete "$INSTDIR\bin\coot-findwaters-bin.exe"
  Delete "$INSTDIR\bin\coot-findwaters.bat"
  Delete "$INSTDIR\bin\findwaters-bin.exe"
  Delete "$INSTDIR\bin\findwaters-real.exe"
  Delete "$INSTDIR\bin\findwaters.bat"
  Delete "$INSTDIR\bin\findwaters"
  Delete "$INSTDIR\bin\coot-available-comp-id.exe"
  Delete "$INSTDIR\bin\coot-compare-dictionaries.exe"
  Delete "$INSTDIR\bin\coot-density-score-by-residue-bin.exe"
  Delete "$INSTDIR\bin\coot-fix-nomenclature-errors.exe"
  Delete "$INSTDIR\bin\coot-make-ligands-db.exe"
  Delete "$INSTDIR\bin\coot-make-shelx-restraints.exe"
  Delete "$INSTDIR\bin\coot-mini-rsr"
  Delete "$INSTDIR\bin\coot-mmrrcc.exe"
  Delete "$INSTDIR\bin\fix-nomenclature-errors.exe"
  Delete "$INSTDIR\bin\gdk-pixbuf-csource.exe"
  Delete "$INSTDIR\bin\gdk-pixbuf-query-loaders.exe"
  Delete "$INSTDIR\bin\glib-genmarshal.exe"
  Delete "$INSTDIR\bin\glib-gettextize"
  Delete "$INSTDIR\bin\glib-mkenums"
  Delete "$INSTDIR\bin\gobject-query.exe"
  Delete "$INSTDIR\bin\go-to-ligand.ico"
  Delete "$INSTDIR\bin\gsl-config"
  Delete "$INSTDIR\bin\gspawn-win32-helper-console.exe"
  Delete "$INSTDIR\bin\gspawn-win32-helper.exe"
  Delete "$INSTDIR\bin\gtk-builder-convert"
  Delete "$INSTDIR\bin\gtk-demo.exe"
  Delete "$INSTDIR\bin\gtk-query-immodules-2.0.exe"
  Delete "$INSTDIR\bin\gunzip"
  Delete "$INSTDIR\bin\gzip.exe"
  Delete "$INSTDIR\bin\iconv.exe"
  Delete "$INSTDIR\bin\layla.bat"
  Delete "$INSTDIR\bin\layla.exe"
  Delete "$INSTDIR\bin\layla.ico"
  Delete "$INSTDIR\bin\lidia.bat"
  Delete "$INSTDIR\bin\lidia.exe"
  Delete "$INSTDIR\bin\lidia-bin.exe"
  Delete "$INSTDIR\bin\mini-rsr-bin.exe"
  Delete "$INSTDIR\bin\render.exe"
  Delete "$INSTDIR\bin\clustalw2.exe"
  Delete "$INSTDIR\bin\Microsoft.VC90.CRT.manifest"
  Delete "$INSTDIR\bin\pango-querymodules.exe"
  Delete "$INSTDIR\bin\pango-view.exe"
  Delete "$INSTDIR\bin\pkg-config.exe"
  Delete "$INSTDIR\bin\ppm2bmp.exe"
  ; probe & reduce (optional?)
  Delete "$INSTDIR\bin\extras\*"
  ; guile things
  Delete "$INSTDIR\bin\*guile*"
  Delete "$INSTDIR\bin\libgmp-3.dll"
  Delete "$INSTDIR\bin\readline5.dll"
  Delete "$INSTDIR\bin\libltdl3.dll"
  ; continue deleting everything
  RMDir /r "$INSTDIR\etc"
  RMDir /r "$INSTDIR\lib"
  RMDir /r "$INSTDIR\examples"
  RMDir /r "$INSTDIR\doc"
  ; we shall only remove installed files here (to e.g. keep .coot.py untouched)
  Delete "$INSTDIR\*wincoot*.bat"
  Delete "$INSTDIR\Coot.url"

  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  SetShellVarContext all
  Delete "$SMPROGRAMS\$ICONS_GROUP\*"
  Delete "$DESKTOP\WinCoot.lnk"
  Delete "$QUICKLAUNCH\WinCoot.lnk"
  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  SetShellVarContext current
  Delete "$SMPROGRAMS\$ICONS_GROUP\*"
  Delete "$DESKTOP\WinCoot.lnk"
  Delete "$QUICKLAUNCH\WinCoot.lnk"
  RMDir "$SMPROGRAMS\$ICONS_GROUP"

  ; keep these in case they exist from previous versions
  RMDir /r "$INSTDIR\bin\Lib"
  RMDir "$INSTDIR\bin\DLLs"
  RMDir "$INSTDIR\bin\extras"
  RMDir "$INSTDIR\bin"
  RMDir /r "$INSTDIR\libexec"
  ; FIXME:: what to do with python?
  ; this is only for old installs...
  RMDir /r "$INSTDIR\python27"
  ; will only be removed if empty
  RMDir "$INSTDIR\.coot-preferences"
  RMDir "$INSTDIR\coot-backup"
  RMDir "$INSTDIR\"

;  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
;  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
  IfErrors 0 +5
    ;${UnErrorHandler} 5 "Error in uninstallation. Could not completely uninstall." 1
    DetailPrint "Error in uninstallation. Could not completely uninstall."
    SetErrorLevel 5
    IfSilent +2 0
        MessageBox MB_OK 'Error in Uninstallation. Aborting!$\n$\r$\n$\rCould not completely uninstall.'
SectionEnd

######################
# 'BUILD-IN' FUNCTIONS
######################

# BL says:: disable for now, since no guile available anyway
!ifdef WITH_GUILE
Function .onSelChange
   ${If} ${SectionIsSelected} ${SEC05}
      MessageBox MB_OK|MB_ICONEXCLAMATION "You have with guile selected. Sure? This may not work perfectly.$\r$\n\"
   ${EndIf}
FunctionEnd
!endif

Function .onInit
  ClearErrors

  ; logging
  ; if old log exists save simply (could be by date)
  ; StrCpy $TEMP .
  ; Dont use INSTDIR as it doesnt exist from the beginning use $TEMP instead.
  ; Maybe use a different place at some point.
  IfFileExists $TEMP\install.log 0 +4
    IfFileExists $TEMP\install.log.1 0 +2
      Delete $TEMP\install.log.1
    Rename $TEMP\install.log $TEMP\install.log.1
  ; Seems install.log always goes to $INSTDIR, since this doesnt
  ; exists yet we try to set it in another way
  Push $INSTDIR
  StrCpy $INSTDIR $TEMP
  LogSet on
  Pop $INSTDIR

    ; Get Command line parameters
        var /GLOBAL INSTDIR_TMP
        StrCpy $INSTDIR_TMP $INSTDIR
        StrCpy $INSTDIR ""

	var /GLOBAL cmdLineParams
	Push $R0

	${GetParameters} $cmdLineParams

	; /? param (help)
	ClearErrors
	${GetOptions} $cmdLineParams '/?' $R0
	IfErrors +3 0
        Call ShowOptions
	Abort

	ClearErrors
	${GetOptions} $cmdLineParams '/help' $R0
	IfErrors +3 0
        Call ShowOptions
	Abort

	Pop $R0

	ClearErrors

    ; Initialise options

	Var /GLOBAL update
	Var /GLOBAL delete_installer
	Var /GLOBAL start_coot

	StrCpy $update             	  0
	StrCpy $delete_installer      	  0
	StrCpy $start_coot      	  0

    ; Parse Parameters

	Push $R0
	Call parseParameters
	Pop $R0

        ${If} $INSTDIR == ""
          ${If} $update = 1
           Call NoInstDirGiven
          ${Else}
           StrCpy $INSTDIR $INSTDIR_TMP
          ${EndIf}
        ${EndIf}
; insert params END
; no more examples dir (have data dir now)
; so default start dir is $INSTDIR
  ${If} $STARTDIR == ""
    StrCpy $STARTDIR "$%USERPROFILE%"
  ${EndIf}
  IfErrors 0 +6
    ;${ErrorHandler} 6 "Error in installation. Could not initiate installation." 1
    DetailPrint "Error in installation. Could not initiate installation."
    SetErrorLevel 6
    IfSilent +2 0
        MessageBox MB_OK 'Error in Installation. Aborting!$\n$\r$\n$\rCould not initiate installation.'
    Abort "Error in installation. Could not initiate installation. Aborting."

FunctionEnd

; finallising
Function .onGUIEnd
  ClearErrors
  ; remove tmp bat file if exists (Delete wont do, need to do it via DOS shell command)
  ; shouldnt be there any more, just to be on the save side...
  ; possibly an anti virus thing?!?
  ; delete both bat files i.e. for i2 too
  IfFileExists "$INSTDIR\wincoot.bat.tmp" "" cont
     ;Delete "$INSTDIR\wincoot.bat.tmp"
     Exec 'cmd /c del "$INSTDIR\wincoot.bat.tmp"'
  cont:
  IfFileExists "$INSTDIR\wincoot-for-ccp4i2.bat.tmp" "" conti2
     Exec 'cmd /c del "$INSTDIR\wincoot-for-ccp4i2.bat.tmp"'
  conti2:

  ; delete the installer
  ${If} $delete_installer = 1
   !insertmacro StrStr $0 "$EXEDIR" "pending-install"
   ${If} $0 == ""
    Exec 'cmd /c del "$EXEDIR\${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"'
   ${Else}
    Exec 'cmd /c rmdir /s /q "$EXEDIR"'
   ${EndIf}
  ${EndIf}

  ; Finally if run then start WinCoot in StartDir
  ${If} $start_coot = 1
    SetOutPath $STARTDIR
    Exec $INSTDIR\wincoot.bat
  ${EndIf}
  IfErrors 0 +6
    ; ${ErrorHandler} 7 "Error in installation. Could not write/edit wincoot.bat." 1
    DetailPrint "Error in installation. Could not write/edit wincoot.bat."
    SetErrorLevel 7
    IfSilent +2 0
        MessageBox MB_OK 'Error in Installation. Aborting!$\n$\r$\n$\rCould not write/edit wincoot.bat.'
    Abort "Error in installation. Could not write/edit (run)wincoot.bat. Aborting!"

FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer." /SD IDOK
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" /SD IDYES IDYES +2
  Abort
FunctionEnd

###################
# GENERAL FUNCTIONS
###################

Function MakeBackground
  ; background depends on update
  ${If} $update = 0
    ; from dark green to dark red : 0 0x80 0 0x80 0 0
    BgImage::SetBg /GRADIENT 0 0x80 0 0x80 0 0
    BgImage::AddText "$(^Name) Installer"
    ;BgImage::AddImage C:\msys64\home\bernhard\installer\coot_pic_welcome.bmp 150 0
    CreateFont $R0 "Comic Sans MS" 30 700
    # add a blue shadow for the text
    BgImage::AddText "$(^Name) Installer" $R0 0 0 255 48 48 798 198
    # add a green shadow for the text
    BgImage::AddText "$(^Name) Installer" $R0 0 255 0 52 52 802 202
    # add the text
    BgImage::AddText "$(^Name) Installer" $R0 255 0 0 50 50 800 200
    BgImage::Redraw
  ${EndIf}
FunctionEnd

Function parseParameters

    ; /instdir=
    ; What about spaces in dir name?? USE quotes!?
    ${GetOptions} $cmdLineParams '/instdir=' $R0
    IfErrors continue0 0
    ${If} $R0 == ""
    MessageBox MB_ICONSTOP "No install directory given.$\n$\n\
               Please use command line option /instdir=instdir$\n$\n\
               Abort installation!"
    Abort
    ${Else}
    StrCpy $INSTDIR $R0
    ${EndIf}
    continue0:

    ; /update
    ${GetOptions} $cmdLineParams '/update' $R0
    IfErrors continue1 0
    StrCpy $update 1
    continue1:

    ; /autoupdate
    ${GetOptions} $cmdLineParams '/autoupdate' $R0
    IfErrors continue2 0
    StrCpy $update 1
    StrCpy $delete_installer 1
    StrCpy $start_coot 1
    continue2:

    ; /startdir=
    ; What about spaces in dir name?? USE quotes!?
    ${GetOptions} $cmdLineParams '/startdir=' $R0
    IfErrors continue3 0
    ${If} $R0 == ""
    MessageBox MB_ICONSTOP "No start directory given.$\n$\n\
               Please use command line option /startdir=startdir$\n$\n\
               Abort installation!"
    Abort
    ${Else}
    StrCpy $STARTDIR $R0
    ${EndIf}
    continue3:

    ; /run
    ${GetOptions} $cmdLineParams '/run' $R0
    IfErrors +2 0
    StrCpy $start_coot 1

    ; /del_inst
    ${GetOptions} $cmdLineParams '/del_inst' $R0
    IfErrors +2 0
    StrCpy $delete_installer 1

FunctionEnd

Function NoInstDirGiven
    IfSilent 0 +2
    MessageBox MB_ICONSTOP "No installation directory given.$\n$\n\
               Please use command line option /instdir=instdir$\n$\n\
               Abort installation!"
    Abort
FunctionEnd

Function ShowOptions
	MessageBox MB_ICONQUESTION "WinCoot Installer Command Line Help$\n$\n\
        Options:$\n\
          /D=instdir         - defines installation directory to instdir$\n\
          /instdir=instdir   - as above (preferred!!! needs to be first)$\n\
          /startdir=statdir  - defines dir where Coot will start (after install/update)$\n\
          /update            - update WinCoot (no questions asked, requires /D)$\n\
          /autoupdate        - as /update but removes installer and starts WinCoot$\n\
          /del_inst          - removes the installer after installation$\n\
          /run               - run WinCoot after installation$\n\
          /S                 - silent installation (and uninstall)$\n\
          /help | /?         - this information"
FunctionEnd

; Dont show pages when updating!
Function CheckForUpdate
  ${If} $update = 1
     Abort
  ${EndIf}
FunctionEnd

; to skip the probe & reduce info if we dont install this
Function SkipProbeReduceInfo
  ${IfNot} ${SectionIsSelected} ${SEC04}
     abort ; no selected
  ${EndIf}
FunctionEnd

; before we start pages
Function InitPreFunction
  Call CheckForUpdate
  ;Call MakeBackground
FunctionEnd

; inistiallize the directory page count
Function ComponentPost
  Call CheckForUpdate
  Var /GLOBAL DIRCOUNT
  StrCpy $DIRCOUNT "0"
FunctionEnd

; for changing wincoot [and gdk-pixbuf-loader] Not sure if here is a good place? Get's a bit messy
Function FinishPagePreFunction

   Var /GLOBAL GUILE_INST_DIR

   ; if we have an old bat file
   ; this we only do for "normal" wincoot.bat; we dont care about i2 any more.
   ${If} $have_bat == "True"
     ; check if wincootbats are different
     Var /Global bat_differ
     StrCpy $bat_differ "False"
     ${TextCompare} "$INSTDIR\wincoot.bat" "$INSTDIR\wincoot.bat.tmp" "FastDiff" "TxtCompResult"

     ${If} $bat_differ == "True"
        ; if different make backup copy and inform user (unless silent)
        IfFileExists $INSTDIR\wincoot.bat.backup 0 +2
          Delete $INSTDIR\wincoot.bat.backup
        Rename "$INSTDIR\wincoot.bat" "$INSTDIR\wincoot.bat.backup"
;        MessageBox MB_OK "BL DEBUG:: just renamed, or not? wincoot.bat"
        ${If} $update = 0
          IfSilent +2
            MessageBox MB_ICONINFORMATION "You already have a (modified) WinCoot batch file (wincoot.bat).$\r$\n\
            You will find the copy wincoot.bat.backup in $INSTDIR"
        ${EndIf}  ; update
     ${EndIf}  ; bat_diff
   ${EndIf}  ; have_bat

   ; MessageBox MB_OK 'BL DEBUG:: just before renaming tmp to wincoot.bat !$\n$\r$\n$\r'

   Rename "$INSTDIR\wincoot.bat.tmp" "$INSTDIR\wincoot.bat"

  ; executable access to everyone
  AccessControl::GrantOnFile /NOINHERIT "$INSTDIR\wincoot.bat" "(BA)" "FullAccess"
  AccessControl::GrantOnFile /NOINHERIT "$INSTDIR\wincoot.bat" "(BU)" "GenericExecute"
;  AccessControl::GrantOnFile /NOINHERIT "$INSTDIR\bin\dynarama.bat" "(BA)" "FullAccess"
;  AccessControl::GrantOnFile /NOINHERIT "$INSTDIR\bin\dynarama.bat" "(BU)" "GenericExecute"
  AccessControl::GrantOnFile /NOINHERIT "$INSTDIR\bin\layla.bat" "(BA)" "FullAccess"
  AccessControl::GrantOnFile /NOINHERIT "$INSTDIR\bin\layla.bat" "(BU)" "GenericExecute"

;  for now dont mess with pixbuf query loader
;  ExecWait 'cmd /c ""$INSTDIR\bin\gdk-pixbuf-query-loaders.exe" > "$INSTDIR\etc\gtk-2.0\gdk-pixbuf.loaders""'
  ; set outpath to run where we want to

  SetOutPath "$STARTDIR"
  Call CheckForUpdate
FunctionEnd

Function TxtCompResult
     StrCpy $bat_differ "True"
     ; make sure the files are closed for renaming
     StrCpy $0 StopTextCompare
     Push $0
FunctionEnd

Function MakeIcons
# run only if not update
${If} $update = 0
  SetOutPath "$INSTDIR"
; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  SetOutPath "$STARTDIR"
  CreateShortCut "$QUICKLAUNCH\WinCoot.lnk" "$SYSDIR\cmd.exe" '/c "$INSTDIR\wincoot.bat"' "$INSTDIR\bin\coot-icon.ico" 0 SW_SHOWMINIMIZED
  CreateShortCut "$DESKTOP\WinCoot.lnk" "$SYSDIR\cmd.exe" '/c "$INSTDIR\wincoot.bat"' "$INSTDIR\bin\coot-icon.ico" 0 SW_SHOWMINIMIZED
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\WinCoot.lnk" "$SYSDIR\cmd.exe" '/c "$INSTDIR\wincoot.bat"' "$INSTDIR\bin\coot-icon.ico" 0 SW_SHOWMINIMIZED
  Sleep 10
;  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\DynaRama.lnk" "$SYSDIR\cmd.exe" '/c "$INSTDIR\bin\dynarama.bat"' "$INSTDIR\bin\rama_all.ico"
  Sleep 10
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Layla.lnk" "$SYSDIR\cmd.exe" '/c "$INSTDIR\bin\layla.bat"' "$INSTDIR\bin\layla.ico"
  Sleep 10
  SetOutPath "$INSTDIR"
  WriteIniStr "$INSTDIR\WinCoot.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  WriteIniStr "$INSTDIR\Coot.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE_2}"
  CreateShortCut "$SMPROGRAMS\WinCoot\WinCoot Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  Sleep 10
  CreateShortCut "$SMPROGRAMS\WinCoot\Coot Website.lnk" "$INSTDIR\Coot.url"
  Sleep 10
  CreateShortCut "$SMPROGRAMS\WinCoot\Uninstall.lnk" "$INSTDIR\uninst.exe"
  Sleep 10
  CreateShortCut "$SMPROGRAMS\WinCoot\Coot Manual.lnk" "$INSTDIR\doc\coot-user-manual.pdf"
  Sleep 10
  CreateShortCut "$SMPROGRAMS\WinCoot\Coot Keys and Buttons.lnk" "$INSTDIR\doc\crib-sheet.pdf"
  Sleep 10
  CreateShortCut "$SMPROGRAMS\WinCoot\Coot Tutorial.lnk" "$INSTDIR\doc\tutorial.pdf"
  !insertmacro MUI_STARTMENU_WRITE_END
  SetOutPath "$INSTDIR"
 ${Endif}
FunctionEnd

Function ErrorHandler

  Pop $0  ; Abort Flag
  Pop $1  ; Message txt
  Pop $2  ; error code

; convert strings to ints
  IntOp $0 $0 + 0
  IntOp $2 $2 + 0

; the message box could be rather a question to abort!?
  IfSilent +2 0
  MessageBox MB_OK 'Error in Installation. Aborting!$\n$\r$\n$\r$1'

  DetailPrint $1
  SetErrorLevel $2
  ${If} $0 == 1
    Abort $1
  ${EndIf}

FunctionEnd

; function to enable Cancel during file installations
; see https://nsis.sourceforge.io/InstFiles_Cancel_-_Allowing_a_user_to_cancel_installation_during_InstFiles
Function InstFilesShow
    GetDlgItem $0 $HWNDPARENT 2
    EnableWindow $0 1
FunctionEnd

; function to show progress on taskbar icon
Function createTaskIconProgress
  w7tbp::Start
FunctionEnd
