/*
 * KiRouter - a push-and-(sometimes-)shove PCB router
 *
 * Copyright (C) 2013-2014 CERN
 * Copyright The KiCad Developers, see AUTHORS.txt for contributors.
 * Author: Tomasz Wlostowski <tomasz.wlostowski@cern.ch>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pns_algo_base.h"
#include "pns_debug_decorator.h"
#include "pns_router.h"

namespace PNS {

ROUTING_SETTINGS& ALGO_BASE::Settings() const
{
    return m_router->Settings();
}


LOGGER* ALGO_BASE::Logger()
{
    return m_logger;
}


const BOX2I& ALGO_BASE::VisibleViewArea() const
{
    return m_router->VisibleViewArea();
}

}
