#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Tree Visitor base class

template <class StructType>
class TreeBaseVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    std::string s, indtd;
    bool use_colors;
    bool start_line = true;
    bool last, attached;
    int indent_level = 0, indent_spaces = 2, lvl = 0;
public:
    TreeBaseVisitor() : use_colors(false), last(true), attached(false) { s.reserve(100000); }
    void inc_indent() {
        indent_level++;
        indtd += "  ";
    }
    void inc_lindent() {
        indent_level++;
        indtd += "| ";
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indtd = indtd.substr(0, indent_level*indent_spaces);
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "└-" + "items=↧");
        attached = false;
        for (size_t i=0; i<x.n_items; i++) {
            inc_indent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_asr(*x.m_items[i]);
            dec_indent();
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("Unimplementedlocation");
        s.append("Unimplementedlocation");
        dec_indent();
    }
    void visit_Module(const Module_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "parent_module=");
        if (x.m_parent_module) {
            s.append(x.m_parent_module);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "loaded_from_mod=");
        if (x.m_loaded_from_mod) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "intrinsic=");
        if (x.m_intrinsic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "has_submodules=");
        if (x.m_has_submodules) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("Unimplementedlocation");
        s.append("Unimplementedlocation");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "function_signature=");
        attached = true;
        self().visit_ttype(*x.m_function_signature);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "return_var=");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "deterministic=");
        if (x.m_deterministic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "side_effect_free=");
        if (x.m_side_effect_free) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "module_file=");
        if (x.m_module_file) {
            s.append("\"" + std::string(x.m_module_file) + "\"");
        } else {
            s.append("()");
        }
        s.append("Unimplementedlocation");
        s.append("Unimplementedlocation");
        dec_indent();
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "procs=↧");
        for (size_t i=0; i<x.n_procs; i++) {
            inc_lindent();
            last = i == x.n_procs-1;
            attached = false;
            self().visit_symbol(*x.m_procs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CustomOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "procs=↧");
        for (size_t i=0; i<x.n_procs; i++) {
            inc_lindent();
            last = i == x.n_procs-1;
            attached = false;
            self().visit_symbol(*x.m_procs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExternalSymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "external=");
        attached = true;
        self().visit_symbol(*x.m_external);
        s.append("\n" + indtd + "|-" + "module_name=");
        s.append(x.m_module_name);
        s.append("\n" + indtd + "|-" + "scope_names=");
        for (size_t i=0; i<x.n_scope_names; i++) {
            s.append(x.m_scope_names[i]);
            if (i < x.n_scope_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "original_name=");
        s.append(x.m_original_name);
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
    }
    void visit_Struct(const Struct_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Struct");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "struct_signature=");
        attached = true;
        self().visit_ttype(*x.m_struct_signature);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "members=");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "member_functions=");
        for (size_t i=0; i<x.n_member_functions; i++) {
            s.append(x.m_member_functions[i]);
            if (i < x.n_member_functions-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "is_packed=");
        if (x.m_is_packed) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "is_abstract=");
        if (x.m_is_abstract) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "initializers=↧");
        for (size_t i=0; i<x.n_initializers; i++) {
            inc_lindent();
            last = i == x.n_initializers-1;
            attached = false;
            self().visit_call_arg(x.m_initializers[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "alignment=");
        if (x.m_alignment) {
            self().visit_expr(*x.m_alignment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "parent=");
        last = true;
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Enum(const Enum_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Enum");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "members=");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "enumtypeType=");
        visit_enumtypeType(x.m_enum_value_type);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "parent=");
        last = true;
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Union(const Union_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Union");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "members=");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "initializers=↧");
        for (size_t i=0; i<x.n_initializers; i++) {
            inc_lindent();
            last = i == x.n_initializers-1;
            attached = false;
            self().visit_call_arg(x.m_initializers[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "parent=");
        last = true;
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Variable(const Variable_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Variable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "intentType=");
        visit_intentType(x.m_intent);
        s.append("\n" + indtd + "|-" + "symbolic_value=");
        if (x.m_symbolic_value) {
            self().visit_expr(*x.m_symbolic_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "storage_typeType=");
        visit_storage_typeType(x.m_storage);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "type_declaration=");
        if (x.m_type_declaration) {
            self().visit_symbol(*x.m_type_declaration);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "presenceType=");
        visit_presenceType(x.m_presence);
        s.append("\n" + indtd + "|-" + "value_attr=");
        if (x.m_value_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "target_attr=");
        if (x.m_target_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "contiguous_attr=");
        if (x.m_contiguous_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "bindc_name=");
        if (x.m_bindc_name) {
            s.append("\"" + std::string(x.m_bindc_name) + "\"");
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "is_volatile=");
        if (x.m_is_volatile) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "is_protected=");
        if (x.m_is_protected) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_StructMethodDeclaration(const StructMethodDeclaration_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructMethodDeclaration");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "self_argument=");
        if (x.m_self_argument) {
            s.append(x.m_self_argument);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "proc_name=");
        s.append(x.m_proc_name);
        s.append("\n" + indtd + "|-" + "proc=");
        attached = true;
        self().visit_symbol(*x.m_proc);
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "is_deferred=");
        if (x.m_is_deferred) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "is_nopass=");
        if (x.m_is_nopass) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlock");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Block(const Block_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Block");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Requirement(const Requirement_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Requirement");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "requires=↧");
        for (size_t i=0; i<x.n_requires; i++) {
            inc_indent();
            last = i == x.n_requires-1;
            attached = false;
            self().visit_require_instantiation(*x.m_requires[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Template(const Template_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Template");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "requires=↧");
        for (size_t i=0; i<x.n_requires; i++) {
            inc_indent();
            last = i == x.n_requires-1;
            attached = false;
            self().visit_require_instantiation(*x.m_requires[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Allocate(const Allocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_alloc_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "stat=");
        if (x.m_stat) {
            self().visit_expr(*x.m_stat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "errmsg=");
        if (x.m_errmsg) {
            self().visit_expr(*x.m_errmsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "source=");
        last = true;
        if (x.m_source) {
            self().visit_expr(*x.m_source);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ReAlloc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_alloc_arg(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Assign(const Assign_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "└-" + "variable=");
        s.append(x.m_variable);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "|-" + "overloaded=");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "realloc_lhs=");
        if (x.m_realloc_lhs) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "move_allocation=");
        if (x.m_move_allocation) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_DebugCheckArrayBounds(const DebugCheckArrayBounds_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DebugCheckArrayBounds");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "|-" + "orig_value=");
        attached = true;
        self().visit_expr(*x.m_orig_value);
        s.append("\n" + indtd + "└-" + "move_allocation=");
        if (x.m_move_allocation) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_Associate(const Associate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Associate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_Cycle(const Cycle_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoConcurrentLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "head=↧");
        for (size_t i=0; i<x.n_head; i++) {
            inc_lindent();
            last = i == x.n_head-1;
            attached = false;
            self().visit_do_loop_head(x.m_head[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "shared=↧");
        for (size_t i=0; i<x.n_shared; i++) {
            inc_lindent();
            last = i == x.n_shared-1;
            attached = false;
            self().visit_expr(*x.m_shared[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "local=↧");
        for (size_t i=0; i<x.n_local; i++) {
            inc_lindent();
            last = i == x.n_local-1;
            attached = false;
            self().visit_expr(*x.m_local[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "reduction=↧");
        for (size_t i=0; i<x.n_reduction; i++) {
            inc_lindent();
            last = i == x.n_reduction-1;
            attached = false;
            self().visit_reduction_expr(x.m_reduction[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_OMPRegion(const OMPRegion_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPRegion");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "omp_region_typeType=");
        visit_omp_region_typeType(x.m_region);
        s.append("\n" + indtd + "|-" + "clauses=↧");
        for (size_t i=0; i<x.n_clauses; i++) {
            inc_lindent();
            last = i == x.n_clauses-1;
            attached = false;
            self().visit_omp_clause(*x.m_clauses[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_DoLoop(const DoLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "head=");
        attached = true;
        self().visit_do_loop_head(x.m_head);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "code=");
        last = true;
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Exit(const Exit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAllSingle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "head=");
        attached = true;
        self().visit_do_loop_head(x.m_head);
        s.append("\n" + indtd + "└-" + "assign_stmt=");
        last = true;
        attached = true;
        self().visit_stmt(*x.m_assign_stmt);
        dec_indent();
    }
    void visit_ForEach(const ForEach_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForEach");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "var=");
        attached = true;
        self().visit_expr(*x.m_var);
        s.append("\n" + indtd + "|-" + "container=");
        attached = true;
        self().visit_expr(*x.m_container);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_GoTo(const GoTo_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoTo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target_id=");
        s.append(std::to_string(x.m_target_id));
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoToTarget");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(std::to_string(x.m_id));
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfArithmetic");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "lt_label=");
        s.append(std::to_string(x.m_lt_label));
        s.append("\n" + indtd + "|-" + "eq_label=");
        s.append(std::to_string(x.m_eq_label));
        s.append("\n" + indtd + "└-" + "gt_label=");
        s.append(std::to_string(x.m_gt_label));
        dec_indent();
    }
    void visit_Print(const Print_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "text=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_text);
        dec_indent();
    }
    void visit_FileOpen(const FileOpen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileOpen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "newunit=");
        if (x.m_newunit) {
            self().visit_expr(*x.m_newunit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "filename=");
        if (x.m_filename) {
            self().visit_expr(*x.m_filename);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "status=");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "form=");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "access=");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "action=");
        last = true;
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileClose(const FileClose_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileClose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "err=");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "status=");
        last = true;
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileRead(const FileRead_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "fmt=");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "advance=");
        if (x.m_advance) {
            self().visit_expr(*x.m_advance);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "size=");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "id=");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overloaded=");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "is_formatted=");
        if (x.m_is_formatted) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileBackspace");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "err=");
        last = true;
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileRewind(const FileRewind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRewind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "err=");
        last = true;
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileInquire(const FileInquire_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileInquire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "file=");
        if (x.m_file) {
            self().visit_expr(*x.m_file);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "err=");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "exist=");
        if (x.m_exist) {
            self().visit_expr(*x.m_exist);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "opened=");
        if (x.m_opened) {
            self().visit_expr(*x.m_opened);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "number=");
        if (x.m_number) {
            self().visit_expr(*x.m_number);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "named=");
        if (x.m_named) {
            self().visit_expr(*x.m_named);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            self().visit_expr(*x.m_name);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "access=");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "sequential=");
        if (x.m_sequential) {
            self().visit_expr(*x.m_sequential);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "direct=");
        if (x.m_direct) {
            self().visit_expr(*x.m_direct);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "form=");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "formatted=");
        if (x.m_formatted) {
            self().visit_expr(*x.m_formatted);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "unformatted=");
        if (x.m_unformatted) {
            self().visit_expr(*x.m_unformatted);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "recl=");
        if (x.m_recl) {
            self().visit_expr(*x.m_recl);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "nextrec=");
        if (x.m_nextrec) {
            self().visit_expr(*x.m_nextrec);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "blank=");
        if (x.m_blank) {
            self().visit_expr(*x.m_blank);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "position=");
        if (x.m_position) {
            self().visit_expr(*x.m_position);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "action=");
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "read=");
        if (x.m_read) {
            self().visit_expr(*x.m_read);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "write=");
        if (x.m_write) {
            self().visit_expr(*x.m_write);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "readwrite=");
        if (x.m_readwrite) {
            self().visit_expr(*x.m_readwrite);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "delim=");
        if (x.m_delim) {
            self().visit_expr(*x.m_delim);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "pad=");
        if (x.m_pad) {
            self().visit_expr(*x.m_pad);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "flen=");
        if (x.m_flen) {
            self().visit_expr(*x.m_flen);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "blocksize=");
        if (x.m_blocksize) {
            self().visit_expr(*x.m_blocksize);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "convert=");
        if (x.m_convert) {
            self().visit_expr(*x.m_convert);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "carriagecontrol=");
        if (x.m_carriagecontrol) {
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "size=");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "pos=");
        if (x.m_pos) {
            self().visit_expr(*x.m_pos);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "iolength=");
        last = true;
        if (x.m_iolength) {
            self().visit_expr(*x.m_iolength);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileWrite(const FileWrite_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "id=");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "separator=");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "overloaded=");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "is_formatted=");
        if (x.m_is_formatted) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_Return(const Return_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_case_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "default=↧");
        for (size_t i=0; i<x.n_default; i++) {
            inc_lindent();
            last = i == x.n_default-1;
            attached = false;
            self().visit_stmt(*x.m_default[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "enable_fall_through=");
        if (x.m_enable_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_Stop(const Stop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "code=");
        last = true;
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Assert(const Assert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "└-" + "msg=");
        last = true;
        if (x.m_msg) {
            self().visit_expr(*x.m_msg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        attached = true;
        self().visit_symbol(*x.m_name);
        s.append("\n" + indtd + "|-" + "original_name=");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "dt=");
        last = true;
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureSubroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "sub_intrinsic_id=");
        s.append(std::to_string(x.m_sub_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        dec_indent();
    }
    void visit_Where(const Where_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Nullify(const Nullify_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Nullify");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Flush(const Flush_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Flush");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        attached = true;
        self().visit_expr(*x.m_unit);
        s.append("\n" + indtd + "|-" + "err=");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "iostat=");
        last = true;
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListAppend(const ListAppend_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListAppend");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "m=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_m);
        dec_indent();
    }
    void visit_SelectType(const SelectType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "selector=");
        attached = true;
        self().visit_expr(*x.m_selector);
        s.append("\n" + indtd + "|-" + "assoc_name=");
        if (x.m_assoc_name) {
            s.append(x.m_assoc_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_type_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "default=↧");
        for (size_t i=0; i<x.n_default; i++) {
            inc_indent();
            last = i == x.n_default-1;
            attached = false;
            self().visit_stmt(*x.m_default[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrToPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "cptr=");
        attached = true;
        self().visit_expr(*x.m_cptr);
        s.append("\n" + indtd + "|-" + "ptr=");
        attached = true;
        self().visit_expr(*x.m_ptr);
        s.append("\n" + indtd + "|-" + "shape=");
        if (x.m_shape) {
            self().visit_expr(*x.m_shape);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "lower_bounds=");
        last = true;
        if (x.m_lower_bounds) {
            self().visit_expr(*x.m_lower_bounds);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_BlockCall(const BlockCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "└-" + "m=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_m);
        dec_indent();
    }
    void visit_SetInsert(const SetInsert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_SetRemove(const SetRemove_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_ListInsert(const ListInsert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "pos=");
        attached = true;
        self().visit_expr(*x.m_pos);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_ListRemove(const ListRemove_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_ListClear(const ListClear_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListClear");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "a=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_a);
        dec_indent();
    }
    void visit_DictInsert(const DictInsert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "key=");
        attached = true;
        self().visit_expr(*x.m_key);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_DictClear(const DictClear_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictClear");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "a=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_a);
        dec_indent();
    }
    void visit_SetClear(const SetClear_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetClear");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "a=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_a);
        dec_indent();
    }
    void visit_Expr(const Expr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Expr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "expression=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_expression);
        dec_indent();
    }
    void visit_IfExp(const IfExp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfExp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=");
        attached = true;
        self().visit_expr(*x.m_body);
        s.append("\n" + indtd + "|-" + "orelse=");
        attached = true;
        self().visit_expr(*x.m_orelse);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "re=");
        attached = true;
        self().visit_expr(*x.m_re);
        s.append("\n" + indtd + "|-" + "im=");
        attached = true;
        self().visit_expr(*x.m_im);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("NamedExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        attached = true;
        self().visit_symbol(*x.m_name);
        s.append("\n" + indtd + "|-" + "original_name=");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "dt=");
        last = true;
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicElementalFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "intrinsic_id=");
        s.append(std::to_string(x.m_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicArrayFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arr_intrinsic_id=");
        s.append(std::to_string(x.m_arr_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "impure_intrinsic_id=");
        s.append(std::to_string(x.m_impure_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeInquiry");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "inquiry_id=");
        s.append(std::to_string(x.m_inquiry_id));
        s.append("\n" + indtd + "|-" + "arg_type=");
        attached = true;
        self().visit_ttype(*x.m_arg_type);
        s.append("\n" + indtd + "|-" + "arg=");
        if (x.m_arg) {
            self().visit_expr(*x.m_arg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_StructConstructor(const StructConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StructConstant(const StructConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_EnumConstructor(const EnumConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnionConstructor(const UnionConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImpliedDoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "var=");
        attached = true;
        self().visit_expr(*x.m_var);
        s.append("\n" + indtd + "|-" + "start=");
        attached = true;
        self().visit_expr(*x.m_start);
        s.append("\n" + indtd + "|-" + "end=");
        attached = true;
        self().visit_expr(*x.m_end);
        s.append("\n" + indtd + "|-" + "increment=");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n=");
        s.append(std::to_string(x.m_n));
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "integerbozType=");
        visit_integerbozType(x.m_intboz_type);
        dec_indent();
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n=");
        s.append(std::to_string(x.m_n));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealConstant(const RealConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "r=");
        s.append(std::to_string(x.m_r));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealCompare(const RealCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCopySign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "source=");
        attached = true;
        self().visit_expr(*x.m_source);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "re=");
        s.append(std::to_string(x.m_re));
        s.append("\n" + indtd + "|-" + "im=");
        s.append(std::to_string(x.m_im));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "logicalbinopType=");
        visit_logicalbinopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListConstant(const ListConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_ListLen(const ListLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListConcat(const ListConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListCompare(const ListCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListCount(const ListCount_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCount");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "ele=");
        attached = true;
        self().visit_expr(*x.m_ele);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListContains(const ListContains_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListContains");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SetConstant(const SetConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "elements=↧");
        for (size_t i=0; i<x.n_elements; i++) {
            inc_lindent();
            last = i == x.n_elements-1;
            attached = false;
            self().visit_expr(*x.m_elements[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_SetLen(const SetLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "elements=↧");
        for (size_t i=0; i<x.n_elements; i++) {
            inc_lindent();
            last = i == x.n_elements-1;
            attached = false;
            self().visit_expr(*x.m_elements[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_TupleLen(const TupleLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleContains(const TupleContains_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleContains");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringConstant(const StringConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "s=");
        s.append("\"" + std::string(x.m_s) + "\"");
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_StringConcat(const StringConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringLen(const StringLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringItem(const StringItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "idx=");
        attached = true;
        self().visit_expr(*x.m_idx);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringSection(const StringSection_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "step=");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringCompare(const StringCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringContains(const StringContains_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringContains");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "substr=");
        attached = true;
        self().visit_expr(*x.m_substr);
        s.append("\n" + indtd + "|-" + "str=");
        attached = true;
        self().visit_expr(*x.m_str);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringOrd(const StringOrd_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringOrd");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringChr(const StringChr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringChr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringFormat(const StringFormat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringFormat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "fmt=");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "string_format_kindType=");
        visit_string_format_kindType(x.m_kind);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringPhysicalCast(const StringPhysicalCast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringPhysicalCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "string_physical_typeType=");
        visit_string_physical_typeType(x.m_old);
        s.append("\n" + indtd + "|-" + "string_physical_typeType=");
        visit_string_physical_typeType(x.m_new);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictConstant(const DictConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "keys=↧");
        for (size_t i=0; i<x.n_keys; i++) {
            inc_lindent();
            last = i == x.n_keys-1;
            attached = false;
            self().visit_expr(*x.m_keys[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_DictLen(const DictLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Var(const Var_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Var");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "v=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_v);
        dec_indent();
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionParam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "param_number=");
        s.append(std::to_string(x.m_param_number));
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "arraystorageType=");
        visit_arraystorageType(x.m_storage_format);
        dec_indent();
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n_data=");
        s.append(std::to_string(x.m_n_data));
        s.append("Unimplementedvoid");
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "arraystorageType=");
        visit_arraystorageType(x.m_storage_format);
        dec_indent();
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_array_index(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "arraystorageType=");
        visit_arraystorageType(x.m_storage_format);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArraySection(const ArraySection_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_array_index(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArraySize(const ArraySize_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySize");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "dim=");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBound");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "dim=");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "arrayboundType=");
        visit_arrayboundType(x.m_bound);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayTranspose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "matrix=");
        attached = true;
        self().visit_expr(*x.m_matrix);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPack");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "mask=");
        attached = true;
        self().visit_expr(*x.m_mask);
        s.append("\n" + indtd + "|-" + "vector=");
        if (x.m_vector) {
            self().visit_expr(*x.m_vector);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayReshape");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "shape=");
        attached = true;
        self().visit_expr(*x.m_shape);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBroadcast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "shape=");
        attached = true;
        self().visit_expr(*x.m_shape);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_BitCast(const BitCast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BitCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "source=");
        attached = true;
        self().visit_expr(*x.m_source);
        s.append("\n" + indtd + "|-" + "mold=");
        attached = true;
        self().visit_expr(*x.m_mold);
        s.append("\n" + indtd + "|-" + "size=");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumName(const EnumName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "enum_type=");
        attached = true;
        self().visit_ttype(*x.m_enum_type);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumValue(const EnumValue_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumValue");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "enum_type=");
        attached = true;
        self().visit_ttype(*x.m_enum_type);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedBoolOp(const OverloadedBoolOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedBoolOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "logicalbinopType=");
        visit_logicalbinopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedStringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_Cast(const Cast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "cast_kindType=");
        visit_cast_kindType(x.m_kind);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPhysicalCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "array_physical_typeType=");
        visit_array_physical_typeType(x.m_old);
        s.append("\n" + indtd + "|-" + "array_physical_typeType=");
        visit_array_physical_typeType(x.m_new);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexRe");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexIm");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictItem(const DictItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "key=");
        attached = true;
        self().visit_expr(*x.m_key);
        s.append("\n" + indtd + "|-" + "default=");
        if (x.m_default) {
            self().visit_expr(*x.m_default);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CLoc(const CLoc_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CLoc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerToCPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GetPointer(const GetPointer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GetPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListItem(const ListItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "pos=");
        attached = true;
        self().visit_expr(*x.m_pos);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleItem(const TupleItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "pos=");
        attached = true;
        self().visit_expr(*x.m_pos);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListSection(const ListSection_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "section=");
        attached = true;
        self().visit_array_index(x.m_section);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictPop(const DictPop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "key=");
        attached = true;
        self().visit_expr(*x.m_key);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SetPop(const SetPop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SetContains(const SetContains_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetContains");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictContains(const DictContains_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictContains");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Ichar(const Ichar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Ichar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Iachar(const Iachar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Iachar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SizeOfType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_ttype(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerNullConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "var_expr=");
        last = true;
        if (x.m_var_expr) {
            self().visit_expr(*x.m_var_expr);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerAssociated");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "ptr=");
        attached = true;
        self().visit_expr(*x.m_ptr);
        s.append("\n" + indtd + "|-" + "tgt=");
        if (x.m_tgt) {
            self().visit_expr(*x.m_tgt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealSqrt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayIsContiguous(const ArrayIsContiguous_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayIsContiguous");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Integer(const Integer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Integer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedInteger");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("String");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "kind=");
        s.append(std::to_string(x.m_kind));
        s.append("\n" + indtd + "|-" + "len=");
        if (x.m_len) {
            self().visit_expr(*x.m_len);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "string_length_kindType=");
        visit_string_length_kindType(x.m_len_kind);
        s.append("\n" + indtd + "└-" + "string_physical_typeType=");
        visit_string_physical_typeType(x.m_physical_type);
        dec_indent();
    }
    void visit_Logical(const Logical_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Set");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_List(const List_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("List");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_Tuple(const Tuple_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Tuple");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=↧");
        for (size_t i=0; i<x.n_type; i++) {
            inc_indent();
            last = i == x.n_type-1;
            attached = false;
            self().visit_ttype(*x.m_type[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_StructType(const StructType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "data_member_types=↧");
        for (size_t i=0; i<x.n_data_member_types; i++) {
            inc_lindent();
            last = i == x.n_data_member_types-1;
            attached = false;
            self().visit_ttype(*x.m_data_member_types[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "member_function_types=↧");
        for (size_t i=0; i<x.n_member_function_types; i++) {
            inc_lindent();
            last = i == x.n_member_function_types-1;
            attached = false;
            self().visit_ttype(*x.m_member_function_types[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "is_cstruct=");
        if (x.m_is_cstruct) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "is_unlimited_polymorphic=");
        if (x.m_is_unlimited_polymorphic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_EnumType(const EnumType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "enum_type=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_enum_type);
        dec_indent();
    }
    void visit_UnionType(const UnionType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "data_member_types=↧");
        for (size_t i=0; i<x.n_data_member_types; i++) {
            inc_indent();
            last = i == x.n_data_member_types-1;
            attached = false;
            self().visit_ttype(*x.m_data_member_types[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Dict(const Dict_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Dict");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "key_type=");
        attached = true;
        self().visit_ttype(*x.m_key_type);
        s.append("\n" + indtd + "└-" + "value_type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_value_type);
        dec_indent();
    }
    void visit_Pointer(const Pointer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Pointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_Allocatable(const Allocatable_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocatable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_CPtr(const CPtr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicExpression");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeParameter");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "param=");
        s.append(x.m_param);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Array");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "dims=↧");
        for (size_t i=0; i<x.n_dims; i++) {
            inc_lindent();
            last = i == x.n_dims-1;
            attached = false;
            self().visit_dimension(x.m_dims[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "array_physical_typeType=");
        visit_array_physical_typeType(x.m_physical_type);
        dec_indent();
    }
    void visit_FunctionType(const FunctionType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg_types=↧");
        for (size_t i=0; i<x.n_arg_types; i++) {
            inc_lindent();
            last = i == x.n_arg_types-1;
            attached = false;
            self().visit_ttype(*x.m_arg_types[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "return_var_type=");
        if (x.m_return_var_type) {
            self().visit_ttype(*x.m_return_var_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "deftypeType=");
        visit_deftypeType(x.m_deftype);
        s.append("\n" + indtd + "|-" + "bindc_name=");
        if (x.m_bindc_name) {
            s.append("\"" + std::string(x.m_bindc_name) + "\"");
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "elemental=");
        if (x.m_elemental) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "pure=");
        if (x.m_pure) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "module=");
        if (x.m_module) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "inline=");
        if (x.m_inline) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "static=");
        if (x.m_static) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "restrictions=↧");
        for (size_t i=0; i<x.n_restrictions; i++) {
            inc_lindent();
            last = i == x.n_restrictions-1;
            attached = false;
            self().visit_symbol(*x.m_restrictions[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "is_restriction=");
        if (x.m_is_restriction) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_cast_kindType(const cast_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cast_kindType::RealToInteger) : {
                s.append("RealToInteger");
             break; }
            case (cast_kindType::IntegerToReal) : {
                s.append("IntegerToReal");
             break; }
            case (cast_kindType::LogicalToReal) : {
                s.append("LogicalToReal");
             break; }
            case (cast_kindType::RealToReal) : {
                s.append("RealToReal");
             break; }
            case (cast_kindType::IntegerToInteger) : {
                s.append("IntegerToInteger");
             break; }
            case (cast_kindType::RealToComplex) : {
                s.append("RealToComplex");
             break; }
            case (cast_kindType::IntegerToComplex) : {
                s.append("IntegerToComplex");
             break; }
            case (cast_kindType::IntegerToLogical) : {
                s.append("IntegerToLogical");
             break; }
            case (cast_kindType::RealToLogical) : {
                s.append("RealToLogical");
             break; }
            case (cast_kindType::StringToLogical) : {
                s.append("StringToLogical");
             break; }
            case (cast_kindType::StringToInteger) : {
                s.append("StringToInteger");
             break; }
            case (cast_kindType::StringToList) : {
                s.append("StringToList");
             break; }
            case (cast_kindType::ComplexToLogical) : {
                s.append("ComplexToLogical");
             break; }
            case (cast_kindType::ComplexToComplex) : {
                s.append("ComplexToComplex");
             break; }
            case (cast_kindType::ComplexToReal) : {
                s.append("ComplexToReal");
             break; }
            case (cast_kindType::ComplexToInteger) : {
                s.append("ComplexToInteger");
             break; }
            case (cast_kindType::LogicalToInteger) : {
                s.append("LogicalToInteger");
             break; }
            case (cast_kindType::RealToString) : {
                s.append("RealToString");
             break; }
            case (cast_kindType::IntegerToString) : {
                s.append("IntegerToString");
             break; }
            case (cast_kindType::LogicalToString) : {
                s.append("LogicalToString");
             break; }
            case (cast_kindType::UnsignedIntegerToInteger) : {
                s.append("UnsignedIntegerToInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToUnsignedInteger) : {
                s.append("UnsignedIntegerToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToReal) : {
                s.append("UnsignedIntegerToReal");
             break; }
            case (cast_kindType::UnsignedIntegerToLogical) : {
                s.append("UnsignedIntegerToLogical");
             break; }
            case (cast_kindType::IntegerToUnsignedInteger) : {
                s.append("IntegerToUnsignedInteger");
             break; }
            case (cast_kindType::RealToUnsignedInteger) : {
                s.append("RealToUnsignedInteger");
             break; }
            case (cast_kindType::CPtrToUnsignedInteger) : {
                s.append("CPtrToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToCPtr) : {
                s.append("UnsignedIntegerToCPtr");
             break; }
            case (cast_kindType::IntegerToSymbolicExpression) : {
                s.append("IntegerToSymbolicExpression");
             break; }
            case (cast_kindType::ListToArray) : {
                s.append("ListToArray");
             break; }
            case (cast_kindType::PointerToInteger) : {
                s.append("PointerToInteger");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_storage_typeType(const storage_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (storage_typeType::Default) : {
                s.append("Default");
             break; }
            case (storage_typeType::Save) : {
                s.append("Save");
             break; }
            case (storage_typeType::Parameter) : {
                s.append("Parameter");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_accessType(const accessType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (accessType::Public) : {
                s.append("Public");
             break; }
            case (accessType::Private) : {
                s.append("Private");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_intentType(const intentType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (intentType::Local) : {
                s.append("Local");
             break; }
            case (intentType::In) : {
                s.append("In");
             break; }
            case (intentType::Out) : {
                s.append("Out");
             break; }
            case (intentType::InOut) : {
                s.append("InOut");
             break; }
            case (intentType::ReturnVar) : {
                s.append("ReturnVar");
             break; }
            case (intentType::Unspecified) : {
                s.append("Unspecified");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_deftypeType(const deftypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (deftypeType::Implementation) : {
                s.append("Implementation");
             break; }
            case (deftypeType::Interface) : {
                s.append("Interface");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_presenceType(const presenceType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (presenceType::Required) : {
                s.append("Required");
             break; }
            case (presenceType::Optional) : {
                s.append("Optional");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_abiType(const abiType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (abiType::Source) : {
                s.append("Source");
             break; }
            case (abiType::LFortranModule) : {
                s.append("LFortranModule");
             break; }
            case (abiType::GFortranModule) : {
                s.append("GFortranModule");
             break; }
            case (abiType::BindC) : {
                s.append("BindC");
             break; }
            case (abiType::BindPython) : {
                s.append("BindPython");
             break; }
            case (abiType::BindJS) : {
                s.append("BindJS");
             break; }
            case (abiType::ExternalUndefined) : {
                s.append("ExternalUndefined");
             break; }
            case (abiType::Intrinsic) : {
                s.append("Intrinsic");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_dimension(const dimension_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "length=");
        last = true;
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "dims=↧");
        for (size_t i=0; i<x.n_dims; i++) {
            inc_lindent();
            last = i == x.n_dims-1;
            attached = false;
            self().visit_dimension(x.m_dims[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "len_expr=");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "sym_subclass=");
        if (x.m_sym_subclass) {
            self().visit_symbol(*x.m_sym_subclass);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Attribute(const Attribute_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Attribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_attribute_arg(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "arg=");
        s.append(x.m_arg);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_reduction_expr(const reduction_expr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "reduction_opType=");
        visit_reduction_opType(x.m_op);
        s.append("\n" + indtd + "└-" + "arg=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_arg);
        dec_indent();
    }
    void visit_Bind(const Bind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "lang=");
        s.append("\"" + std::string(x.m_lang) + "\"");
        s.append("\n" + indtd + "└-" + "name=");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "left=");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "right=");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "step=");
        last = true;
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "v=");
        if (x.m_v) {
            self().visit_expr(*x.m_v);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "increment=");
        last = true;
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=↧");
        for (size_t i=0; i<x.n_test; i++) {
            inc_lindent();
            last = i == x.n_test-1;
            attached = false;
            self().visit_expr(*x.m_test[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "fall_through=");
        if (x.m_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt_Range");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "sym=");
        attached = true;
        self().visit_symbol(*x.m_sym);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "sym=");
        attached = true;
        self().visit_symbol(*x.m_sym);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_enumtypeType(const enumtypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (enumtypeType::IntegerConsecutiveFromZero) : {
                s.append("IntegerConsecutiveFromZero");
             break; }
            case (enumtypeType::IntegerUnique) : {
                s.append("IntegerUnique");
             break; }
            case (enumtypeType::IntegerNotUnique) : {
                s.append("IntegerNotUnique");
             break; }
            case (enumtypeType::NonInteger) : {
                s.append("NonInteger");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_Require(const Require_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Require");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "args=");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_physical_typeType(const array_physical_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (array_physical_typeType::DescriptorArray) : {
                s.append("DescriptorArray");
             break; }
            case (array_physical_typeType::PointerArray) : {
                s.append("PointerArray");
             break; }
            case (array_physical_typeType::UnboundedPointerArray) : {
                s.append("UnboundedPointerArray");
             break; }
            case (array_physical_typeType::FixedSizeArray) : {
                s.append("FixedSizeArray");
             break; }
            case (array_physical_typeType::StringArraySinglePointer) : {
                s.append("StringArraySinglePointer");
             break; }
            case (array_physical_typeType::NumPyArray) : {
                s.append("NumPyArray");
             break; }
            case (array_physical_typeType::ISODescriptorArray) : {
                s.append("ISODescriptorArray");
             break; }
            case (array_physical_typeType::SIMDArray) : {
                s.append("SIMDArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_physical_typeType(const string_physical_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_physical_typeType::DescriptorString) : {
                s.append("DescriptorString");
             break; }
            case (string_physical_typeType::CChar) : {
                s.append("CChar");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_length_kindType(const string_length_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_length_kindType::AssumedLength) : {
                s.append("AssumedLength");
             break; }
            case (string_length_kindType::DeferredLength) : {
                s.append("DeferredLength");
             break; }
            case (string_length_kindType::ExpressionLength) : {
                s.append("ExpressionLength");
             break; }
            case (string_length_kindType::ImplicitLength) : {
                s.append("ImplicitLength");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_binopType(const binopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (binopType::Add) : {
                s.append("Add");
             break; }
            case (binopType::Sub) : {
                s.append("Sub");
             break; }
            case (binopType::Mul) : {
                s.append("Mul");
             break; }
            case (binopType::Div) : {
                s.append("Div");
             break; }
            case (binopType::Pow) : {
                s.append("Pow");
             break; }
            case (binopType::BitAnd) : {
                s.append("BitAnd");
             break; }
            case (binopType::BitOr) : {
                s.append("BitOr");
             break; }
            case (binopType::BitXor) : {
                s.append("BitXor");
             break; }
            case (binopType::BitLShift) : {
                s.append("BitLShift");
             break; }
            case (binopType::BitRShift) : {
                s.append("BitRShift");
             break; }
            case (binopType::LBitRShift) : {
                s.append("LBitRShift");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_reduction_opType(const reduction_opType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (reduction_opType::ReduceAdd) : {
                s.append("ReduceAdd");
             break; }
            case (reduction_opType::ReduceSub) : {
                s.append("ReduceSub");
             break; }
            case (reduction_opType::ReduceMul) : {
                s.append("ReduceMul");
             break; }
            case (reduction_opType::ReduceMIN) : {
                s.append("ReduceMIN");
             break; }
            case (reduction_opType::ReduceMAX) : {
                s.append("ReduceMAX");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_logicalbinopType(const logicalbinopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (logicalbinopType::And) : {
                s.append("And");
             break; }
            case (logicalbinopType::Or) : {
                s.append("Or");
             break; }
            case (logicalbinopType::Xor) : {
                s.append("Xor");
             break; }
            case (logicalbinopType::NEqv) : {
                s.append("NEqv");
             break; }
            case (logicalbinopType::Eqv) : {
                s.append("Eqv");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("Eq");
             break; }
            case (cmpopType::NotEq) : {
                s.append("NotEq");
             break; }
            case (cmpopType::Lt) : {
                s.append("Lt");
             break; }
            case (cmpopType::LtE) : {
                s.append("LtE");
             break; }
            case (cmpopType::Gt) : {
                s.append("Gt");
             break; }
            case (cmpopType::GtE) : {
                s.append("GtE");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_integerbozType(const integerbozType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (integerbozType::Binary) : {
                s.append("Binary");
             break; }
            case (integerbozType::Hex) : {
                s.append("Hex");
             break; }
            case (integerbozType::Octal) : {
                s.append("Octal");
             break; }
            case (integerbozType::Decimal) : {
                s.append("Decimal");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arrayboundType(const arrayboundType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arrayboundType::LBound) : {
                s.append("LBound");
             break; }
            case (arrayboundType::UBound) : {
                s.append("UBound");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arraystorageType(const arraystorageType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arraystorageType::RowMajor) : {
                s.append("RowMajor");
             break; }
            case (arraystorageType::ColMajor) : {
                s.append("ColMajor");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_format_kindType(const string_format_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_format_kindType::FormatFortran) : {
                s.append("FormatFortran");
             break; }
            case (string_format_kindType::FormatC) : {
                s.append("FormatC");
             break; }
            case (string_format_kindType::FormatPythonPercent) : {
                s.append("FormatPythonPercent");
             break; }
            case (string_format_kindType::FormatPythonFString) : {
                s.append("FormatPythonFString");
             break; }
            case (string_format_kindType::FormatPythonFormat) : {
                s.append("FormatPythonFormat");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_omp_region_typeType(const omp_region_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (omp_region_typeType::Parallel) : {
                s.append("Parallel");
             break; }
            case (omp_region_typeType::Do) : {
                s.append("Do");
             break; }
            case (omp_region_typeType::ParallelDo) : {
                s.append("ParallelDo");
             break; }
            case (omp_region_typeType::Sections) : {
                s.append("Sections");
             break; }
            case (omp_region_typeType::Section) : {
                s.append("Section");
             break; }
            case (omp_region_typeType::ParallelSections) : {
                s.append("ParallelSections");
             break; }
            case (omp_region_typeType::Critical) : {
                s.append("Critical");
             break; }
            case (omp_region_typeType::Atomic) : {
                s.append("Atomic");
             break; }
            case (omp_region_typeType::Barrier) : {
                s.append("Barrier");
             break; }
            case (omp_region_typeType::Single) : {
                s.append("Single");
             break; }
            case (omp_region_typeType::Master) : {
                s.append("Master");
             break; }
            case (omp_region_typeType::Task) : {
                s.append("Task");
             break; }
            case (omp_region_typeType::Taskwait) : {
                s.append("Taskwait");
             break; }
            case (omp_region_typeType::Taskloop) : {
                s.append("Taskloop");
             break; }
            case (omp_region_typeType::Simd) : {
                s.append("Simd");
             break; }
            case (omp_region_typeType::Teams) : {
                s.append("Teams");
             break; }
            case (omp_region_typeType::Distribute) : {
                s.append("Distribute");
             break; }
            case (omp_region_typeType::TeamsDistribute) : {
                s.append("TeamsDistribute");
             break; }
            case (omp_region_typeType::DistributeParallelDo) : {
                s.append("DistributeParallelDo");
             break; }
            case (omp_region_typeType::Target) : {
                s.append("Target");
             break; }
            case (omp_region_typeType::TargetData) : {
                s.append("TargetData");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_OMPPrivate(const OMPPrivate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPPrivate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_OMPShared(const OMPShared_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPShared");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_OMPFirstPrivate(const OMPFirstPrivate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPFirstPrivate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_OMPLastPrivate(const OMPLastPrivate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPLastPrivate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_OMPReduction(const OMPReduction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPReduction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "reduction_opType=");
        visit_reduction_opType(x.m_operator);
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_OMPCollapse(const OMPCollapse_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPCollapse");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "count=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_count);
        dec_indent();
    }
    void visit_OMPIf(const OMPIf_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPIf");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "condition=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_condition);
        dec_indent();
    }
    void visit_OMPNumThreads(const OMPNumThreads_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPNumThreads");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "num_threads=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_num_threads);
        dec_indent();
    }
    void visit_OMPSchedule(const OMPSchedule_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPSchedule");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "schedule_typeType=");
        visit_schedule_typeType(x.m_kind);
        s.append("\n" + indtd + "└-" + "chunk_size=");
        last = true;
        if (x.m_chunk_size) {
            self().visit_expr(*x.m_chunk_size);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_OMPNowait(const OMPNowait_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPNowait");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OMPNumTeams(const OMPNumTeams_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPNumTeams");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "num_teams=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_num_teams);
        dec_indent();
    }
    void visit_OMPThreadLimit(const OMPThreadLimit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPThreadLimit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "thread_limit=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_thread_limit);
        dec_indent();
    }
    void visit_OMPDevice(const OMPDevice_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPDevice");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "device=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_device);
        dec_indent();
    }
    void visit_OMPMap(const OMPMap_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OMPMap");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "map_typeType=");
        visit_map_typeType(x.m_type);
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_map_typeType(const map_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (map_typeType::To) : {
                s.append("To");
             break; }
            case (map_typeType::From) : {
                s.append("From");
             break; }
            case (map_typeType::ToFrom) : {
                s.append("ToFrom");
             break; }
            case (map_typeType::Alloc) : {
                s.append("Alloc");
             break; }
            case (map_typeType::Release) : {
                s.append("Release");
             break; }
            case (map_typeType::Delete) : {
                s.append("Delete");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_schedule_typeType(const schedule_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (schedule_typeType::Static) : {
                s.append("Static");
             break; }
            case (schedule_typeType::Dynamic) : {
                s.append("Dynamic");
             break; }
            case (schedule_typeType::Guided) : {
                s.append("Guided");
             break; }
            case (schedule_typeType::Auto) : {
                s.append("Auto");
             break; }
            case (schedule_typeType::Runtime) : {
                s.append("Runtime");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
};


}
