% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkTRUE.R
\name{checkTRUE}
\alias{checkTRUE}
\alias{check_true}
\alias{assertTRUE}
\alias{assert_true}
\alias{testTRUE}
\alias{test_true}
\title{Check if an argument is TRUE}
\usage{
checkTRUE(x, na.ok = FALSE)

check_true(x, na.ok = FALSE)

assertTRUE(x, na.ok = FALSE, .var.name = vname(x), add = NULL)

assert_true(x, na.ok = FALSE, .var.name = vname(x), add = NULL)

testTRUE(x, na.ok = FALSE)

test_true(x, na.ok = FALSE)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertTRUE.}/\code{assert_true.} return 
 \code{x} invisibly, whereas
 \code{checkTRUE.}/\code{check_true.} and 
 \code{testTRUE.}/\code{test_true.} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertTRUE.}/\code{assert_true.}
 throws an error message, 
 \code{testTRUE.}/\code{test_true.}
 returns \code{FALSE},
 and \code{checkTRUE.}/\code{check_true.} 
 return a string with the error message.
 The function \code{expect_true.} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Simply checks if an argument is \code{TRUE}.
}
\examples{
testTRUE(TRUE)
testTRUE(FALSE)
}
