% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paint.R
\name{painting}
\alias{painting}
\alias{image_fill}
\alias{image_annotate}
\title{Image Painting}
\usage{
image_fill(image, color, point = "+1+1", fuzz = 0, refcolor = NULL)

image_annotate(
  image,
  text,
  gravity = "northwest",
  location = "+0+0",
  degrees = 0,
  size = 10,
  font = "",
  style = "normal",
  weight = 400,
  kerning = 0,
  decoration = NULL,
  color = NULL,
  strokecolor = NULL,
  strokewidth = NULL,
  boxcolor = NULL
)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{color}{a valid \href{https://imagemagick.org/Magick++/Color.html}{color string} such as
\code{"navyblue"} or \code{"#000080"}. Use \code{"none"} for transparency.}

\item{point}{a geometry_point string indicating the starting point of the flood-fill}

\item{fuzz}{relative color distance (value between 0 and 100) to be considered similar
in the filling algorithm}

\item{refcolor}{if set, \code{fuzz} color distance will be measured against this color,
not the color of the starting \code{point}. Any color (within \code{fuzz} color distance of
the given \code{refcolor}), connected to starting point will be replaced with the \code{color}.
If the pixel at the starting point does not itself match the given \code{refcolor}
(according to \code{fuzz}) then no action will be taken.}

\item{text}{character vector of length equal to 'image' or length 1}

\item{gravity}{string with
\href{https://imagemagick.org/Magick++/Enumerations.html#GravityType}{gravity}
value from \link{gravity_types}.}

\item{location}{geometry string with location relative to \code{gravity}}

\item{degrees}{rotates text around center point}

\item{size}{font-size in pixels}

\item{font}{string with font family such as \code{"sans"}, \code{"mono"}, \code{"serif"},
\code{"Times"}, \code{"Helvetica"}, \code{"Trebuchet"}, \code{"Georgia"}, \code{"Palatino"} or \code{"Comic Sans"}.
See \code{\link[=magick_fonts]{magick_fonts()}} for what is available.}

\item{style}{value of \link{style_types} for example \code{"italic"}}

\item{weight}{thickness of the font, 400 is normal and 700 is bold, see \code{\link[=magick_fonts]{magick_fonts()}}.}

\item{kerning}{increases or decreases whitespace between letters}

\item{decoration}{value of \link{decoration_types} for example \code{"underline"}}

\item{strokecolor}{a \href{https://imagemagick.org/Magick++/Color.html}{color string}
adds a stroke (border around the text)}

\item{strokewidth}{set the strokewidth of the border around the text}

\item{boxcolor}{a \href{https://imagemagick.org/Magick++/Color.html}{color string}
for background color that annotation text is rendered on.}
}
\description{
The \code{\link[=image_fill]{image_fill()}} function performs flood-fill by painting starting point and all
neighboring pixels of approximately the same color. Annotate prints some text on
the image.
}
\details{
Note that more sophisticated drawing mechanisms are available via the graphics
device using \link{image_draw}.

Setting a font, weight, style only works if your imagemagick is compiled
with fontconfig support.
}
\examples{
logo <- image_read("logo:")
logo <- image_background(logo, 'white')
image_fill(logo, "pink", point = "+450+400")
image_fill(logo, "pink", point = "+450+400", fuzz = 25)
# Add some text to an image
image_annotate(logo, "This is a test")
image_annotate(logo, "CONFIDENTIAL", size = 50, color = "red", boxcolor = "pink",
 degrees = 30, location = "+100+100")

# Setting fonts requires fontconfig support (and that you have the font)
image_annotate(logo, "The quick brown fox", font = "monospace", size = 50)
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{defines}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
