/*
 *                            COPYRIGHT
 *
 *  sch-rnd - modular/flexible schematics editor - any map helpers (e.g. devmap/funcmap)
 *  Copyright (C) 2023 Tibor 'Igor2' Palinkas
 *
 *  (Supported by NLnet NGI0 Entrust in 2023)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/sch-rnd
 *    contact lead developer: http://www.repo.hu/projects/sch-rnd/contact.html
 *    mailing list: http://www.repo.hu/projects/sch-rnd/contact.html
 */

/* Maintain a cache of parsed comp/net/conn objects and compile abstract
   model from them */

#include <libcschem/config.h>

#include <stdio.h>
#include <genht/htsp.h>
#include <genht/hash.h>
#include <librnd/core/plugins.h>
#include <librnd/core/error.h>
#include <librnd/core/compat_misc.h>
#include <libcschem/abstract.h>
#include <libcschem/actions_csch.h>
#include <libcschem/concrete.h>
#include <libcschem/cnc_grp.h>
#include <libcschem/engine.h>

#include "lib_anymap.h"

#include "loclib.c"
#include "libs.c"
#include "preview.c"

/*** plugin ***/

int pplg_check_ver_lib_anymap(int ver_needed) { return 0; }

void pplg_uninit_lib_anymap(void)
{
}

int pplg_init_lib_anymap(void)
{
	RND_API_CHK_VER;

	return 0;
}

