---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, numéro, symbole numéro, symbole degré, 
              petit rond, petit o, o en exposant, petit zéro
---

# Comment obtenir le symbole "numéro" ?

La version actuelle de LaTeX dispose par défaut d'une commande `\textnumero`. 
Mais ce symbole est à éviter dans un texte français (voir ci-après l'évocation de <ctanpkg:textcomp>). 
D'où les solutions présentées ci-après.


## Avec l'extension <ctanpkg:babel>

L'option `french` de l'extension [babel](ctanpkg:babel-french) fournit les
commandes `\no` et `\No`. En voici un exemple (où l'option `french` est placée 
dans les options de l'extension).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici venir le \no 1 et le \No 2.
\end{document}
```


## Avec l'extension <ctanpkg:e-french>

L'extension <ctanpkg:e-french> fournit des commandes `\numero`, `\Numero`, `\numeros` et `\Numeros`.

:::{todo} Exemple compilable à ajouter.
:::


## Avec l'extension <ctanpkg:textcomp>

:::{warning}
L’extension <ctanpkg:textcomp> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif, d'autant plus que le symbole obtenu n'est pas recommandé.
:::

L'extension <ctanpkg:textcomp> fournit un symbole `\textnumero` qui, si la police active le permet,
produit un glyphe qui est une abréviation de numéro plutôt d’usage dans les langues slaves. 
Ce glyphe n’est pas disponible avec l’extension <ctanpkg:fourier>.

En voici un exemple :

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{textcomp}

\begin{document}
Voici venir le \textnumero 1.
\end{document}
```