package coninput

// VirtualKeyCode holds a virtual key code (see
// https://docs.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes).
type VirtualKeyCode uint16

const (
	VK_LBUTTON             VirtualKeyCode = 0x01
	VK_RBUTTON             VirtualKeyCode = 0x02
	VK_CANCEL              VirtualKeyCode = 0x03
	VK_MBUTTON             VirtualKeyCode = 0x04
	VK_XBUTTON1            VirtualKeyCode = 0x05
	VK_XBUTTON2            VirtualKeyCode = 0x06
	VK_BACK                VirtualKeyCode = 0x08
	VK_TAB                 VirtualKeyCode = 0x09
	VK_CLEAR               VirtualKeyCode = 0x0C
	VK_RETURN              VirtualKeyCode = 0x0D
	VK_SHIFT               VirtualKeyCode = 0x10
	VK_CONTROL             VirtualKeyCode = 0x11
	VK_MENU                VirtualKeyCode = 0x12
	VK_PAUSE               VirtualKeyCode = 0x13
	VK_CAPITAL             VirtualKeyCode = 0x14
	VK_KANA                VirtualKeyCode = 0x15
	VK_HANGEUL             VirtualKeyCode = 0x15
	VK_HANGUL              VirtualKeyCode = 0x15
	VK_IME_ON              VirtualKeyCode = 0x16
	VK_JUNJA               VirtualKeyCode = 0x17
	VK_FINAL               VirtualKeyCode = 0x18
	VK_HANJA               VirtualKeyCode = 0x19
	VK_KANJI               VirtualKeyCode = 0x19
	VK_IME_OFF             VirtualKeyCode = 0x1A
	VK_ESCAPE              VirtualKeyCode = 0x1B
	VK_CONVERT             VirtualKeyCode = 0x1C
	VK_NONCONVERT          VirtualKeyCode = 0x1D
	VK_ACCEPT              VirtualKeyCode = 0x1E
	VK_MODECHANGE          VirtualKeyCode = 0x1F
	VK_SPACE               VirtualKeyCode = 0x20
	VK_PRIOR               VirtualKeyCode = 0x21
	VK_NEXT                VirtualKeyCode = 0x22
	VK_END                 VirtualKeyCode = 0x23
	VK_HOME                VirtualKeyCode = 0x24
	VK_LEFT                VirtualKeyCode = 0x25
	VK_UP                  VirtualKeyCode = 0x26
	VK_RIGHT               VirtualKeyCode = 0x27
	VK_DOWN                VirtualKeyCode = 0x28
	VK_SELECT              VirtualKeyCode = 0x29
	VK_PRINT               VirtualKeyCode = 0x2A
	VK_EXECUTE             VirtualKeyCode = 0x2B
	VK_SNAPSHOT            VirtualKeyCode = 0x2C
	VK_INSERT              VirtualKeyCode = 0x2D
	VK_DELETE              VirtualKeyCode = 0x2E
	VK_HELP                VirtualKeyCode = 0x2F
	VK_0                   VirtualKeyCode = 0x30
	VK_1                   VirtualKeyCode = 0x31
	VK_2                   VirtualKeyCode = 0x32
	VK_3                   VirtualKeyCode = 0x33
	VK_4                   VirtualKeyCode = 0x34
	VK_5                   VirtualKeyCode = 0x35
	VK_6                   VirtualKeyCode = 0x36
	VK_7                   VirtualKeyCode = 0x37
	VK_8                   VirtualKeyCode = 0x38
	VK_9                   VirtualKeyCode = 0x39
	VK_A                   VirtualKeyCode = 0x41
	VK_B                   VirtualKeyCode = 0x42
	VK_C                   VirtualKeyCode = 0x43
	VK_D                   VirtualKeyCode = 0x44
	VK_E                   VirtualKeyCode = 0x45
	VK_F                   VirtualKeyCode = 0x46
	VK_G                   VirtualKeyCode = 0x47
	VK_H                   VirtualKeyCode = 0x48
	VK_I                   VirtualKeyCode = 0x49
	VK_J                   VirtualKeyCode = 0x4A
	VK_K                   VirtualKeyCode = 0x4B
	VK_L                   VirtualKeyCode = 0x4C
	VK_M                   VirtualKeyCode = 0x4D
	VK_N                   VirtualKeyCode = 0x4E
	VK_O                   VirtualKeyCode = 0x4F
	VK_P                   VirtualKeyCode = 0x50
	VK_Q                   VirtualKeyCode = 0x51
	VK_R                   VirtualKeyCode = 0x52
	VK_S                   VirtualKeyCode = 0x53
	VK_T                   VirtualKeyCode = 0x54
	VK_U                   VirtualKeyCode = 0x55
	VK_V                   VirtualKeyCode = 0x56
	VK_W                   VirtualKeyCode = 0x57
	VK_X                   VirtualKeyCode = 0x58
	VK_Y                   VirtualKeyCode = 0x59
	VK_Z                   VirtualKeyCode = 0x5A
	VK_LWIN                VirtualKeyCode = 0x5B
	VK_RWIN                VirtualKeyCode = 0x5C
	VK_APPS                VirtualKeyCode = 0x5D
	VK_SLEEP               VirtualKeyCode = 0x5F
	VK_NUMPAD0             VirtualKeyCode = 0x60
	VK_NUMPAD1             VirtualKeyCode = 0x61
	VK_NUMPAD2             VirtualKeyCode = 0x62
	VK_NUMPAD3             VirtualKeyCode = 0x63
	VK_NUMPAD4             VirtualKeyCode = 0x64
	VK_NUMPAD5             VirtualKeyCode = 0x65
	VK_NUMPAD6             VirtualKeyCode = 0x66
	VK_NUMPAD7             VirtualKeyCode = 0x67
	VK_NUMPAD8             VirtualKeyCode = 0x68
	VK_NUMPAD9             VirtualKeyCode = 0x69
	VK_MULTIPLY            VirtualKeyCode = 0x6A
	VK_ADD                 VirtualKeyCode = 0x6B
	VK_SEPARATOR           VirtualKeyCode = 0x6C
	VK_SUBTRACT            VirtualKeyCode = 0x6D
	VK_DECIMAL             VirtualKeyCode = 0x6E
	VK_DIVIDE              VirtualKeyCode = 0x6F
	VK_F1                  VirtualKeyCode = 0x70
	VK_F2                  VirtualKeyCode = 0x71
	VK_F3                  VirtualKeyCode = 0x72
	VK_F4                  VirtualKeyCode = 0x73
	VK_F5                  VirtualKeyCode = 0x74
	VK_F6                  VirtualKeyCode = 0x75
	VK_F7                  VirtualKeyCode = 0x76
	VK_F8                  VirtualKeyCode = 0x77
	VK_F9                  VirtualKeyCode = 0x78
	VK_F10                 VirtualKeyCode = 0x79
	VK_F11                 VirtualKeyCode = 0x7A
	VK_F12                 VirtualKeyCode = 0x7B
	VK_F13                 VirtualKeyCode = 0x7C
	VK_F14                 VirtualKeyCode = 0x7D
	VK_F15                 VirtualKeyCode = 0x7E
	VK_F16                 VirtualKeyCode = 0x7F
	VK_F17                 VirtualKeyCode = 0x80
	VK_F18                 VirtualKeyCode = 0x81
	VK_F19                 VirtualKeyCode = 0x82
	VK_F20                 VirtualKeyCode = 0x83
	VK_F21                 VirtualKeyCode = 0x84
	VK_F22                 VirtualKeyCode = 0x85
	VK_F23                 VirtualKeyCode = 0x86
	VK_F24                 VirtualKeyCode = 0x87
	VK_NUMLOCK             VirtualKeyCode = 0x90
	VK_SCROLL              VirtualKeyCode = 0x91
	VK_OEM_NEC_EQUAL       VirtualKeyCode = 0x92
	VK_OEM_FJ_JISHO        VirtualKeyCode = 0x92
	VK_OEM_FJ_MASSHOU      VirtualKeyCode = 0x93
	VK_OEM_FJ_TOUROKU      VirtualKeyCode = 0x94
	VK_OEM_FJ_LOYA         VirtualKeyCode = 0x95
	VK_OEM_FJ_ROYA         VirtualKeyCode = 0x96
	VK_LSHIFT              VirtualKeyCode = 0xA0
	VK_RSHIFT              VirtualKeyCode = 0xA1
	VK_LCONTROL            VirtualKeyCode = 0xA2
	VK_RCONTROL            VirtualKeyCode = 0xA3
	VK_LMENU               VirtualKeyCode = 0xA4
	VK_RMENU               VirtualKeyCode = 0xA5
	VK_BROWSER_BACK        VirtualKeyCode = 0xA6
	VK_BROWSER_FORWARD     VirtualKeyCode = 0xA7
	VK_BROWSER_REFRESH     VirtualKeyCode = 0xA8
	VK_BROWSER_STOP        VirtualKeyCode = 0xA9
	VK_BROWSER_SEARCH      VirtualKeyCode = 0xAA
	VK_BROWSER_FAVORITES   VirtualKeyCode = 0xAB
	VK_BROWSER_HOME        VirtualKeyCode = 0xAC
	VK_VOLUME_MUTE         VirtualKeyCode = 0xAD
	VK_VOLUME_DOWN         VirtualKeyCode = 0xAE
	VK_VOLUME_UP           VirtualKeyCode = 0xAF
	VK_MEDIA_NEXT_TRACK    VirtualKeyCode = 0xB0
	VK_MEDIA_PREV_TRACK    VirtualKeyCode = 0xB1
	VK_MEDIA_STOP          VirtualKeyCode = 0xB2
	VK_MEDIA_PLAY_PAUSE    VirtualKeyCode = 0xB3
	VK_LAUNCH_MAIL         VirtualKeyCode = 0xB4
	VK_LAUNCH_MEDIA_SELECT VirtualKeyCode = 0xB5
	VK_LAUNCH_APP1         VirtualKeyCode = 0xB6
	VK_LAUNCH_APP2         VirtualKeyCode = 0xB7
	VK_OEM_1               VirtualKeyCode = 0xBA
	VK_OEM_PLUS            VirtualKeyCode = 0xBB
	VK_OEM_COMMA           VirtualKeyCode = 0xBC
	VK_OEM_MINUS           VirtualKeyCode = 0xBD
	VK_OEM_PERIOD          VirtualKeyCode = 0xBE
	VK_OEM_2               VirtualKeyCode = 0xBF
	VK_OEM_3               VirtualKeyCode = 0xC0
	VK_OEM_4               VirtualKeyCode = 0xDB
	VK_OEM_5               VirtualKeyCode = 0xDC
	VK_OEM_6               VirtualKeyCode = 0xDD
	VK_OEM_7               VirtualKeyCode = 0xDE
	VK_OEM_8               VirtualKeyCode = 0xDF
	VK_OEM_AX              VirtualKeyCode = 0xE1
	VK_OEM_102             VirtualKeyCode = 0xE2
	VK_ICO_HELP            VirtualKeyCode = 0xE3
	VK_ICO_00              VirtualKeyCode = 0xE4
	VK_PROCESSKEY          VirtualKeyCode = 0xE5
	VK_ICO_CLEAR           VirtualKeyCode = 0xE6
	VK_OEM_RESET           VirtualKeyCode = 0xE9
	VK_OEM_JUMP            VirtualKeyCode = 0xEA
	VK_OEM_PA1             VirtualKeyCode = 0xEB
	VK_OEM_PA2             VirtualKeyCode = 0xEC
	VK_OEM_PA3             VirtualKeyCode = 0xED
	VK_OEM_WSCTRL          VirtualKeyCode = 0xEE
	VK_OEM_CUSEL           VirtualKeyCode = 0xEF
	VK_OEM_ATTN            VirtualKeyCode = 0xF0
	VK_OEM_FINISH          VirtualKeyCode = 0xF1
	VK_OEM_COPY            VirtualKeyCode = 0xF2
	VK_OEM_AUTO            VirtualKeyCode = 0xF3
	VK_OEM_ENLW            VirtualKeyCode = 0xF4
	VK_OEM_BACKTAB         VirtualKeyCode = 0xF5
	VK_ATTN                VirtualKeyCode = 0xF6
	VK_CRSEL               VirtualKeyCode = 0xF7
	VK_EXSEL               VirtualKeyCode = 0xF8
	VK_EREOF               VirtualKeyCode = 0xF9
	VK_PLAY                VirtualKeyCode = 0xFA
	VK_ZOOM                VirtualKeyCode = 0xFB
	VK_NONAME              VirtualKeyCode = 0xFC
	VK_PA1                 VirtualKeyCode = 0xFD
	VK_OEM_CLEAR           VirtualKeyCode = 0xFE
)
