/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022-2024 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef __IRIS_HFI_GEN2_DEFINES_H__
#define __IRIS_HFI_GEN2_DEFINES_H__

#include <linux/types.h>

#define HFI_VIDEO_ARCH_LX			0x1

#define HFI_CMD_BEGIN				0x01000000
#define HFI_CMD_INIT				0x01000001
#define HFI_CMD_POWER_COLLAPSE			0x01000002
#define HFI_CMD_OPEN				0x01000003
#define HFI_CMD_CLOSE				0x01000004
#define HFI_CMD_START				0x01000005
#define HFI_CMD_STOP				0x01000006
#define HFI_CMD_DRAIN				0x01000007
#define HFI_CMD_RESUME				0x01000008
#define HFI_CMD_BUFFER				0x01000009
#define HFI_CMD_SUBSCRIBE_MODE			0x0100000B
#define HFI_CMD_SETTINGS_CHANGE			0x0100000C
#define HFI_CMD_PAUSE				0x01000011
#define HFI_CMD_END				0x01FFFFFF

#define HFI_BITMASK_BITSTREAM_WIDTH		0xffff0000
#define HFI_BITMASK_BITSTREAM_HEIGHT		0x0000ffff
#define HFI_BITMASK_FRAME_MBS_ONLY_FLAG		0x00000001

#define HFI_PROP_BEGIN				0x03000000
#define HFI_PROP_IMAGE_VERSION			0x03000001
#define HFI_PROP_INTRA_FRAME_POWER_COLLAPSE	0x03000002
#define HFI_PROP_UBWC_MAX_CHANNELS		0x03000003
#define HFI_PROP_UBWC_MAL_LENGTH		0x03000004
#define HFI_PROP_UBWC_HBB			0x03000005
#define HFI_PROP_UBWC_BANK_SWZL_LEVEL1		0x03000006
#define HFI_PROP_UBWC_BANK_SWZL_LEVEL2		0x03000007
#define HFI_PROP_UBWC_BANK_SWZL_LEVEL3		0x03000008
#define HFI_PROP_UBWC_BANK_SPREADING		0x03000009
#define HFI_PROP_CODEC				0x03000100
#define HFI_PROP_COLOR_FORMAT			0x03000101
#define HFI_PROP_BITSTREAM_RESOLUTION		0x03000103
#define HFI_PROP_LINEAR_STRIDE_SCANLINE		0x03000104
#define HFI_PROP_CROP_OFFSETS			0x03000105
#define HFI_PROP_PROFILE			0x03000107
#define HFI_PROP_LEVEL				0x03000108
#define HFI_PROP_TIER				0x03000109
#define HFI_PROP_STAGE				0x0300010a
#define HFI_PROP_PIPE				0x0300010b
#define HFI_PROP_LUMA_CHROMA_BIT_DEPTH		0x0300010f
#define HFI_PROP_CODED_FRAMES			0x03000120
#define HFI_PROP_CABAC_SESSION			0x03000121
#define HFI_PROP_BUFFER_HOST_MAX_COUNT		0x03000123
#define HFI_PROP_BUFFER_FW_MIN_OUTPUT_COUNT	0x03000124
#define HFI_PROP_PIC_ORDER_CNT_TYPE		0x03000128
#define HFI_PROP_QUALITY_MODE			0x03000148
#define HFI_PROP_SIGNAL_COLOR_INFO		0x03000155
#define HFI_PROP_PICTURE_TYPE			0x03000162
#define HFI_PROP_DEC_DEFAULT_HEADER		0x03000168
#define HFI_PROP_DEC_START_FROM_RAP_FRAME	0x03000169
#define HFI_PROP_NO_OUTPUT			0x0300016a
#define HFI_PROP_COMV_BUFFER_COUNT		0x03000193
#define HFI_PROP_END				0x03FFFFFF

#define HFI_SESSION_ERROR_BEGIN			0x04000000
#define HFI_ERROR_UNKNOWN_SESSION		0x04000001
#define HFI_ERROR_MAX_SESSIONS			0x04000002
#define HFI_ERROR_FATAL				0x04000003
#define HFI_ERROR_INVALID_STATE			0x04000004
#define HFI_ERROR_INSUFFICIENT_RESOURCES	0x04000005
#define HFI_ERROR_BUFFER_NOT_SET		0x04000006
#define HFI_ERROR_STREAM_UNSUPPORTED		0x04000008
#define HFI_SESSION_ERROR_END			0x04FFFFFF

#define HFI_SYSTEM_ERROR_BEGIN			0x05000000
#define HFI_SYS_ERROR_WD_TIMEOUT		0x05000001
#define HFI_SYSTEM_ERROR_END			0x05FFFFFF

#define HFI_INFORMATION_BEGIN			0x06000000
#define HFI_INFO_UNSUPPORTED			0x06000001
#define HFI_INFO_DATA_CORRUPT			0x06000002
#define HFI_INFO_BUFFER_OVERFLOW		0x06000004
#define HFI_INFO_HFI_FLAG_DRAIN_LAST		0x06000006
#define HFI_INFO_HFI_FLAG_PSC_LAST		0x06000007
#define HFI_INFORMATION_END			0x06FFFFFF

enum hfi_property_mode_type {
	HFI_MODE_PORT_SETTINGS_CHANGE		= 0x00000001,
	HFI_MODE_PROPERTY			= 0x00000002,
};

enum hfi_color_format {
	HFI_COLOR_FMT_OPAQUE			= 0,
	HFI_COLOR_FMT_NV12			= 1,
	HFI_COLOR_FMT_NV12_UBWC			= 2,
	HFI_COLOR_FMT_P010			= 3,
	HFI_COLOR_FMT_TP10_UBWC			= 4,
	HFI_COLOR_FMT_RGBA8888			= 5,
	HFI_COLOR_FMT_RGBA8888_UBWC		= 6,
	HFI_COLOR_FMT_NV21			= 7,
};

enum hfi_codec_type {
	HFI_CODEC_DECODE_AVC			= 1,
	HFI_CODEC_ENCODE_AVC			= 2,
	HFI_CODEC_DECODE_HEVC			= 3,
	HFI_CODEC_ENCODE_HEVC			= 4,
	HFI_CODEC_DECODE_VP9			= 5,
};

enum hfi_picture_type {
	HFI_PICTURE_IDR				= 0x00000001,
	HFI_PICTURE_P				= 0x00000002,
	HFI_PICTURE_B				= 0x00000004,
	HFI_PICTURE_I				= 0x00000008,
	HFI_PICTURE_CRA				= 0x00000010,
	HFI_PICTURE_BLA				= 0x00000020,
	HFI_PICTURE_NOSHOW			= 0x00000040,
};

enum hfi_buffer_type {
	HFI_BUFFER_BITSTREAM			= 0x00000001,
	HFI_BUFFER_RAW				= 0x00000002,
	HFI_BUFFER_METADATA			= 0x00000003,
	HFI_BUFFER_SUBCACHE			= 0x00000004,
	HFI_BUFFER_PARTIAL_DATA			= 0x00000005,
	HFI_BUFFER_DPB				= 0x00000006,
	HFI_BUFFER_BIN				= 0x00000007,
	HFI_BUFFER_LINE				= 0x00000008,
	HFI_BUFFER_ARP				= 0x00000009,
	HFI_BUFFER_COMV				= 0x0000000A,
	HFI_BUFFER_NON_COMV			= 0x0000000B,
	HFI_BUFFER_PERSIST			= 0x0000000C,
	HFI_BUFFER_VPSS				= 0x0000000D,
};

enum hfi_buffer_host_flags {
	HFI_BUF_HOST_FLAG_RELEASE		= 0x00000001,
	HFI_BUF_HOST_FLAG_READONLY		= 0x00000010,
	HFI_BUF_HOST_FLAG_CODEC_CONFIG		= 0x00000100,
	HFI_BUF_HOST_FLAGS_CB_NON_SECURE	= 0x00000200,
};

enum hfi_buffer_firmware_flags {
	HFI_BUF_FW_FLAG_RELEASE_DONE		= 0x00000001,
	HFI_BUF_FW_FLAG_READONLY		= 0x00000010,
	HFI_BUF_FW_FLAG_LAST			= 0x10000000,
	HFI_BUF_FW_FLAG_PSC_LAST		= 0x20000000,
};

enum hfi_packet_firmware_flags {
	HFI_FW_FLAGS_SUCCESS			= 0x00000001,
	HFI_FW_FLAGS_INFORMATION		= 0x00000002,
	HFI_FW_FLAGS_SESSION_ERROR		= 0x00000004,
	HFI_FW_FLAGS_SYSTEM_ERROR		= 0x00000008,
};

struct hfi_debug_header {
	u32 size;
	u32 debug_level;
	u32 reserved[2];
};

#endif
