;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
;
; REQUIRES: llvm-14-plus
; RUN: igc_opt --opaque-pointers --platformdg2 -igc-custom-safe-opt -S < %s --dce | FileCheck %s
; ------------------------------------------------
; CustomSafeOptPass: DotAddToDp4a
; ------------------------------------------------
define void @test_DotAddToDp4a(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f) {
; CHECK-LABEL: @test_DotAddToDp4a(
; CHECK:    [[TMP1:%.*]] = call i32 @llvm.genx.GenISA.dp4a.ss.i32(i32 0, i32 %a, i32 %b)
; CHECK:    [[TMP2:%.*]] = call i32 @llvm.genx.GenISA.dp4a.ss.i32(i32 [[TMP1]], i32 %c, i32 %d)
; CHECK:    [[TMP3:%.*]] = call i32 @llvm.genx.GenISA.dp4a.ss.i32(i32 [[TMP2]], i32 %e, i32 %f)
;
  %1 = call i32 @llvm.genx.GenISA.dp4a.ss.i32(i32 0, i32 %a, i32 %b)
  %2 = call i32 @llvm.genx.GenISA.dp4a.ss.i32(i32 0, i32 %c, i32 %d)
  %3 = add i32 %1, %2
  %4 = call i32 @llvm.genx.GenISA.dp4a.ss.i32(i32 0, i32 %e, i32 %f)
  %5 = add i32 %3, %4
  ret void
}

declare i32 @llvm.genx.GenISA.dp4a.ss.i32(i32, i32, i32)
